/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:42:18 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif

gchar** getStringArray(JNIEnv *env, jobjectArray anArray);
void freeStringArray(JNIEnv *env, jobjectArray anArray, gchar** str);

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_init
     * Signature: ([Lint ;[Ljava/lang/String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1init (JNIEnv *env, 
							   jclass cls, 
							   jintArray argc, 
							   jobjectArray args) 
    {
        gint *argc_g = (gint *) (*env)->GetIntArrayElements (env, argc, NULL);
        gchar **args_g_arr =getStringArray(env, args);
        gchar ***args_g = &args_g_arr;
        gtk_init (argc_g, args_g);
        (*env)->ReleaseIntArrayElements (env, argc, (jint *) argc_g, 0);
        freeStringArray(env, args, args_g_arr);
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_init_check
     * Signature: ([Lint ;[Ljava/lang/String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1init_1check (JNIEnv *env, jclass cls, 
        jintArray argc, jobjectArray args) 
    {
        gint *argc_g = (gint *) (*env)->GetIntArrayElements (env, argc, NULL);
        gchar ***args_g = (gchar***)getStringArray(env, args);
        gtk_init_check (argc_g, args_g);
        (*env)->ReleaseIntArrayElements (env, argc, (jint *) argc_g, 0);
        freeStringArray(env, args, args_g);
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_disable_setlocale
     * Signature: ()V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1disable_1setlocale (JNIEnv *env, jclass cls) 
    {
        {
            gtk_disable_setlocale ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_set_locale
     * Signature: ()[B
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Gtk_gtk_1set_1locale (JNIEnv *env, jclass cls) 
    {
		return (*env)->NewStringUTF(env, gtk_set_locale ());
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_get_default_language
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Gtk_gtk_1get_1default_1language (JNIEnv *env, jclass 
        cls) 
    {
        {
            return (jint)gtk_get_default_language ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_events_pending
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Gtk_gtk_1events_1pending (JNIEnv *env, jclass cls) 
    {
        {
            jint result_j = (jint) (gtk_events_pending ());
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_main_do_event
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1main_1do_1event (JNIEnv *env, jclass cls, jint 
        event) 
    {
        GdkEvent *event_g = (GdkEvent *)event;
        {
            gtk_main_do_event (event_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_main
     * Signature: ()V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1main (JNIEnv *env, jclass cls) 
    {
        {
            gtk_main ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_main_level
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Gtk_gtk_1main_1level (JNIEnv *env, jclass cls) 
    {
        {
            jint result_j = (jint) (gtk_main_level ());
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_main_quit
     * Signature: ()V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1main_1quit (JNIEnv *env, jclass cls) 
    {
        {
            gtk_main_quit ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_main_iteration
     * Signature: ()Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Gtk_gtk_1main_1iteration (JNIEnv *env, jclass cls) 
    {
        {
            jboolean result_j = (jboolean) (gtk_main_iteration ());
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_grab_add
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1grab_1add (JNIEnv *env, jclass cls, jint 
        widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_grab_add (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_grab_get_current
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Gtk_gtk_1grab_1get_1current (JNIEnv *env, jclass cls) 
    {
        {
            return (jint)gtk_grab_get_current ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_grab_remove
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1grab_1remove (JNIEnv *env, jclass cls, jint 
        widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            gtk_grab_remove (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_get_current_event
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Gtk_gtk_1get_1current_1event (JNIEnv *env, jclass cls) 
    {
        {
            return (jint)gtk_get_current_event ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_get_current_event_time
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Gtk_gtk_1get_1current_1event_1time (JNIEnv *env, jclass 
        cls) 
    {
        {
            jint result_j = (jint) (gtk_get_current_event_time ());
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_get_event_widget
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Gtk_gtk_1get_1event_1widget (JNIEnv *env, jclass cls, 
        jint event) 
    {
        GdkEvent *event_g = (GdkEvent *)event;
        {
            return (jint)gtk_get_event_widget (event_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_type_name
     * Signature: (I)[B
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Gtk_gtk_1type_1name (JNIEnv *env, jclass cls, 
        jint type) 
    {
        GType *type_g = (GType *)type;
		return (*env)->NewStringUTF(env,  (gchar*)gtk_type_name (GTK_OBJECT_TYPE(type_g)));
    }

    /*
     * Class:     org.gnu.gtk.Gtk
     * Method:    gtk_type_from_name
     * Signature: ([B)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Gtk_gtk_1type_1from_1name (JNIEnv *env, jclass cls, 
        jstring name) 
    {
        const gchar* name_g = (*env)->GetStringUTFChars( env, name, NULL);
		jint retval = (jint)gtk_type_from_name (name_g);
		(*env)->ReleaseStringUTFChars(env, name, name_g);
		return retval;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
