/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;
/**
 *
 */
public class EventMotion extends Boxed 
{
	public EventMotion(Handle handle) {
		this.handle = handle;
	}

	public Window getWindow(){
		return new Window(getWindow(handle));
	}

	public boolean getSendEvent(){
		return getSendEvent(handle);
	}

	public int getTimeMillis(){
		return getTime(handle);
	}

	public double getX(){
		return getX(handle);
	}

	public double getY(){
		return getY(handle);
	}

	public ModifierType getState(){
		return ModifierType.intern(getState(handle));
	}

	public boolean isHint(){
		return getIsHint(handle) == 1;
	}

	public Device getDevice(){
		return new Device(getDevice(handle));
	}

	public double getXRoot(){
		return getXRoot(handle);
	}

	public double getYRoot(){
		return getYRoot(handle);
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getType (Handle obj);
    native static final protected Handle getWindow (Handle obj);
    native static final protected boolean getSendEvent (Handle obj);
    native static final protected int getTime (Handle obj);
    native static final protected double getX (Handle obj);
    native static final protected double getY (Handle obj);
    native static final protected int getState (Handle obj);
    native static final protected int getIsHint (Handle obj);
    native static final protected Handle getDevice (Handle obj);
    native static final protected double getXRoot (Handle obj);
    native static final protected double getYRoot (Handle obj);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}
