/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_BindingSet
#define _Included_org_gnu_gtk_BindingSet
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gtk_BindingSet
 * Method:    gtk_binding_set_new
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_BindingSet_gtk_1binding_1set_1new
  (JNIEnv *env , jclass cls, jstring name)
{
	const gchar* setName = (*env)->GetStringUTFChars(env, name, NULL);
	jint retval = (jint)gtk_binding_set_new(setName);
	(*env)->ReleaseStringUTFChars(env, name, setName);
	return retval;
}

/*
 * Class:     org_gnu_gtk_BindingSet
 * Method:    gtk_binding_set_find
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_BindingSet_gtk_1binding_1set_1find
  (JNIEnv *env, jclass cls, jstring name)
{
	const gchar* setName = (*env)->GetStringUTFChars(env, name, NULL);
	jint retval = (jint)gtk_binding_set_find(setName);
	(*env)->ReleaseStringUTFChars(env, name, setName);
	return retval;
}

/*
 * Class:     org_gnu_gtk_BindingSet
 * Method:    gtk_bindings_activate
 * Signature: (III)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_BindingSet_gtk_1bindings_1activate
  (JNIEnv *env, jclass cls, jint object, jint keyval, jint modifier)
{
	return (jboolean)gtk_bindings_activate((GtkObject*)object, (guint)keyval, (GdkModifierType)modifier);
}

/*
 * Class:     org_gnu_gtk_BindingSet
 * Method:    gtk_binding_set_activate
 * Signature: (IIII)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_BindingSet_gtk_1binding_1set_1activate
  (JNIEnv *env, jclass cls, jint binding, jint keyval, jint modifier, jint object)
{
	return (jboolean)gtk_binding_set_activate((GtkBindingSet*)binding, (guint)keyval, (GdkModifierType)modifier, (GtkObject*)object);
}

/*
 * Class:     org_gnu_gtk_BindingSet
 * Method:    gtk_binding_entry_clear
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_BindingSet_gtk_1binding_1entry_1clear
  (JNIEnv *env, jclass cls, jint binding, jint keyval, jint modifier)
{
	gtk_binding_entry_clear((GtkBindingSet*)binding, (guint)keyval, (GdkModifierType)modifier);
}

/*
 * Class:     org_gnu_gtk_BindingSet
 * Method:    gtk_binding_set_add_path
 * Signature: (IILjava/lang/String;I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_BindingSet_gtk_1binding_1set_1add_1path
  (JNIEnv *env, jclass cls, jint binding, jint pathType, jstring pathPattern, jint priority)
{
	const gchar* pattern = (*env)->GetStringUTFChars(env, pathPattern, NULL);
	gtk_binding_set_add_path((GtkBindingSet*)binding, (GtkPathType)pathType, pattern, (GtkPathPriorityType)priority);
}

#ifdef __cplusplus
}
#endif
#endif
