/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
/**
 *
 */
public class EventExpose extends Boxed 
{
	public EventExpose(int handle) {
		this.handle = handle;
	}

	public Window getWindow() {
		return new Window(getWindow(handle));
	}

	public boolean getSendEvent() {
		return getSendEvent(handle);
	}

	public Rectangle getArea() {
		return new Rectangle(getArea(handle));
	}

	public Region getRegion() {
		return new Region(getRegion(handle));
	}

	public int getCount() {
		return getCount(handle);
	}


    native static final protected int getArea (int obj);
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getType (int obj);
    native static final protected int getWindow (int obj);
    native static final protected boolean getSendEvent (int obj);
    native static final protected int getRegion (int obj);
    native static final protected int getCount (int obj);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}
