/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 10:21:57 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gnome.h>
#ifdef __cplusplus
extern "C" 
{
#endif

void freeStringArray(JNIEnv *env, jobjectArray anArray, gchar** str);
gchar** getStringArray(JNIEnv *env, jobjectArray anArray);

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gnome.About
     * Method:    gnome_about_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_About_gnome_1about_1get_1type (JNIEnv *env, jclass 
        cls) 
    {
        {
            return (jint)gnome_about_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gnome.About
     * Method:    gnome_about_new
     * Signature: ([B[B[B[BLjava/lang/String;Ljava/lang/String;[BI)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_About_gnome_1about_1new (JNIEnv *env, jclass cls, 
        jstring title, jstring version, jstring copyright, jstring comments, jobjectArray 
        authors, jobjectArray documenters, jstring translatorCredits, jint logo) 
    {
        const gchar* title_g = (*env)->GetStringUTFChars(env, title, NULL);
        const gchar* version_g = (*env)->GetStringUTFChars(env, version, NULL);
        const gchar* copyright_g = (*env)->GetStringUTFChars(env, copyright, NULL);
        const gchar* comments_g = (*env)->GetStringUTFChars(env, comments, NULL);
        const gchar* translatorCredits_g = (*env)->GetStringUTFChars(env, translatorCredits, NULL);
        gchar **authors_g = getStringArray(env, authors);
        gchar**documenters_g = getStringArray(env, documenters);
        jint retval;
		GdkPixbuf *logo_g;
		
		if (logo) {
		  logo_g = (GdkPixbuf *)logo;
		} else {
		  logo_g = NULL;
		}

       retval = (jint)gnome_about_new (title_g, version_g, copyright_g, comments_g, (const gchar**)authors_g,  
       		(const gchar**)documenters_g, translatorCredits_g, logo_g);
       	
		(*env)->ReleaseStringUTFChars(env, title, title_g);
		(*env)->ReleaseStringUTFChars(env, version, version_g);
		(*env)->ReleaseStringUTFChars(env, copyright, copyright_g);
		(*env)->ReleaseStringUTFChars(env, comments, comments_g);
		(*env)->ReleaseStringUTFChars(env, translatorCredits, translatorCredits_g);
		
		freeStringArray(env, authors, authors_g);
		freeStringArray(env, documenters, documenters_g);

		return retval;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
