/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:27:55 EDT
 */

package org.gnu.gnome;
import org.gnu.glib.Type;
import org.gnu.gtk.VBox;
/**
 * A GnomeIconEntry is a button that pops up a window displaying a
 * collection of icons. The user can select one of the icons found in
 * /usr/share/pixmaps or browse the file system to find icons in other
 * directories. The pull-down list of directory names maintains a
 * history of previously opened directories.
 */
public class IconEntry extends VBox {
	
	/**
	 * Construct a new IconEntry
	 */
	public IconEntry(String historyId, String dialogTitle) {
		handle = gnome_icon_entry_new(historyId, dialogTitle);
		initializeEventHandlers();
	}
	
	/**
	 * Construct a new IconEntry from a handle to a native resource.
	 */
	public IconEntry(int handle) {
	    super(handle);
	}
	
	protected void noopInit() {
	}
	
	/**
	 * Set the subdirectory in which to look for icons.
	 */
	public void setSubdirectory(String subdir) {
		gnome_icon_entry_set_pixmap_subdir(handle, subdir);
	}
	
	/**
	 * Retrieve the filename of the icon selected
	 */
	public String getFilename() {
		return gnome_icon_entry_get_filename(handle);
	}
	
	/**
	 * Set the filename of an icon.
	 */
	public void setFilename(String filename) {
		gnome_icon_entry_set_filename(handle, filename);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_icon_entry_get_type());
	}
	
	/**
	 * Set the title for the Browse Dialog.
	 */
	public void setBrowseDialogTitle(String browseDialogTitle) {
		gnome_icon_entry_set_browse_dialog_title(handle, browseDialogTitle);
	}
	
	/**
	 * Set the history id
	 */
	public void setHistoryId(String id) {
		gnome_icon_entry_set_history_id(handle, id);
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gnome_icon_entry_get_type();
	native static final protected int gnome_icon_entry_new(String historyId, String browserDialogTitle);
	native static final protected void gnome_icon_entry_set_pixmap_subdir(int ientry, String subdir);
	native static final protected String gnome_icon_entry_get_filename(int ientry);
	native static final protected boolean gnome_icon_entry_set_filename(int ientry, String filename);
	native static final protected void gnome_icon_entry_set_browse_dialog_title(int ientry, String browseDialogTitle);
	native static final protected void gnome_icon_entry_set_history_id(int ientry, String historyId);
	native static final protected int gnome_icon_entry_pick_dialog(int ientry);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
