/* grilo-0.1.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Grl", lower_case_cprefix = "grl_")]
namespace Grl {
	[CCode (cheader_filename = "grilo.h")]
	public class Config : GLib.Object {
		[CCode (has_construct_function = false)]
		public Config (string plugin, string source);
		public unowned string get_api_key ();
		public uchar get_api_key_blob (size_t size);
		public unowned string get_api_secret ();
		public unowned string get_api_token ();
		public uchar get_binary (string param, size_t size);
		public bool get_boolean (string param);
		public float get_float (string param);
		public int get_int (string param);
		public unowned string get_password ();
		public unowned string get_plugin ();
		public unowned string get_string (string param);
		public unowned string get_username ();
		public bool has_param (string param);
		public void @set (string param, GLib.Value value);
		public void set_api_key (string key);
		public void set_api_key_blob (uchar blob, size_t size);
		public void set_api_secret (string secret);
		public void set_api_token (string token);
		public void set_binary (string param, uchar blob, size_t size);
		public void set_boolean (string param, bool value);
		public void set_float (string param, float value);
		public void set_int (string param, int value);
		public void set_password (string secret);
		public void set_plugin (string plugin);
		public void set_source (string source);
		public void set_string (string param, string value);
		public void set_username (string secret);
	}
	[CCode (cheader_filename = "grilo.h")]
	public class Data : GLib.Object {
		[CCode (has_construct_function = false)]
		public Data ();
		public void add (Grl.KeyID key);
		public void add_binary (Grl.KeyID key, uchar buf, size_t size);
		public void add_float (Grl.KeyID key, float floatvalue);
		public void add_int (Grl.KeyID key, int intvalue);
		public void add_related_keys (Grl.RelatedKeys relkeys);
		public void add_string (Grl.KeyID key, string strvalue);
		public unowned Grl.Data dup ();
		public GLib.Value @get (Grl.KeyID key);
		public unowned GLib.List get_all_single_related_keys (Grl.KeyID key);
		public unowned GLib.List get_all_single_related_keys_string (Grl.KeyID key);
		public uchar get_binary (Grl.KeyID key, size_t size);
		public float get_float (Grl.KeyID key);
		public int get_int (Grl.KeyID key);
		public GLib.List<weak Grl.KeyID> get_keys ();
		public bool get_overwrite ();
		public unowned Grl.RelatedKeys get_related_keys (Grl.KeyID key, uint index);
		public unowned string get_string (Grl.KeyID key);
		public bool has_key (Grl.KeyID key);
		public bool key_is_known (Grl.KeyID key);
		public uint length (Grl.KeyID key);
		public void remove (Grl.KeyID key);
		public void remove_nth (Grl.KeyID key, uint index);
		public void @set (Grl.KeyID key, GLib.Value value);
		public void set_binary (Grl.KeyID key, uchar buf, size_t size);
		public void set_float (Grl.KeyID key, float floatvalue);
		public void set_int (Grl.KeyID key, int intvalue);
		public void set_overwrite (bool overwrite);
		public void set_related_keys (Grl.RelatedKeys relkeys, uint index);
		public void set_string (Grl.KeyID key, string strvalue);
		public bool overwrite { get; set; }
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class KeyID {
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class LogDomain {
		[CCode (has_construct_function = false)]
		public LogDomain (string name);
	}
	[CCode (cheader_filename = "grilo.h")]
	public class Media : Grl.Data {
		[CCode (has_construct_function = false)]
		public Media ();
		public void add_author (string author);
		public void add_external_player (string player);
		public void add_external_url (string url);
		public void add_thumbnail (string thumbnail);
		public void add_thumbnail_binary (uchar thumbnail, size_t size);
		public void add_url_data (string url, string mime);
		public unowned string get_author ();
		public unowned string get_author_nth (uint index);
		public unowned string get_certificate ();
		public unowned string get_date ();
		public unowned string get_description ();
		public int get_duration ();
		public unowned string get_external_url ();
		public unowned string get_external_url_nth (uint index);
		public unowned string get_id ();
		public unowned string get_last_played ();
		public int get_last_position ();
		public unowned string get_license ();
		public unowned string get_mime ();
		public int get_play_count ();
		public unowned string get_player ();
		public unowned string get_player_nth (uint index);
		public float get_rating ();
		public unowned string get_site ();
		public unowned string get_source ();
		public unowned string get_studio ();
		public unowned string get_thumbnail ();
		public uchar get_thumbnail_binary (size_t size);
		public uchar get_thumbnail_binary_nth (size_t size, uint index);
		public unowned string get_thumbnail_nth (uint index);
		public unowned string get_title ();
		public unowned string get_url ();
		public unowned string get_url_data (string mime);
		public unowned string get_url_data_nth (uint index, string mime);
		public unowned string serialize ();
		public unowned string serialize_extended (Grl.MediaSerializeType serial_type);
		public void set_author (string author);
		public void set_certificate (string certificate);
		public void set_date (string date);
		public void set_description (string description);
		public void set_duration (int duration);
		public void set_external_player (string player);
		public void set_external_url (string url);
		public void set_id (string id);
		public void set_last_played (string last_played);
		public void set_last_position (int last_position);
		public void set_license (string license);
		public void set_mime (string mime);
		public void set_play_count (int play_count);
		public void set_rating (float rating, float max);
		public void set_site (string site);
		public void set_source (string source);
		public void set_studio (string studio);
		public void set_thumbnail (string thumbnail);
		public void set_thumbnail_binary (uchar thumbnail, size_t size);
		public void set_title (string title);
		public void set_url (string url);
		public void set_url_data (string url, string mime);
		public static unowned Grl.Media unserialize (string serial);
	}
	[CCode (cheader_filename = "grilo.h")]
	public class MediaAudio : Grl.Media {
		[CCode (type = "GrlMedia*", has_construct_function = false)]
		public MediaAudio ();
		public void add_artist (string artist);
		public void add_genre (string genre);
		public void add_lyrics (string lyrics);
		public void add_url_data (string url, string mime, int bitrate);
		public unowned string get_album ();
		public unowned string get_artist ();
		public unowned string get_artist_nth (uint index);
		public int get_bitrate ();
		public unowned string get_genre ();
		public unowned string get_genre_nth (uint index);
		public unowned string get_lyrics ();
		public unowned string get_lyrics_nth (uint index);
		public unowned string get_url_data (string mime, int bitrate);
		public unowned string get_url_data_nth (uint index, string mime, int bitrate);
		public void set_album (string album);
		public void set_artist (string artist);
		public void set_bitrate (int bitrate);
		public void set_genre (string genre);
		public void set_lyrics (string lyrics);
		public void set_url_data (string url, string mime, int bitrate);
	}
	[CCode (cheader_filename = "grilo.h")]
	public class MediaBox : Grl.Media {
		[CCode (type = "GrlMedia*", has_construct_function = false)]
		public MediaBox ();
		public int get_childcount ();
		public void set_childcount (int childcount);
	}
	[CCode (cheader_filename = "grilo.h")]
	public class MediaImage : Grl.Media {
		[CCode (type = "GrlMedia*", has_construct_function = false)]
		public MediaImage ();
		public void add_url_data (string url, string mime, int width, int height);
		public int get_height ();
		public unowned string get_url_data (string mime, int width, int height);
		public unowned string get_url_data_nth (uint index, string mime, int width, int height);
		public int get_width ();
		public void set_height (int height);
		public void set_size (int width, int height);
		public void set_url_data (string url, string mime, int width, int height);
		public void set_width (int width);
	}
	[CCode (cheader_filename = "grilo.h")]
	public class MediaPlugin : GLib.Object {
		[CCode (has_construct_function = false)]
		protected MediaPlugin ();
		public unowned string get_author ();
		public unowned string get_description ();
		public unowned string get_filename ();
		public unowned string get_id ();
		public unowned string get_info (string key);
		public GLib.List<weak string> get_info_keys ();
		public unowned string get_license ();
		public unowned string get_name ();
		public int get_rank ();
		public unowned string get_site ();
		public unowned string get_version ();
	}
	[CCode (cheader_filename = "grilo.h")]
	public class MediaSource : Grl.MetadataSource {
		[CCode (has_construct_function = false)]
		protected MediaSource ();
		public virtual void browse (Grl.Media container, GLib.List<Grl.KeyID> keys, uint skip, uint count, Grl.MetadataResolutionFlags flags, Grl.MediaSourceResultCb callback);
		public GLib.List<Grl.Media> browse_sync (Grl.Media container, GLib.List<Grl.KeyID> keys, uint skip, uint count, Grl.MetadataResolutionFlags flags) throws GLib.Error;
		public virtual void cancel (uint operation_id);
		public uint get_auto_split_threshold ();
		public void get_media_from_uri (string uri, GLib.List keys, Grl.MetadataResolutionFlags flags, Grl.MediaSourceMetadataCb callback);
		public unowned Grl.Media get_media_from_uri_sync (string uri, GLib.List keys, Grl.MetadataResolutionFlags flags) throws GLib.Error;
		public void* get_operation_data (uint operation_id);
		[NoWrapper]
		public virtual void media_from_uri (Grl.MediaSourceMediaFromUriSpec mfss);
		public virtual void metadata (Grl.Media media, GLib.List<Grl.KeyID> keys, Grl.MetadataResolutionFlags flags, Grl.MediaSourceMetadataCb callback);
		public Grl.Media metadata_sync (Grl.Media media, GLib.List<Grl.KeyID> keys, Grl.MetadataResolutionFlags flags) throws GLib.Error;
		public void notify_change (Grl.Media media, Grl.MediaSourceChangeType change_type, bool location_unknown);
		public virtual bool notify_change_start () throws GLib.Error;
		public virtual bool notify_change_stop () throws GLib.Error;
		public virtual void query (string query, GLib.List<Grl.KeyID> keys, uint skip, uint count, Grl.MetadataResolutionFlags flags, Grl.MediaSourceResultCb callback);
		public GLib.List<Grl.Media> query_sync (string query, GLib.List<Grl.KeyID> keys, uint skip, uint count, Grl.MetadataResolutionFlags flags) throws GLib.Error;
		public virtual void remove (Grl.Media media, Grl.MediaSourceRemoveCb callback);
		public void remove_sync (Grl.Media media) throws GLib.Error;
		public virtual void search (string text, GLib.List<Grl.KeyID> keys, uint skip, uint count, Grl.MetadataResolutionFlags flags, Grl.MediaSourceResultCb callback);
		public GLib.List<Grl.Media> search_sync (string text, GLib.List<Grl.KeyID> keys, uint skip, uint count, Grl.MetadataResolutionFlags flags) throws GLib.Error;
		public void set_auto_split_threshold (uint threshold);
		public void set_operation_data (uint operation_id, void* data);
		public virtual void store (Grl.MediaBox parent, Grl.Media media, Grl.MediaSourceStoreCb callback);
		public void store_sync (Grl.MediaBox parent, Grl.Media media) throws GLib.Error;
		public virtual bool test_media_from_uri (string uri);
		public uint auto_split_threshold { get; set; }
		public virtual signal void content_changed (Grl.Media p0, Grl.MediaSourceChangeType p1, bool p2);
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class MediaSourceBrowseSpec {
		public uint browse_id;
		public weak Grl.MediaSourceResultCb callback;
		public weak Grl.Media container;
		public uint count;
		public Grl.MetadataResolutionFlags flags;
		public weak GLib.List keys;
		public uint skip;
		public weak Grl.MediaSource source;
		public void* user_data;
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class MediaSourceMediaFromUriSpec {
		public weak Grl.MediaSourceMetadataCb callback;
		public Grl.MetadataResolutionFlags flags;
		public weak GLib.List keys;
		public weak Grl.MediaSource source;
		public weak string uri;
		public void* user_data;
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class MediaSourceMetadataSpec {
		public weak Grl.MediaSourceMetadataCb callback;
		public Grl.MetadataResolutionFlags flags;
		public weak GLib.List keys;
		public weak Grl.Media media;
		public uint metadata_id;
		public weak Grl.MediaSource source;
		public void* user_data;
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class MediaSourceQuerySpec {
		public weak Grl.MediaSourceResultCb callback;
		public uint count;
		public Grl.MetadataResolutionFlags flags;
		public weak GLib.List keys;
		public weak string query;
		public uint query_id;
		public uint skip;
		public weak Grl.MediaSource source;
		public void* user_data;
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class MediaSourceRemoveSpec {
		public weak Grl.MediaSourceRemoveCb callback;
		public weak Grl.Media media;
		public weak string media_id;
		public weak Grl.MediaSource source;
		public void* user_data;
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class MediaSourceSearchSpec {
		public weak Grl.MediaSourceResultCb callback;
		public uint count;
		public Grl.MetadataResolutionFlags flags;
		public weak GLib.List keys;
		public uint search_id;
		public uint skip;
		public weak Grl.MediaSource source;
		public weak string text;
		public void* user_data;
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class MediaSourceStoreSpec {
		public weak Grl.MediaSourceStoreCb callback;
		public weak Grl.Media media;
		public weak Grl.MediaBox parent;
		public weak Grl.MediaSource source;
		public void* user_data;
	}
	[CCode (cheader_filename = "grilo.h")]
	public class MediaVideo : Grl.Media {
		[CCode (type = "GrlMedia*", has_construct_function = false)]
		public MediaVideo ();
		public void add_url_data (string url, string mime, float framerate, int width, int height);
		public float get_framerate ();
		public int get_height ();
		public unowned string get_url_data (string mime, float framerate, int width, int height);
		public unowned string get_url_data_nth (uint index, string mime, float framerate, int width, int height);
		public int get_width ();
		public void set_framerate (float framerate);
		public void set_height (int height);
		public void set_size (int width, int height);
		public void set_url_data (string url, string mime, float framerate, int width, int height);
		public void set_width (int width);
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class MetadataKey {
		[CCode (cname = "GRL_METADATA_KEY_ALBUM")]
		public GLib.ParamSpec ALBUM;
		[CCode (cname = "GRL_METADATA_KEY_ARTIST")]
		public GLib.ParamSpec ARTIST;
		[CCode (cname = "GRL_METADATA_KEY_AUTHOR")]
		public GLib.ParamSpec AUTHOR;
		[CCode (cname = "GRL_METADATA_KEY_BITRATE")]
		public GLib.ParamSpec BITRATE;
		[CCode (cname = "GRL_METADATA_KEY_CERTIFICATE")]
		public GLib.ParamSpec CERTIFICATE;
		[CCode (cname = "GRL_METADATA_KEY_CHILDCOUNT")]
		public GLib.ParamSpec CHILDCOUNT;
		[CCode (cname = "GRL_METADATA_KEY_DATE")]
		public GLib.ParamSpec DATE;
		[CCode (cname = "GRL_METADATA_KEY_DESCRIPTION")]
		public GLib.ParamSpec DESCRIPTION;
		[CCode (cname = "GRL_METADATA_KEY_DURATION")]
		public GLib.ParamSpec DURATION;
		[CCode (cname = "GRL_METADATA_KEY_EXTERNAL_PLAYER")]
		public GLib.ParamSpec EXTERNAL_PLAYER;
		[CCode (cname = "GRL_METADATA_KEY_EXTERNAL_URL")]
		public GLib.ParamSpec EXTERNAL_URL;
		[CCode (cname = "GRL_METADATA_KEY_FRAMERATE")]
		public GLib.ParamSpec FRAMERATE;
		[CCode (cname = "GRL_METADATA_KEY_GENRE")]
		public GLib.ParamSpec GENRE;
		[CCode (cname = "GRL_METADATA_KEY_HEIGHT")]
		public GLib.ParamSpec HEIGHT;
		[CCode (cname = "GRL_METADATA_KEY_ID")]
		public static GLib.ParamSpec ID;
		[CCode (cname = "GRL_METADATA_KEY_LAST_PLAYED")]
		public GLib.ParamSpec LAST_PLAYED;
		[CCode (cname = "GRL_METADATA_KEY_LAST_POSITION")]
		public GLib.ParamSpec LAST_POSITION;
		[CCode (cname = "GRL_METADATA_KEY_LICENSE")]
		public GLib.ParamSpec LICENSE;
		[CCode (cname = "GRL_METADATA_KEY_LYRICS")]
		public GLib.ParamSpec LYRICS;
		[CCode (cname = "GRL_METADATA_KEY_MIME")]
		public GLib.ParamSpec MIME;
		[CCode (cname = "GRL_METADATA_KEY_PLAY_COUNT")]
		public GLib.ParamSpec PLAY_COUNT;
		[CCode (cname = "GRL_METADATA_KEY_RATING")]
		public GLib.ParamSpec RATING;
		[CCode (cname = "GRL_METADATA_KEY_SITE")]
		public GLib.ParamSpec SITE;
		[CCode (cname = "GRL_METADATA_KEY_SOURCE")]
		public GLib.ParamSpec SOURCE;
		[CCode (cname = "GRL_METADATA_KEY_STUDIO")]
		public GLib.ParamSpec STUDIO;
		[CCode (cname = "GRL_METADATA_KEY_THUMBNAIL")]
		public GLib.ParamSpec THUMBNAIL;
		[CCode (cname = "GRL_METADATA_KEY_TITLE")]
		public static GLib.ParamSpec TITLE;
		[CCode (cname = "GRL_METADATA_KEY_URL")]
		public static GLib.ParamSpec URL;
		[CCode (cname = "GRL_METADATA_KEY_WIDTH")]
		public GLib.ParamSpec WIDTH;
		public static unowned GLib.List list_new (GLib.ParamSpec p, ...);
	}
	[CCode (cheader_filename = "grilo.h")]
	public class MetadataSource : Grl.MediaPlugin {
		[CCode (has_construct_function = false)]
		protected MetadataSource ();
		public GLib.List<weak Grl.KeyID> filter_slow (ref unowned GLib.List<weak Grl.KeyID> keys, bool return_filtered);
		public GLib.List<weak Grl.KeyID> filter_supported (ref unowned GLib.List<weak Grl.KeyID> keys, bool return_filtered);
		public GLib.List<weak Grl.KeyID> filter_writable (ref unowned GLib.List<weak Grl.KeyID> keys, bool return_filtered);
		public unowned string get_description ();
		public unowned string get_id ();
		public unowned string get_name ();
		public virtual unowned GLib.List<weak Grl.KeyID> key_depends (Grl.KeyID key_id);
		public virtual bool may_resolve (Grl.Media media, Grl.KeyID key_id, GLib.List missing_keys);
		public virtual void resolve (GLib.List<Grl.KeyID> keys, Grl.Media media, Grl.MetadataResolutionFlags flags, Grl.MetadataSourceResolveCb callback);
		public unowned Grl.Media resolve_sync (GLib.List<Grl.KeyID> keys, Grl.Media media, Grl.MetadataResolutionFlags flags) throws GLib.Error;
		public virtual void set_metadata (Grl.Media media, GLib.List<Grl.KeyID> keys, Grl.MetadataWritingFlags flags, Grl.MetadataSourceSetMetadataCb callback);
		public unowned GLib.List set_metadata_sync (Grl.Media media, GLib.List<Grl.KeyID> keys, Grl.MetadataWritingFlags flags) throws GLib.Error;
		public virtual unowned GLib.List<weak Grl.KeyID> slow_keys ();
		public virtual unowned GLib.List<weak Grl.KeyID> supported_keys ();
		public virtual Grl.SupportedOps supported_operations ();
		public virtual unowned GLib.List<weak Grl.KeyID> writable_keys ();
		[NoAccessorMethod]
		public string source_desc { owned get; set construct; }
		[NoAccessorMethod]
		public string source_id { owned get; set construct; }
		[NoAccessorMethod]
		public string source_name { owned get; set construct; }
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class MetadataSourceResolveSpec {
		public weak Grl.MetadataSourceResolveCb callback;
		public Grl.MetadataResolutionFlags flags;
		public weak GLib.List keys;
		public weak Grl.Media media;
		public weak Grl.MetadataSource source;
		public void* user_data;
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class MetadataSourceSetMetadataSpec {
		public weak Grl.MetadataSourceSetMetadataCb callback;
		public weak GLib.List failed_keys;
		public Grl.MetadataWritingFlags flags;
		public weak GLib.List keys;
		public weak Grl.Media media;
		public weak Grl.MetadataSource source;
		public void* user_data;
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class PluginDescriptor {
		public weak Grl.PluginInfo info;
		public weak GLib.Module module;
		public weak GLib.Callback plugin_deinit;
		public weak GLib.Callback plugin_init;
	}
	[Compact]
	[CCode (cheader_filename = "grilo.h")]
	public class PluginInfo {
		public weak string filename;
		public weak string id;
		public weak GLib.HashTable optional_info;
		public int rank;
	}
	[CCode (cheader_filename = "grilo.h")]
	public class PluginRegistry : GLib.Object {
		[CCode (has_construct_function = false)]
		protected PluginRegistry ();
		public bool add_config (Grl.Config config) throws GLib.Error;
		public bool add_config_from_file (string config_file) throws GLib.Error;
		public void add_directory (string path);
		public static unowned Grl.PluginRegistry get_default ();
		public GLib.List<weak Grl.KeyID> get_metadata_keys ();
		public GLib.List<weak Grl.MediaPlugin> get_sources (bool ranked);
		public GLib.List<weak Grl.MediaPlugin> get_sources_by_operations (Grl.SupportedOps ops, bool ranked);
		public bool load (string path) throws GLib.Error;
		public bool load_all () throws GLib.Error;
		public bool load_directory (string path) throws GLib.Error;
		public unowned Grl.KeyID lookup_metadata_key (string key_name);
		public unowned GLib.List lookup_metadata_key_relation (Grl.KeyID key);
		public unowned Grl.MediaPlugin lookup_source (string source_id);
		public unowned Grl.KeyID register_metadata_key (GLib.ParamSpec key) throws GLib.Error;
		public void register_metadata_key_relation (Grl.KeyID key1, Grl.KeyID key2);
		public bool register_source (Grl.PluginInfo plugin, Grl.MediaPlugin source) throws GLib.Error;
		public bool unload (string plugin_id) throws GLib.Error;
		public bool unregister_source (Grl.MediaPlugin source) throws GLib.Error;
		public virtual signal void source_added (Grl.MediaPlugin p0);
		public virtual signal void source_removed (Grl.MediaPlugin p0);
	}
	[CCode (cheader_filename = "grilo.h")]
	public class RelatedKeys : GLib.Object {
		[CCode (has_construct_function = false)]
		public RelatedKeys ();
		public void add (Grl.KeyID key);
		public unowned Grl.RelatedKeys dup ();
		public GLib.Value @get (Grl.KeyID key);
		public uchar get_binary (Grl.KeyID key, size_t size);
		public float get_float (Grl.KeyID key);
		public int get_int (Grl.KeyID key);
		public unowned GLib.List get_keys (bool include_unknown);
		public unowned string get_string (Grl.KeyID key);
		public bool has_key (Grl.KeyID key);
		public bool key_is_known (Grl.KeyID key);
		public void @set (Grl.KeyID key, GLib.Value value);
		public void set_binary (Grl.KeyID key, uchar buf, size_t size);
		public void set_float (Grl.KeyID key, float floatvalue);
		public void set_int (Grl.KeyID key, int intvalue);
		public void set_string (Grl.KeyID key, string strvalue);
		[CCode (has_construct_function = false)]
		public RelatedKeys.valist (Grl.KeyID key, void* args);
		[CCode (has_construct_function = false)]
		public RelatedKeys.with_keys (Grl.KeyID key);
	}
	[CCode (cprefix = "GRL_LOG_LEVEL_", has_type_id = false, cheader_filename = "grilo.h")]
	public enum LogLevel {
		NONE,
		ERROR,
		WARNING,
		MESSAGE,
		INFO,
		DEBUG,
		LAST
	}
	[CCode (cprefix = "GRL_MEDIA_SERIALIZE_", has_type_id = false, cheader_filename = "grilo.h")]
	public enum MediaSerializeType {
		BASIC,
		PARTIAL,
		FULL
	}
	[CCode (cprefix = "GRL_CONTENT_", has_type_id = false, cheader_filename = "grilo.h")]
	public enum MediaSourceChangeType {
		CHANGED,
		ADDED,
		REMOVED
	}
	[CCode (cprefix = "GRL_RESOLVE_", has_type_id = false, cheader_filename = "grilo.h")]
	public enum MetadataResolutionFlags {
		NORMAL,
		FULL,
		IDLE_RELAY,
		FAST_ONLY
	}
	[CCode (cprefix = "GRL_WRITE_", has_type_id = false, cheader_filename = "grilo.h")]
	public enum MetadataWritingFlags {
		NORMAL,
		FULL
	}
	[CCode (cprefix = "GRL_PLUGIN_RANK_", has_type_id = false, cheader_filename = "grilo.h")]
	public enum PluginRank {
		LOWEST,
		LOW,
		DEFAULT,
		HIGH,
		HIGHEST
	}
	[CCode (cprefix = "GRL_OP_", has_type_id = false, cheader_filename = "grilo.h")]
	public enum SupportedOps {
		NONE,
		METADATA,
		RESOLVE,
		BROWSE,
		SEARCH,
		QUERY,
		STORE,
		STORE_PARENT,
		REMOVE,
		SET_METADATA,
		MEDIA_FROM_URI,
		NOTIFY_CHANGE
	}
	[CCode (cprefix = "GRL_CORE_ERROR_", cheader_filename = "grilo.h")]
	public errordomain CoreError {
		BROWSE_FAILED,
		SEARCH_FAILED,
		SEARCH_NULL_UNSUPPORTED,
		QUERY_FAILED,
		METADATA_FAILED,
		RESOLVE_FAILED,
		MEDIA_NOT_FOUND,
		STORE_FAILED,
		REMOVE_FAILED,
		SET_METADATA_FAILED,
		MEDIA_FROM_URI_FAILED,
		CONFIG_LOAD_FAILED,
		CONFIG_FAILED,
		UNREGISTER_SOURCE_FAILED,
		LOAD_PLUGIN_FAILED,
		UNLOAD_PLUGIN_FAILED,
		REGISTER_METADATA_KEY_FAILED,
		NOTIFY_CHANGED_FAILED,
		OPERATION_CANCELLED,
	}
	[CCode (cheader_filename = "grilo.h", instance_pos = 2.1)]
	public delegate void MediaSourceMetadataCb (Grl.MediaSource source, Grl.Media? media, GLib.Error error);
	[CCode (cheader_filename = "grilo.h", instance_pos = 2.1)]
	public delegate void MediaSourceRemoveCb (Grl.MediaSource source, Grl.Media? media, GLib.Error error);
	[CCode (cheader_filename = "grilo.h", instance_pos = 4.1)]
	public delegate void MediaSourceResultCb (Grl.MediaSource source, uint operation_id, Grl.Media? media, uint remaining, GLib.Error? error);
	[CCode (cheader_filename = "grilo.h", instance_pos = 3.1)]
	public delegate void MediaSourceStoreCb (Grl.MediaSource source, Grl.MediaBox? parent, Grl.Media? media, GLib.Error? error);
	[CCode (cheader_filename = "grilo.h", instance_pos = 2.1)]
	public delegate void MetadataSourceResolveCb (Grl.MetadataSource source, Grl.Media? media, GLib.Error? error);
	[CCode (cheader_filename = "grilo.h", instance_pos = 3.1)]
	public delegate void MetadataSourceSetMetadataCb (Grl.MetadataSource source, Grl.Media? media, GLib.List failed_keys, GLib.Error? error);
	[CCode (cheader_filename = "grilo.h")]
	public const string CONFIG_KEY_APIKEY;
	[CCode (cheader_filename = "grilo.h")]
	public const string CONFIG_KEY_APIKEY_BLOB;
	[CCode (cheader_filename = "grilo.h")]
	public const string CONFIG_KEY_APISECRET;
	[CCode (cheader_filename = "grilo.h")]
	public const string CONFIG_KEY_APITOKEN;
	[CCode (cheader_filename = "grilo.h")]
	public const string CONFIG_KEY_PASSWORD;
	[CCode (cheader_filename = "grilo.h")]
	public const string CONFIG_KEY_PLUGIN;
	[CCode (cheader_filename = "grilo.h")]
	public const string CONFIG_KEY_SOURCE;
	[CCode (cheader_filename = "grilo.h")]
	public const string CONFIG_KEY_USERNAME;
	[CCode (cheader_filename = "grilo.h")]
	public const string KEYID_FORMAT;
	[CCode (cheader_filename = "grilo.h")]
	public const string MEDIA_PLUGIN_AUTHOR;
	[CCode (cheader_filename = "grilo.h")]
	public const string MEDIA_PLUGIN_DESCRIPTION;
	[CCode (cheader_filename = "grilo.h")]
	public const string MEDIA_PLUGIN_LICENSE;
	[CCode (cheader_filename = "grilo.h")]
	public const string MEDIA_PLUGIN_NAME;
	[CCode (cheader_filename = "grilo.h")]
	public const string MEDIA_PLUGIN_SITE;
	[CCode (cheader_filename = "grilo.h")]
	public const string MEDIA_PLUGIN_VERSION;
	[CCode (cheader_filename = "grilo.h")]
	public const string PLUGIN_PATH_VAR;
	[CCode (cheader_filename = "grilo.h")]
	public const string PLUGIN_RANKS_VAR;
	[CCode (cheader_filename = "grilo.h")]
	public static void init ([CCode (array_length_pos = 0.9)] ref unowned string[] argv);
	[CCode (cheader_filename = "grilo.h")]
	public static unowned GLib.OptionGroup init_get_option_group ();
	[CCode (cheader_filename = "grilo.h")]
	public static unowned GLib.List list_from_va (void* p, ...);
	[CCode (cheader_filename = "grilo.h")]
	public static void log (Grl.LogDomain domain, Grl.LogLevel level, string strloc, string format);
	[CCode (cheader_filename = "grilo.h")]
	public static void log_configure (string config);
	[CCode (cheader_filename = "grilo.h")]
	public static unowned string metadata_key_get_desc (Grl.KeyID key);
	[CCode (cheader_filename = "grilo.h")]
	public static unowned string metadata_key_get_name (Grl.KeyID key);
	[CCode (cheader_filename = "grilo.h")]
	public static void multiple_cancel (uint search_id);
	[CCode (cheader_filename = "grilo.h")]
	public static void multiple_get_media_from_uri (string uri, GLib.List keys, Grl.MetadataResolutionFlags flags, Grl.MediaSourceMetadataCb callback);
	[CCode (cheader_filename = "grilo.h")]
	public static uint multiple_search (GLib.List sources, string text, GLib.List keys, uint count, Grl.MetadataResolutionFlags flags, Grl.MediaSourceResultCb callback);
	[CCode (cheader_filename = "grilo.h")]
	public static unowned GLib.List multiple_search_sync (GLib.List sources, string text, GLib.List keys, uint count, Grl.MetadataResolutionFlags flags) throws GLib.Error;
	[CCode (cheader_filename = "grilo.h")]
	public static void paging_translate (uint skip, uint count, uint max_page_size, uint page_size, uint page_number, uint internal_offset);
}
