// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GOOCANVASMM_ITEM_H
#define _GOOCANVASMM_ITEM_H


#include <glibmm.h>


/* Copyright (C) 1998-2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <goocanvasmm/bounds.h>
#include <goocanvasmm/style.h>
#include <cairomm/cairomm.h>
#include <goocanvasitem.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef union _GooCanvasPathCommand GooCanvasPathCommand; }
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GooCanvasItem GooCanvasItem;
typedef struct _GooCanvasItemClass GooCanvasItemClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Goocanvas
{ class Item_Class; } // namespace Goocanvas
namespace Goocanvas
{

//TODO: Somehow make the enum values be ITEM_VISIBLE instead of CANVAS_ITEM_VISIBLE. It seems to just find the first _.
/** @addtogroup goocanvasmmEnums Enums and Flags */

/**
 * @ingroup goocanvasmmEnums
 * @par Bitwise operators:
 * <tt>%PointerEvents operator|(PointerEvents, PointerEvents)</tt><br>
 * <tt>%PointerEvents operator&(PointerEvents, PointerEvents)</tt><br>
 * <tt>%PointerEvents operator^(PointerEvents, PointerEvents)</tt><br>
 * <tt>%PointerEvents operator~(PointerEvents)</tt><br>
 * <tt>%PointerEvents& operator|=(PointerEvents&, PointerEvents)</tt><br>
 * <tt>%PointerEvents& operator&=(PointerEvents&, PointerEvents)</tt><br>
 * <tt>%PointerEvents& operator^=(PointerEvents&, PointerEvents)</tt><br>
 */
enum PointerEvents
{
  CANVAS_EVENTS_VISIBLE_MASK = 1 << 0,
  CANVAS_EVENTS_PAINTED_MASK = 1 << 1,
  CANVAS_EVENTS_FILL_MASK = 1 << 2,
  CANVAS_EVENTS_STROKE_MASK = 1 << 3,
  CANVAS_EVENTS_NONE = 0,
  CANVAS_EVENTS_VISIBLE_PAINTED = 0x1,
  CANVAS_EVENTS_VISIBLE_FILL = 0x1,
  CANVAS_EVENTS_VISIBLE_STROKE = 0x1,
  CANVAS_EVENTS_VISIBLE = 0x1,
  CANVAS_EVENTS_PAINTED = 0x2,
  CANVAS_EVENTS_FILL = 0x4,
  CANVAS_EVENTS_STROKE = 0x8,
  CANVAS_EVENTS_ALL = 0x4
};

/** @ingroup goocanvasmmEnums */
inline PointerEvents operator|(PointerEvents lhs, PointerEvents rhs)
  { return static_cast<PointerEvents>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup goocanvasmmEnums */
inline PointerEvents operator&(PointerEvents lhs, PointerEvents rhs)
  { return static_cast<PointerEvents>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup goocanvasmmEnums */
inline PointerEvents operator^(PointerEvents lhs, PointerEvents rhs)
  { return static_cast<PointerEvents>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup goocanvasmmEnums */
inline PointerEvents operator~(PointerEvents flags)
  { return static_cast<PointerEvents>(~static_cast<unsigned>(flags)); }

/** @ingroup goocanvasmmEnums */
inline PointerEvents& operator|=(PointerEvents& lhs, PointerEvents rhs)
  { return (lhs = static_cast<PointerEvents>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup goocanvasmmEnums */
inline PointerEvents& operator&=(PointerEvents& lhs, PointerEvents rhs)
  { return (lhs = static_cast<PointerEvents>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup goocanvasmmEnums */
inline PointerEvents& operator^=(PointerEvents& lhs, PointerEvents rhs)
  { return (lhs = static_cast<PointerEvents>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Goocanvas


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Goocanvas::PointerEvents> : public Glib::Value_Flags<Goocanvas::PointerEvents>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Goocanvas
{

/**
 * @ingroup goocanvasmmEnums
 */
enum ItemVisibility
{
  CANVAS_ITEM_HIDDEN,
  CANVAS_ITEM_INVISIBLE,
  CANVAS_ITEM_VISIBLE,
  CANVAS_ITEM_VISIBLE_ABOVE_THRESHOLD
};

} // namespace Goocanvas


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Goocanvas::ItemVisibility> : public Glib::Value_Enum<Goocanvas::ItemVisibility>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Goocanvas
{


class Canvas ;
class ItemModel ;


class Item : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Item CppObjectType;
  typedef Item_Class CppClassType;
  typedef GooCanvasItem BaseObjectType;
  typedef GooCanvasItemIface BaseClassType;

private:
  friend class Item_Class;
  static CppClassType item_class_;

  // noncopyable
  Item(const Item&);
  Item& operator=(const Item&);

protected:
  Item(); // you must derive from this class

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Item(GooCanvasItem* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Item();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GooCanvasItem*       gobj()       { return reinterpret_cast<GooCanvasItem*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GooCanvasItem* gobj() const { return reinterpret_cast<GooCanvasItem*>(gobject_); }

private:


public:

  
  Canvas* get_canvas();
  
  const Canvas* get_canvas() const;
  
  void set_canvas(Canvas* canvas);

  
  bool is_visible() const;

  
  Glib::RefPtr<ItemModel> get_model();
  
  Glib::RefPtr<const ItemModel> get_model() const;
  
  void set_model(const Glib::RefPtr<ItemModel>& model);

  
  Glib::RefPtr<Item> get_parent();
  
  Glib::RefPtr<const Item> get_parent() const;
  
  void set_parent(const Glib::RefPtr<Item>& parent);
  
  void remove();

  
  bool is_container() const;
  
  int get_n_children() const;
  
  Glib::RefPtr<Item> get_child(int child_num);
  
  Glib::RefPtr<const Item> get_child(int child_num) const;
  
  int find_child(const Glib::RefPtr<Item>& child);
  
  void add_child(const Glib::RefPtr<Item>& child, int pos);
  void add_child(const Glib::RefPtr<Item>& child);

  
  void move_child(int old_position, int new_position);
  
  void remove_child(int child_num);

  
  void raise(const Glib::RefPtr<Item>& above);

  /** Raise the item to the top of the stack.
   */
  void raise();

  
  void lower(const Glib::RefPtr<Item>& below);

  /** Lower the item to the bottom of the stack.
   */
  void lower();

  Bounds get_bounds() const;
  

  void request_update();
  
  void ensure_upated();
  
  void update(bool entire_tree, const Cairo::RefPtr<Cairo::Context>& context, Bounds& bounds);
  
  void paint(const Cairo::RefPtr<Cairo::Context>& context, const Bounds& bounds, double scale);
  
  bool get_requested_area(const Cairo::RefPtr<Cairo::Context>& context, Bounds& bounds) const;
  
  double get_requested_height(const Cairo::RefPtr<Cairo::Context>& context, double width) const;
  
  void allocate_area(const Cairo::RefPtr<Cairo::Context>& context, const Bounds& requested_area, const Bounds& allocated_area, double x_offset, double y_offset);

 
  Glib::ListHandle< Glib::RefPtr<Item> > get_items_at(double x, double y, const Cairo::RefPtr<Cairo::Context>& context, bool is_pointer_event, bool parent_is_visible, const Glib::ListHandle< Glib::RefPtr<Item> >& found_items);

  //TODO: Use Cairo::RefPtr?
  
  bool get_transform(Cairo::Matrix* matrix);
  
  void set_transform(const Cairo::Matrix* matrix);

  
  void set_simple_transform(double x, double y, double scale, double rotation);
  
  void translate(double tx, double ty);
  
  void scale(double sx, double sy);
  
  void rotate(double degrees, double cx, double cy);
  
  void skew_x(double degrees, double cx, double cy);
  
  void skew_y(double degrees, double cx, double cy);

  
  bool get_transform_for_child(const Glib::RefPtr<Item>& child, Cairo::Matrix* transform);

  
  Glib::RefPtr<Style> get_style();
  
  Glib::RefPtr<const Style> get_style() const;
  
  void set_style(const Glib::RefPtr<Style>& style);

  
  void animate(double x, double y, double scale, double degrees, bool absolute, int duration, int step_time, GooCanvasAnimateType type);
  
  void stop_animation();


  //_WRAP_SIGNAL(void child_added(int child_num), "child_added")
  //_WRAP_SIGNAL(void child_moved(int old_position, int new_position), "child_moved")
  //_WRAP_SIGNAL(void child_removed(int child_num), "child_removed")
  //_WRAP_SIGNAL(void changed(bool recompute_bounds), "changed")

 
  /**
   * @par Prototype:
   * <tt>bool on_my_%enter_notify_event(const Glib::RefPtr<Item>& target, GdkEventCrossing* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventCrossing* > signal_enter_notify_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%leave_notify_event(const Glib::RefPtr<Item>& target, GdkEventCrossing* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventCrossing* > signal_leave_notify_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%motion_notify_event(const Glib::RefPtr<Item>& target, GdkEventMotion* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventMotion* > signal_motion_notify_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%button_press_event(const Glib::RefPtr<Item>& target, GdkEventButton* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventButton* > signal_button_press_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%button_release_event(const Glib::RefPtr<Item>& target, GdkEventButton* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventButton* > signal_button_release_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%focus_in_event(const Glib::RefPtr<Item>& target, GdkEventFocus* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventFocus* > signal_focus_in_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%focus_out_event(const Glib::RefPtr<Item>& target, GdkEventFocus* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventFocus* > signal_focus_out_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%key_press_event(const Glib::RefPtr<Item>& target, GdkEventKey* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventKey* > signal_key_press_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%key_release_event(const Glib::RefPtr<Item>& target, GdkEventKey* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventKey* > signal_key_release_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%grab_broken_event(const Glib::RefPtr<Item>& target, GdkEventGrabBroken* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventGrabBroken* > signal_grab_broken_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%child_notify(GParamSpec* pspec)</tt>
   */

  Glib::SignalProxy1< void,GParamSpec* > signal_child_notify();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If the item can take the keyboard focus.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_can_focus() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If the item can take the keyboard focus.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_can_focus() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** When the canvas item is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<ItemVisibility> property_visibility() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** When the canvas item is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ItemVisibility> property_visibility() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A description of the item for use by assistive technologies.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_description() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A description of the item for use by assistive technologies.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_description() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The scale threshold at which the item becomes visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_visibility_threshold() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The scale threshold at which the item becomes visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_visibility_threshold() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Specifies when the item receives pointer events.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<PointerEvents> property_pointer_events() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Specifies when the item receives pointer events.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<PointerEvents> property_pointer_events() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:

/*

  //_WRAP_VFUNC(Cairo::Matrix* get_transform(), get_transform)
  _WRAP_VFUNC(void set_transform(Cairo::Matrix* matrix), set_transform)
  //_WRAP_VFUNC(Glib::RefPtr<ItemView> create_view(const Glib::RefPtr<View>& canvas_view, const Glib::RefPtr<ItemView>& parent_view), create_view)
*/


/* Virtual methods that group items must implement. */
/*
  GooCanvas*		(* get_canvas)			(GooCanvasItem		*item);
  void			(* set_canvas(
							 GooCanvas		*canvas);
  gint			(* get_n_children)		(GooCanvasItem		*item);
  GooCanvasItem*	(* get_child(
							 gint			 child_num);
  void			(* request_update)		(GooCanvasItem		*item);
*/
  /* Virtual methods that group items may implement. */

/*
  void			(* add_child(
							 GooCanvasItem		*child,
							 gint			 position);
  void			(* move_child(
							 gint			 old_position,
							 gint			 new_position);
  void			(* remove_child(
							 gint			 child_num);
  void			(* get_child_property(
							 GooCanvasItem		*child,
							 guint			 property_id,
							 GValue			*value,
							 GParamSpec		*pspec);
  void			(* set_child_property(
							 GooCanvasItem		*child,
							 guint			 property_id,
							 const GValue		*value,
							 GParamSpec		*pspec);
  gboolean		(* get_transform_for_child)	(GooCanvasItem		*item,
							 GooCanvasItem		*child,
							 cairo_matrix_t		*transform);
*/

  /* Virtual methods that all canvas items must implement. */

 
;
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<Item> get_parent_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_parent_vfunc(const Glib::RefPtr<Item>& parent);
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void get_bounds_vfunc(GooCanvasBounds* bounds);
#endif //GLIBMM_VFUNCS_ENABLED


  //gtkmmproc error: get_items_at :  vfunc defs lookup failed
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void update_vfunc(bool entire_tree, const Cairo::RefPtr<Cairo::Context>& cr, GooCanvasBounds* bounds);
#endif //GLIBMM_VFUNCS_ENABLED


;
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void paint_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, const Bounds& bounds, double scale);
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool get_requested_area_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, GooCanvasBounds* requested_area);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void allocate_area_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, const Bounds& requested_area, const Bounds& allocated_area, double x_offset, double y_offset);
#endif //GLIBMM_VFUNCS_ENABLED


  /* Virtual methods that canvas items may implement. */

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool get_transform_vfunc(cairo_matrix_t* transform);
#endif //GLIBMM_VFUNCS_ENABLED

  //gtkmmproc error: set_transform :  vfunc defs lookup failed
  //gtkmmproc error: get_style :  vfunc defs lookup failed
  //gtkmmproc error: set_style :  vfunc defs lookup failed
  //gtkmmproc error: is_visible :  vfunc defs lookup failed
  //gtkmmproc error: get_requested_height :  vfunc defs lookup failed

  /* Virtual methods that model/view items must implement. */
/*
  GooCanvasItemModel*	(* get_model)			(GooCanvasItem		*item);
  void			(* set_model(
							 GooCanvasItemModel	*model);
*/


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual bool on_enter_notify_event(const Glib::RefPtr<Item>& target, GdkEventCrossing* event);
  virtual bool on_leave_notify_event(const Glib::RefPtr<Item>& target, GdkEventCrossing* event);
  virtual bool on_motion_notify_event(const Glib::RefPtr<Item>& target, GdkEventMotion* event);
  virtual bool on_button_press_event(const Glib::RefPtr<Item>& target, GdkEventButton* event);
  virtual bool on_button_release_event(const Glib::RefPtr<Item>& target, GdkEventButton* event);
  virtual bool on_focus_in_event(const Glib::RefPtr<Item>& target, GdkEventFocus* event);
  virtual bool on_focus_out_event(const Glib::RefPtr<Item>& target, GdkEventFocus* event);
  virtual bool on_key_press_event(const Glib::RefPtr<Item>& target, GdkEventKey* event);
  virtual bool on_key_release_event(const Glib::RefPtr<Item>& target, GdkEventKey* event);
  virtual bool on_grab_broken_event(const Glib::RefPtr<Item>& target, GdkEventGrabBroken* event);
  virtual void on_child_notify(GParamSpec* pspec);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} //namespace Goocanvas


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Goocanvas::Item
   */
  Glib::RefPtr<Goocanvas::Item> wrap(GooCanvasItem* object, bool take_copy = false);

} // namespace Glib


#endif /* _GOOCANVASMM_ITEM_H */

