/* kf-persona-store.c generated by valac 0.12.0, the Vala compiler
 * generated from kf-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE (folks_backends_kf_persona_store_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))

typedef struct _FolksBackendsKfPersonaStore FolksBackendsKfPersonaStore;
typedef struct _FolksBackendsKfPersonaStoreClass FolksBackendsKfPersonaStoreClass;
typedef struct _FolksBackendsKfPersonaStorePrivate FolksBackendsKfPersonaStorePrivate;

#define FOLKS_BACKENDS_KF_TYPE_PERSONA (folks_backends_kf_persona_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersona))
#define FOLKS_BACKENDS_KF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA))
#define FOLKS_BACKENDS_KF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA))
#define FOLKS_BACKENDS_KF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaClass))

typedef struct _FolksBackendsKfPersona FolksBackendsKfPersona;
typedef struct _FolksBackendsKfPersonaClass FolksBackendsKfPersonaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksBackendsKfPersonaStorePrepareData FolksBackendsKfPersonaStorePrepareData;
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
typedef struct _FolksBackendsKfPersonaStoreFlushData FolksBackendsKfPersonaStoreFlushData;
typedef struct _FolksBackendsKfPersonaStoreRemovePersonaData FolksBackendsKfPersonaStoreRemovePersonaData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FolksBackendsKfPersonaStoreAddPersonaFromDetailsData FolksBackendsKfPersonaStoreAddPersonaFromDetailsData;
typedef struct _FolksBackendsKfPersonaStoreSaveKeyFileData FolksBackendsKfPersonaStoreSaveKeyFileData;

struct _FolksBackendsKfPersonaStore {
	FolksPersonaStore parent_instance;
	FolksBackendsKfPersonaStorePrivate * priv;
};

struct _FolksBackendsKfPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _FolksBackendsKfPersonaStorePrivate {
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	GFile* _file;
	GKeyFile* _key_file;
	GCancellable* _save_key_file_cancellable;
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
};

struct _FolksBackendsKfPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	gchar* _tmp0_;
	gchar* filename;
	GKeyFile* _tmp1_;
	gchar* contents;
	gsize length;
	gchar* _tmp2_;
	gsize _tmp3_;
	GError * e1;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* parent_dir;
	GError * e3;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFileOutputStream* _tmp9_;
	GFileOutputStream* stream;
	GError * e2;
	const gchar* _tmp10_;
	gsize _tmp11_;
	gchar** _tmp12_;
	gchar** groups;
	gint groups_length1;
	gint _groups_size_;
	GeeHashSet* _tmp13_;
	GeeHashSet* added_personas;
	gchar** persona_id_collection;
	int persona_id_collection_length1;
	int persona_id_it;
	gchar* _tmp14_;
	gchar* persona_id;
	FolksBackendsKfPersona* _tmp15_;
	FolksBackendsKfPersona* persona;
	const gchar* _tmp16_;
	gint _tmp17_;
	GError * _inner_error_;
};

struct _FolksBackendsKfPersonaStoreFlushData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	GMainContext* _tmp0_;
	GMainContext* _tmp1_;
	GMainContext* context;
};

struct _FolksBackendsKfPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	FolksPersona* persona;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* personas;
	GError * e;
	GError * _inner_error_;
};

struct _FolksBackendsKfPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	const gchar* _tmp0_;
	gconstpointer _tmp1_;
	GValue* val;
	GeeMultiMap* _tmp2_;
	GObject* _tmp3_;
	GeeMultiMap* _tmp4_;
	GeeMultiMap* im_addresses;
	const gchar* _tmp5_;
	gconstpointer _tmp6_;
	GValue* val2;
	GeeMultiMap* _tmp7_;
	GObject* _tmp8_;
	GeeMultiMap* _tmp9_;
	GeeMultiMap* web_service_addresses;
	gint _tmp10_;
	gint _tmp11_;
	guint im_addresses_size;
	gint _tmp12_;
	gint _tmp13_;
	guint web_service_addresses_size;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	gchar* persona_id;
	gboolean _tmp18_;
	gboolean _tmp19_;
	guint32 _tmp20_;
	gchar* _tmp21_;
	FolksBackendsKfPersona* _tmp22_;
	FolksBackendsKfPersona* persona;
	const gchar* _tmp23_;
	GeeHashSet* _tmp24_;
	GeeHashSet* personas;
	GError * _inner_error_;
};

struct _FolksBackendsKfPersonaStoreSaveKeyFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	gchar* _tmp0_;
	gchar* key_file_data;
	GCancellable* _tmp1_;
	GCancellable* cancellable;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	GError * e;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_;
};


static gpointer folks_backends_kf_persona_store_parent_class = NULL;

GType folks_backends_kf_persona_store_get_type (void) G_GNUC_CONST;
GType folks_backends_kf_persona_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_KF_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStorePrivate))
enum  {
	FOLKS_BACKENDS_KF_PERSONA_STORE_DUMMY_PROPERTY,
	FOLKS_BACKENDS_KF_PERSONA_STORE_TYPE_ID,
	FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_ADD_PERSONAS,
	FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_GROUP_PERSONAS,
	FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	FOLKS_BACKENDS_KF_PERSONA_STORE_IS_PREPARED,
	FOLKS_BACKENDS_KF_PERSONA_STORE_PERSONAS
};
FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_new (GFile* key_file);
FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_construct (GType object_type, GFile* key_file);
static void folks_backends_kf_persona_store_real_prepare_data_free (gpointer _data);
static void folks_backends_kf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_store_real_prepare_co (FolksBackendsKfPersonaStorePrepareData* data);
static void folks_backends_kf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
FolksBackendsKfPersona* folks_backends_kf_persona_new (GKeyFile* key_file, const gchar* id, FolksPersonaStore* store);
FolksBackendsKfPersona* folks_backends_kf_persona_construct (GType object_type, GKeyFile* key_file, const gchar* id, FolksPersonaStore* store);
static void folks_backends_kf_persona_store_real_flush_data_free (gpointer _data);
static void folks_backends_kf_persona_store_real_flush (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_store_real_flush_co (FolksBackendsKfPersonaStoreFlushData* data);
static void folks_backends_kf_persona_store_real_remove_persona_data_free (gpointer _data);
static void folks_backends_kf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_store_real_remove_persona_co (FolksBackendsKfPersonaStoreRemovePersonaData* data);
void folks_backends_kf_persona_store_save_key_file (FolksBackendsKfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backends_kf_persona_store_save_key_file_finish (FolksBackendsKfPersonaStore* self, GAsyncResult* _res_);
static void folks_backends_kf_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_backends_kf_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void folks_backends_kf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_store_real_add_persona_from_details_co (FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* data);
static void folks_backends_kf_persona_store_save_key_file_data_free (gpointer _data);
static gboolean folks_backends_kf_persona_store_save_key_file_co (FolksBackendsKfPersonaStoreSaveKeyFileData* data);
static void folks_backends_kf_persona_store_save_key_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_backends_kf_persona_store_finalize (GObject* obj);
static void _vala_folks_backends_kf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to expose the {@link Persona}s provided by the
   * different groups in the key file given by `key_file`.
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_construct (GType object_type, GFile* key_file) {
	FolksBackendsKfPersonaStore * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* id;
	GFile* _tmp1_;
	GeeHashMap* _tmp2_ = NULL;
	GeeMap* _tmp3_ = NULL;
	g_return_val_if_fail (key_file != NULL, NULL);
	_tmp0_ = g_file_get_basename (key_file);
	id = _tmp0_;
	self = (FolksBackendsKfPersonaStore*) g_object_new (object_type, "id", id, "display-name", id, NULL);
	folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_FULL);
	_tmp1_ = _g_object_ref0 (key_file);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_BACKENDS_KF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp2_;
	_tmp3_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp3_;
	_g_free0 (id);
	return self;
}


FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_new (GFile* key_file) {
	return folks_backends_kf_persona_store_construct (FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, key_file);
}


static void folks_backends_kf_persona_store_real_prepare_data_free (gpointer _data) {
	FolksBackendsKfPersonaStorePrepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendsKfPersonaStorePrepareData, data);
}


static void folks_backends_kf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStore * self;
	FolksBackendsKfPersonaStorePrepareData* _data_;
	self = (FolksBackendsKfPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_real_prepare_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_backends_kf_persona_store_real_prepare_co (_data_);
}


static void folks_backends_kf_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsKfPersonaStorePrepareData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void folks_backends_kf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaStorePrepareData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_backends_kf_persona_store_real_prepare_co (data);
}


static gboolean folks_backends_kf_persona_store_real_prepare_co (FolksBackendsKfPersonaStorePrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__is_prepared);
		if (!data->self->priv->_is_prepared) {
			data->_tmp0_ = NULL;
			data->_tmp0_ = g_file_get_path (data->self->priv->_file);
			data->filename = data->_tmp0_;
			data->_tmp1_ = NULL;
			data->_tmp1_ = g_key_file_new ();
			_g_key_file_free0 (data->self->priv->_key_file);
			data->self->priv->_key_file = data->_tmp1_;
			while (TRUE) {
				data->contents = NULL;
				data->length = (gsize) 0;
				data->_tmp2_ = NULL;
				data->_state_ = 1;
				g_file_load_contents_async (data->self->priv->_file, NULL, folks_backends_kf_persona_store_prepare_ready, data);
				return FALSE;
				_state_1:
				g_file_load_contents_finish (data->self->priv->_file, data->_res_, &data->_tmp2_, &data->_tmp3_, NULL, &data->_inner_error_);
				_g_free0 (data->contents);
				data->contents = data->_tmp2_;
				data->length = data->_tmp3_;
				if (data->_inner_error_ != NULL) {
					_g_free0 (data->contents);
					goto __catch7_g_error;
				}
				if (data->length > 0) {
					g_key_file_load_from_data (data->self->priv->_key_file, data->contents, data->length, G_KEY_FILE_KEEP_COMMENTS, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						_g_free0 (data->contents);
						goto __catch7_g_error;
					}
				}
				_g_free0 (data->contents);
				break;
				_g_free0 (data->contents);
				goto __finally7;
				__catch7_g_error:
				{
					data->e1 = data->_inner_error_;
					data->_inner_error_ = NULL;
					if (!g_error_matches (data->e1, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
						data->_tmp4_ = NULL;
						data->_tmp4_ = _ ("The relationship key file '%s' could not be loaded: %s");
						g_warning (data->_tmp4_, data->filename, data->e1->message);
						g_signal_emit_by_name ((FolksPersonaStore*) data->self, "removed");
						_g_error_free0 (data->e1);
						_g_free0 (data->filename);
						g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
					_g_error_free0 (data->e1);
				}
				__finally7:
				if (data->_inner_error_ != NULL) {
					_g_free0 (data->filename);
					_g_free0 (data->filename);
					g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
				data->_tmp5_ = NULL;
				data->_tmp5_ = g_file_get_parent (data->self->priv->_file);
				data->parent_dir = data->_tmp5_;
				g_file_make_directory_with_parents (data->parent_dir, NULL, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch8_g_error;
				}
				goto __finally8;
				__catch8_g_error:
				{
					data->e3 = data->_inner_error_;
					data->_inner_error_ = NULL;
					if (!g_error_matches (data->e3, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
						data->_tmp6_ = NULL;
						data->_tmp6_ = _ ("The relationship key file directory '%s' could not be created: %s");
						data->_tmp7_ = NULL;
						data->_tmp7_ = g_file_get_path (data->parent_dir);
						data->_tmp8_ = data->_tmp7_;
						g_warning (data->_tmp6_, data->_tmp8_, data->e3->message);
						_g_free0 (data->_tmp8_);
						g_signal_emit_by_name ((FolksPersonaStore*) data->self, "removed");
						_g_error_free0 (data->e3);
						_g_object_unref0 (data->parent_dir);
						_g_free0 (data->filename);
						g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
					_g_error_free0 (data->e3);
				}
				__finally8:
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->parent_dir);
					_g_free0 (data->filename);
					_g_object_unref0 (data->parent_dir);
					_g_free0 (data->filename);
					g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
				data->_state_ = 2;
				g_file_create_async (data->self->priv->_file, G_FILE_CREATE_PRIVATE, G_PRIORITY_DEFAULT, NULL, folks_backends_kf_persona_store_prepare_ready, data);
				return FALSE;
				_state_2:
				data->_tmp9_ = NULL;
				data->_tmp9_ = g_file_create_finish (data->self->priv->_file, data->_res_, &data->_inner_error_);
				data->stream = data->_tmp9_;
				if (data->_inner_error_ != NULL) {
					goto __catch9_g_error;
				}
				data->_state_ = 3;
				g_output_stream_close_async ((GOutputStream*) data->stream, G_PRIORITY_DEFAULT, NULL, folks_backends_kf_persona_store_prepare_ready, data);
				return FALSE;
				_state_3:
				g_output_stream_close_finish ((GOutputStream*) data->stream, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->stream);
					goto __catch9_g_error;
				}
				_g_object_unref0 (data->stream);
				goto __finally9;
				__catch9_g_error:
				{
					data->e2 = data->_inner_error_;
					data->_inner_error_ = NULL;
					if (!g_error_matches (data->e2, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
						data->_tmp10_ = NULL;
						data->_tmp10_ = _ ("The relationship key file '%s' could not be created: %s");
						g_warning (data->_tmp10_, data->filename, data->e2->message);
						g_signal_emit_by_name ((FolksPersonaStore*) data->self, "removed");
						_g_error_free0 (data->e2);
						_g_object_unref0 (data->parent_dir);
						_g_free0 (data->filename);
						g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
					_g_error_free0 (data->e2);
				}
				__finally9:
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->parent_dir);
					_g_free0 (data->filename);
					_g_object_unref0 (data->parent_dir);
					_g_free0 (data->filename);
					g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
				_g_object_unref0 (data->parent_dir);
			}
			data->_tmp12_ = NULL;
			data->_tmp12_ = g_key_file_get_groups (data->self->priv->_key_file, &data->_tmp11_);
			data->groups = data->_tmp12_;
			data->groups_length1 = data->_tmp11_;
			data->_groups_size_ = data->_tmp11_;
			data->_tmp13_ = NULL;
			data->_tmp13_ = gee_hash_set_new (FOLKS_BACKENDS_KF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
			data->added_personas = data->_tmp13_;
			{
				data->persona_id_collection = data->groups;
				data->persona_id_collection_length1 = data->groups_length1;
				for (data->persona_id_it = 0; data->persona_id_it < data->groups_length1; data->persona_id_it = data->persona_id_it + 1) {
					data->_tmp14_ = g_strdup (data->persona_id_collection[data->persona_id_it]);
					data->persona_id = data->_tmp14_;
					{
						data->_tmp15_ = NULL;
						data->_tmp15_ = folks_backends_kf_persona_new (data->self->priv->_key_file, data->persona_id, (FolksPersonaStore*) data->self);
						data->persona = data->_tmp15_;
						data->_tmp16_ = NULL;
						data->_tmp16_ = folks_persona_get_iid ((FolksPersona*) data->persona);
						gee_abstract_map_set ((GeeAbstractMap*) data->self->priv->_personas, data->_tmp16_, data->persona);
						gee_abstract_collection_add ((GeeAbstractCollection*) data->added_personas, data->persona);
						_g_object_unref0 (data->persona);
						_g_free0 (data->persona_id);
					}
				}
			}
			data->_tmp17_ = gee_map_get_size ((GeeMap*) data->self->priv->_personas);
			if (data->_tmp17_ > 0) {
				_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) data->self, (GeeSet*) data->added_personas, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
			}
			data->self->priv->_is_prepared = TRUE;
			g_object_notify ((GObject*) data->self, "is-prepared");
			_g_object_unref0 (data->added_personas);
			data->groups = (_vala_array_free (data->groups, data->groups_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data->filename);
		}
		__finally6:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_backends_kf_persona_store_real_flush_data_free (gpointer _data) {
	FolksBackendsKfPersonaStoreFlushData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendsKfPersonaStoreFlushData, data);
}


static void folks_backends_kf_persona_store_real_flush (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStore * self;
	FolksBackendsKfPersonaStoreFlushData* _data_;
	self = (FolksBackendsKfPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStoreFlushData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_real_flush);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_real_flush_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_backends_kf_persona_store_real_flush_co (_data_);
}


static void folks_backends_kf_persona_store_real_flush_finish (FolksPersonaStore* base, GAsyncResult* _res_) {
	FolksBackendsKfPersonaStoreFlushData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static gpointer _g_main_context_ref0 (gpointer self) {
	return self ? g_main_context_ref (self) : NULL;
}


static gboolean folks_backends_kf_persona_store_real_flush_co (FolksBackendsKfPersonaStoreFlushData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_main_context_default ();
	data->_tmp1_ = _g_main_context_ref0 (data->_tmp0_);
	data->context = data->_tmp1_;
	while (TRUE) {
		if (!(data->self->priv->_save_key_file_cancellable != NULL)) {
			break;
		}
		g_main_context_iteration (data->context, TRUE);
	}
	_g_main_context_unref0 (data->context);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_backends_kf_persona_store_real_remove_persona_data_free (gpointer _data) {
	FolksBackendsKfPersonaStoreRemovePersonaData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendsKfPersonaStoreRemovePersonaData, data);
}


static void folks_backends_kf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStore * self;
	FolksBackendsKfPersonaStoreRemovePersonaData* _data_;
	self = (FolksBackendsKfPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_real_remove_persona_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->persona = _g_object_ref0 (persona);
	folks_backends_kf_persona_store_real_remove_persona_co (_data_);
}


static void folks_backends_kf_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsKfPersonaStoreRemovePersonaData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void folks_backends_kf_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaStoreRemovePersonaData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_backends_kf_persona_store_real_remove_persona_co (data);
}


static gboolean folks_backends_kf_persona_store_real_remove_persona_co (FolksBackendsKfPersonaStoreRemovePersonaData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_persona_get_uid (data->persona);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_persona_get_iid (data->persona);
	data->_tmp2_ = NULL;
	data->_tmp2_ = folks_persona_get_display_id (data->persona);
	g_debug ("kf-persona-store.vala:273: Removing Persona '%s' (IID '%s', group '%s'" \
")", data->_tmp0_, data->_tmp1_, data->_tmp2_);
	data->_tmp3_ = NULL;
	data->_tmp3_ = folks_persona_get_display_id (data->persona);
	g_key_file_remove_group (data->self->priv->_key_file, data->_tmp3_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch10_g_key_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_state_ = 1;
	folks_backends_kf_persona_store_save_key_file (data->self, folks_backends_kf_persona_store_remove_persona_ready, data);
	return FALSE;
	_state_1:
	folks_backends_kf_persona_store_save_key_file_finish (data->self, data->_res_);
	data->_tmp4_ = NULL;
	data->_tmp4_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->personas = data->_tmp4_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->personas, data->persona);
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) data->self, NULL, (GeeSet*) data->personas, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_g_object_unref0 (data->personas);
	goto __finally10;
	__catch10_g_key_file_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		_g_error_free0 (data->e);
	}
	__finally10:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_backends_kf_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* data;
	data = _data;
	_g_hash_table_unref0 (data->details);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendsKfPersonaStoreAddPersonaFromDetailsData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void folks_backends_kf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStore * self;
	FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* _data_;
	self = (FolksBackendsKfPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_real_add_persona_from_details_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->details = _g_hash_table_ref0 (details);
	folks_backends_kf_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* folks_backends_kf_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * Accepted keys for `details` are:
   * - PersonaStore.detail_key (PersonaDetail.IM_ADDRESSES)
   * - PersonaStore.detail_key (PersonaDetail.WEB_SERVICE_ADDRESSES)
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   */
static gboolean folks_backends_kf_persona_store_real_add_persona_from_details_co (FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_IM_ADDRESSES);
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_hash_table_lookup (data->details, data->_tmp0_);
	data->val = (GValue*) data->_tmp1_;
	if (data->val != NULL) {
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_value_get_object (data->val);
		data->_tmp2_ = GEE_MULTI_MAP (data->_tmp3_);
	} else {
		data->_tmp2_ = NULL;
	}
	data->_tmp4_ = _g_object_ref0 (data->_tmp2_);
	data->im_addresses = data->_tmp4_;
	data->_tmp5_ = NULL;
	data->_tmp5_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES);
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_hash_table_lookup (data->details, data->_tmp5_);
	data->val2 = (GValue*) data->_tmp6_;
	if (data->val2 != NULL) {
		data->_tmp8_ = NULL;
		data->_tmp8_ = g_value_get_object (data->val2);
		data->_tmp7_ = GEE_MULTI_MAP (data->_tmp8_);
	} else {
		data->_tmp7_ = NULL;
	}
	data->_tmp9_ = _g_object_ref0 (data->_tmp7_);
	data->web_service_addresses = data->_tmp9_;
	if (data->im_addresses == NULL) {
		data->_tmp10_ = 0;
	} else {
		data->_tmp11_ = gee_multi_map_get_size (data->im_addresses);
		data->_tmp10_ = data->_tmp11_;
	}
	data->im_addresses_size = (guint) data->_tmp10_;
	if (data->web_service_addresses == NULL) {
		data->_tmp12_ = 0;
	} else {
		data->_tmp13_ = gee_multi_map_get_size (data->web_service_addresses);
		data->_tmp12_ = data->_tmp13_;
	}
	data->web_service_addresses_size = (guint) data->_tmp12_;
	if ((data->im_addresses_size + data->web_service_addresses_size) == 0) {
		data->_tmp14_ = NULL;
		data->_tmp14_ = _ ("Persona store (%s, %s) requires the following details:\n" \
"    im-addresses (provided: '%p')");
		data->_tmp15_ = NULL;
		data->_tmp15_ = folks_persona_store_get_type_id ((FolksPersonaStore*) data->self);
		data->_tmp16_ = NULL;
		data->_tmp16_ = folks_persona_store_get_id ((FolksPersonaStore*) data->self);
		data->_tmp17_ = NULL;
		data->_tmp17_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT, data->_tmp14_, data->_tmp15_, data->_tmp16_, data->im_addresses);
		data->_inner_error_ = data->_tmp17_;
		if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->web_service_addresses);
			_g_object_unref0 (data->im_addresses);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->web_service_addresses);
			_g_object_unref0 (data->im_addresses);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	g_debug ("kf-persona-store.vala:332: Adding Persona from details.");
	data->persona_id = NULL;
	{
		data->_tmp18_ = TRUE;
		while (TRUE) {
			if (!data->_tmp18_) {
				data->_tmp19_ = g_key_file_has_group (data->self->priv->_key_file, data->persona_id);
				if (!(data->_tmp19_ == TRUE)) {
					break;
				}
			}
			data->_tmp18_ = FALSE;
			data->_tmp20_ = g_random_int ();
			data->_tmp21_ = NULL;
			data->_tmp21_ = g_strdup_printf ("%u", data->_tmp20_);
			_g_free0 (data->persona_id);
			data->persona_id = data->_tmp21_;
		}
	}
	data->_tmp22_ = NULL;
	data->_tmp22_ = folks_backends_kf_persona_new (data->self->priv->_key_file, data->persona_id, (FolksPersonaStore*) data->self);
	data->persona = data->_tmp22_;
	data->_tmp23_ = NULL;
	data->_tmp23_ = folks_persona_get_iid ((FolksPersona*) data->persona);
	gee_abstract_map_set ((GeeAbstractMap*) data->self->priv->_personas, data->_tmp23_, data->persona);
	if (data->im_addresses_size > 0) {
		folks_im_details_set_im_addresses ((FolksImDetails*) data->persona, data->im_addresses);
	}
	if (data->web_service_addresses_size > 0) {
		folks_web_service_details_set_web_service_addresses ((FolksWebServiceDetails*) data->persona, data->web_service_addresses);
	}
	data->_tmp24_ = NULL;
	data->_tmp24_ = gee_hash_set_new (FOLKS_BACKENDS_KF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->personas = data->_tmp24_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->personas, data->persona);
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) data->self, (GeeSet*) data->personas, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	data->result = (FolksPersona*) data->persona;
	_g_object_unref0 (data->personas);
	_g_free0 (data->persona_id);
	_g_object_unref0 (data->web_service_addresses);
	_g_object_unref0 (data->im_addresses);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->personas);
	_g_object_unref0 (data->persona);
	_g_free0 (data->persona_id);
	_g_object_unref0 (data->web_service_addresses);
	_g_object_unref0 (data->im_addresses);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_backends_kf_persona_store_save_key_file_data_free (gpointer _data) {
	FolksBackendsKfPersonaStoreSaveKeyFileData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendsKfPersonaStoreSaveKeyFileData, data);
}


void folks_backends_kf_persona_store_save_key_file (FolksBackendsKfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStoreSaveKeyFileData* _data_;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStoreSaveKeyFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_save_key_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_save_key_file_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_backends_kf_persona_store_save_key_file_co (_data_);
}


void folks_backends_kf_persona_store_save_key_file_finish (FolksBackendsKfPersonaStore* self, GAsyncResult* _res_) {
	FolksBackendsKfPersonaStoreSaveKeyFileData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_backends_kf_persona_store_save_key_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaStoreSaveKeyFileData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_backends_kf_persona_store_save_key_file_co (data);
}


static gboolean folks_backends_kf_persona_store_save_key_file_co (FolksBackendsKfPersonaStoreSaveKeyFileData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_key_file_to_data (data->self->priv->_key_file, NULL, NULL);
	data->key_file_data = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_cancellable_new ();
	data->cancellable = data->_tmp1_;
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_file_get_path (data->self->priv->_file);
	data->_tmp3_ = data->_tmp2_;
	g_debug ("kf-persona-store.vala:369: Saving key file '%s'.", data->_tmp3_);
	_g_free0 (data->_tmp3_);
	if (data->self->priv->_save_key_file_cancellable != NULL) {
		g_cancellable_cancel (data->self->priv->_save_key_file_cancellable);
	}
	data->self->priv->_save_key_file_cancellable = data->cancellable;
	data->_tmp4_ = strlen (data->key_file_data);
	data->_state_ = 1;
	g_file_replace_contents_async (data->self->priv->_file, data->key_file_data, (gsize) data->_tmp4_, NULL, FALSE, G_FILE_CREATE_PRIVATE, data->cancellable, folks_backends_kf_persona_store_save_key_file_ready, data);
	return FALSE;
	_state_1:
	g_file_replace_contents_finish (data->self->priv->_file, data->_res_, NULL, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch11_g_error;
	}
	goto __finally11;
	__catch11_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		if (!g_error_matches (data->e, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			data->_tmp5_ = NULL;
			data->_tmp5_ = _ ("Could not write updated key file '%s': %s");
			data->_tmp6_ = NULL;
			data->_tmp6_ = g_file_get_path (data->self->priv->_file);
			data->_tmp7_ = data->_tmp6_;
			g_warning (data->_tmp5_, data->_tmp7_, data->e->message);
			_g_free0 (data->_tmp7_);
		}
		_g_error_free0 (data->e);
	}
	__finally11:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->cancellable);
		_g_free0 (data->key_file_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->self->priv->_save_key_file_cancellable == data->cancellable) {
		data->self->priv->_save_key_file_cancellable = NULL;
	}
	_g_object_unref0 (data->cancellable);
	_g_free0 (data->key_file_data);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static const gchar* folks_backends_kf_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}


static FolksMaybeBool folks_backends_kf_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_TRUE;
	return result;
}


static FolksMaybeBool folks_backends_kf_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_TRUE;
	return result;
}


static FolksMaybeBool folks_backends_kf_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool folks_backends_kf_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_TRUE;
	return result;
}


static gboolean folks_backends_kf_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = self->priv->_is_prepared;
	return result;
}


static GeeMap* folks_backends_kf_persona_store_real_get_personas (FolksPersonaStore* base) {
	GeeMap* result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = self->priv->_personas_ro;
	return result;
}


static void folks_backends_kf_persona_store_class_init (FolksBackendsKfPersonaStoreClass * klass) {
	folks_backends_kf_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsKfPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = folks_backends_kf_persona_store_real_prepare;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = folks_backends_kf_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->flush = folks_backends_kf_persona_store_real_flush;
	FOLKS_PERSONA_STORE_CLASS (klass)->flush_finish = folks_backends_kf_persona_store_real_flush_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = folks_backends_kf_persona_store_real_remove_persona;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = folks_backends_kf_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = folks_backends_kf_persona_store_real_add_persona_from_details;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = folks_backends_kf_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = folks_backends_kf_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = folks_backends_kf_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = folks_backends_kf_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = folks_backends_kf_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = folks_backends_kf_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = folks_backends_kf_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = folks_backends_kf_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_kf_persona_store_get_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_kf_persona_store_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_TYPE_ID, "type-id");
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_ADD_PERSONAS, "can-add-personas");
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_ALIAS_PERSONAS, "can-alias-personas");
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_GROUP_PERSONAS, "can-group-personas");
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_REMOVE_PERSONAS, "can-remove-personas");
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.3.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_IS_PREPARED, "is-prepared");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_PERSONAS, "personas");
}


static void folks_backends_kf_persona_store_instance_init (FolksBackendsKfPersonaStore * self) {
	self->priv = FOLKS_BACKENDS_KF_PERSONA_STORE_GET_PRIVATE (self);
	self->priv->_save_key_file_cancellable = NULL;
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
}


static void folks_backends_kf_persona_store_finalize (GObject* obj) {
	FolksBackendsKfPersonaStore * self;
	self = FOLKS_BACKENDS_KF_PERSONA_STORE (obj);
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	_g_object_unref0 (self->priv->_file);
	_g_key_file_free0 (self->priv->_key_file);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	G_OBJECT_CLASS (folks_backends_kf_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which is associated with a single simple key file. It will
 * create a {@link Persona} for each of the groups in the key file.
 *
 * @since 0.1.13
 */
GType folks_backends_kf_persona_store_get_type (void) {
	static volatile gsize folks_backends_kf_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_kf_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsKfPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_kf_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsKfPersonaStore), 0, (GInstanceInitFunc) folks_backends_kf_persona_store_instance_init, NULL };
		GType folks_backends_kf_persona_store_type_id;
		folks_backends_kf_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "FolksBackendsKfPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_kf_persona_store_type_id__volatile, folks_backends_kf_persona_store_type_id);
	}
	return folks_backends_kf_persona_store_type_id__volatile;
}


static void _vala_folks_backends_kf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsKfPersonaStore * self;
	self = FOLKS_BACKENDS_KF_PERSONA_STORE (object);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_PERSONAS:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



