/* phones-updates.c generated by valac 0.12.0, the Vala compiler
 * generated from phones-updates.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks/folks-tracker.h>
#include <gio/gio.h>


#define TYPE_PHONES_UPDATES_TESTS (phones_updates_tests_get_type ())
#define PHONES_UPDATES_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHONES_UPDATES_TESTS, PhonesUpdatesTests))
#define PHONES_UPDATES_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHONES_UPDATES_TESTS, PhonesUpdatesTestsClass))
#define IS_PHONES_UPDATES_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHONES_UPDATES_TESTS))
#define IS_PHONES_UPDATES_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHONES_UPDATES_TESTS))
#define PHONES_UPDATES_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHONES_UPDATES_TESTS, PhonesUpdatesTestsClass))

typedef struct _PhonesUpdatesTests PhonesUpdatesTests;
typedef struct _PhonesUpdatesTestsClass PhonesUpdatesTestsClass;
typedef struct _PhonesUpdatesTestsPrivate PhonesUpdatesTestsPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PhonesUpdatesTestsTestPhonesUpdatesAsyncData PhonesUpdatesTestsTestPhonesUpdatesAsyncData;

struct _PhonesUpdatesTests {
	FolksTestCase parent_instance;
	PhonesUpdatesTestsPrivate * priv;
};

struct _PhonesUpdatesTestsClass {
	FolksTestCaseClass parent_class;
};

struct _PhonesUpdatesTestsPrivate {
	GMainLoop* _main_loop;
	TrackerTestBackend* _tracker_backend;
	FolksIndividualAggregator* _aggregator;
	gchar* _initial_fullname_1;
	gchar* _contact_urn_1;
	gchar* _phone_1;
	gchar* _phone_2;
	gchar* _individual_id;
	gboolean _initial_phone_found;
	gboolean _initial_phone_found_again;
	gboolean _updated_phone_found;
};

struct _PhonesUpdatesTestsTestPhonesUpdatesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	PhonesUpdatesTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	GError * e;
	GError * _inner_error_;
};


static gpointer phones_updates_tests_parent_class = NULL;

GType phones_updates_tests_get_type (void) G_GNUC_CONST;
#define PHONES_UPDATES_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHONES_UPDATES_TESTS, PhonesUpdatesTestsPrivate))
enum  {
	PHONES_UPDATES_TESTS_DUMMY_PROPERTY
};
PhonesUpdatesTests* phones_updates_tests_new (void);
PhonesUpdatesTests* phones_updates_tests_construct (GType object_type);
void phones_updates_tests_test_phones_updates (PhonesUpdatesTests* self);
static void _phones_updates_tests_test_phones_updates_folks_test_case_test_method (gpointer self);
static void phones_updates_tests_real_set_up (FolksTestCase* base);
static void phones_updates_tests_real_tear_down (FolksTestCase* base);
static void _phones_updates_tests_test_phones_updates_async (PhonesUpdatesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _phones_updates_tests_test_phones_updates_finish (PhonesUpdatesTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (PhonesUpdatesTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void _phones_updates_tests_test_phones_updates_async_data_free (gpointer _data);
static gboolean _phones_updates_tests_test_phones_updates_async_co (PhonesUpdatesTestsTestPhonesUpdatesAsyncData* data);
static void _phones_updates_tests_test_phones_updates_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _phones_updates_tests_individuals_changed_cb (PhonesUpdatesTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __phones_updates_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _phones_updates_tests_notify_phones_cb (PhonesUpdatesTests* self, GObject* individual_obj, GParamSpec* ps);
static void __phones_updates_tests_notify_phones_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _phones_updates_tests_update_phone (PhonesUpdatesTests* self);
static void phones_updates_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _phones_updates_tests_test_phones_updates_folks_test_case_test_method (gpointer self) {
	phones_updates_tests_test_phones_updates (self);
}


PhonesUpdatesTests* phones_updates_tests_construct (GType object_type) {
	PhonesUpdatesTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (PhonesUpdatesTests*) folks_test_case_construct (object_type, "PhonesUpdates");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	tracker_test_backend_set_debug (self->priv->_tracker_backend, FALSE);
	folks_test_case_add_test ((FolksTestCase*) self, "phones updates", _phones_updates_tests_test_phones_updates_folks_test_case_test_method, self);
	return self;
}


PhonesUpdatesTests* phones_updates_tests_new (void) {
	return phones_updates_tests_construct (TYPE_PHONES_UPDATES_TESTS);
}


static void phones_updates_tests_real_set_up (FolksTestCase* base) {
	PhonesUpdatesTests * self;
	self = (PhonesUpdatesTests*) base;
}


static void phones_updates_tests_real_tear_down (FolksTestCase* base) {
	PhonesUpdatesTests * self;
	self = (PhonesUpdatesTests*) base;
}


static gboolean _lambda0_ (PhonesUpdatesTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void phones_updates_tests_test_phones_updates (PhonesUpdatesTests* self) {
	GMainLoop* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* c1;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	c1 = _tmp1_;
	_tmp2_ = g_strdup ("persona #1");
	_g_free0 (self->priv->_initial_fullname_1);
	self->priv->_initial_fullname_1 = _tmp2_;
	_tmp3_ = g_strdup ("<urn:contact001>");
	_g_free0 (self->priv->_contact_urn_1);
	self->priv->_contact_urn_1 = _tmp3_;
	_tmp4_ = g_strdup ("12345");
	_g_free0 (self->priv->_phone_1);
	self->priv->_phone_1 = _tmp4_;
	_tmp5_ = g_strdup ("54321");
	_g_free0 (self->priv->_phone_2);
	self->priv->_phone_2 = _tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRACKER_TEST_BACKEND_URN, self->priv->_contact_urn_1);
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_FULLNAME, self->priv->_initial_fullname_1);
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_PHONE_PROP, self->priv->_phone_1);
	tracker_test_backend_add_contact (self->priv->_tracker_backend, c1);
	tracker_test_backend_set_up (self->priv->_tracker_backend);
	_tmp6_ = g_strdup ("");
	_g_free0 (self->priv->_individual_id);
	self->priv->_individual_id = _tmp6_;
	self->priv->_initial_phone_found = FALSE;
	self->priv->_initial_phone_found_again = FALSE;
	self->priv->_updated_phone_found = FALSE;
	_phones_updates_tests_test_phones_updates_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (self->priv->_initial_phone_found == TRUE);
	g_assert (self->priv->_initial_phone_found_again == FALSE);
	g_assert (self->priv->_updated_phone_found == TRUE);
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
	_g_object_unref0 (c1);
}


static void _phones_updates_tests_test_phones_updates_async_data_free (gpointer _data) {
	PhonesUpdatesTestsTestPhonesUpdatesAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (PhonesUpdatesTestsTestPhonesUpdatesAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _phones_updates_tests_test_phones_updates_async (PhonesUpdatesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PhonesUpdatesTestsTestPhonesUpdatesAsyncData* _data_;
	_data_ = g_slice_new0 (PhonesUpdatesTestsTestPhonesUpdatesAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _phones_updates_tests_test_phones_updates_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _phones_updates_tests_test_phones_updates_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_phones_updates_tests_test_phones_updates_async_co (_data_);
}


static void _phones_updates_tests_test_phones_updates_finish (PhonesUpdatesTests* self, GAsyncResult* _res_) {
	PhonesUpdatesTestsTestPhonesUpdatesAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _phones_updates_tests_test_phones_updates_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	PhonesUpdatesTestsTestPhonesUpdatesAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_phones_updates_tests_test_phones_updates_async_co (data);
}


static void __phones_updates_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_phones_updates_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static gboolean _phones_updates_tests_test_phones_updates_async_co (PhonesUpdatesTestsTestPhonesUpdatesAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, _phones_updates_tests_test_phones_updates_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_aggregator_new ();
	_g_object_unref0 (data->self->priv->_aggregator);
	data->self->priv->_aggregator = data->_tmp1_;
	g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __phones_updates_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, _phones_updates_tests_test_phones_updates_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("phones-updates.vala:109: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void __phones_updates_tests_notify_phones_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_phones_updates_tests_notify_phones_cb (self, _sender, pspec);
}


static void _phones_updates_tests_individuals_changed_cb (PhonesUpdatesTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) added);
		_i_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksIndividual* i;
			const gchar* _tmp3_ = NULL;
			_tmp1_ = gee_iterator_next (_i_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp2_;
			_tmp3_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
			if (g_strcmp0 (_tmp3_, self->priv->_initial_fullname_1) == 0) {
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				_tmp4_ = folks_individual_get_id (i);
				_tmp5_ = g_strdup (_tmp4_);
				_g_free0 (self->priv->_individual_id);
				self->priv->_individual_id = _tmp5_;
				g_signal_connect_object ((GObject*) i, "notify::phone-numbers", (GCallback) __phones_updates_tests_notify_phones_cb_g_object_notify, self, 0);
				{
					GeeSet* _tmp6_ = NULL;
					GeeIterator* _tmp7_ = NULL;
					GeeIterator* _fd_it;
					_tmp6_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) i);
					_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
					_fd_it = _tmp7_;
					while (TRUE) {
						gboolean _tmp8_;
						gpointer _tmp9_ = NULL;
						FolksFieldDetails* fd;
						const gchar* _tmp10_ = NULL;
						gchar* _tmp11_;
						gchar* phone;
						_tmp8_ = gee_iterator_next (_fd_it);
						if (!_tmp8_) {
							break;
						}
						_tmp9_ = gee_iterator_get (_fd_it);
						fd = (FolksFieldDetails*) _tmp9_;
						_tmp10_ = folks_field_details_get_value (fd);
						_tmp11_ = g_strdup (_tmp10_);
						phone = _tmp11_;
						if (g_strcmp0 (phone, self->priv->_phone_1) == 0) {
							self->priv->_initial_phone_found = TRUE;
							_phones_updates_tests_update_phone (self);
						}
						_g_free0 (phone);
						_g_object_unref0 (fd);
					}
					_g_object_unref0 (_fd_it);
				}
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_tmp12_ = gee_collection_get_size ((GeeCollection*) removed);
	g_assert (_tmp12_ == 0);
}


static void _phones_updates_tests_notify_phones_cb (PhonesUpdatesTests* self, GObject* individual_obj, GParamSpec* ps) {
	FolksIndividual* _tmp0_;
	FolksIndividual* i;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual_obj != NULL);
	g_return_if_fail (ps != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_INDIVIDUAL (individual_obj));
	i = _tmp0_;
	{
		GeeSet* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _fd_it;
		_tmp1_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) i);
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_fd_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			FolksFieldDetails* fd;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gchar* phone;
			_tmp3_ = gee_iterator_next (_fd_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_fd_it);
			fd = (FolksFieldDetails*) _tmp4_;
			_tmp5_ = folks_field_details_get_value (fd);
			_tmp6_ = g_strdup (_tmp5_);
			phone = _tmp6_;
			if (g_strcmp0 (phone, self->priv->_phone_1) == 0) {
				self->priv->_initial_phone_found_again = TRUE;
			}
			if (g_strcmp0 (phone, self->priv->_phone_2) == 0) {
				self->priv->_updated_phone_found = TRUE;
				g_main_loop_quit (self->priv->_main_loop);
			}
			_g_free0 (phone);
			_g_object_unref0 (fd);
		}
		_g_object_unref0 (_fd_it);
	}
	_g_object_unref0 (i);
}


static void _phones_updates_tests_update_phone (PhonesUpdatesTests* self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* urn_phone_1;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* urn_phone_2;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* affl_2;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strconcat ("<", self->priv->_phone_1, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ">", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	urn_phone_1 = _tmp3_;
	tracker_test_backend_remove_triplet (self->priv->_tracker_backend, self->priv->_contact_urn_1, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, urn_phone_1);
	_tmp4_ = g_strconcat ("<phone:", self->priv->_phone_2, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, ">", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	urn_phone_2 = _tmp7_;
	tracker_test_backend_insert_triplet (self->priv->_tracker_backend, urn_phone_2, "a", TRF_ONTOLOGY_DEFS_NCO_PHONE, TRF_ONTOLOGY_DEFS_NCO_PHONE_PROP, self->priv->_phone_2, NULL, NULL);
	_tmp8_ = g_strconcat ("<", self->priv->_phone_2, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, ">", NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	affl_2 = _tmp11_;
	tracker_test_backend_insert_triplet (self->priv->_tracker_backend, affl_2, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, NULL, NULL, NULL, NULL);
	tracker_test_backend_insert_triplet (self->priv->_tracker_backend, affl_2, TRF_ONTOLOGY_DEFS_NCO_HAS_PHONE, urn_phone_2, NULL, NULL, NULL, NULL);
	tracker_test_backend_insert_triplet (self->priv->_tracker_backend, self->priv->_contact_urn_1, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, affl_2, NULL, NULL, NULL, NULL);
	_g_free0 (affl_2);
	_g_free0 (urn_phone_2);
	_g_free0 (urn_phone_1);
}


static void phones_updates_tests_class_init (PhonesUpdatesTestsClass * klass) {
	phones_updates_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PhonesUpdatesTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = phones_updates_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = phones_updates_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = phones_updates_tests_finalize;
}


static void phones_updates_tests_instance_init (PhonesUpdatesTests * self) {
	self->priv = PHONES_UPDATES_TESTS_GET_PRIVATE (self);
}


static void phones_updates_tests_finalize (GObject* obj) {
	PhonesUpdatesTests * self;
	self = PHONES_UPDATES_TESTS (obj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_object_unref0 (self->priv->_aggregator);
	_g_free0 (self->priv->_initial_fullname_1);
	_g_free0 (self->priv->_contact_urn_1);
	_g_free0 (self->priv->_phone_1);
	_g_free0 (self->priv->_phone_2);
	_g_free0 (self->priv->_individual_id);
	G_OBJECT_CLASS (phones_updates_tests_parent_class)->finalize (obj);
}


GType phones_updates_tests_get_type (void) {
	static volatile gsize phones_updates_tests_type_id__volatile = 0;
	if (g_once_init_enter (&phones_updates_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhonesUpdatesTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) phones_updates_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhonesUpdatesTests), 0, (GInstanceInitFunc) phones_updates_tests_instance_init, NULL };
		GType phones_updates_tests_type_id;
		phones_updates_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "PhonesUpdatesTests", &g_define_type_info, 0);
		g_once_init_leave (&phones_updates_tests_type_id__volatile, phones_updates_tests_type_id);
	}
	return phones_updates_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	PhonesUpdatesTests* _tmp1_ = NULL;
	PhonesUpdatesTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = phones_updates_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



