/*
 *  Copyright (C) 2002 Christophe Fergeau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: ephy-notebook.h,v 1.7 2004/01/04 12:52:04 chpe Exp $
 */

#ifndef EPHY_NOTEBOOK_H
#define EPHY_NOTEBOOK_H

#include <glib.h>
#include <gtk/gtknotebook.h>

G_BEGIN_DECLS

#define EPHY_TYPE_NOTEBOOK		(ephy_notebook_get_type ())
#define EPHY_NOTEBOOK(o)		(G_TYPE_CHECK_INSTANCE_CAST ((o), EPHY_TYPE_NOTEBOOK, EphyNotebook))
#define EPHY_NOTEBOOK_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST((k), EPHY_TYPE_NOTEBOOK, EphyNotebookClass))
#define EPHY_IS_NOTEBOOK(o)		(G_TYPE_CHECK_INSTANCE_TYPE ((o), EPHY_TYPE_NOTEBOOK))
#define EPHY_IS_NOTEBOOK_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), EPHY_TYPE_NOTEBOOK))
#define EPHY_NOTEBOOK_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), EPHY_TYPE_NOTEBOOK, EphyNotebookClass))

typedef struct EphyNotebookClass EphyNotebookClass;
typedef struct EphyNotebook EphyNotebook;
typedef struct EphyNotebookPrivate EphyNotebookPrivate;

typedef enum
{
	EPHY_NOTEBOOK_TAB_LOAD_NORMAL,
	EPHY_NOTEBOOK_TAB_LOAD_LOADING,
	EPHY_NOTEBOOK_TAB_LOAD_COMPLETED
} EphyNotebookPageLoadStatus;

enum
{
	EPHY_NOTEBOOK_INSERT_LAST = -1,
	EPHY_NOTEBOOK_INSERT_GROUPED = -2
};

struct EphyNotebook
{
	GtkNotebook parent;

	/*< private >*/
        EphyNotebookPrivate *priv;
};

struct EphyNotebookClass
{
        GtkNotebookClass parent_class;

	/* Signals */
	void (* tab_added)      (EphyNotebook *notebook,
				 GtkWidget *child);
	void (* tab_removed)    (EphyNotebook *notebook,
				 GtkWidget *child);
	void (* tab_detached)   (EphyNotebook *notebook,
				 GtkWidget *child);
	void (* tabs_reordered) (EphyNotebook *notebook);
	void (* tab_delete)	(EphyNotebook *notebook,
				 GtkWidget *child);
};

GType		ephy_notebook_get_type		(void);

GtkWidget      *ephy_notebook_new		(void);

void		ephy_notebook_insert_page	(EphyNotebook *nb,
						 GtkWidget *child,
						 int position,
						 gboolean jump_to);

void		ephy_notebook_remove_page	(EphyNotebook *nb,
						 GtkWidget *child);

void            ephy_notebook_move_page         (EphyNotebook *src,
						 EphyNotebook *dest,
						 GtkWidget *src_page,
						 gint dest_page);

void		ephy_notebook_set_show_tabs	(EphyNotebook *nb,
						 gboolean show_tabs);

G_END_DECLS

#endif /* EPHY_NOTEBOOK_H */
