/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-bookmark.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-bookmark
 * @title: IAnjutaBookmark
 * @short_description: Bookmark interface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-bookmark.h
 * 
 */

#include "ianjuta-bookmark.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_bookmark_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-bookmark-quark");
	}
	
	return quark;
}

/**
 * ianjuta_bookmark_clear_all:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Clear all bookmarks
 *
 */
void
ianjuta_bookmark_clear_all (IAnjutaBookmark *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BOOKMARK(obj));
	IANJUTA_BOOKMARK_GET_IFACE (obj)->clear_all (obj, err);
}

/* Default implementation */
static void
ianjuta_bookmark_clear_all_default (IAnjutaBookmark *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_bookmark_first:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Goto first bookmark
 *
 */
void
ianjuta_bookmark_first (IAnjutaBookmark *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BOOKMARK(obj));
	IANJUTA_BOOKMARK_GET_IFACE (obj)->first (obj, err);
}

/* Default implementation */
static void
ianjuta_bookmark_first_default (IAnjutaBookmark *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_bookmark_last:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Goto last bookmark
 *
 */
void
ianjuta_bookmark_last (IAnjutaBookmark *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BOOKMARK(obj));
	IANJUTA_BOOKMARK_GET_IFACE (obj)->last (obj, err);
}

/* Default implementation */
static void
ianjuta_bookmark_last_default (IAnjutaBookmark *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_bookmark_next:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Goto next bookmark
 *
 */
void
ianjuta_bookmark_next (IAnjutaBookmark *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BOOKMARK(obj));
	IANJUTA_BOOKMARK_GET_IFACE (obj)->next (obj, err);
}

/* Default implementation */
static void
ianjuta_bookmark_next_default (IAnjutaBookmark *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_bookmark_previous:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Goto previous bookmark
 *
 */
void
ianjuta_bookmark_previous (IAnjutaBookmark *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BOOKMARK(obj));
	IANJUTA_BOOKMARK_GET_IFACE (obj)->previous (obj, err);
}

/* Default implementation */
static void
ianjuta_bookmark_previous_default (IAnjutaBookmark *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_bookmark_toggle:
 * @obj: Self
 * @location: The location where bookmark is toggled.
 * @ensure_visible: If the location must be made visible.
 * @err: Error propagation and reporting
 *
 * Toggle bookmark at given @location
 *
 */
void
ianjuta_bookmark_toggle (IAnjutaBookmark *obj, gint location,   gboolean ensure_visible, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BOOKMARK(obj));
	IANJUTA_BOOKMARK_GET_IFACE (obj)->toggle (obj, location, ensure_visible, err);
}

/* Default implementation */
static void
ianjuta_bookmark_toggle_default (IAnjutaBookmark *obj, gint location,   gboolean ensure_visible, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_bookmark_base_init (IAnjutaBookmarkIface* klass)
{
	static gboolean initialized = FALSE;

	klass->clear_all = ianjuta_bookmark_clear_all_default;
	klass->first = ianjuta_bookmark_first_default;
	klass->last = ianjuta_bookmark_last_default;
	klass->next = ianjuta_bookmark_next_default;
	klass->previous = ianjuta_bookmark_previous_default;
	klass->toggle = ianjuta_bookmark_toggle_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_bookmark_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaBookmarkIface),
			(GBaseInitFunc) ianjuta_bookmark_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaBookmark", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
