/* rygel-http-post-test.c generated by valac, the Vala compiler
 * generated from rygel-http-post-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <libgssdp/gssdp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_HTTP_POST_TEST (rygel_http_post_test_get_type ())
#define RYGEL_HTTP_POST_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST_TEST, RygelHTTPPostTest))
#define RYGEL_HTTP_POST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST_TEST, RygelHTTPPostTestClass))
#define RYGEL_IS_HTTP_POST_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST_TEST))
#define RYGEL_IS_HTTP_POST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST_TEST))
#define RYGEL_HTTP_POST_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST_TEST, RygelHTTPPostTestClass))

typedef struct _RygelHTTPPostTest RygelHTTPPostTest;
typedef struct _RygelHTTPPostTestClass RygelHTTPPostTestClass;
typedef struct _RygelHTTPPostTestPrivate RygelHTTPPostTestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelHttpPostTestHandleClientMessageData RygelHttpPostTestHandleClientMessageData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _RygelHttpPostTestCheckAndExitData RygelHttpPostTestCheckAndExitData;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;
typedef struct _Block2Data Block2Data;
typedef struct _RygelMediaContainerFindObjectData RygelMediaContainerFindObjectData;
typedef struct _Block3Data Block3Data;
typedef struct _RygelMediaItemGetWritableData RygelMediaItemGetWritableData;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;
typedef struct _Block4Data Block4Data;
typedef struct _RygelHttpResponseRunData RygelHttpResponseRunData;
typedef struct _RygelParamSpecMediaObject RygelParamSpecMediaObject;

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPPostTest {
	GObject parent_instance;
	RygelHTTPPostTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
};

struct _RygelHTTPPostTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPPostTest* self, GError** error);
};

struct _RygelHTTPPostTestPrivate {
	gboolean server_done;
	gboolean client_done;
	GMainLoop* main_loop;
	GError* error;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHttpPostTestHandleClientMessageData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPostTest* self;
	SoupMessage* msg;
	RygelHTTPRequest* request;
	RygelHTTPRequest* _tmp0_;
	GError* _tmp1_;
	GError * _error_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	RygelMediaItem* item;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* id;
	glong size;
	glong duration;
	GFile* file;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	gchar* content;
	gint content_length1;
	GUPnPContext* context;
	SoupMessage* msg;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHttpPostTestCheckAndExitData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPostTest* self;
	gboolean _tmp0_;
	GFile* file;
	GFileInputStream* stream;
	gchar* buffer;
	gchar* _tmp1_;
	gint _buffer_size_;
	gint buffer_length1;
	gint i;
	gboolean _tmp2_;
	GError* _tmp3_;
	GError * _error_;
	GError * _inner_error_;
};

struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	GSourceFunc _tmp0_;
	Block1Data* _data1_;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediaContainer * self;
	GSourceFunc find_object_continue;
	gpointer find_object_continue_target;
	GDestroyNotify find_object_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediaContainerFindObjectData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	char* item_id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	GSourceFunc _tmp0_;
	Block2Data* _data2_;
};

struct _Block3Data {
	int _ref_count_;
	RygelMediaItem * self;
	GSourceFunc get_writable_continue;
	gpointer get_writable_continue_target;
	GDestroyNotify get_writable_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediaItemGetWritableData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaItem* self;
	GCancellable* cancellable;
	GFile* result;
	GSourceFunc _tmp0_;
	Block3Data* _data3_;
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
};

struct _RygelHTTPResponsePrivate {
	GCancellable* _cancellable;
	SoupMessage* msg;
	SoupServer* server;
};

struct _Block4Data {
	int _ref_count_;
	RygelHTTPResponse * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpResponseRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPResponse* self;
	GSourceFunc _tmp0_;
	Block4Data* _data4_;
};

struct _RygelParamSpecMediaObject {
	GParamSpec parent_instance;
};


static gpointer rygel_http_post_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_http_response_parent_class = NULL;
static RygelStateMachineIface* rygel_http_response_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_object_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_post_test_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_POST_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_POST_TEST, RygelHTTPPostTestPrivate))
enum  {
	RYGEL_HTTP_POST_TEST_DUMMY_PROPERTY
};
RygelHTTPPostTest* rygel_http_post_test_new (GError** error);
RygelHTTPPostTest* rygel_http_post_test_construct (GType object_type, GError** error);
void rygel_http_post_test_run (RygelHTTPPostTest* self, GError** error);
gint rygel_http_post_test_main (char** args, int args_length1);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
char* rygel_http_server_get_uri (RygelHTTPServer* self);
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const char* uri);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const char* uri);
static gboolean rygel_http_post_test_on_timeout (RygelHTTPPostTest* self);
static gboolean _rygel_http_post_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_post_test_on_message_received (RygelHTTPPostTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_post_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
static void rygel_http_post_test_on_client_completed (RygelHTTPPostTest* self, RygelStateMachine* client);
static void _rygel_http_post_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_http_post_test_real_run (RygelHTTPPostTest* self, GError** error);
RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_post_get_type (void) G_GNUC_CONST;
static RygelHTTPRequest* rygel_http_post_test_create_request (RygelHTTPPostTest* self, SoupMessage* msg, GError** error);
static void rygel_http_post_test_check_and_exit (RygelHTTPPostTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_test_check_and_exit_finish (RygelHTTPPostTest* self, GAsyncResult* _res_);
static void rygel_http_post_test_handle_client_message (RygelHTTPPostTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_test_handle_client_message_finish (RygelHTTPPostTest* self, GAsyncResult* _res_);
static void rygel_http_post_test_handle_client_message_data_free (gpointer _data);
static void rygel_http_post_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
static gboolean rygel_http_post_test_handle_client_message_co (RygelHttpPostTestHandleClientMessageData* data);
static void rygel_http_post_test_check_and_exit_data_free (gpointer _data);
static void rygel_http_post_test_check_and_exit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
#define RYGEL_HTTP_CLIENT_LENGTH ((gsize) 1024)
static gboolean rygel_http_post_test_check_and_exit_co (RygelHttpPostTestCheckAndExitData* data);
static void rygel_http_post_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, SoupClientContext* client);
static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg);
static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self);
const char* rygel_http_server_get_path_root (RygelHTTPServer* self);
#define RYGEL_MEDIA_CONTAINER_ITEM_ID "TestItem"
RygelHTTPItemURI* rygel_http_item_uri_new (const char* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const char* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const char* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const char* transcode_target);
char* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_server_finalize (GObject* obj);
static void rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_client_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void _lambda2_ (SoupSession* session, SoupMessage* msg, Block1Data* _data1_);
static void __lambda2__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* data);
static void rygel_http_client_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
RygelMediaItem* rygel_media_item_new (const char* id);
RygelMediaItem* rygel_media_item_construct (GType object_type, const char* id);
static void rygel_media_container_find_object_data_free (gpointer _data);
static void rygel_media_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const char* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self);
static gboolean _lambda1_ (Block2Data* _data2_);
static gboolean __lambda1__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* data);
static void rygel_media_container_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_ITEM_URI "file:///tmp/rygel-upload-test.wav"
static void rygel_media_item_get_writable_data_free (gpointer _data);
static void rygel_media_item_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_item_get_writable (RygelMediaItem* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_item_get_writable_finish (RygelMediaItem* self, GAsyncResult* _res_, GError** error);
static gboolean _rygel_media_item_get_writable_co_gsource_func (gpointer self);
static gboolean _lambda0_ (Block3Data* _data3_);
static gboolean __lambda0__gsource_func (gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean rygel_media_item_get_writable_co (RygelMediaItemGetWritableData* data);
static void rygel_media_item_finalize (RygelMediaObject* obj);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponsePrivate))
enum  {
	RYGEL_HTTP_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_RESPONSE_CANCELLABLE
};
RygelHTTPResponse* rygel_http_response_new (RygelHTTPPost* get_request);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPPost* get_request);
static void rygel_http_response_real_run_data_free (gpointer _data);
static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self);
static gboolean _lambda3_ (Block4Data* _data4_);
static gboolean __lambda3__gsource_func (gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* data);
static void rygel_http_response_finalize (GObject* obj);
static void rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
static void rygel_media_object_finalize (RygelMediaObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


#line 43 "rygel-http-post-test.vala"
gint rygel_http_post_test_main (char** args, int args_length1) {
#line 582 "rygel-http-post-test.c"
	gint result = 0;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		RygelHTTPPostTest* test;
#line 45 "rygel-http-post-test.vala"
		test = rygel_http_post_test_new (&_inner_error_);
#line 590 "rygel-http-post-test.c"
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 47 "rygel-http-post-test.vala"
		rygel_http_post_test_run (test, &_inner_error_);
#line 599 "rygel-http-post-test.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (test);
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (test);
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			result = _error_->code;
			_g_error_free0 (_error_);
#line 49 "rygel-http-post-test.vala"
			return result;
#line 620 "rygel-http-post-test.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 51 "rygel-http-post-test.vala"
			g_critical ("rygel-http-post-test.vala:51: %s", _error_->message);
#line 632 "rygel-http-post-test.c"
			result = -1;
			_g_error_free0 (_error_);
#line 53 "rygel-http-post-test.vala"
			return result;
#line 637 "rygel-http-post-test.c"
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
#line 56 "rygel-http-post-test.vala"
	return result;
#line 649 "rygel-http-post-test.c"
}


#line 43 "rygel-http-post-test.vala"
int main (int argc, char ** argv) {
#line 655 "rygel-http-post-test.c"
	g_thread_init (NULL);
#line 43 "rygel-http-post-test.vala"
	g_type_init ();
#line 43 "rygel-http-post-test.vala"
	return rygel_http_post_test_main (argv, argc);
#line 661 "rygel-http-post-test.c"
}


#line 59 "rygel-http-post-test.vala"
RygelHTTPPostTest* rygel_http_post_test_construct (GType object_type, GError** error) {
#line 667 "rygel-http-post-test.c"
	GError * _inner_error_;
	RygelHTTPPostTest * self;
	RygelHTTPServer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPClient* _tmp3_;
	char* _tmp2_;
	GMainLoop* _tmp4_;
	_inner_error_ = NULL;
#line 59 "rygel-http-post-test.vala"
	self = (RygelHTTPPostTest*) g_object_new (object_type, NULL);
#line 60 "rygel-http-post-test.vala"
	_tmp0_ = rygel_http_server_new (&_inner_error_);
#line 680 "rygel-http-post-test.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
#line 60 "rygel-http-post-test.vala"
	self->server = (_tmp1_ = _tmp0_, _g_object_unref0 (self->server), _tmp1_);
#line 61 "rygel-http-post-test.vala"
	self->client = (_tmp3_ = rygel_http_client_new (self->server->context, _tmp2_ = rygel_http_server_get_uri (self->server)), _g_object_unref0 (self->client), _tmp3_);
#line 690 "rygel-http-post-test.c"
	_g_free0 (_tmp2_);
#line 63 "rygel-http-post-test.vala"
	self->priv->main_loop = (_tmp4_ = g_main_loop_new (NULL, FALSE), _g_main_loop_unref0 (self->priv->main_loop), _tmp4_);
#line 694 "rygel-http-post-test.c"
	return self;
}


#line 59 "rygel-http-post-test.vala"
RygelHTTPPostTest* rygel_http_post_test_new (GError** error) {
#line 59 "rygel-http-post-test.vala"
	return rygel_http_post_test_construct (RYGEL_TYPE_HTTP_POST_TEST, error);
#line 703 "rygel-http-post-test.c"
}


#line 114 "rygel-http-post-test.vala"
static gboolean _rygel_http_post_test_on_timeout_gsource_func (gpointer self) {
#line 709 "rygel-http-post-test.c"
	gboolean result;
	result = rygel_http_post_test_on_timeout (self);
	return result;
}


#line 91 "rygel-http-post-test.vala"
static void _rygel_http_post_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 718 "rygel-http-post-test.c"
	rygel_http_post_test_on_message_received (self, _sender, message);
}


#line 86 "rygel-http-post-test.vala"
static void _rygel_http_post_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 725 "rygel-http-post-test.c"
	rygel_http_post_test_on_client_completed (self, _sender);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


#line 66 "rygel-http-post-test.vala"
static void rygel_http_post_test_real_run (RygelHTTPPostTest* self, GError** error) {
#line 737 "rygel-http-post-test.c"
	GError * _inner_error_;
#line 66 "rygel-http-post-test.vala"
	g_return_if_fail (self != NULL);
#line 741 "rygel-http-post-test.c"
	_inner_error_ = NULL;
#line 67 "rygel-http-post-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_post_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 68 "rygel-http-post-test.vala"
	g_signal_connect_object (self->server, "message-received", (GCallback) _rygel_http_post_test_on_message_received_rygel_http_server_message_received, self, 0);
#line 69 "rygel-http-post-test.vala"
	g_signal_connect_object ((RygelStateMachine*) self->client, "completed", (GCallback) _rygel_http_post_test_on_client_completed_rygel_state_machine_completed, self, 0);
#line 71 "rygel-http-post-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) self->client, NULL, NULL);
#line 73 "rygel-http-post-test.vala"
	g_main_loop_run (self->priv->main_loop);
#line 75 "rygel-http-post-test.vala"
	if (self->priv->error != NULL) {
#line 755 "rygel-http-post-test.c"
		_inner_error_ = _g_error_copy0 (self->priv->error);
		{
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


#line 66 "rygel-http-post-test.vala"
void rygel_http_post_test_run (RygelHTTPPostTest* self, GError** error) {
#line 66 "rygel-http-post-test.vala"
	RYGEL_HTTP_POST_TEST_GET_CLASS (self)->run (self, error);
#line 769 "rygel-http-post-test.c"
}


#line 80 "rygel-http-post-test.vala"
static RygelHTTPRequest* rygel_http_post_test_create_request (RygelHTTPPostTest* self, SoupMessage* msg, GError** error) {
#line 775 "rygel-http-post-test.c"
	RygelHTTPRequest* result = NULL;
#line 80 "rygel-http-post-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "rygel-http-post-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 781 "rygel-http-post-test.c"
	result = (RygelHTTPRequest*) rygel_http_post_new (self->server, gupnp_context_get_server (self->server->context), msg);
#line 81 "rygel-http-post-test.vala"
	return result;
#line 785 "rygel-http-post-test.c"
}


#line 86 "rygel-http-post-test.vala"
static void rygel_http_post_test_on_client_completed (RygelHTTPPostTest* self, RygelStateMachine* client) {
#line 86 "rygel-http-post-test.vala"
	g_return_if_fail (self != NULL);
#line 86 "rygel-http-post-test.vala"
	g_return_if_fail (client != NULL);
#line 87 "rygel-http-post-test.vala"
	self->priv->client_done = TRUE;
#line 88 "rygel-http-post-test.vala"
	rygel_http_post_test_check_and_exit (self, NULL, NULL);
#line 799 "rygel-http-post-test.c"
}


#line 91 "rygel-http-post-test.vala"
static void rygel_http_post_test_on_message_received (RygelHTTPPostTest* self, RygelHTTPServer* server, SoupMessage* msg) {
#line 91 "rygel-http-post-test.vala"
	g_return_if_fail (self != NULL);
#line 91 "rygel-http-post-test.vala"
	g_return_if_fail (server != NULL);
#line 91 "rygel-http-post-test.vala"
	g_return_if_fail (msg != NULL);
#line 93 "rygel-http-post-test.vala"
	rygel_http_post_test_handle_client_message (self, msg, NULL, NULL);
#line 813 "rygel-http-post-test.c"
}


static void rygel_http_post_test_handle_client_message_data_free (gpointer _data) {
	RygelHttpPostTestHandleClientMessageData* data;
	data = _data;
	_g_object_unref0 (data->msg);
	g_object_unref (data->self);
	g_slice_free (RygelHttpPostTestHandleClientMessageData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_http_post_test_handle_client_message (RygelHTTPPostTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostTestHandleClientMessageData* _data_;
	_data_ = g_slice_new0 (RygelHttpPostTestHandleClientMessageData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_test_handle_client_message);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_test_handle_client_message_data_free);
	_data_->self = g_object_ref (self);
	_data_->msg = _g_object_ref0 (msg);
	rygel_http_post_test_handle_client_message_co (_data_);
}


static void rygel_http_post_test_handle_client_message_finish (RygelHTTPPostTest* self, GAsyncResult* _res_) {
	RygelHttpPostTestHandleClientMessageData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_post_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostTestHandleClientMessageData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_post_test_handle_client_message_co (data);
}


static gboolean rygel_http_post_test_handle_client_message_co (RygelHttpPostTestHandleClientMessageData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->request = rygel_http_post_test_create_request (data->self, data->msg, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			data->_state_ = 1;
			rygel_state_machine_run ((RygelStateMachine*) data->request, rygel_http_post_test_handle_client_message_ready, data);
			return FALSE;
			_state_1:
#line 100 "rygel-http-post-test.vala"
			rygel_state_machine_run_finish ((RygelStateMachine*) data->request, data->_res_);
#line 102 "rygel-http-post-test.vala"
			g_assert (((RygelHTTPRequest*) (data->_tmp0_ = data->request, RYGEL_IS_HTTP_POST (data->_tmp0_) ? ((RygelHTTPPost*) data->_tmp0_) : NULL))->item != NULL);
#line 104 "rygel-http-post-test.vala"
			data->self->priv->server_done = TRUE;
#line 105 "rygel-http-post-test.vala"
			rygel_http_post_test_check_and_exit (data->self, NULL, NULL);
#line 884 "rygel-http-post-test.c"
			_g_object_unref0 (data->request);
		}
		goto __finally1;
		__catch1_g_error:
		{
			data->_error_ = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
#line 107 "rygel-http-post-test.vala"
				data->self->priv->error = (data->_tmp1_ = _g_error_copy0 (data->_error_), _g_error_free0 (data->self->priv->error), data->_tmp1_);
#line 108 "rygel-http-post-test.vala"
				g_main_loop_quit (data->self->priv->main_loop);
#line 897 "rygel-http-post-test.c"
				_g_error_free0 (data->_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_error_free0 (data->_error_);
			}
		}
		__finally1:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 114 "rygel-http-post-test.vala"
static gboolean rygel_http_post_test_on_timeout (RygelHTTPPostTest* self) {
#line 932 "rygel-http-post-test.c"
	gboolean result = FALSE;
	GError* _tmp0_;
#line 114 "rygel-http-post-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 115 "rygel-http-post-test.vala"
	self->priv->error = (_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout"), _g_error_free0 (self->priv->error), _tmp0_);
#line 116 "rygel-http-post-test.vala"
	g_main_loop_quit (self->priv->main_loop);
#line 941 "rygel-http-post-test.c"
	result = FALSE;
#line 118 "rygel-http-post-test.vala"
	return result;
#line 945 "rygel-http-post-test.c"
}


static void rygel_http_post_test_check_and_exit_data_free (gpointer _data) {
	RygelHttpPostTestCheckAndExitData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelHttpPostTestCheckAndExitData, data);
}


static void rygel_http_post_test_check_and_exit (RygelHTTPPostTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostTestCheckAndExitData* _data_;
	_data_ = g_slice_new0 (RygelHttpPostTestCheckAndExitData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_test_check_and_exit);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_test_check_and_exit_data_free);
	_data_->self = g_object_ref (self);
	rygel_http_post_test_check_and_exit_co (_data_);
}


static void rygel_http_post_test_check_and_exit_finish (RygelHTTPPostTest* self, GAsyncResult* _res_) {
	RygelHttpPostTestCheckAndExitData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_post_test_check_and_exit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostTestCheckAndExitData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_post_test_check_and_exit_co (data);
}


static gboolean rygel_http_post_test_check_and_exit_co (RygelHttpPostTestCheckAndExitData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
#line 122 "rygel-http-post-test.vala"
		if (data->self->priv->server_done) {
#line 122 "rygel-http-post-test.vala"
			data->_tmp0_ = data->self->priv->client_done;
#line 998 "rygel-http-post-test.c"
		} else {
#line 122 "rygel-http-post-test.vala"
			data->_tmp0_ = FALSE;
#line 1002 "rygel-http-post-test.c"
		}
#line 122 "rygel-http-post-test.vala"
		if (!data->_tmp0_) {
#line 1006 "rygel-http-post-test.c"
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		{
			data->file = _g_object_ref0 (data->self->server->root_container->item->file);
			data->_state_ = 2;
			g_file_read_async (data->file, G_PRIORITY_HIGH, NULL, rygel_http_post_test_check_and_exit_ready, data);
			return FALSE;
			_state_2:
			data->stream = g_file_read_finish (data->file, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->file);
				goto __catch2_g_error;
			}
			data->buffer = (data->_tmp1_ = g_new0 (gchar, RYGEL_HTTP_CLIENT_LENGTH), data->buffer_length1 = RYGEL_HTTP_CLIENT_LENGTH, data->_buffer_size_ = data->buffer_length1, data->_tmp1_);
			data->_state_ = 3;
			g_input_stream_read_async ((GInputStream*) data->stream, data->buffer, RYGEL_HTTP_CLIENT_LENGTH, G_PRIORITY_HIGH, NULL, rygel_http_post_test_check_and_exit_ready, data);
			return FALSE;
			_state_3:
#line 131 "rygel-http-post-test.vala"
			g_input_stream_read_finish ((GInputStream*) data->stream, data->_res_, &data->_inner_error_);
#line 1035 "rygel-http-post-test.c"
			if (data->_inner_error_ != NULL) {
				data->buffer = (g_free (data->buffer), NULL);
				_g_object_unref0 (data->stream);
				_g_object_unref0 (data->file);
				goto __catch2_g_error;
			}
			{
				data->i = 0;
				{
					data->_tmp2_ = TRUE;
#line 135 "rygel-http-post-test.vala"
					while (TRUE) {
#line 135 "rygel-http-post-test.vala"
						if (!data->_tmp2_) {
#line 135 "rygel-http-post-test.vala"
							data->i++;
#line 1052 "rygel-http-post-test.c"
						}
#line 135 "rygel-http-post-test.vala"
						data->_tmp2_ = FALSE;
#line 135 "rygel-http-post-test.vala"
						if (!(data->i < RYGEL_HTTP_CLIENT_LENGTH)) {
#line 135 "rygel-http-post-test.vala"
							break;
#line 1060 "rygel-http-post-test.c"
						}
#line 136 "rygel-http-post-test.vala"
						g_assert (data->buffer[data->i] == data->self->client->content[data->i]);
#line 1064 "rygel-http-post-test.c"
					}
				}
			}
			data->buffer = (g_free (data->buffer), NULL);
			_g_object_unref0 (data->stream);
			_g_object_unref0 (data->file);
		}
		goto __finally2;
		__catch2_g_error:
		{
			data->_error_ = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
#line 139 "rygel-http-post-test.vala"
				data->self->priv->error = (data->_tmp3_ = _g_error_copy0 (data->_error_), _g_error_free0 (data->self->priv->error), data->_tmp3_);
#line 1080 "rygel-http-post-test.c"
				_g_error_free0 (data->_error_);
			}
		}
		__finally2:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
#line 142 "rygel-http-post-test.vala"
		g_main_loop_quit (data->self->priv->main_loop);
#line 1092 "rygel-http-post-test.c"
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_http_post_test_class_init (RygelHTTPPostTestClass * klass) {
	rygel_http_post_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPPostTestPrivate));
	RYGEL_HTTP_POST_TEST_CLASS (klass)->run = rygel_http_post_test_real_run;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_post_test_finalize;
}


static void rygel_http_post_test_instance_init (RygelHTTPPostTest * self) {
	self->priv = RYGEL_HTTP_POST_TEST_GET_PRIVATE (self);
}


static void rygel_http_post_test_finalize (GObject* obj) {
	RygelHTTPPostTest * self;
	self = RYGEL_HTTP_POST_TEST (obj);
	_g_object_unref0 (self->server);
	_g_object_unref0 (self->client);
	_g_main_loop_unref0 (self->priv->main_loop);
	_g_error_free0 (self->priv->error);
	G_OBJECT_CLASS (rygel_http_post_test_parent_class)->finalize (obj);
}


GType rygel_http_post_test_get_type (void) {
	static volatile gsize rygel_http_post_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_post_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPPostTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_post_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPPostTest), 0, (GInstanceInitFunc) rygel_http_post_test_instance_init, NULL };
		GType rygel_http_post_test_type_id;
		rygel_http_post_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPPostTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_post_test_type_id__volatile, rygel_http_post_test_type_id);
	}
	return rygel_http_post_test_type_id__volatile;
}


#line 184 "rygel-http-post-test.vala"
static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
#line 1144 "rygel-http-post-test.c"
	rygel_http_server_on_request_started (self, _sender, msg, client);
}


#line 168 "rygel-http-post-test.vala"
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
#line 1151 "rygel-http-post-test.c"
	GError * _inner_error_;
	RygelHTTPServer * self;
	RygelMediaContainer* _tmp2_;
	_inner_error_ = NULL;
#line 168 "rygel-http-post-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 1158 "rygel-http-post-test.c"
	{
		GUPnPContext* _tmp0_;
		GUPnPContext* _tmp1_;
#line 170 "rygel-http-post-test.vala"
		_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 1164 "rygel-http-post-test.c"
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
#line 170 "rygel-http-post-test.vala"
		self->context = (_tmp1_ = _tmp0_, _g_object_unref0 (self->context), _tmp1_);
#line 1170 "rygel-http-post-test.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
			{
				_g_error_free0 (_error_);
				goto __finally3;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 175 "rygel-http-post-test.vala"
	g_assert (self->context != NULL);
#line 176 "rygel-http-post-test.vala"
	g_assert (gssdp_client_get_host_ip ((GSSDPClient*) self->context) != NULL);
#line 177 "rygel-http-post-test.vala"
	g_assert (gupnp_context_get_port (self->context) > 0);
#line 179 "rygel-http-post-test.vala"
	g_signal_connect_object (gupnp_context_get_server (self->context), "request-started", (GCallback) _rygel_http_server_on_request_started_soup_server_request_started, self, 0);
#line 181 "rygel-http-post-test.vala"
	self->root_container = (_tmp2_ = rygel_media_container_new (), _rygel_media_object_unref0 (self->root_container), _tmp2_);
#line 1209 "rygel-http-post-test.c"
	return self;
}


#line 168 "rygel-http-post-test.vala"
RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 168 "rygel-http-post-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 1218 "rygel-http-post-test.c"
}


#line 190 "rygel-http-post-test.vala"
static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self) {
#line 1224 "rygel-http-post-test.c"
	rygel_http_server_on_got_headers (self, _sender);
}


#line 184 "rygel-http-post-test.vala"
static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, SoupClientContext* client) {
#line 184 "rygel-http-post-test.vala"
	g_return_if_fail (self != NULL);
#line 184 "rygel-http-post-test.vala"
	g_return_if_fail (server != NULL);
#line 184 "rygel-http-post-test.vala"
	g_return_if_fail (msg != NULL);
#line 184 "rygel-http-post-test.vala"
	g_return_if_fail (client != NULL);
#line 187 "rygel-http-post-test.vala"
	g_signal_connect_object (msg, "got-headers", (GCallback) _rygel_http_server_on_got_headers_soup_message_got_headers, self, 0);
#line 1241 "rygel-http-post-test.c"
}


#line 190 "rygel-http-post-test.vala"
static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg) {
#line 190 "rygel-http-post-test.vala"
	g_return_if_fail (self != NULL);
#line 190 "rygel-http-post-test.vala"
	g_return_if_fail (msg != NULL);
#line 191 "rygel-http-post-test.vala"
	g_signal_emit_by_name (self, "message-received", msg);
#line 1253 "rygel-http-post-test.c"
}


const char* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = RYGEL_HTTP_SERVER_SERVER_PATH;
#line 150 "rygel-http-post-test.vala"
	return result;
#line 1263 "rygel-http-post-test.c"
}


char* rygel_http_server_get_uri (RygelHTTPServer* self) {
	char* result;
	RygelHTTPItemURI* item_uri;
	g_return_val_if_fail (self != NULL, NULL);
#line 159 "rygel-http-post-test.vala"
	item_uri = rygel_http_item_uri_new (RYGEL_MEDIA_CONTAINER_ITEM_ID, self, -1, -1, NULL);
#line 1273 "rygel-http-post-test.c"
	result = rygel_http_item_uri_to_string (item_uri);
	_g_object_unref0 (item_uri);
#line 162 "rygel-http-post-test.vala"
	return result;
#line 1278 "rygel-http-post-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = rygel_http_server_get_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SOUP_TYPE_MESSAGE);
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (obj);
	_rygel_media_object_unref0 (self->root_container);
	_g_object_unref0 (self->context);
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT:
		g_value_set_string (value, rygel_http_server_get_path_root (self));
		break;
		case RYGEL_HTTP_SERVER_URI:
		g_value_take_string (value, rygel_http_server_get_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


#line 205 "rygel-http-post-test.vala"
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const char* uri) {
#line 1336 "rygel-http-post-test.c"
	RygelHTTPClient * self;
	GUPnPContext* _tmp0_;
	gchar* _tmp1_;
	SoupMessage* _tmp2_;
#line 205 "rygel-http-post-test.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 205 "rygel-http-post-test.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 205 "rygel-http-post-test.vala"
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
#line 207 "rygel-http-post-test.vala"
	self->context = (_tmp0_ = _g_object_ref0 (context), _g_object_unref0 (self->context), _tmp0_);
#line 208 "rygel-http-post-test.vala"
	self->content = (_tmp1_ = g_new0 (gchar, 1024), self->content = (g_free (self->content), NULL), self->content_length1 = 1024, _tmp1_);
#line 210 "rygel-http-post-test.vala"
	self->msg = (_tmp2_ = soup_message_new ("POST", uri), _g_object_unref0 (self->msg), _tmp2_);
#line 211 "rygel-http-post-test.vala"
	g_assert (self->msg != NULL);
#line 1355 "rygel-http-post-test.c"
	return self;
}


#line 205 "rygel-http-post-test.vala"
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const char* uri) {
#line 205 "rygel-http-post-test.vala"
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context, uri);
#line 1364 "rygel-http-post-test.c"
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelHttpClientRunData, data);
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	self = (RygelHTTPClient*) base;
	_data_ = g_slice_new0 (RygelHttpClientRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_http_client_real_run_co (_data_);
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_client_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpClientRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_client_real_run_co (data);
}


#line 214 "rygel-http-post-test.vala"
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
#line 1404 "rygel-http-post-test.c"
	gboolean result;
	result = rygel_http_client_real_run_co (self);
	return result;
}


#line 219 "rygel-http-post-test.vala"
static void _lambda2_ (SoupSession* session, SoupMessage* msg, Block1Data* _data1_) {
#line 1413 "rygel-http-post-test.c"
	RygelHTTPClient * self;
	self = _data1_->self;
#line 219 "rygel-http-post-test.vala"
	g_return_if_fail (session != NULL);
#line 219 "rygel-http-post-test.vala"
	g_return_if_fail (msg != NULL);
#line 220 "rygel-http-post-test.vala"
	_data1_->run_continue (_data1_->run_continue_target);
#line 1422 "rygel-http-post-test.c"
}


#line 219 "rygel-http-post-test.vala"
static void __lambda2__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
#line 1428 "rygel-http-post-test.c"
	_lambda2_ (session, msg, self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
		_data1_->run_continue = NULL;
		_data1_->run_continue_target = NULL;
		_data1_->run_continue_target_destroy_notify = NULL;
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_data1_ = g_slice_new0 (Block1Data);
		data->_data1_->_ref_count_ = 1;
		data->_data1_->self = g_object_ref (data->self);
		data->_data1_->_async_data_ = data;
		data->_data1_->run_continue = (data->_tmp0_ = _rygel_http_client_real_run_co_gsource_func, data->_data1_->run_continue_target = data, data->_data1_->run_continue_target_destroy_notify = NULL, data->_tmp0_);
#line 217 "rygel-http-post-test.vala"
		soup_message_body_append (data->self->msg->request_body, SOUP_MEMORY_COPY, data->self->content, RYGEL_HTTP_CLIENT_LENGTH);
#line 219 "rygel-http-post-test.vala"
		soup_session_queue_message (gupnp_context_get_session (data->self->context), _g_object_ref0 (data->self->msg), __lambda2__soup_session_callback, data->_data1_);
#line 1471 "rygel-http-post-test.c"
		data->_state_ = 4;
		return FALSE;
		_state_4:
		;
#line 225 "rygel-http-post-test.vala"
		g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
#line 1478 "rygel-http-post-test.c"
		block1_data_unref (data->_data1_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	self = (RygelHTTPClient*) base;
	result = self->priv->_cancellable;
#line 203 "rygel-http-post-test.vala"
	return result;
#line 1500 "rygel-http-post-test.c"
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
	self = (RygelHTTPClient*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_http_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_http_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, "cancellable");
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_http_client_real_run;
	iface->run_finish = rygel_http_client_real_run_finish;
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (obj);
	self->content = (g_free (self->content), NULL);
	_g_object_unref0 (self->context);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


#line 234 "rygel-http-post-test.vala"
RygelMediaContainer* rygel_media_container_construct (GType object_type) {
#line 1592 "rygel-http-post-test.c"
	RygelMediaContainer* self;
	RygelMediaItem* _tmp0_;
#line 234 "rygel-http-post-test.vala"
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
#line 235 "rygel-http-post-test.vala"
	self->item = (_tmp0_ = rygel_media_item_new (RYGEL_MEDIA_CONTAINER_ITEM_ID), _rygel_media_object_unref0 (self->item), _tmp0_);
#line 1599 "rygel-http-post-test.c"
	return self;
}


#line 234 "rygel-http-post-test.vala"
RygelMediaContainer* rygel_media_container_new (void) {
#line 234 "rygel-http-post-test.vala"
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
#line 1608 "rygel-http-post-test.c"
}


static void rygel_media_container_find_object_data_free (gpointer _data) {
	RygelMediaContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->item_id);
	_g_object_unref0 (data->cancellable);
	_rygel_media_object_unref0 (data->result);
	rygel_media_object_unref (data->self);
	g_slice_free (RygelMediaContainerFindObjectData, data);
}


void rygel_media_container_find_object (RygelMediaContainer* self, const char* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* _data_;
	_data_ = g_slice_new0 (RygelMediaContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_media_container_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_find_object_data_free);
	_data_->self = rygel_media_object_ref (self);
	_data_->item_id = g_strdup (item_id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_container_find_object_co (_data_);
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_container_find_object_co (data);
}


#line 238 "rygel-http-post-test.vala"
static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self) {
#line 1658 "rygel-http-post-test.c"
	gboolean result;
	result = rygel_media_container_find_object_co (self);
	return result;
}


#line 242 "rygel-http-post-test.vala"
static gboolean _lambda1_ (Block2Data* _data2_) {
#line 1667 "rygel-http-post-test.c"
	RygelMediaContainer * self;
	gboolean result = FALSE;
	self = _data2_->self;
#line 243 "rygel-http-post-test.vala"
	_data2_->find_object_continue (_data2_->find_object_continue_target);
#line 1673 "rygel-http-post-test.c"
	result = FALSE;
#line 245 "rygel-http-post-test.vala"
	return result;
#line 1677 "rygel-http-post-test.c"
}


#line 242 "rygel-http-post-test.vala"
static gboolean __lambda1__gsource_func (gpointer self) {
#line 1683 "rygel-http-post-test.c"
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


static gpointer _rygel_media_object_ref0 (gpointer self) {
	return self ? rygel_media_object_ref (self) : NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_rygel_media_object_unref0 (_data2_->self);
		(_data2_->find_object_continue_target_destroy_notify == NULL) ? NULL : (_data2_->find_object_continue_target_destroy_notify (_data2_->find_object_continue_target), NULL);
		_data2_->find_object_continue = NULL;
		_data2_->find_object_continue_target = NULL;
		_data2_->find_object_continue_target_destroy_notify = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_data2_ = g_slice_new0 (Block2Data);
		data->_data2_->_ref_count_ = 1;
		data->_data2_->self = rygel_media_object_ref (data->self);
		data->_data2_->_async_data_ = data;
		data->_data2_->find_object_continue = (data->_tmp0_ = _rygel_media_container_find_object_co_gsource_func, data->_data2_->find_object_continue_target = data, data->_data2_->find_object_continue_target_destroy_notify = NULL, data->_tmp0_);
#line 242 "rygel-http-post-test.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda1__gsource_func, block2_data_ref (data->_data2_), block2_data_unref);
#line 1731 "rygel-http-post-test.c"
		data->_state_ = 5;
		return FALSE;
		_state_5:
		;
#line 250 "rygel-http-post-test.vala"
		if (_vala_strcmp0 (data->item_id, RYGEL_MEDIA_CONTAINER_ITEM_ID) == 0) {
#line 1738 "rygel-http-post-test.c"
			data->result = _rygel_media_object_ref0 ((RygelMediaObject*) data->self->item);
			block2_data_unref (data->_data2_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			data->result = NULL;
			block2_data_unref (data->_data2_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		block2_data_unref (data->_data2_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_container_finalize;
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


static void rygel_media_container_finalize (RygelMediaObject* obj) {
	RygelMediaContainer * self;
	self = RYGEL_MEDIA_CONTAINER (obj);
	_rygel_media_object_unref0 (self->item);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_container_parent_class)->finalize (obj);
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


#line 267 "rygel-http-post-test.vala"
RygelMediaItem* rygel_media_item_construct (GType object_type, const char* id) {
#line 1809 "rygel-http-post-test.c"
	GError * _inner_error_;
	RygelMediaItem* self;
	char* _tmp0_;
	GFile* _tmp1_;
#line 267 "rygel-http-post-test.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 1816 "rygel-http-post-test.c"
	_inner_error_ = NULL;
#line 267 "rygel-http-post-test.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 268 "rygel-http-post-test.vala"
	self->id = (_tmp0_ = g_strdup (id), _g_free0 (self->id), _tmp0_);
#line 270 "rygel-http-post-test.vala"
	self->file = (_tmp1_ = g_file_new_for_uri (RYGEL_MEDIA_ITEM_URI), _g_object_unref0 (self->file), _tmp1_);
#line 1824 "rygel-http-post-test.c"
	{
		GFileOutputStream* _tmp2_;
#line 272 "rygel-http-post-test.vala"
		_tmp2_ = g_file_replace (self->file, NULL, FALSE, 0, NULL, &_inner_error_);
#line 1829 "rygel-http-post-test.c"
		_g_object_unref0 (_tmp2_);
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch4_g_io_error_exists;
			}
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_io_error_exists:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (_error_);
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 275 "rygel-http-post-test.vala"
			g_assert_not_reached ();
#line 1857 "rygel-http-post-test.c"
			_g_error_free0 (_error_);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


#line 267 "rygel-http-post-test.vala"
RygelMediaItem* rygel_media_item_new (const char* id) {
#line 267 "rygel-http-post-test.vala"
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM, id);
#line 1875 "rygel-http-post-test.c"
}


static void rygel_media_item_get_writable_data_free (gpointer _data) {
	RygelMediaItemGetWritableData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	rygel_media_object_unref (data->self);
	g_slice_free (RygelMediaItemGetWritableData, data);
}


void rygel_media_item_get_writable (RygelMediaItem* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaItemGetWritableData* _data_;
	_data_ = g_slice_new0 (RygelMediaItemGetWritableData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_media_item_get_writable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_item_get_writable_data_free);
	_data_->self = rygel_media_object_ref (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_item_get_writable_co (_data_);
}


GFile* rygel_media_item_get_writable_finish (RygelMediaItem* self, GAsyncResult* _res_, GError** error) {
	GFile* result;
	RygelMediaItemGetWritableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_item_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaItemGetWritableData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_item_get_writable_co (data);
}


#line 287 "rygel-http-post-test.vala"
static gboolean _rygel_media_item_get_writable_co_gsource_func (gpointer self) {
#line 1923 "rygel-http-post-test.c"
	gboolean result;
	result = rygel_media_item_get_writable_co (self);
	return result;
}


#line 290 "rygel-http-post-test.vala"
static gboolean _lambda0_ (Block3Data* _data3_) {
#line 1932 "rygel-http-post-test.c"
	RygelMediaItem * self;
	gboolean result = FALSE;
	self = _data3_->self;
#line 291 "rygel-http-post-test.vala"
	_data3_->get_writable_continue (_data3_->get_writable_continue_target);
#line 1938 "rygel-http-post-test.c"
	result = FALSE;
#line 293 "rygel-http-post-test.vala"
	return result;
#line 1942 "rygel-http-post-test.c"
}


#line 290 "rygel-http-post-test.vala"
static gboolean __lambda0__gsource_func (gpointer self) {
#line 1948 "rygel-http-post-test.c"
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_rygel_media_object_unref0 (_data3_->self);
		(_data3_->get_writable_continue_target_destroy_notify == NULL) ? NULL : (_data3_->get_writable_continue_target_destroy_notify (_data3_->get_writable_continue_target), NULL);
		_data3_->get_writable_continue = NULL;
		_data3_->get_writable_continue_target = NULL;
		_data3_->get_writable_continue_target_destroy_notify = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean rygel_media_item_get_writable_co (RygelMediaItemGetWritableData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_data3_ = g_slice_new0 (Block3Data);
		data->_data3_->_ref_count_ = 1;
		data->_data3_->self = rygel_media_object_ref (data->self);
		data->_data3_->_async_data_ = data;
		data->_data3_->get_writable_continue = (data->_tmp0_ = _rygel_media_item_get_writable_co_gsource_func, data->_data3_->get_writable_continue_target = data, data->_data3_->get_writable_continue_target_destroy_notify = NULL, data->_tmp0_);
#line 290 "rygel-http-post-test.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda0__gsource_func, block3_data_ref (data->_data3_), block3_data_unref);
#line 1991 "rygel-http-post-test.c"
		data->_state_ = 6;
		return FALSE;
		_state_6:
		;
		data->result = _g_object_ref0 (data->self->file);
		block3_data_unref (data->_data3_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		block3_data_unref (data->_data3_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->size = (glong) 1024;
	self->duration = (glong) 1024;
}


static void rygel_media_item_finalize (RygelMediaObject* obj) {
	RygelMediaItem * self;
	GError * _inner_error_;
	self = RYGEL_MEDIA_ITEM (obj);
	_inner_error_ = NULL;
	{
		{
#line 281 "rygel-http-post-test.vala"
			g_file_delete (self->file, NULL, &_inner_error_);
#line 2042 "rygel-http-post-test.c"
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
			}
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			{
#line 283 "rygel-http-post-test.vala"
				g_assert_not_reached ();
#line 2056 "rygel-http-post-test.c"
				_g_error_free0 (_error_);
			}
		}
		__finally5:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	_g_free0 (self->id);
	_g_object_unref0 (self->file);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


#line 308 "rygel-http-post-test.vala"
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPPost* get_request) {
#line 2086 "rygel-http-post-test.c"
	RygelHTTPResponse * self;
	SoupMessage* _tmp0_;
	SoupServer* _tmp1_;
#line 308 "rygel-http-post-test.vala"
	g_return_val_if_fail (get_request != NULL, NULL);
#line 308 "rygel-http-post-test.vala"
	self = (RygelHTTPResponse*) g_object_new (object_type, NULL);
#line 309 "rygel-http-post-test.vala"
	self->priv->msg = (_tmp0_ = _g_object_ref0 (((RygelHTTPRequest*) get_request)->msg), _g_object_unref0 (self->priv->msg), _tmp0_);
#line 310 "rygel-http-post-test.vala"
	self->priv->server = (_tmp1_ = _g_object_ref0 (((RygelHTTPRequest*) get_request)->server), _g_object_unref0 (self->priv->server), _tmp1_);
#line 2098 "rygel-http-post-test.c"
	return self;
}


#line 308 "rygel-http-post-test.vala"
RygelHTTPResponse* rygel_http_response_new (RygelHTTPPost* get_request) {
#line 308 "rygel-http-post-test.vala"
	return rygel_http_response_construct (RYGEL_TYPE_HTTP_RESPONSE, get_request);
#line 2107 "rygel-http-post-test.c"
}


static void rygel_http_response_real_run_data_free (gpointer _data) {
	RygelHttpResponseRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelHttpResponseRunData, data);
}


static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPResponse * self;
	RygelHttpResponseRunData* _data_;
	self = (RygelHTTPResponse*) base;
	_data_ = g_slice_new0 (RygelHttpResponseRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_response_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_response_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_http_response_real_run_co (_data_);
}


static void rygel_http_response_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpResponseRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpResponseRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_response_real_run_co (data);
}


#line 313 "rygel-http-post-test.vala"
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self) {
#line 2147 "rygel-http-post-test.c"
	gboolean result;
	result = rygel_http_response_real_run_co (self);
	return result;
}


#line 316 "rygel-http-post-test.vala"
static gboolean _lambda3_ (Block4Data* _data4_) {
#line 2156 "rygel-http-post-test.c"
	RygelHTTPResponse * self;
	gboolean result = FALSE;
	self = _data4_->self;
#line 317 "rygel-http-post-test.vala"
	_data4_->run_continue (_data4_->run_continue_target);
#line 2162 "rygel-http-post-test.c"
	result = FALSE;
#line 319 "rygel-http-post-test.vala"
	return result;
#line 2166 "rygel-http-post-test.c"
}


#line 316 "rygel-http-post-test.vala"
static gboolean __lambda3__gsource_func (gpointer self) {
#line 2172 "rygel-http-post-test.c"
	gboolean result;
	result = _lambda3_ (self);
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		(_data4_->run_continue_target_destroy_notify == NULL) ? NULL : (_data4_->run_continue_target_destroy_notify (_data4_->run_continue_target), NULL);
		_data4_->run_continue = NULL;
		_data4_->run_continue_target = NULL;
		_data4_->run_continue_target_destroy_notify = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_data4_ = g_slice_new0 (Block4Data);
		data->_data4_->_ref_count_ = 1;
		data->_data4_->self = g_object_ref (data->self);
		data->_data4_->_async_data_ = data;
		data->_data4_->run_continue = (data->_tmp0_ = _rygel_http_response_real_run_co_gsource_func, data->_data4_->run_continue_target = data, data->_data4_->run_continue_target_destroy_notify = NULL, data->_tmp0_);
#line 316 "rygel-http-post-test.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda3__gsource_func, block4_data_ref (data->_data4_), block4_data_unref);
#line 2215 "rygel-http-post-test.c"
		data->_state_ = 7;
		return FALSE;
		_state_7:
		;
#line 324 "rygel-http-post-test.vala"
		soup_message_set_status (data->self->priv->msg, (guint) SOUP_STATUS_OK);
#line 325 "rygel-http-post-test.vala"
		soup_server_unpause_message (data->self->priv->server, data->self->priv->msg);
#line 327 "rygel-http-post-test.vala"
		g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
#line 2226 "rygel-http-post-test.c"
		block4_data_unref (data->_data4_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static GCancellable* rygel_http_response_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPResponse* self;
	self = (RygelHTTPResponse*) base;
	result = self->priv->_cancellable;
#line 303 "rygel-http-post-test.vala"
	return result;
#line 2248 "rygel-http-post-test.c"
}


static void rygel_http_response_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
	self = (RygelHTTPResponse*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_response_class_init (RygelHTTPResponseClass * klass) {
	rygel_http_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPResponsePrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_http_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_http_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_CANCELLABLE, "cancellable");
}


static void rygel_http_response_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_response_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_http_response_real_run;
	iface->run_finish = rygel_http_response_real_run_finish;
	iface->get_cancellable = rygel_http_response_real_get_cancellable;
	iface->set_cancellable = rygel_http_response_real_set_cancellable;
}


static void rygel_http_response_instance_init (RygelHTTPResponse * self) {
	self->priv = RYGEL_HTTP_RESPONSE_GET_PRIVATE (self);
}


static void rygel_http_response_finalize (GObject* obj) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (obj);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->msg);
	_g_object_unref0 (self->priv->server);
	G_OBJECT_CLASS (rygel_http_response_parent_class)->finalize (obj);
}


GType rygel_http_response_get_type (void) {
	static volatile gsize rygel_http_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponse), 0, (GInstanceInitFunc) rygel_http_response_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_response_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_response_type_id;
		rygel_http_response_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponse", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_response_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_response_type_id__volatile, rygel_http_response_type_id);
	}
	return rygel_http_response_type_id__volatile;
}


static void rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


#line 331 "rygel-http-post-test.vala"
RygelMediaObject* rygel_media_object_construct (GType object_type) {
#line 2339 "rygel-http-post-test.c"
	RygelMediaObject* self;
	self = (RygelMediaObject*) g_type_create_instance (object_type);
	return self;
}


#line 331 "rygel-http-post-test.vala"
RygelMediaObject* rygel_media_object_new (void) {
#line 331 "rygel-http-post-test.vala"
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
#line 2350 "rygel-http-post-test.c"
}


static void rygel_value_media_object_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_media_object_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_media_object_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_media_object_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_media_object_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_media_object_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_media_object_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelMediaObject* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_media_object_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_media_object_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaObject** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_media_object_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecMediaObject* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_MEDIA_OBJECT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_media_object (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_media_object_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_object_unref (old);
	}
}


void rygel_value_take_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_object_unref (old);
	}
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	self->ref_count = 1;
}


static void rygel_media_object_finalize (RygelMediaObject* obj) {
	RygelMediaObject * self;
	self = RYGEL_MEDIA_OBJECT (obj);
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_media_object_init, rygel_value_media_object_free_value, rygel_value_media_object_copy_value, rygel_value_media_object_peek_pointer, "p", rygel_value_media_object_collect_value, "p", rygel_value_media_object_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaObject", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


gpointer rygel_media_object_ref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_media_object_unref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_MEDIA_OBJECT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




