#include <config.h>
#include "gnome-print-filter-clip.h"

#include <gmodule.h>

#include <libgnomeprint/gnome-print-filter.h>
#include <libgnomeprint/gnome-print-i18n.h>

#define FILTER_NAME        N_("clip")
#define FILTER_DESCRIPTION N_("The clip-filter lets you select regions.")

struct _GnomePrintFilterClip {
	GnomePrintFilter parent;

	gdouble l, r, t, b;
};
                                                                                
struct _GnomePrintFilterClipClass {
	GnomePrintFilterClass parent_class;
};

static GnomePrintFilterClass *parent_class = NULL;

enum {
	PROP_0,
	PROP_NAME,
	PROP_DESCRIPTION,
	PROP_LEFT,
	PROP_RIGHT,
	PROP_TOP,
	PROP_BOTTOM
};

static void
gnome_print_filter_clip_get_property (GObject *object, guint n, GValue *v,
				GParamSpec *pspec)
{
	GnomePrintFilterClip *filter = (GnomePrintFilterClip *) object;

	switch (n) {
	case PROP_NAME:
		g_value_set_string (v, _(FILTER_NAME));
		break;
	case PROP_DESCRIPTION:
		g_value_set_string (v, _(FILTER_DESCRIPTION));
		break;
	case PROP_LEFT:   g_value_set_double (v, filter->l);    break;
	case PROP_RIGHT:  g_value_set_double (v, filter->r);    break;
	case PROP_TOP:    g_value_set_double (v, filter->t);    break;
	case PROP_BOTTOM: g_value_set_double (v, filter->b);    break;
	default: G_OBJECT_WARN_INVALID_PROPERTY_ID (object, n, pspec);
	}
}

static void
gnome_print_filter_clip_set_property (GObject *object, guint n,
		const GValue *v, GParamSpec *pspec)
{
	GnomePrintFilterClip *filter = (GnomePrintFilterClip *) object;
	gdouble d;

	switch (n) {
	case PROP_LEFT: 
		d = g_value_get_double (v);
		if (filter->l != d) {
			filter->l = d;
			gnome_print_filter_changed (GNOME_PRINT_FILTER (filter));
		}
		break;
	case PROP_RIGHT:
		d = g_value_get_double (v);
		if (filter->r != d) {
			filter->r = d;
			gnome_print_filter_changed (GNOME_PRINT_FILTER (filter));
		}
		break;
	case PROP_BOTTOM:
		d = g_value_get_double (v);
		if (filter->b != d) {
			filter->b = d;
			gnome_print_filter_changed (GNOME_PRINT_FILTER (filter));
		}
		break;
	case PROP_TOP:
		d = g_value_get_double (v);
		if (filter->t != d) {
			filter->t = d;
			gnome_print_filter_changed (GNOME_PRINT_FILTER (filter));
		}
		break;
	default: G_OBJECT_WARN_INVALID_PROPERTY_ID (object, n, pspec);
	}
}

#define CR(res) { gint r = (res); if (r < 0) return r; }

static gint
beginpage_impl (GnomePrintFilter *filter,
		GnomePrintContext *pc, const guchar *name)
{
	GnomePrintFilterClip *f = (GnomePrintFilterClip *) filter;
	ArtBpath bpath[6];

	CR (parent_class->beginpage (filter, pc, name));
	bpath[0].code = ART_MOVETO; bpath[0].x3 = f->l; bpath[0].y3 = f->b;
	bpath[1].code = ART_LINETO; bpath[1].x3 = f->l; bpath[1].y3 = f->t;
	bpath[2].code = ART_LINETO; bpath[2].x3 = f->r; bpath[2].y3 = f->t;
	bpath[3].code = ART_LINETO; bpath[3].x3 = f->r; bpath[3].y3 = f->b;
	bpath[4].code = ART_LINETO; bpath[4].x3 = f->l; bpath[4].y3 = f->b;
	bpath[5].code = ART_END;
	CR (gnome_print_filter_clip (filter, bpath, ART_WIND_RULE_NONZERO));

	return GNOME_PRINT_OK;
}

static void
gnome_print_filter_clip_class_init (GnomePrintFilterClipClass *klass)
{
	GObjectClass *object_class = (GObjectClass *) klass;
	GnomePrintFilterClass *filter_class = (GnomePrintFilterClass *) klass;

	parent_class = g_type_class_peek_parent (klass);

	object_class->get_property = gnome_print_filter_clip_get_property;
	object_class->set_property = gnome_print_filter_clip_set_property;

	g_object_class_override_property (object_class, PROP_NAME, "name");
	g_object_class_override_property (object_class, PROP_DESCRIPTION, "description");
	g_object_class_install_property (object_class, PROP_LEFT,
		g_param_spec_double ("left", _("Left"), _("Left"),
			-G_MAXDOUBLE, G_MAXDOUBLE, 0., G_PARAM_READWRITE));
	g_object_class_install_property (object_class, PROP_RIGHT,
		g_param_spec_double ("right", _("Right"), _("Right"),
			-G_MAXDOUBLE, G_MAXDOUBLE, 1., G_PARAM_READWRITE));
	g_object_class_install_property (object_class, PROP_TOP,
		g_param_spec_double ("top", _("Top"), _("Top"),
			-G_MAXDOUBLE, G_MAXDOUBLE, 1., G_PARAM_READWRITE));
	g_object_class_install_property (object_class, PROP_BOTTOM,
		g_param_spec_double ("bottom", _("Bottom"), _("Bottom"),
			-G_MAXDOUBLE, G_MAXDOUBLE, 0., G_PARAM_READWRITE));

	object_class->get_property = gnome_print_filter_clip_get_property;
	object_class->set_property = gnome_print_filter_clip_set_property;

	filter_class->beginpage = beginpage_impl;
}

static void
gnome_print_filter_clip_init (GnomePrintFilterClip *f)
{
	f->t = f->r = 1.;
}

GType
gnome_print_filter_clip_get_type (void)
{
	static GType type = 0;

	if (!type) {
		static const GTypeInfo info = {
			sizeof (GnomePrintFilterClipClass), NULL, NULL,
			(GClassInitFunc) gnome_print_filter_clip_class_init,
			NULL, NULL, sizeof (GnomePrintFilterClip), 0, 
			(GInstanceInitFunc) gnome_print_filter_clip_init
		};
		type = g_type_register_static (GNOME_TYPE_PRINT_FILTER,
				"GnomePrintFilterClip", &info, 0);
	}
	return type;
}

G_MODULE_EXPORT GType gnome_print__filter_get_type (void);

G_MODULE_EXPORT GType
gnome_print__filter_get_type (void)
{
	return GNOME_TYPE_PRINT_FILTER_CLIP;
}
