%define glib2_version 2.0.3
%define pango_version 1.0.99
%define gtk2_version 2.0.5
%define libgnomeui_version 2.0.0
%define gail_version 0.17-2
%define desktop_file_utils_version 0.2.90

%define gettext_package gnome-media-2.0

Summary:        GNOME media programs.
Name:           gnome-media
Version:        2.1.1
Release:        9
Copyright:      GPL
Group:          Applications/Multimedia
Source:         ftp://ftp.gnome.org/pub/GNOME/sources/pre-gnome2/gnome-media/gnome-media-%{version}.tar.gz
Prereq:         scrollkeeper >= 0.1.4
BuildPrereq:    scrollkeeper intltool
BuildRoot:      %{_tmppath}/%{name}-%{PACKAGE_VERSION}-root
Obsoletes:      gnome
URL:            http://www.gnome.org

BuildRequires:  glib2-devel >= %{glib2_version}
BuildRequires:  pango-devel >= %{pango_version}
BuildRequires:  gtk2-devel >= %{gtk2_version}
BuildRequires:  libgnomeui-devel >= %{libgnomeui_version}
BuildRequires:  gail-devel >= %{gail_version}
BuildRequires:  Xft
BuildRequires:  fontconfig
BuildRequires:  desktop-file-utils >= %{desktop_file_utils_version}
BuildRequires:  /usr/bin/automake-1.4

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
GUI applications and desktop tools to be used in conjunction with a
window manager for the X Window System. The gnome-media package will
install media features like the GNOME CD player.

Install gnome-media if you want to use GNOME's multimedia
capabilities.

%prep
%setup

%build
%configure
make

%install
rm -rf $RPM_BUILD_ROOT

export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
%makeinstall
unset GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL

# Clean out files that should not be part of the rpm.
# This is the recommended way of dealing with it for RH8
rm -f $RPM_BUILD_ROOT%{_libdir}/*.a
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
rm -rf $RPM_BUILD_ROOT/var/scrollkeeper/*

%find_lang %{gettext_package}

%clean
rm -rf $RPM_BUILD_ROOT

%post
scrollkeeper-update
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
SCHEMAS="CDDB-Slave2.schemas gnome-volume-control.schemas gnome-cd.schemas gnome-sound-recorder.schemas"
for S in $SCHEMAS; do
  gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/$S > /dev/null
done
/sbin/ldconfig

%postun
scrollkeeper-update
/sbin/ldconfig
/bin/true ## for rpmlint, -p requires absolute path and is just dumb

%files -f %{gettext_package}.lang
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README
%{_prefix}/libexec/*
%{_datadir}/idl
%{_datadir}/applications
%{_datadir}/pixmaps
%{_datadir}/omf
%{_datadir}/gnome
%{_datadir}/gnome-sound-recorder/ui/gsr.xml
%{_datadir}/control-center-2.0
%{_libdir}/*.so.*
%{_libdir}/bonobo
%{_bindir}/*
%{_sysconfdir}/gconf/schemas/*.schemas

# devel, if we had a devel
%{_includedir}/*
%{_libdir}/*.so

%changelog
* Wed Oct 23 2002 Christian Schaller <Uraeus@gnome.org>
- Update for use in CVS package
- I remove all the stuff installed into /var/scrollkeeper this is probably a bugwhich I have no idea how to fix
