/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif


GdkEventType GdkEventConfigure_get_type (GdkEventConfigure * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventConfigure
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventConfigure_getType (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventConfigure *obj_g = (GdkEventConfigure *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventConfigure_get_type (obj_g));
}

GdkWindow * GdkEventConfigure_get_window (GdkEventConfigure * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventConfigure
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventConfigure_getWindow (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventConfigure *obj_g = (GdkEventConfigure *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventConfigure_get_window (obj_g));
}

gboolean GdkEventConfigure_get_send_event (GdkEventConfigure * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventConfigure
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventConfigure_getSendEvent (JNIEnv *env, jclass 
    cls, jobject obj) 
{
    GdkEventConfigure *obj_g = (GdkEventConfigure *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventConfigure_get_send_event (obj_g));
}

gint32 GdkEventConfigure_get_x (GdkEventConfigure * cptr) 
{
    return cptr->x;
}

/*
 * Class:     org.gnu.gdk.EventConfigure
 * Method:    getX
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventConfigure_getX (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventConfigure *obj_g = (GdkEventConfigure *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventConfigure_get_x (obj_g));
}

gint32 GdkEventConfigure_get_y (GdkEventConfigure * cptr) 
{
    return cptr->y;
}

/*
 * Class:     org.gnu.gdk.EventConfigure
 * Method:    getY
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventConfigure_getY (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventConfigure *obj_g = (GdkEventConfigure *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventConfigure_get_y (obj_g));
}

gint32 GdkEventConfigure_get_width (GdkEventConfigure * cptr) 
{
    return cptr->width;
}

/*
 * Class:     org.gnu.gdk.EventConfigure
 * Method:    getWidth
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventConfigure_getWidth (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventConfigure *obj_g = (GdkEventConfigure *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventConfigure_get_width (obj_g));
}

gint32 GdkEventConfigure_get_height (GdkEventConfigure * cptr) 
{
    return cptr->height;
}

/*
 * Class:     org.gnu.gdk.EventConfigure
 * Method:    getHeight
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventConfigure_getHeight (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventConfigure *obj_g = (GdkEventConfigure *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventConfigure_get_height (obj_g));
}


#ifdef __cplusplus
}

#endif
