// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _ATKMM_TEXT_H
#define _ATKMM_TEXT_H

#include <glibmm.h>

/* $Id: text.hg,v 1.7 2005/01/05 18:21:30 murrayc Exp $ */

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <atkmm/component.h> /* for Atk::CoordType */
#include <atk/atktext.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _AtkText AtkText;
typedef struct _AtkTextClass AtkTextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Atk
{ class Text_Class; } // namespace Atk
namespace Atk
{

class Attribute
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Attribute CppObjectType;
  typedef AtkAttribute BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:


public:
  Attribute();
  Attribute(const Glib::ustring& name, const Glib::ustring& value);
  explicit Attribute(const AtkAttribute* gobject);
  ~Attribute();

  Attribute(const Attribute& other);
  Attribute& operator=(const Attribute& other);

  void swap(Attribute& other);

  Glib::ustring get_name() const;
  Glib::ustring get_value() const;

  /// Provides access to the underlying C GObject.
  AtkAttribute*       gobj()       { return &gobject_; }

  /// Provides access to the underlying C GObject.
  const AtkAttribute* gobj() const { return &gobject_; }

protected:
  AtkAttribute gobject_;


};

/** @relates Atk::Attribute */
inline void swap(Attribute& lhs, Attribute& rhs)
  { lhs.swap(rhs); }

struct AttributeTraits
{
  typedef Atk::Attribute      CppType;
  typedef const AtkAttribute* CType;
  typedef AtkAttribute*       CTypeNonConst;

  static CType to_c_type(CType item)          { return item; }
  static CType to_c_type(const CppType& item) { return item.gobj(); }
  static CppType to_cpp_type(CType item)      { return CppType(item); }
  static void release_c_type(CType item)      { g_free(const_cast<CTypeNonConst>(item)); }
};

typedef Glib::SListHandle<Attribute, AttributeTraits> AttributeSet;


/** @addtogroup atkmmEnums Enums and Flags */

/**
 * @ingroup atkmmEnums
 */
enum BuiltinTextAttribute
{
  TEXT_ATTR_INVALID,
  TEXT_ATTR_LEFT_MARGIN,
  TEXT_ATTR_RIGHT_MARGIN,
  TEXT_ATTR_INDENT,
  TEXT_ATTR_INVISIBLE,
  TEXT_ATTR_EDITABLE,
  TEXT_ATTR_PIXELS_ABOVE_LINES,
  TEXT_ATTR_PIXELS_BELOW_LINES,
  TEXT_ATTR_PIXELS_INSIDE_WRAP,
  TEXT_ATTR_BG_FULL_HEIGHT,
  TEXT_ATTR_RISE,
  TEXT_ATTR_UNDERLINE,
  TEXT_ATTR_STRIKETHROUGH,
  TEXT_ATTR_SIZE,
  TEXT_ATTR_SCALE,
  TEXT_ATTR_WEIGHT,
  TEXT_ATTR_LANGUAGE,
  TEXT_ATTR_FAMILY_NAME,
  TEXT_ATTR_BG_COLOR,
  TEXT_ATTR_FG_COLOR,
  TEXT_ATTR_BG_STIPPLE,
  TEXT_ATTR_FG_STIPPLE,
  TEXT_ATTR_WRAP_MODE,
  TEXT_ATTR_DIRECTION,
  TEXT_ATTR_JUSTIFICATION,
  TEXT_ATTR_STRETCH,
  TEXT_ATTR_VARIANT,
  TEXT_ATTR_STYLE,
  TEXT_ATTR_LAST_DEFINED
};

} // namespace Atk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Atk::BuiltinTextAttribute> : public Glib::Value_Enum<Atk::BuiltinTextAttribute>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Atk
{


class TextAttribute
{
private:
  int attribute_;

public:
  TextAttribute() : attribute_ (0) {}
  TextAttribute(BuiltinTextAttribute attribute) : attribute_ (attribute) {}

  // Behave like an ordinary enum.
  explicit TextAttribute(int attribute) : attribute_ (attribute) {}
  operator int() const { return attribute_; }

  static TextAttribute for_name(const Glib::ustring& name);
  static Glib::ustring get_name(TextAttribute attribute);
  static Glib::ustring get_value(TextAttribute attribute, int index);
};

} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Atk::TextAttribute> : public Glib::Value_Enum<Atk::TextAttribute>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{

/**
 * @ingroup atkmmEnums
 */
enum TextBoundary
{
  TEXT_BOUNDARY_CHAR,
  TEXT_BOUNDARY_WORD_START,
  TEXT_BOUNDARY_WORD_END,
  TEXT_BOUNDARY_SENTENCE_START,
  TEXT_BOUNDARY_SENTENCE_END,
  TEXT_BOUNDARY_LINE_START,
  TEXT_BOUNDARY_LINE_END
};

} // namespace Atk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Atk::TextBoundary> : public Glib::Value_Enum<Atk::TextBoundary>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Atk
{

/**
 * @ingroup atkmmEnums
 */
enum TextClipType
{
  TEXT_CLIP_NONE,
  TEXT_CLIP_MIN,
  TEXT_CLIP_MAX,
  TEXT_CLIP_BOTH
};

} // namespace Atk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Atk::TextClipType> : public Glib::Value_Enum<Atk::TextClipType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Atk
{


/** The ATK interface implemented by components with text content.
 * This should be implemented by Atk::Objects on behalf of widgets that have text content which is either attributed
 * or otherwise non-trivial. Atk::Objects whose text content is simple, unattributed, and very brief may expose that
 * content via Atk::Object::get_name() instead; however if the text is editable, multi-line, typically longer than
 * three or four words, attributed, selectable, or if the object already uses the 'name' ATK property for other
 * information, this Text interface should be used to expose the text content. In the case of editable text content,
 * Atk::EditableText (a subtype of the Atk::Text interface) should be implemented instead.
 *
 * Atk::Text provides not only traversal facilities and change notification for text content, but also caret tracking
 * and glyph bounding box calculations. Note that the text strings are exposed as UTF-8, and are therefore potentially
 * multi-byte, and caret-to-byte offset mapping makes no assumptions about the character length; also bounding box
 * glyph-to-offset mapping may be complex for languages which use ligatures.
 */

class Text : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Text CppObjectType;
  typedef Text_Class CppClassType;
  typedef AtkText BaseObjectType;
  typedef AtkTextIface BaseClassType;

private:
  friend class Text_Class;
  static CppClassType text_class_;

  // noncopyable
  Text(const Text&);
  Text& operator=(const Text&);

protected:
  Text(); // you must derive from this class
  explicit Text(AtkText* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Text();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkText*       gobj()       { return reinterpret_cast<AtkText*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const AtkText* gobj() const { return reinterpret_cast<AtkText*>(gobject_); }

private:


public:
  
  /** Gets the specified text.
   * @param start_offset Start position.
   * @param end_offset End position.
   * @return The text from @a start_offset  up to, but not including @a end_offset .
   */
  Glib::ustring get_text(int start_offset, int end_offset) const;
  
  /** Gets the specified text.
   * @param offset Position.
   * @return The character at @a offset .
   */
  gunichar get_character_at_offset(int offset) const;
  
  /** Gets the specified text.
   * 
   * If the boundary_type if ATK_TEXT_BOUNDARY_CHAR the character after the 
   * offset is returned.
   * 
   * If the boundary_type is ATK_TEXT_BOUNDARY_WORD_START the returned string
   * is from the word start after the offset to the next word start.
   * 
   * The returned string will contain the word after the offset if the offset 
   * is inside a word or if the offset is not inside a word.
   * 
   * If the boundary_type is ATK_TEXT_BOUNDARY_WORD_END the returned string
   * is from the word end at or after the offset to the next work end.
   * 
   * The returned string will contain the word after the offset if the offset
   * is inside a word and will contain the word after the word after the offset
   * if the offset is not inside a word.
   * 
   * If the boundary type is ATK_TEXT_BOUNDARY_SENTENCE_START the returned
   * string is from the sentence start after the offset to the next sentence
   * start.
   * 
   * The returned string will contain the sentence after the offset if the offset
   * is inside a sentence or if the offset is not inside a sentence.
   * 
   * If the boundary_type is ATK_TEXT_BOUNDARY_SENTENCE_END the returned string
   * is from the sentence end at or after the offset to the next sentence end.
   * 
   * The returned string will contain the sentence after the offset if the offset
   * is inside a sentence and will contain the sentence after the sentence
   * after the offset if the offset is not inside a sentence.
   * 
   * If the boundary type is ATK_TEXT_BOUNDARY_LINE_START the returned
   * string is from the line start after the offset to the next line start.
   * 
   * If the boundary_type is ATK_TEXT_BOUNDARY_LINE_END the returned string
   * is from the line end at or after the offset to the next line start.
   * @param offset Position.
   * @param boundary_type An Atk::TextBoundary.
   * @param start_offset The start offset of the returned string.
   * @param end_offset The offset of the first character after the 
   * returned substring.
   * @return The text after @a offset  bounded by the specified @a boundary_type .
   */
  Glib::ustring get_text_after_offset(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const;
  
  /** Gets the specified text.
   * 
   * If the boundary_type if ATK_TEXT_BOUNDARY_CHAR the character at the
   * offset is returned.
   * 
   * If the boundary_type is ATK_TEXT_BOUNDARY_WORD_START the returned string
   * is from the word start at or before the offset to the word start after 
   * the offset.
   * 
   * The returned string will contain the word at the offset if the offset
   * is inside a word and will contain the word before the offset if the 
   * offset is not inside a word.
   * 
   * If the boundary_type is ATK_TEXT_BOUNDARY_WORD_END the returned string
   * is from the word end before the offset to the word end at or after the
   * offset.
   * 
   * The returned string will contain the word at the offset if the offset
   * is inside a word and will contain the word after to the offset if the 
   * offset is not inside a word.
   * 
   * If the boundary type is ATK_TEXT_BOUNDARY_SENTENCE_START the returned
   * string is from the sentence start at or before the offset to the sentence
   * start after the offset.
   * 
   * The returned string will contain the sentence at the offset if the offset
   * is inside a sentence and will contain the sentence before the offset 
   * if the offset is not inside a sentence.
   * 
   * If the boundary_type is ATK_TEXT_BOUNDARY_SENTENCE_END the returned string
   * is from the sentence end before the offset to the sentence end at or
   * after the offset.
   * 
   * The returned string will contain the sentence at the offset if the offset
   * is inside a sentence and will contain the sentence after the offset 
   * if the offset is not inside a sentence.
   * 
   * If the boundary type is ATK_TEXT_BOUNDARY_LINE_START the returned
   * string is from the line start at or before the offset to the line
   * start after the offset.
   * 
   * If the boundary_type is ATK_TEXT_BOUNDARY_LINE_END the returned string
   * is from the line end before the offset to the line end at or after
   * the offset.
   * @param offset Position.
   * @param boundary_type An Atk::TextBoundary.
   * @param start_offset The start offset of the returned string.
   * @param end_offset The offset of the first character after the 
   * returned substring.
   * @return The text at @a offset  bounded by the specified @a boundary_type .
   */
  Glib::ustring get_text_at_offset(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const;
  
  /** Gets the specified text.
   * 
   * If the boundary_type if ATK_TEXT_BOUNDARY_CHAR the character before the
   * offset is returned.
   * 
   * If the boundary_type is ATK_TEXT_BOUNDARY_WORD_START the returned string
   * is from the word start before the word start before the offset to 
   * the word start before the offset.
   * 
   * The returned string will contain the word before the offset if the offset
   * is inside a word and will contain the word before the word before the 
   * offset if the offset is not inside a word.
   * 
   * If the boundary_type is ATK_TEXT_BOUNDARY_WORD_END the returned string
   * is from the word end before the word end at or before the offset to the 
   * word end at or before the offset.
   * 
   * The returned string will contain the word before the offset if the offset
   * is inside a word or if the offset is not inside a word.
   * 
   * If the boundary type is ATK_TEXT_BOUNDARY_SENTENCE_START the returned
   * string is from the sentence start before the sentence start before 
   * the offset to the sentence start before the offset.
   * 
   * The returned string will contain the sentence before the offset if the 
   * offset is inside a sentence and will contain the sentence before the 
   * sentence before the offset if the offset is not inside a sentence.
   * 
   * If the boundary_type is ATK_TEXT_BOUNDARY_SENTENCE_END the returned string
   * is from the sentence end before the sentence end at or before the offset to 
   * the sentence end at or before the offset.
   * 
   * The returned string will contain the sentence before the offset if the 
   * offset is inside a sentence or if the offset is not inside a sentence.
   * 
   * If the boundary type is ATK_TEXT_BOUNDARY_LINE_START the returned
   * string is from the line start before the line start ar or before the offset 
   * to the line start ar or before the offset.
   * 
   * If the boundary_type is ATK_TEXT_BOUNDARY_LINE_END the returned string
   * is from the line end before the line end before the offset to the 
   * line end before the offset.
   * @param offset Position.
   * @param boundary_type An Atk::TextBoundary.
   * @param start_offset The start offset of the returned string.
   * @param end_offset The offset of the first character after the 
   * returned substring.
   * @return The text before @a offset  bounded by the specified @a boundary_type .
   */
  Glib::ustring get_text_before_offset(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const;
  
  /** Gets the offset position of the caret (cursor).
   * @return The offset position of the caret (cursor).
   */
  int get_caret_offset() const;
  
  /** Get the bounding box containing the glyph representing the character at 
   * a particular text offset.
   * @param offset The offset of the text character for which bounding information is required.
   * @param x Pointer for the x cordinate of the bounding box.
   * @param y Pointer for the y cordinate of the bounding box.
   * @param width Pointer for the width of the bounding box.
   * @param height Pointer for the height of the bounding box.
   * @param coords Specify whether coordinates are relative to the screen or widget window.
   */
  void get_character_extents(int offset, int& x, int& y, int& width, int& height, CoordType coords) const;
  
  /** Creates an Atk::AttributeSet which consists of the attributes explicitly
   * set at the position @a offset  in the text. @a start_offset  and @a end_offset  are
   * set to the start and end of the range around @a offset  where the attributes are
   * invariant. See the enum AtkTextAttribute for types of text attributes that
   * can be returned. Note that other attributes may also be returned.
   * @param offset The offset at which to get the attributes.
   * @param start_offset The address to put the start offset of the range.
   * @param end_offset The address to put the end offset of the range.
   * @return An Atk::AttributeSet which contains the attributes explicitly set
   * at @a offset .
   */
  AttributeSet get_run_attributes(int offset, int& start_offset, int& end_offset) const;
  
  /** Creates an Atk::AttributeSet which consists of the default values of
   * attributes for the text. See the enum AtkTextAttribute for types of text
   * attributes that can be returned. Note that other attributes may also be
   * returned.
   * @return An Atk::AttributeSet which contains the default values of attributes.
   * at @a offset .
   */
  AttributeSet get_default_attributes() const;
  
  /** Gets the character count.
   * @return The number of characters.
   */
  int get_character_count() const;
  
  /** Gets the offset of the character located at coordinates @a x  and @a y . @a x  and @a y 
   * are interpreted as being relative to the screen or this widget's window
   * depending on @a coords .
   * @param x Screen x-position of character.
   * @param y Screen y-position of character.
   * @param coords Specify whether coordinates are relative to the screen or
   * widget window.
   * @return The offset to the character which is located at
   * the specified @a x  and @a y  coordinates.
   */
  int get_offset_at_point(int x, int y, CoordType coords) const;
  
  /** Gets the number of selected regions.
   * @return The number of selected regions, or -1 if a failure
   * occurred.
   */
  int get_n_selections() const;
  
  /** Gets the text from the specified selection.
   * @param selection_num The selection number.  The selected regions are
   * assigned numbers that correspond to how far the region is from the
   * start of the text.  The selected region closest to the beginning
   * of the text region is assigned the number 0, etc.  Note that adding,
   * moving or deleting a selected region can change the numbering.
   * @param start_offset Passes back the start position of the selected region.
   * @param end_offset Passes back the end position of (e.g. offset immediately past) 
   * the selected region.
   * @return The selected text.
   */
  Glib::ustring get_selection(int selection_num, int& start_offset, int& end_offset) const;
  
  /** Adds a selection bounded by the specified offsets.
   * @param start_offset The start position of the selected region.
   * @param end_offset The offset of the first character after the selected region.
   * @return <tt>true</tt> if success, <tt>false</tt> otherwise.
   */
  bool add_selection(int start_offset, int end_offset);
  
  /** Removes the specified selection.
   * @param selection_num The selection number.  The selected regions are
   * assigned numbers that correspond to how far the region is from the
   * start of the text.  The selected region closest to the beginning
   * of the text region is assigned the number 0, etc.  Note that adding,
   * moving or deleting a selected region can change the numbering.
   * @return <tt>true</tt> if success, <tt>false</tt> otherwise.
   */
  bool remove_selection(int selection_num);
  
  /** Changes the start and end offset of the specified selection.
   * @param selection_num The selection number.  The selected regions are
   * assigned numbers that correspond to how far the region is from the
   * start of the text.  The selected region closest to the beginning
   * of the text region is assigned the number 0, etc.  Note that adding,
   * moving or deleting a selected region can change the numbering.
   * @param start_offset The new start position of the selection.
   * @param end_offset The new end position of (e.g. offset immediately past) 
   * the selection.
   * @return <tt>true</tt> if success, <tt>false</tt> otherwise.
   */
  bool set_selection(int selection_num, int start_offset, int end_offset);
  
  /** Sets the caret (cursor) position to the specified @a offset .
   * @param offset Position.
   * @return <tt>true</tt> if success, <tt>false</tt> otherwise.
   */
  bool set_caret_offset(int offset);
  
  typedef AtkTextRectangle Rectangle;
    
  
  /** Get the bounding box for text within the specified range.
   * @param start_offset The offset of the first text character for which boundary 
   * information is required.
   * @param end_offset The offset of the text character after the last character 
   * for which boundary information is required.
   * @param coord_type Specify whether coordinates are relative to the screen or widget window.
   * @param rect A pointer to a AtkTextRectangle which is filled in by this function.
   */
  void get_range_extents(int start_offset, int end_offset,
                                      CoordType coord_type,
                                      Rectangle& rect);
  
  /** Get the ranges of text in the specified bounding box.
   * @param rect An AtkTextRectagle giving the dimensions of the bounding box.
   * @param coord_type Specify whether coordinates are relative to the screen or widget window.
   * @param x_clip_type Specify the horizontal clip type.
   * @param y_clip_type Specify the vertical clip type.
   * @return Array of AtkTextRange. The last element of the array returned 
   * by this function will be <tt>0</tt>.
   */
  AtkTextRange** get_bounded_ranges(const Rectangle& rect, CoordType coord_type,
                                                 TextClipType x_clip_type, TextClipType y_clip_type);
                                                           

  Glib::SignalProxy2< void,int,int > signal_text_changed();

  
  Glib::SignalProxy1< void,int > signal_text_caret_moved();

  
  Glib::SignalProxy0< void > signal_text_selection_changed();

  
  Glib::SignalProxy0< void > signal_text_attributes_changed();


protected:
 

    virtual Glib::ustring get_text_vfunc(int start_offset, int end_offset) const;
    virtual gunichar get_character_at_offset_vfunc(int offset) const;
    virtual Glib::ustring get_text_after_offset_vfunc(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const;
    virtual Glib::ustring get_text_at_offset_vfunc(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const;
    virtual Glib::ustring get_text_before_offset_vfunc(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const;
    virtual int get_caret_offset_vfunc() const;
    virtual void get_character_extents_vfunc(int offset, int& x, int& y, int& width, int& height, CoordType coords) const;
    virtual AtkAttributeSet* get_run_attributes_vfunc(int offset, int& start_offset, int& end_offset) const;
    virtual AtkAttributeSet* get_default_attributes_vfunc() const;
    virtual int get_character_count_vfunc() const;
    virtual int get_offset_at_point_vfunc(int x, int y, CoordType coords) const;
    virtual int get_n_selections_vfunc() const;
    virtual Glib::ustring get_selection_vfunc(int selection_num, int& start_offset, int& end_offset) const;
    virtual bool add_selection_vfunc(int start_offset, int end_offset);
    virtual bool remove_selection_vfunc(int selection_num);
    virtual bool set_selection_vfunc(int selection_num, int start_offset, int end_offset);
    virtual bool set_caret_offset_vfunc(int offset);
  
  //TODO: Add get_range_extents(), and get_bounded_ranges() vfuncs when we can break ABI.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_text_changed(int position, int length);
  virtual void on_text_caret_moved(int location);
  virtual void on_text_selection_changed();
  virtual void on_text_attributes_changed();


};

} // namespace Atk


namespace Glib
{
  /** @relates Atk::Text
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Atk::Text> wrap(AtkText* object, bool take_copy = false);

} // namespace Glib

#endif /* _ATKMM_TEXT_H */

