#if !defined (DEBUG)
#define DEBUG 1
#endif

#include <AppKit.h>
#include <InterfaceKit.h>
#include <Debug.h>

#include <stdio.h>
#include <stdlib.h>
#include "gtk/gtk.h"
#include "libgimp/gimp.h"
#include "libgimp/gimpui.h"
#include "libgimp/gimpprotocol.h"

#include "IEWindow.h"
#include "GimpStub.h"
#include "FilterViews.h"

typedef struct
{
  gdouble tile_size;
  gdouble tile_saturation;
  gint    bg_color;
} CubismVals;

extern "C" CubismVals		cvals;

typedef struct ReturnValue {
	BMessage	*msg;
	bool		done;
};

class GIMPDlog : public IEWindow {
public:
	GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms);
	~GIMPDlog(void);

virtual	void		MessageReceived(BMessage *message);
virtual	bool		QuitRequested (void);
		void		DoPreview (void);
		void		DoMiniPreview (void);
//public:
protected:
	FILTER_NAME			*fFilter;
	TFilterParams		*fParms;
	BSliderTextHelper	*fHelper1;
	BSliderTextHelperFloat *fHelper2;
	ReturnValue			*fReturn;
	TMiniView			*fMiniView;
	gdouble				tile_size, tile_saturation;
	gint				bg_color;
	bool				fPreview;
};

GIMPDlog::GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms) : IEWindow("cubism") {
	ASSERT (!ret->done); fReturn = ret; fReturn->msg = NULL;
	AddTemporaryBPath (NULL); fParms = parms; fFilter = filter;

	tile_size = cvals.tile_size; tile_saturation = cvals.tile_saturation; bg_color = cvals.bg_color;
	fPreview = false;
	Lock ();
	fMiniView = new TMiniView (FindView("Preview"), parms); fMiniView->Parms()->fDocument = NULL;	//	To say it's a min view
	BControl	*ctl;
	if (bg_color) { ctl = (BControl *) FindView ("Ints"); ASSERT (typeid(*ctl)==typeid(BCheckBox)); ctl->SetValue (1); }
	fHelper1 = new BSliderTextHelper ("Sld1", "TE1", this); fHelper1->SetValue (tile_size);
	fHelper2 = new BSliderTextHelperFloat ("Sld2", "TE2", this, 10); fHelper1->SetValue (tile_saturation);
	gProgressView = new TDlogProgressView (FindView ("Progress"));
	Unlock ();
	Show();
	PostMessage ('_xPr');
}

GIMPDlog::~GIMPDlog(void) {
	if (!fReturn->msg) {
		fParms->fDst->Copy (*fParms->fSrc);
		FilterUpdate (fParms);
	} else  {
		if (!fPreview) {
			fPreview = true;
			DoPreview ();	//	We do the action if it was not previewed.
		}
		VERIFY (B_OK == fFilter->Archive (fReturn->msg, true));
	}
	delete fHelper1; delete fHelper2;
	fReturn->done = true;
}

bool GIMPDlog::QuitRequested (void) {
	gProgressView = NULL;
	return true;
}

void GIMPDlog::DoPreview (void) {
	if (fPreview) {
		CubismVals	values;
		values.tile_size = tile_size; values.tile_saturation = tile_saturation; values.bg_color = bg_color;
		fFilter->SetValue (&values);
	}
	DoMiniPreview ();
}

void GIMPDlog::DoMiniPreview (void) {
	CubismVals	values;
	values.tile_size = tile_size; values.tile_saturation = tile_saturation; values.bg_color = bg_color;
	BMessage		msg;
	VERIFY (B_NO_ERROR == fFilter->Archive (&msg));
	FILTER_NAME	*oldCur = gCurFilter; gCurFilter = NULL;
	FILTER_NAME	*filter = (FILTER_NAME *) instantiate_object (&msg);
	filter->SetValue (&values); fMiniView->Parms()->fFilter = filter;
	filter->ApplyFilter (fMiniView->Parms());
	delete filter; gCurFilter = oldCur; ASSERT (oldCur = fFilter);
	fMiniView->DestChanged ();
}

// Handling of user interface and other events
void GIMPDlog::MessageReceived (BMessage *message) {
	int32			value;

	switch(message->what){
		case '_xPr':	DoMiniPreview (); break;
		case 'Ints':	bg_color = !bg_color; DoPreview (); break;
		case 'Sld1':	value = message->FindInt32 ("be:value"); if (value != tile_size) { tile_size = value; DoPreview (); } break;
		case 'Sld2':	value = message->FindInt32 ("be:value"); if (value != 10 * tile_saturation) { tile_saturation = double(value) / 10; DoPreview (); } break;
		case 'View':	fPreview = !fPreview;
						if (fPreview) {
							DoPreview ();
						} else {
							//	Removes the preview by restoring the original image.
							fParms->fDst->Copy (*fParms->fSrc);
							FilterUpdate (fParms);
						}
						break;
		case 'Abut':	fFilter->DoAbout (); break;
		case 'OK  ':	fReturn->msg = new BMessage ('Parm'); cvals.tile_size = tile_size;
						cvals.tile_saturation = tile_saturation; cvals.bg_color = bg_color;
		case 'Esc ':	gProgressView = NULL; Quit (); break;
		default:		inherited::MessageReceived(message); break;
	}

}

void FILTER_NAME::DoIt (TFilterParams *parms, const void *values) {
	GParam	inputParms[6], *outputParms;
	gint	cntOutput;

	inputParms[0].type = PARAM_INT32; inputParms[0].data.d_int32 = RUN_NONINTERACTIVE;
	inputParms[2].type = PARAM_DRAWABLE; inputParms[2].data.d_drawable = gint32(parms);
	inputParms[3].type = PARAM_INT32; inputParms[3].data.d_float = ((const CubismVals *)values)->tile_size;
	inputParms[4].type = PARAM_INT32; inputParms[4].data.d_float = ((const CubismVals *)values)->tile_saturation;
	inputParms[5].type = PARAM_INT32; inputParms[5].data.d_int32 = ((const CubismVals *)values)->bg_color;
	(*PLUG_IN_INFO.run_proc) (fName, 6, inputParms, &cntOutput, &outputParms);
}

BMessage *FILTER_NAME::ApplyFilter (TFilterParams *parms) {
	BMessage	*result = NULL;

	if (fInited) {
		DoIt (parms, fData);
	} else {
		ReturnValue	returnVal;

		fLock = new Benaphore ("Synchro Dialog");
		returnVal.done = fChanged = false; fInited = true;
		AddTemporaryBPath (filterFile);
		new GIMPDlog (&returnVal, this, parms);
		do {
			if (fChanged) {
				fLock->Lock ();
				CubismVals	tmpValues;
				memcpy (&tmpValues, fData, sizeof (CubismVals));
				fChanged = false;
				fLock->Unlock ();
				DoIt (parms, &tmpValues);
				FilterUpdate (parms);
			} else {
				snooze (250000);
			}
		} while (!returnVal.done);
		result = returnVal.msg;
	}
	return result;
}

void FILTER_NAME::PrepareData (void) {
	fData = (void *) new char [sizeof(CubismVals)]; fDataSize = sizeof (CubismVals);
	ASSERT (fData);
}

void FILTER_NAME::DisposeData (void) {
	delete (CubismVals *)fData;
}

void FILTER_NAME::SetValue (void *value) {
	if (fLock) {
		ASSERT (fLock);
		fLock->Lock ();
	
		memcpy (fData, value, sizeof(CubismVals));
		fChanged = true;
		fLock->Unlock ();
	} else {
		memcpy (fData, value, sizeof(CubismVals));
	}
}

void gimp_get_data (gchar *id, gpointer data) {
	//	ASSERT (gCurFilter); gCurFilter->GetData (id, data);
}

void gimp_set_data (gchar *id, gpointer data, guint32 length) {
	//	ASSERT (gCurFilter); gCurFilter->SetData (id, data, length);
}

