/* synMap.c was originally generated by the autoSql program, which also 
 * generated synMap.h and synMap.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "synMap.h"


void synMapStaticLoad(char **row, struct synMap *ret)
/* Load a row from synMap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chromA = row[0];
ret->chromStartA = sqlUnsigned(row[1]);
ret->chromEndA = sqlUnsigned(row[2]);
ret->strandA = row[3];
ret->chromB = row[4];
ret->chromStartB = sqlUnsigned(row[5]);
ret->chromEndB = sqlUnsigned(row[6]);
}

struct synMap *synMapLoad(char **row)
/* Load a synMap from row fetched with select * from synMap
 * from database.  Dispose of this with synMapFree(). */
{
struct synMap *ret;

AllocVar(ret);
ret->chromA = cloneString(row[0]);
ret->chromStartA = sqlUnsigned(row[1]);
ret->chromEndA = sqlUnsigned(row[2]);
ret->strandA = cloneString(row[3]);
ret->chromB = cloneString(row[4]);
ret->chromStartB = sqlUnsigned(row[5]);
ret->chromEndB = sqlUnsigned(row[6]);
return ret;
}

struct synMap *synMapNoStrandLoad(char **row)
/* Load a synMap from row fetched with select * from synMap
 * from database.  Dispose of this with synMapFree(). */
{
struct synMap *ret;

AllocVar(ret);
ret->chromA = cloneString(row[0]);
ret->chromStartA = sqlUnsigned(row[1]);
ret->chromEndA = sqlUnsigned(row[2]);

ret->chromB = cloneString(row[3]);
ret->chromStartB = sqlUnsigned(row[4]);
ret->chromEndB = sqlUnsigned(row[5]);
return ret;
}


struct synMap *synMapLoadAll(char *fileName) 
/* Load all synMap from a tab-separated file.
 * Dispose of this with synMapFreeList(). */
{
struct synMap *list = NULL, *el=NULL;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char **row;
char *words[32];
char *line = NULL;
int lineSize = 1024;
int wordCount = 0;
int lineWCount = 0;
int count =0;

wordCount = lineFileChop(lf, words);
if (wordCount == 0)
    errAbort("%s appears to be empty", fileName);
lineFileClose(&lf);
lf = lineFileOpen(fileName, TRUE);
row = needMem(sizeof(char *) * wordCount);
while (lineFileNext(lf, &line, &lineSize))
    {
    count++;
    if(strstr(line, "?") == NULL)
	{
	lineWCount = chopByWhite(line, row, wordCount);
	if(wordCount != lineWCount)
	    errAbort("Expecting %d words got %d at line %d\n",  wordCount, lineWCount, count);
	if(lineWCount == 7)
	    el = synMapLoad(row);
	else if(lineWCount >= 10)
	    el = synMapNoStrandLoad(row);
	else 
	    errAbort("synMap::synMapLoadAll() - expecting 7 or greater than 10 fields got %d", lineWCount);
	slAddHead(&list, el);
	}
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct synMap *synMapCommaIn(char **pS, struct synMap *ret)
/* Create a synMap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new synMap */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chromA = sqlStringComma(&s);
ret->chromStartA = sqlUnsignedComma(&s);
ret->chromEndA = sqlUnsignedComma(&s);
ret->strandA = sqlStringComma(&s);
ret->chromB = sqlStringComma(&s);
ret->chromStartB = sqlUnsignedComma(&s);
ret->chromEndB = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void synMapFree(struct synMap **pEl)
/* Free a single dynamically allocated synMap such as created
 * with synMapLoad(). */
{
struct synMap *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chromA);
freeMem(el->strandA);
freeMem(el->chromB);
freez(pEl);
}

void synMapFreeList(struct synMap **pList)
/* Free a list of dynamically allocated synMap's */
{
struct synMap *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    synMapFree(&el);
    }
*pList = NULL;
}

void synMapOutput(struct synMap *el, FILE *f, char sep, char lastSep) 
/* Print out synMap.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chromA);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStartA);
fputc(sep,f);
fprintf(f, "%u", el->chromEndA);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strandA);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chromB);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStartB);
fputc(sep,f);
fprintf(f, "%u", el->chromEndB);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

