# celeraOverlay.sql was originally generated by the autoSql program, which also 
# generated celeraOverlay.c and celeraOverlay.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Celera assembly overlay in the public (NCBI) assembly
CREATE TABLE celeraOverlay (
    bin smallint not null,      # Index field
    chrom varchar(255) not null,	# Human chromosome
    chromStart int unsigned not null,	# Start position in chromosome
    chromEnd int unsigned not null,	# End position in chromosome
    name varchar(255) not null,	# Other chromosome and start
    otherChrom varchar(25) not null,	# Other chromosome
    otherStart int unsigned not null,	# Start in other chromosome
    otherEnd int unsigned not null,	# End in other chromosome
    orient char(1) not null,	# Strand/orientation (F or R)
    field1 char(1) not null,	# ? (always M)
    field2 char(1) not null,	# ? (r or u)
    localId varchar(10) not null,	# ?
    parentInfo varchar(25) not null,	# ?
    refId varchar(25) not null,	# Reference ID
    refStart int unsigned not null,	# Start position in reference
    refLength int unsigned not null,	# Length in reference
    refOrient tinyint not null,	# Strand/orientation in reference (-1 or 1)
    queryId varchar(25) not null,	# Query ID
    queryStart int unsigned not null,	# Start position in query
    queryLength int unsigned not null,	# Length in query
    queryOrient tinyint not null,	# Strand/orientation in query (-1 or 1)
              #Indices
    INDEX (chrom(8), bin),
    INDEX (chrom(8), chromStart),
    INDEX (name(18))
);
