/* pepPred.h was originally generated by the autoSql program, which also 
 * generated pepPred.c and pepPred.sql.  This header links the database and the RAM 
 * representation of objects. */

#ifndef PEPPRED_H
#define PEPPRED_H

struct pepPred
/* A predicted peptide - linked to a predicted gene. */
    {
    struct pepPred *next;  /* Next in singly linked list. */
    char *name;	/* Name of gene - same as in genePred */
    char *seq;	/* Peptide sequence */
    };

void pepPredStaticLoad(char **row, struct pepPred *ret);
/* Load a row from pepPred table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct pepPred *pepPredLoad(char **row);
/* Load a pepPred from row fetched with select * from pepPred
 * from database.  Dispose of this with pepPredFree(). */

struct pepPred *pepPredCommaIn(char **pS, struct pepPred *ret);
/* Create a pepPred out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new pepPred */

void pepPredFree(struct pepPred **pEl);
/* Free a single dynamically allocated pepPred such as created
 * with pepPredLoad(). */

void pepPredFreeList(struct pepPred **pList);
/* Free a list of dynamically allocated pepPred's */

void pepPredOutput(struct pepPred *el, FILE *f, char sep, char lastSep);
/* Print out pepPred.  Separate fields with sep. Follow last field with lastSep. */

#define pepPredTabOut(el,f) pepPredOutput(el,f,'\t','\n');
/* Print out pepPred as a line in a tab-separated file. */

#define pepPredCommaOut(el,f) pepPredOutput(el,f,',',',');
/* Print out pepPred as a comma separated list including final comma. */

#endif /* PEPPRED_H */

