/* exprBed.h was originally generated by the autoSql program, which also 
 * generated exprBed.c and exprBed.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef EXPRBED_H
#define EXPRBED_H

struct exprBed
/* Expression data information */
    {
    struct exprBed *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome name */
    unsigned chromStart;	/* position in nucleotides where feature starts on chromosome */
    unsigned chromEnd;	/* position in nucleotides where featrure stops on chromsome */
    char *name;	/* feature standardized name; can be a gene, exon or other */
    unsigned size;	/* Size of the feature, may be useful if we cannot place it */
    unsigned uniqueAlign;	/* 1 if alignment was a global maximum, 0 otherwise */
    unsigned score;	/* Score from pslLayout of best score */
    char *hname;	/* feature human name: can be a gene, exon or other */
    unsigned numExp;	/* Number of experiments in this bed */
    char **hybes;	/* Name of experimental hybridization performed, often name of tissue used */
    float *scores;	/* log of ratio of feature for particular hybridization */
    };

struct exprBed *exprBedLoad(char **row);
/* Load a exprBed from row fetched with select * from exprBed
 * from database.  Dispose of this with exprBedFree(). */

struct exprBed *exprBedLoadAll(char *fileName);
/* Load all exprBed from a tab-separated file.
 * Dispose of this with exprBedFreeList(). */

struct exprBed *exprBedCommaIn(char **pS, struct exprBed *ret);
/* Create a exprBed out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new exprBed */

void exprBedFree(struct exprBed **pEl);
/* Free a single dynamically allocated exprBed such as created
 * with exprBedLoad(). */

void exprBedFreeList(struct exprBed **pList);
/* Free a list of dynamically allocated exprBed's */

void exprBedOutput(struct exprBed *el, FILE *f, char sep, char lastSep);
/* Print out exprBed.  Separate fields with sep. Follow last field with lastSep. */

#define exprBedTabOut(el,f) exprBedOutput(el,f,'\t','\n');
/* Print out exprBed as a line in a tab-separated file. */

#define exprBedCommaOut(el,f) exprBedOutput(el,f,',',',');
/* Print out exprBed as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* EXPRBED_H */

