/* encodePrimateAlleles.h was originally generated by the autoSql program, which also 
 * generated encodePrimateAlleles.c and encodePrimateAlleles.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef ENCODEPRIMATEALLELES_H
#define ENCODEPRIMATEALLELES_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define ENCODEPRIMATEALLELES_NUM_COLS 18

struct encodePrimateAlleles
/* Primate (chimp and macaque) alleles for ENCODE resequencing SNPs */
    {
    struct encodePrimateAlleles *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* Name of SNP - rsId or temporary name */
    unsigned score;	/* 0 */
    char strand;	/* + or - */
    char refAllele;	/* A, C, G, or T */
    char otherAllele;	/* A, C, G, or T */
    char *chimpChrom;	/* Chimp Chromosome */
    unsigned chimpPos;	/* End position in himpChrom */
    char chimpStrand;	/* + or - or . */
    char *chimpAllele;	/* A, C, G, T, a, c, g, t, or . */
    unsigned chimpQual;	/* Chimp quality score */
    char *rhesusChrom;	/* Rhesus Chromosome */
    unsigned rhesusPos;	/* End position in rhesusChrom */
    char rhesusStrand;	/* + or - or . */
    char *rhesusAllele;	/* A, C, G, T, a, c, g, t, or . */
    unsigned rhesusQual;	/* Rhesus quality score */
    };

void encodePrimateAllelesStaticLoad(char **row, struct encodePrimateAlleles *ret);
/* Load a row from encodePrimateAlleles table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct encodePrimateAlleles *encodePrimateAllelesLoad(char **row);
/* Load a encodePrimateAlleles from row fetched with select * from encodePrimateAlleles
 * from database.  Dispose of this with encodePrimateAllelesFree(). */

struct encodePrimateAlleles *encodePrimateAllelesLoadAll(char *fileName);
/* Load all encodePrimateAlleles from whitespace-separated file.
 * Dispose of this with encodePrimateAllelesFreeList(). */

struct encodePrimateAlleles *encodePrimateAllelesLoadAllByChar(char *fileName, char chopper);
/* Load all encodePrimateAlleles from chopper separated file.
 * Dispose of this with encodePrimateAllelesFreeList(). */

#define encodePrimateAllelesLoadAllByTab(a) encodePrimateAllelesLoadAllByChar(a, '\t');
/* Load all encodePrimateAlleles from tab separated file.
 * Dispose of this with encodePrimateAllelesFreeList(). */

struct encodePrimateAlleles *encodePrimateAllelesLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all encodePrimateAlleles from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with encodePrimateAllelesFreeList(). */

void encodePrimateAllelesSaveToDb(struct sqlConnection *conn, struct encodePrimateAlleles *el, char *tableName, int updateSize);
/* Save encodePrimateAlleles as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use encodePrimateAllelesSaveToDbEscaped() */

void encodePrimateAllelesSaveToDbEscaped(struct sqlConnection *conn, struct encodePrimateAlleles *el, char *tableName, int updateSize);
/* Save encodePrimateAlleles as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than encodePrimateAllelesSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct encodePrimateAlleles *encodePrimateAllelesCommaIn(char **pS, struct encodePrimateAlleles *ret);
/* Create a encodePrimateAlleles out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new encodePrimateAlleles */

void encodePrimateAllelesFree(struct encodePrimateAlleles **pEl);
/* Free a single dynamically allocated encodePrimateAlleles such as created
 * with encodePrimateAllelesLoad(). */

void encodePrimateAllelesFreeList(struct encodePrimateAlleles **pList);
/* Free a list of dynamically allocated encodePrimateAlleles's */

void encodePrimateAllelesOutput(struct encodePrimateAlleles *el, FILE *f, char sep, char lastSep);
/* Print out encodePrimateAlleles.  Separate fields with sep. Follow last field with lastSep. */

#define encodePrimateAllelesTabOut(el,f) encodePrimateAllelesOutput(el,f,'\t','\n');
/* Print out encodePrimateAlleles as a line in a tab-separated file. */

#define encodePrimateAllelesCommaOut(el,f) encodePrimateAllelesOutput(el,f,',',',');
/* Print out encodePrimateAlleles as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ENCODEPRIMATEALLELES_H */

