/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.SlaveBrowser;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatServlet
extends HttpServlet {
    private static final long serialVersionUID = 5484417807218095115L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatServlet.class);
    private final CapturedBrowsers capturedBrowsers;
    private final Gson gson = new Gson();

    public HeartbeatServlet(CapturedBrowsers capturedBrowsers) {
        this.capturedBrowsers = capturedBrowsers;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PrintWriter writer = resp.getWriter();
        String id = req.getParameter("id");
        if (id != null) {
            SlaveBrowser browser = this.capturedBrowsers.getBrowser(id);
            if (browser != null) {
                LOGGER.debug("heartbeat " + browser);
                if (!browser.isAlive()) {
                    this.capturedBrowsers.removeSlave(id);
                    writer.write("DEAD:" + this.gson.toJson(browser.getBrowserInfo()));
                } else {
                    writer.write("OK");
                }
            } else {
                LOGGER.debug("heartbeat " + id + "with no browser.");
                writer.write("DEAD: can't find browser.");
            }
        } else {
            LOGGER.debug("no heartbeat, no browser.");
            writer.write("DEAD");
        }
        writer.flush();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = req.getParameter("id");
        SlaveBrowser browser = this.capturedBrowsers.getBrowser(id);
        PrintWriter writer = resp.getWriter();
        if (browser != null) {
            browser.heartBeat();
            if (browser.getCommandRunning() == null) {
                writer.write("Waiting...");
            } else {
                writer.write("Running: " + browser.getCommandRunning());
            }
        } else {
            writer.write("UNKNOWN");
        }
        writer.flush();
    }
}

