/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.Border;
import org.netbeans.swing.laf.flatlaf.HiDPIUtils;

final class DPISafeBorder
implements Border {
    private final Insets insets;
    private final Color color;

    public static Border matte(int n, int n2, int n3, int n4, Color color) {
        return new DPISafeBorder(new Insets(n, n2, n3, n4), color);
    }

    private DPISafeBorder(Insets insets, Color color) {
        if (insets == null) {
            throw new NullPointerException();
        }
        if (color == null) {
            throw new NullPointerException();
        }
        this.insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this.color = color;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl = this.insets.left == 0;
        boolean bl2 = this.insets.top == 0;
        HiDPIUtils.paintAtScale1x(graphics, n, n2, n3, n4, bl, bl2, this::paintBorderAtScale1x);
    }

    private void paintBorderAtScale1x(Graphics2D graphics2D, int n, int n2, double d) {
        Color color = graphics2D.getColor();
        int n3 = HiDPIUtils.deviceBorderWidth(d, this.insets.left);
        int n4 = HiDPIUtils.deviceBorderWidth(d, this.insets.right);
        int n5 = HiDPIUtils.deviceBorderWidth(d, this.insets.top);
        int n6 = HiDPIUtils.deviceBorderWidth(d, this.insets.bottom);
        graphics2D.setColor(this.color);
        graphics2D.fillRect(0, 0, n - n4, n5);
        graphics2D.fillRect(0, n5, n3, n2 - n5);
        graphics2D.fillRect(n3, n2 - n6, n - n3, n6);
        graphics2D.fillRect(n - n4, 0, n4, n2 - n6);
        graphics2D.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

