/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.widget.ResourceTable;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.RenderUtil;

public final class LineBorder
implements Border {
    private Insets insets;
    private Color color;
    private ResourceTableListener listener = null;

    public LineBorder(int n, int n2, int n3, int n4, Color color) {
        this.insets = new Insets(n, n2, n3, n4);
        this.color = color;
    }

    public LineBorder(int n, int n2, int n3, int n4, String string, Widget widget) {
        this(n, n2, n3, n4, string, widget.getResourceTable());
    }

    public LineBorder(int n, int n2, int n3, int n4, String string, ResourceTable resourceTable) {
        this.insets = new Insets(n, n2, n3, n4);
        Object object = resourceTable.getProperty(string);
        if (object instanceof Color) {
            this.color = (Color)object;
        }
        this.listener = new ResourceTableListener();
        resourceTable.addPropertyChangeListener(string, this.listener);
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setColor(this.color);
        RenderUtil.drawRect(graphics2D, rectangle);
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    public class ResourceTableListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            LineBorder.this.color = (Color)propertyChangeEvent.getNewValue();
        }
    }
}

