/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.constructs.web.AlreadyGzippedException;
import net.sf.ehcache.constructs.web.GenericResponseWrapper;
import net.sf.ehcache.constructs.web.PageInfo;
import net.sf.ehcache.constructs.web.filter.CachingFilter;

public abstract class PageFragmentCachingFilter
extends CachingFilter {
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws Exception {
        PageInfo pageInfo = this.buildPageInfo(request, response, chain);
        this.writeResponse(response, pageInfo);
    }

    protected PageInfo buildPage(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws AlreadyGzippedException, Exception {
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        GenericResponseWrapper wrapper = new GenericResponseWrapper(response, outstr);
        chain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
        wrapper.flush();
        return new PageInfo(wrapper.getStatus(), wrapper.getContentType(), wrapper.getHeaders(), wrapper.getCookies(), outstr.toByteArray(), false);
    }

    protected void writeResponse(HttpServletResponse response, PageInfo pageInfo) throws IOException {
        byte[] cachedPage = pageInfo.getUngzippedBody();
        String page = new String(cachedPage, response.getCharacterEncoding());
        String implementationVendor = response.getClass().getPackage().getImplementationVendor();
        if (implementationVendor != null && implementationVendor.equals("\"Evermind\"")) {
            response.getOutputStream().print(page);
        } else {
            response.getWriter().write(page);
        }
    }
}

