/******************************************************************************
 *{@C
 *      Copyright:      2009-2022 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgOpenThreads.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module 
 *                      OpenThreads.
 *
 *****************************************************************************/

%include "osgOpenThreadsHeader.i"

%{
using namespace OpenThreads;
%}

/* Note:
 * We do not include the Config header file, because it contains
 * system-specifc values regarding mutexes.
 * Rather the correct _OPENTHREADS_ATOMIC* macro is set in the
 * tcl3dOsg Makefile per system.
 */

%include OpenThreads/Block
%include OpenThreads/Barrier
%include OpenThreads/Condition

%include OpenThreads/Thread
%include OpenThreads/Mutex
%include OpenThreads/ReentrantMutex
%include OpenThreads/ReadWriteMutex
%include OpenThreads/ScopedLock

%include OpenThreads/Version
