set osgDir [pwd]
set osgDir [file normalize $osgDir]

set glob1 "swigfiles/osg*.i"
set swigFileList [lsort [glob $glob1]]
#puts $swigFileList

foreach f $swigFileList {
    set fp [open $f "r"]
    # puts "Processing $f"
    while { [gets $fp line] >= 0 } {
        set inclFile ""
        set line [string trim $line]
        if { [string match "%include*" $line] } {
            scan $line "%%include %s" inclFile
            set inclFile [string trim $inclFile "\""]
            lappend wrappedFilesList $inclFile
        } elseif { [string match "#include*" $line] } {
            scan $line "#include %s" inclFile
            set inclFile [string trim $inclFile "<>"]
            # puts "Found include file: $inclFile"
            lappend includedFilesList $inclFile
        }
    }
    close $fp
}

set numInclFiles  0
set numWrapped    0
set numNotWrapped 0

cd $osgDir/include
set dirList [lsort -dictionary [glob -types d OpenThreads osg*]]
foreach dir $dirList {
    set fileList [lsort -dictionary [glob $dir/*]]
    incr numInclFiles [llength $fileList]
    foreach f $fileList {
        set indWrapped  [lsearch $wrappedFilesList $f]
        set indIncluded [lsearch $includedFilesList $f]
        if { $indWrapped >= 0 } {
            set msg ""
            if { $indIncluded < 0 } {
                set msg "(Not included)"
            }
            puts "Wrapped: $f $msg"
            incr numWrapped
        } else {
            puts "Not yet: $f"
            incr numNotWrapped
        }
    }
}

puts "Number of include files  : $numInclFiles"
puts "Number of wrapped files  : $numWrapped"
puts "Number of unwrapped files: $numNotWrapped"

cd $osgDir
set fileList [lsort -dictionary [glob *wrap.cpp]]
set numTotalCppLines 0
foreach f $fileList {
    set fp [open $f "r"]
    set numCppLines 0
    while { [gets $fp line] >= 0 } {
        if { [string trim $line] ne "" } {
            incr numCppLines
        }
    }
    puts "$f : $numCppLines source code lines"
    close $fp
    incr numTotalCppLines $numCppLines
}

puts "Number of source code lines: $numTotalCppLines"

exit 0
