package require tcl3d

info commands tcl3dVec3*

set sv1 [tcl3dVectorFromArgs float 0 0 0]
set sv2 [tcl3dVectorFromArgs float 1 2 3]
set se1 [tcl3dVectorFromArgs float 1 0 0]
set se2 [tcl3dVectorFromArgs float 0 1 0]
set se3 [tcl3dVectorFromArgs float 0 0 1]
set sx  [tcl3dVectorFromArgs float 0 0 0]

set dv1 [tcl3dVectorFromArgs double 0 0 0]
set dv2 [tcl3dVectorFromArgs double 1 2 3]
set de1 [tcl3dVectorFromArgs double 1 0 0]
set de2 [tcl3dVectorFromArgs double 0 1 0]
set de3 [tcl3dVectorFromArgs double 0 0 1]
set dx  [tcl3dVectorFromArgs double 0 0 0]

puts -nonewline "New vector sv1:"
tcl3dVec3Print $sv1
puts "\tLength: [tcl3dVec3fLength $sv1]"
puts -nonewline "New vector dv1:"
tcl3dVec3Print $dv1
puts "\tLength: [tcl3dVec3dLength $dv1]"
puts ""

puts -nonewline "New vector sv2:"
tcl3dVec3Print $sv2
puts "\tLength: [tcl3dVec3fLength $sv2]"
tcl3dVec3fCopy $sv2 $sx
puts "\tCopied vector identical: [tcl3dVec3fCompare $sv2 $sx 1.0E-6]"
tcl3dVec3fNormalize $sx 
puts -nonewline "\tNormalized: " ; tcl3dVec3Print $sx
puts "\tLength: [tcl3dVec3fLength $sx]"
puts -nonewline "New vector dv2:"
tcl3dVec3Print $dv2
puts "\tLength: [tcl3dVec3dLength $dv2]"
tcl3dVec3dCopy $dv2 $dx
puts "\tCopied vector identical: [tcl3dVec3dCompare $dv2 $dx 1.0E-9]"
tcl3dVec3dNormalize $dx 
puts -nonewline "\tNormalized: " ; tcl3dVec3Print $dx
puts "\tLength: [tcl3dVec3dLength $dx]"
puts ""

puts -nonewline "New vector se1:"
tcl3dVec3Print $se1
puts -nonewline "New vector se2:"
tcl3dVec3Print $se2

puts -nonewline "\tDistance between se1 and se2: " 
puts [tcl3dVec3fDistance $se1 $se2]
puts -nonewline "\tDot product between se1 and se2: " 
puts [tcl3dVec3fDotProduct $se1 $se2]
puts -nonewline "\tDot product between se1 and sv2: " 
puts [tcl3dVec3fDotProduct $se1 $sv2]
puts -nonewline "\tCross product between se1 and se2: " 
tcl3dVec3fCrossProduct $se1 $se2 $sx
tcl3dVec3Print $sx

puts -nonewline "New vector de1:"
tcl3dVec3Print $de1
puts -nonewline "New vector de2:"
tcl3dVec3Print $de2

puts -nonewline "\tDistance between de1 and de2: " 
puts [tcl3dVec3dDistance $de1 $de2]
puts -nonewline "\tDot product between de1 and de2: " 
puts [tcl3dVec3dDotProduct $de1 $de2]
puts -nonewline "\tDot product between de1 and dv2: " 
puts [tcl3dVec3dDotProduct $de1 $dv2]
puts -nonewline "\tCross product between de1 and de2: " 
tcl3dVec3dCrossProduct $de1 $de2 $dx
tcl3dVec3Print $dx
puts ""

puts -nonewline "sx = se1       :" 
tcl3dVec3fCopy $se1 $sx
tcl3dVec3Print $sx
puts -nonewline "sx = se1 + sv2 :" 
tcl3dVec3fAdd $se1 $sv2 $sx
tcl3dVec3Print $sx
puts -nonewline "sx = sx - se1  :" 
tcl3dVec3fSubtract $sx $se1 $sx
tcl3dVec3Print $sx
puts -nonewline "sx = 3.5 * sv2 :" 
tcl3dVec3fScale 3.5 $sv2 $sx
tcl3dVec3Print $sx
puts -nonewline "dx = de1       :" 
tcl3dVec3dCopy $de1 $dx
tcl3dVec3Print $dx
puts -nonewline "dx = de1 + dv2 :" 
tcl3dVec3dAdd $de1 $dv2 $dx
tcl3dVec3Print $dx
puts -nonewline "dx = dx - de1  :" 
tcl3dVec3dSubtract $dx $de1 $dx
tcl3dVec3Print $dx
puts -nonewline "dx = 3.5 * dv2 :" 
tcl3dVec3dScale 3.5 $dv2 $dx
tcl3dVec3Print $dx

exit
