package require tcl3d

set c [tcl3dName2Hex white]
puts "\[tcl3dName2Hex white\]  returns \"$c\""
set c [tcl3dName2Hexa white]
puts "\[tcl3dName2Hexa white\] returns \"$c\""
puts ""

set c [tcl3dName2rgb white]
puts "\[tcl3dName2rgb white\] returns \{$c\}"
set n [eval tcl3dRgb2Name $c]
puts "\[tcl3dRgb2Name $c\] returns \"$n\""
puts ""

set c [tcl3dName2rgba white]
puts "\[tcl3dName2rgba white\] returns \{$c\}"
set n [eval tcl3dRgba2Name $c]
puts "\[tcl3dRgba2Name $c\] returns \"$n\""
puts ""

set c [tcl3dName2rgbf white]
puts "\[tcl3dName2rgbf white\] returns \{$c\}"
set n [eval tcl3dRgbf2Name $c]
puts "\[tcl3dRgbfName $c\] returns \"$n\""
puts ""

set c [tcl3dName2rgbaf white]
puts "\[tcl3dName2rgbaf white\] returns \{$c\}"
set n [eval tcl3dRgbaf2Name $c]
puts "\[tcl3dRgbafName $c\] returns \"$n\""
puts ""

set c [tcl3dName2rgb "#0a0c0e"]
puts "\[tcl3dName2rgb \"#0a0c0e\"\] returns \{$c\}"
puts ""

set c [tcl3dFindColorName white]
puts "\[tcl3dFindColorName white\] returns \"$c\""
set c [tcl3dFindColorName WitE]
puts "\[tcl3dFindColorName WiTE\] returns \"$c\""
puts ""

puts "List of color names and their byte and float representation:"
foreach c [tcl3dGetColorNames] {
    set cub [tcl3dName2rgb $c]
    set cf  [tcl3dName2rgbf $c]
    puts [format "%20s {%3d %3d %3d} {%1.3f %1.3f %1.3f}" \
          $c \
          [lindex $cub 0] [lindex $cub 1] [lindex $cub 2] \
          [lindex $cf  0] [lindex $cf  1] [lindex $cf  2]]
}

exit 0
