/******************************************************************************
 *{@C
 *      Copyright:      2006-2022 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dGl2ps
 *      Filename:       tcl3dGl2ps.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Main SWIG files for wrapping the GL2PS library.
 *                      This file is responsible for the Tcl package tcl3dGl2ps.
 *
 *                      The macro USE_GL2PS_IF must be defined at compilation
 *                      time to include the functionality of the GL2PS library
 *                      into the Tcl3D package.
 *
 *****************************************************************************/

// The name of our generated Tcl package.

%module tcl3dGl2ps


// Code to initialize the Tk stubs library.

%{
#include <tk.h>
%}

%init %{
#ifndef USE_GL2PS_IF
    Tcl_SetResult(interp, (char *) "GL2PS library not wrapped", TCL_STATIC);
    return TCL_ERROR;
#endif

#ifdef USE_TK_STUBS
    if (Tk_InitStubs(interp, (char*)"8.5", 0) == NULL) {
      return TCL_ERROR;
    }
#endif
%}

#ifdef USE_GL2PS_IF

// Standard modules from the SWIG library

%include typemaps.i


// Common Tcl3D wrapper modules.

%include tcl3dVectors.i
%include tcl3dConstHash.i
%include tcl3dPointer.i
%include tcl3dArgv.i
%include tcl3dTypemaps.i


// Wrap the GL2PS library.

%include gl2ps.i

#endif // USE_GL2PS_IF
