/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kotlin.Pair;
import kotlin.annotations.jvm.ReadOnly;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.HashMultimap;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScopesHolderForClass;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterUtilsKt;
import org.jetbrains.kotlin.descriptors.ValueClassRepresentation;
import org.jetbrains.kotlin.descriptors.ValueClassRepresentationKt;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtContextReceiver;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassInfoUtil;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassOrObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.ClassResolutionScopesSupport;
import org.jetbrains.kotlin.resolve.lazy.descriptors.ClassResolutionScopesSupportKt;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotations;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContext;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassMemberScope;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyTypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.StaticScopeForKotlinEnum;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.AbstractClassTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.checker.SimpleClassicTypeSystemContext;

public class LazyClassDescriptor
extends ClassDescriptorBase
implements ClassDescriptorWithResolutionScopes,
LazyEntity {
    private static final Function1<KotlinType, Boolean> VALID_SUPERTYPE = type2 -> {
        assert (!KotlinTypeKt.isError(type2)) : "Error types must be filtered out in DescriptorResolver";
        return TypeUtils.getClassDescriptor(type2) != null;
    };
    private final LazyClassContext c;
    @Nullable
    private final KtClassOrObject classOrObject;
    private final ClassMemberDeclarationProvider declarationProvider;
    private final LazyClassTypeConstructor typeConstructor;
    private final NotNullLazyValue<Modality> modality;
    private final DescriptorVisibility visibility;
    private final ClassKind kind;
    private final boolean isInner;
    private final boolean isData;
    private final boolean isInline;
    private final boolean isExpect;
    private final boolean isActual;
    private final boolean isFun;
    private final boolean isValue;
    private final Annotations annotations;
    private final Annotations danglingAnnotations;
    private final NullableLazyValue<ClassDescriptorWithResolutionScopes> companionObjectDescriptor;
    private final MemoizedFunctionToNotNull<KtObjectDeclaration, ClassDescriptor> extraCompanionObjectDescriptors;
    private final ScopesHolderForClass<LazyClassMemberScope> scopesHolderForClass;
    private final MemberScope staticScope;
    private final NullableLazyValue<Void> forceResolveAllContents;
    private final boolean isCompanionObject;
    private final ClassResolutionScopesSupport resolutionScopesSupport;
    private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;
    private final NotNullLazyValue<LexicalScope> scopeForInitializerResolution;
    private final NotNullLazyValue<Collection<ClassDescriptor>> sealedSubclasses;
    private final NotNullLazyValue<List<ReceiverParameterDescriptor>> contextReceivers;

    public LazyClassDescriptor(@NotNull LazyClassContext c, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name2, @NotNull KtClassLikeInfo classLikeInfo, boolean isExternal) {
        if (c == null) {
            LazyClassDescriptor.$$$reportNull$$$0(0);
        }
        if (containingDeclaration == null) {
            LazyClassDescriptor.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(2);
        }
        if (classLikeInfo == null) {
            LazyClassDescriptor.$$$reportNull$$$0(3);
        }
        super(c.getStorageManager(), containingDeclaration, name2, KotlinSourceElementKt.toSourceElement(classLikeInfo.getCorrespondingClassOrObject()), isExternal);
        this.c = c;
        this.classOrObject = classLikeInfo.getCorrespondingClassOrObject();
        this.declarationProvider = c.getDeclarationProviderFactory().getClassMemberDeclarationProvider(classLikeInfo);
        StorageManager storageManager = c.getStorageManager();
        this.scopesHolderForClass = this.createScopesHolderForClass(c, this.declarationProvider);
        this.kind = classLikeInfo.getClassKind();
        this.staticScope = this.kind == ClassKind.ENUM_CLASS ? new StaticScopeForKotlinEnum(storageManager, this, true) : MemberScope.Empty.INSTANCE;
        this.typeConstructor = new LazyClassTypeConstructor();
        this.isCompanionObject = classLikeInfo instanceof KtObjectInfo && ((KtObjectInfo)classLikeInfo).isCompanionObject();
        KtModifierList modifierList2 = classLikeInfo.getModifierList();
        if (this.kind.isSingleton()) {
            this.modality = storageManager.createLazyValue(() -> Modality.FINAL);
        } else {
            Modality defaultModality = this.kind == ClassKind.INTERFACE ? Modality.ABSTRACT : Modality.FINAL;
            this.modality = storageManager.createLazyValue(() -> ModifiersChecker.resolveModalityFromModifiers(this.classOrObject, defaultModality, c.getTrace().getBindingContext(), null, true));
        }
        boolean isLocal = this.classOrObject != null && KtPsiUtil.isLocal(this.classOrObject);
        this.visibility = isLocal ? DescriptorVisibilities.LOCAL : ModifiersChecker.resolveVisibilityFromModifiers(modifierList2, DescriptorVisibilities.DEFAULT_VISIBILITY);
        this.isInner = modifierList2 != null && modifierList2.hasModifier(KtTokens.INNER_KEYWORD) && !LazyClassDescriptor.isIllegalInner(this);
        this.isData = modifierList2 != null && modifierList2.hasModifier(KtTokens.DATA_KEYWORD);
        this.isInline = modifierList2 != null && modifierList2.hasModifier(KtTokens.INLINE_KEYWORD);
        this.isActual = modifierList2 != null && PsiUtilsKt.hasActualModifier(modifierList2);
        this.isExpect = modifierList2 != null && PsiUtilsKt.hasExpectModifier(modifierList2) || containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).isExpect();
        this.isFun = modifierList2 != null && PsiUtilsKt.hasFunModifier(modifierList2);
        this.isValue = modifierList2 != null && PsiUtilsKt.hasValueModifier(modifierList2);
        ArrayList<KtAnnotationEntry> annotationEntries = new ArrayList<KtAnnotationEntry>();
        if (this.classOrObject != null && this.classOrObject.getParent() instanceof KtObjectLiteralExpression) {
            annotationEntries.addAll(KtPsiUtilKt.getAnnotationEntries((KtObjectLiteralExpression)this.classOrObject.getParent()));
        }
        if (modifierList2 != null) {
            annotationEntries.addAll(modifierList2.getAnnotationEntries());
        }
        this.annotations = !annotationEntries.isEmpty() ? new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

            @Override
            @NotNull
            public LexicalScope getScope() {
                LexicalScope lexicalScope = LazyClassDescriptor.this.getOuterScope();
                if (lexicalScope == null) {
                    1.$$$reportNull$$$0(0);
                }
                return lexicalScope;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$1", "getScope"));
            }
        }, annotationEntries) : Annotations.Companion.getEMPTY();
        List<KtAnnotationEntry> ktDanglingAnnotations = classLikeInfo.getDanglingAnnotations();
        this.danglingAnnotations = ktDanglingAnnotations.isEmpty() ? Annotations.Companion.getEMPTY() : new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

            @Override
            @NotNull
            public LexicalScope getScope() {
                LexicalScope lexicalScope = LazyClassDescriptor.this.getScopeForMemberDeclarationResolution();
                if (lexicalScope == null) {
                    2.$$$reportNull$$$0(0);
                }
                return lexicalScope;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$2", "getScope"));
            }
        }, ktDanglingAnnotations);
        this.companionObjectDescriptor = storageManager.createNullableLazyValue(() -> this.computeCompanionObjectDescriptor(this.getCompanionObjectIfAllowed()));
        this.extraCompanionObjectDescriptors = storageManager.createMemoizedFunction(this::computeCompanionObjectDescriptor);
        this.forceResolveAllContents = storageManager.createRecursionTolerantNullableLazyValue(() -> {
            this.doForceResolveAllContents();
            return null;
        }, null);
        this.resolutionScopesSupport = new ClassResolutionScopesSupport(this, storageManager, c.getLanguageVersionSettings(), (Function0<? extends LexicalScope>)((Function0)this::getOuterScope));
        this.parameters = c.getStorageManager().createLazyValue(() -> {
            List<KtTypeParameter> typeParameters2;
            boolean isAnonymousObject;
            KtClassLikeInfo classInfo2 = this.declarationProvider.getOwnerInfo();
            KtTypeParameterList typeParameterList = classInfo2.getTypeParameterList();
            if (typeParameterList == null) {
                return Collections.emptyList();
            }
            boolean bl = isAnonymousObject = classInfo2.getClassKind() == ClassKind.CLASS && classInfo2.getCorrespondingClassOrObject() instanceof KtObjectDeclaration;
            if (classInfo2.getClassKind() == ClassKind.ENUM_CLASS) {
                c.getTrace().report(Errors.TYPE_PARAMETERS_IN_ENUM.on(typeParameterList));
            }
            if (classInfo2.getClassKind() == ClassKind.OBJECT) {
                c.getTrace().report(Errors.TYPE_PARAMETERS_IN_OBJECT.on(typeParameterList));
            }
            if (isAnonymousObject) {
                DiagnosticFactory0<KtTypeParameterList> diagnosticFactory = c.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitTypeParametersInAnonymousObjects) ? Errors.TYPE_PARAMETERS_IN_OBJECT : Errors.TYPE_PARAMETERS_IN_ANONYMOUS_OBJECT;
                c.getTrace().report(diagnosticFactory.on(typeParameterList));
            }
            if ((typeParameters2 = typeParameterList.getParameters()).isEmpty()) {
                return Collections.emptyList();
            }
            boolean supportClassTypeParameterAnnotations = c.getLanguageVersionSettings().supportsFeature(LanguageFeature.ClassTypeParameterAnnotations);
            ArrayList<LazyTypeParameterDescriptor> parameters2 = new ArrayList<LazyTypeParameterDescriptor>(typeParameters2.size());
            for (int i = 0; i < typeParameters2.size(); ++i) {
                KtTypeParameter parameter2 = typeParameters2.get(i);
                Annotations lazyAnnotations = supportClassTypeParameterAnnotations ? new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

                    @Override
                    @NotNull
                    public LexicalScope getScope() {
                        LexicalScope lexicalScope = LazyClassDescriptor.this.getOuterScope();
                        if (lexicalScope == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return lexicalScope;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$3", "getScope"));
                    }
                }, parameter2.getAnnotationEntries()) : Annotations.Companion.getEMPTY();
                parameters2.add(new LazyTypeParameterDescriptor(c, this, parameter2, lazyAnnotations, i));
            }
            return parameters2;
        });
        this.scopeForInitializerResolution = storageManager.createLazyValue(() -> ClassResolutionScopesSupportKt.scopeForInitializerResolution(this, this.createInitializerScopeParent(), classLikeInfo.getPrimaryConstructorParameters()));
        boolean freedomForSealedInterfacesSupported = c.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowSealedInheritorsInDifferentFilesOfSamePackage);
        this.sealedSubclasses = storageManager.createLazyValue(() -> {
            if (this.getModality() == Modality.SEALED) {
                return c.getSealedClassInheritorsProvider().computeSealedSubclasses(this, freedomForSealedInterfacesSupported);
            }
            return Collections.emptyList();
        });
        this.contextReceivers = storageManager.createLazyValue(() -> {
            if (this.classOrObject == null) {
                return CollectionsKt.emptyList();
            }
            List<KtContextReceiver> contextReceivers = this.classOrObject.getContextReceivers();
            List contextReceiverDescriptors = IntStream.range(0, contextReceivers.size()).mapToObj(index2 -> {
                KtContextReceiver contextReceiver2 = (KtContextReceiver)contextReceivers.get(index2);
                KtTypeReference typeReference = contextReceiver2.typeReference();
                if (typeReference == null) {
                    return null;
                }
                KotlinType kotlinType = c.getTypeResolver().resolveType(this.getScopeForClassHeaderResolution(), typeReference, c.getTrace(), true);
                Name label = contextReceiver2.labelNameAsName() != null ? contextReceiver2.labelNameAsName() : NameUtils.contextReceiverName(index2);
                return DescriptorFactory.createContextReceiverParameterForClass(this, kotlinType, contextReceiver2.labelNameAsName(), Annotations.Companion.getEMPTY(), index2);
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (c.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextReceivers)) {
                HashMultimap labelNameToReceiverMap = HashMultimap.create();
                for (int i = 0; i < contextReceivers.size(); ++i) {
                    labelNameToReceiverMap.put(contextReceivers.get(i).name(), contextReceiverDescriptors.get(i));
                }
                c.getTrace().record(BindingContext.DESCRIPTOR_TO_CONTEXT_RECEIVER_MAP, this, labelNameToReceiverMap);
            }
            return contextReceiverDescriptors;
        });
        if (this.classOrObject != null) {
            this.c.getTrace().record(BindingContext.CLASS, this.classOrObject, this);
        }
        this.c.getTrace().record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, DescriptorUtils.getFqName(this), this);
    }

    private static boolean isIllegalInner(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(4);
        }
        if (!DescriptorUtils.isClass(descriptor2)) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        return !(containingDeclaration instanceof ClassDescriptor) || DescriptorUtils.isInterface(containingDeclaration) || DescriptorUtils.isObject(containingDeclaration);
    }

    @NotNull
    private DeclarationDescriptor createInitializerScopeParent() {
        ClassConstructorDescriptor primaryConstructor2 = this.getUnsubstitutedPrimaryConstructor();
        if (primaryConstructor2 != null) {
            ClassConstructorDescriptor classConstructorDescriptor = primaryConstructor2;
            if (classConstructorDescriptor == null) {
                LazyClassDescriptor.$$$reportNull$$$0(5);
            }
            return classConstructorDescriptor;
        }
        return new FunctionDescriptorImpl(this, null, Annotations.Companion.getEMPTY(), Name.special("<init-blocks>"), CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE){
            {
                this.initialize(null, null, CollectionsKt.emptyList(), Collections.emptyList(), Collections.emptyList(), null, Modality.FINAL, DescriptorVisibilities.PRIVATE);
            }

            @Override
            @NotNull
            protected FunctionDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @Nullable FunctionDescriptor original, @NotNull CallableMemberDescriptor.Kind kind, @Nullable Name newName2, @NotNull Annotations annotations2, @NotNull SourceElement source) {
                if (newOwner == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (kind == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (annotations2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (source == null) {
                    4.$$$reportNull$$$0(3);
                }
                throw new UnsupportedOperationException();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newOwner";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "kind";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "annotations";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$4";
                objectArray[2] = "createSubstitutedCopy";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    protected ScopesHolderForClass<LazyClassMemberScope> createScopesHolderForClass(@NotNull LazyClassContext c, @NotNull ClassMemberDeclarationProvider declarationProvider) {
        if (c == null) {
            LazyClassDescriptor.$$$reportNull$$$0(6);
        }
        if (declarationProvider == null) {
            LazyClassDescriptor.$$$reportNull$$$0(7);
        }
        ScopesHolderForClass<LazyClassMemberScope> scopesHolderForClass = ScopesHolderForClass.Companion.create(this, c.getStorageManager(), c.getKotlinTypeCheckerOfOwnerModule().getKotlinTypeRefiner(), kotlinTypeRefinerForDependentModule -> {
            LazyClassMemberScope scopeForDeclaredMembers = !kotlinTypeRefinerForDependentModule.isRefinementNeededForModule(c.getModuleDescriptor()) ? null : this.scopesHolderForClass.getScope(c.getKotlinTypeCheckerOfOwnerModule().getKotlinTypeRefiner());
            return new LazyClassMemberScope(c, declarationProvider, this, c.getTrace(), (KotlinTypeRefiner)kotlinTypeRefinerForDependentModule, scopeForDeclaredMembers);
        });
        if (scopesHolderForClass == null) {
            LazyClassDescriptor.$$$reportNull$$$0(8);
        }
        return scopesHolderForClass;
    }

    @Override
    @NotNull
    public MemberScope getUnsubstitutedMemberScope(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        if (kotlinTypeRefiner == null) {
            LazyClassDescriptor.$$$reportNull$$$0(9);
        }
        LazyClassMemberScope lazyClassMemberScope = this.scopesHolderForClass.getScope(kotlinTypeRefiner);
        if (lazyClassMemberScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(10);
        }
        return lazyClassMemberScope;
    }

    @NotNull
    protected LexicalScope getOuterScope() {
        LexicalScope lexicalScope = this.c.getDeclarationScopeProvider().getResolutionScopeForDeclaration(this.declarationProvider.getOwnerInfo().getScopeAnchor());
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(11);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForClassHeaderResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForClassHeaderResolution().invoke();
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(12);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForConstructorHeaderResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForConstructorHeaderResolution().invoke();
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(13);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForCompanionObjectHeaderResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForCompanionObjectHeaderResolution().invoke();
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(14);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForMemberDeclarationResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForMemberDeclarationResolution().invoke();
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(15);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForStaticMemberDeclarationResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForStaticMemberDeclarationResolution().invoke();
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(16);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForInitializerResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.scopeForInitializerResolution.invoke();
        if (lexicalScope == null) {
            LazyClassDescriptor.$$$reportNull$$$0(17);
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public Collection<CallableMemberDescriptor> getDeclaredCallableMembers() {
        List list2 = CollectionsKt.filter(DescriptorUtils.getAllDescriptors(this.getUnsubstitutedMemberScope()), descriptor2 -> descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE);
        if (list2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @Override
    @NotNull
    public MemberScope getStaticScope() {
        MemberScope memberScope2 = this.staticScope;
        if (memberScope2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(19);
        }
        return memberScope2;
    }

    @Override
    @NotNull
    public Collection<ClassConstructorDescriptor> getConstructors() {
        Collection<ClassConstructorDescriptor> collection = ((LazyClassMemberScope)this.getUnsubstitutedMemberScope()).getConstructors();
        if (collection == null) {
            LazyClassDescriptor.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getContextReceivers() {
        List list2 = (List)this.contextReceivers.invoke();
        if (list2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @Override
    public ClassConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return ((LazyClassMemberScope)this.getUnsubstitutedMemberScope()).getPrimaryConstructor();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        LazyClassTypeConstructor lazyClassTypeConstructor = this.typeConstructor;
        if (lazyClassTypeConstructor == null) {
            LazyClassDescriptor.$$$reportNull$$$0(22);
        }
        return lazyClassTypeConstructor;
    }

    @Override
    public ClassDescriptorWithResolutionScopes getCompanionObjectDescriptor() {
        return (ClassDescriptorWithResolutionScopes)this.companionObjectDescriptor.invoke();
    }

    @Override
    @Nullable
    public SimpleType getDefaultFunctionTypeForSamInterface() {
        return this.c.getSamConversionResolver().resolveFunctionTypeIfSamInterface(this);
    }

    @Override
    public boolean isDefinitelyNotSamInterface() {
        return !this.isFun();
    }

    @NotNull
    @ReadOnly
    public List<ClassDescriptor> getDescriptorsForExtraCompanionObjects() {
        KtObjectDeclaration allowedCompanionObject = this.getCompanionObjectIfAllowed();
        List list2 = CollectionsKt.map((Iterable)CollectionsKt.filter(this.declarationProvider.getOwnerInfo().getCompanionObjects(), companionObject2 -> companionObject2 != allowedCompanionObject), this.extraCompanionObjectDescriptors);
        if (list2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(23);
        }
        return list2;
    }

    @Nullable
    private ClassDescriptorWithResolutionScopes computeCompanionObjectDescriptor(@Nullable KtObjectDeclaration companionObject2) {
        if (companionObject2 == null) {
            return this.createSyntheticCompanionObjectDescriptor();
        }
        KtClassLikeInfo companionObjectInfo = LazyClassDescriptor.getCompanionObjectInfo(companionObject2);
        if (!(companionObjectInfo instanceof KtClassOrObjectInfo)) {
            return null;
        }
        Name name2 = ((KtClassOrObjectInfo)companionObjectInfo).getName();
        assert (name2 != null);
        this.getUnsubstitutedMemberScope().getContributedClassifier(name2, NoLookupLocation.WHEN_GET_COMPANION_OBJECT);
        ClassDescriptor companionObjectDescriptor2 = this.c.getTrace().get(BindingContext.CLASS, companionObject2);
        if (companionObjectDescriptor2 instanceof ClassDescriptorWithResolutionScopes) {
            assert (DescriptorUtils.isCompanionObject(companionObjectDescriptor2)) : "Not a companion object: " + companionObjectDescriptor2;
            return (ClassDescriptorWithResolutionScopes)companionObjectDescriptor2;
        }
        return null;
    }

    private ClassDescriptorWithResolutionScopes createSyntheticCompanionObjectDescriptor() {
        Name syntheticCompanionName = this.c.getSyntheticResolveExtension().getSyntheticCompanionObjectNameIfNeeded(this);
        if (syntheticCompanionName == null) {
            return null;
        }
        SyntheticClassOrObjectDescriptor companionDescriptor = new SyntheticClassOrObjectDescriptor(this.c, this.classOrObject, this, syntheticCompanionName, this.getSource(), this.getOuterScope(), Modality.FINAL, DescriptorVisibilities.PUBLIC, Annotations.Companion.getEMPTY(), DescriptorVisibilities.PRIVATE, ClassKind.OBJECT, true);
        companionDescriptor.initialize();
        return companionDescriptor;
    }

    @Nullable
    private static KtClassLikeInfo getCompanionObjectInfo(@Nullable KtObjectDeclaration companionObject2) {
        if (companionObject2 != null) {
            return KtClassInfoUtil.createClassOrObjectInfo(companionObject2);
        }
        return null;
    }

    @Nullable
    private KtObjectDeclaration getCompanionObjectIfAllowed() {
        KtObjectDeclaration companionObject2 = (KtObjectDeclaration)CollectionsKt.firstOrNull(this.declarationProvider.getOwnerInfo().getCompanionObjects());
        return companionObject2 != null && this.isCompanionObjectAllowed() ? companionObject2 : null;
    }

    private boolean isCompanionObjectAllowed() {
        return !this.getKind().isSingleton() && !this.isInner() && !DescriptorUtils.isLocal(this);
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            LazyClassDescriptor.$$$reportNull$$$0(24);
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = (Modality)((Object)this.modality.invoke());
        if (modality == null) {
            LazyClassDescriptor.$$$reportNull$$$0(25);
        }
        return modality;
    }

    @Override
    @NotNull
    public DescriptorVisibility getVisibility() {
        DescriptorVisibility descriptorVisibility = this.visibility;
        if (descriptorVisibility == null) {
            LazyClassDescriptor.$$$reportNull$$$0(26);
        }
        return descriptorVisibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    public boolean isData() {
        return this.isData;
    }

    @Override
    public boolean isInline() {
        return this.isInline;
    }

    @Override
    public boolean isCompanionObject() {
        return this.isCompanionObject;
    }

    @Override
    public boolean isExpect() {
        return this.isExpect;
    }

    @Override
    public boolean isActual() {
        return this.isActual;
    }

    @Override
    public boolean isFun() {
        return this.isFun;
    }

    @Override
    public boolean isValue() {
        return this.isValue;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = this.annotations;
        if (annotations2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(27);
        }
        return annotations2;
    }

    @NotNull
    public Annotations getDanglingAnnotations() {
        Annotations annotations2 = this.danglingAnnotations;
        if (annotations2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(28);
        }
        return annotations2;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getSealedSubclasses() {
        Collection collection = (Collection)this.sealedSubclasses.invoke();
        if (collection == null) {
            LazyClassDescriptor.$$$reportNull$$$0(29);
        }
        return collection;
    }

    @Override
    @Nullable
    public ValueClassRepresentation<SimpleType> getValueClassRepresentation() {
        if (!this.isValue && !this.isInline) {
            return null;
        }
        ClassConstructorDescriptor constructor2 = this.getUnsubstitutedPrimaryConstructor();
        InlineClassRepresentation<SimpleType> invalidValueClassRepresentation = new InlineClassRepresentation<SimpleType>(SpecialNames.SAFE_IDENTIFIER_FOR_NO_NAME, this.c.getModuleDescriptor().getBuiltIns().getAnyType());
        if (constructor2 == null) {
            return invalidValueClassRepresentation;
        }
        List<ValueParameterDescriptor> parameters2 = constructor2.getValueParameters();
        SimpleClassicTypeSystemContext context = SimpleClassicTypeSystemContext.INSTANCE;
        if (LazyClassDescriptor.isRecursiveInlineClass(constructor2, new HashSet<ClassDescriptor>())) {
            return new InlineClassRepresentation<SimpleType>(parameters2.get(0).getName(), (SimpleType)parameters2.get(0).getType());
        }
        if (parameters2.size() == 0) {
            return invalidValueClassRepresentation;
        }
        List fields2 = parameters2.stream().map(parameter2 -> new Pair((Object)parameter2.getName(), (Object)((SimpleType)parameter2.getType()))).collect(Collectors.toList());
        return ValueClassRepresentationKt.createValueClassRepresentation(context, fields2);
    }

    private static boolean isRecursiveInlineClass(@Nullable ClassConstructorDescriptor constructor2, @NotNull Set<ClassDescriptor> visited2) {
        if (visited2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(30);
        }
        if (constructor2 == null || constructor2.getValueParameters().size() != 1 || !constructor2.getConstructedClass().isValue() && !constructor2.getConstructedClass().isInline()) {
            return false;
        }
        if (!visited2.add(constructor2.getConstructedClass())) {
            return true;
        }
        SimpleType type2 = (SimpleType)constructor2.getValueParameters().get(0).getType();
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (descriptor2 instanceof ClassDescriptor) {
            ClassConstructorDescriptor newConstructor = ((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor();
            return LazyClassDescriptor.isRecursiveInlineClass(newConstructor, visited2);
        }
        return false;
    }

    @Override
    public void validate() {
        if (this.parameters == null) {
            throw new IllegalStateException("parameters == null for " + this);
        }
    }

    public String toString() {
        return (this.isExpect ? "expect " : (this.isActual ? "actual " : "")) + "class " + this.getName().toString();
    }

    @Override
    public void forceResolveAllContents() {
        this.forceResolveAllContents.invoke();
    }

    private void doForceResolveAllContents() {
        this.resolveMemberHeaders();
        ClassDescriptorWithResolutionScopes companionObjectDescriptor2 = this.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 != null) {
            ForceResolveUtil.forceResolveAllContents(companionObjectDescriptor2);
        }
        ForceResolveUtil.forceResolveAllContents(this.getConstructors());
        ForceResolveUtil.forceResolveAllContents(this.getDescriptorsForExtraCompanionObjects());
        ForceResolveUtil.forceResolveAllContents(this.getUnsubstitutedMemberScope());
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
        ForceResolveUtil.forceResolveAllContents(this.getContextReceivers());
    }

    public void resolveMemberHeaders() {
        ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
        ForceResolveUtil.forceResolveAllContents(this.getDanglingAnnotations());
        this.getCompanionObjectDescriptor();
        this.getDescriptorsForExtraCompanionObjects();
        this.getConstructors();
        this.getContainingDeclaration();
        this.getThisAsReceiverParameter();
        this.getKind();
        this.getModality();
        this.getName();
        this.getOriginal();
        this.getScopeForClassHeaderResolution();
        this.getScopeForMemberDeclarationResolution();
        DescriptorUtils.getAllDescriptors(this.getUnsubstitutedMemberScope());
        this.getScopeForInitializerResolution();
        this.getUnsubstitutedInnerClassesScope();
        this.getTypeConstructor().getSupertypes();
        for (TypeParameterDescriptor typeParameterDescriptor : this.getTypeConstructor().getParameters()) {
            typeParameterDescriptor.getUpperBounds();
        }
        this.getUnsubstitutedPrimaryConstructor();
        this.getVisibility();
        this.getContextReceivers();
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getDeclaredTypeParameters() {
        List list2 = (List)this.parameters.invoke();
        if (list2 == null) {
            LazyClassDescriptor.$$$reportNull$$$0(31);
        }
        return list2;
    }

    @NotNull
    protected Collection<KotlinType> computeSupertypes() {
        if (KotlinBuiltIns.isSpecialClassWithNoSupertypes(this)) {
            List<KotlinType> list2 = Collections.emptyList();
            if (list2 == null) {
                LazyClassDescriptor.$$$reportNull$$$0(32);
            }
            return list2;
        }
        KtClassOrObject classOrObject = this.declarationProvider.getOwnerInfo().getCorrespondingClassOrObject();
        if (classOrObject == null) {
            Set<KotlinType> set = Collections.singleton(this.c.getModuleDescriptor().getBuiltIns().getAnyType());
            if (set == null) {
                LazyClassDescriptor.$$$reportNull$$$0(33);
            }
            return set;
        }
        List<KotlinType> allSupertypes = this.c.getDescriptorResolver().resolveSupertypes(this.getScopeForClassHeaderResolution(), this, classOrObject, this.c.getTrace());
        return new ArrayList<KotlinType>(CollectionsKt.filter(allSupertypes, VALID_SUPERTYPE));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLikeInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinTypeRefiner";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitializerScopeParent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopesHolderForClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsubstitutedMemberScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForClassHeaderResolution";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForConstructorHeaderResolution";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForCompanionObjectHeaderResolution";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForMemberDeclarationResolution";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForStaticMemberDeclarationResolution";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForInitializerResolution";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredCallableMembers";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticScope";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextReceivers";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeConstructor";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorsForExtraCompanionObjects";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getModality";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDanglingAnnotations";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSealedSubclasses";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredTypeParameters";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSupertypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIllegalInner";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createScopesHolderForClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUnsubstitutedMemberScope";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isRecursiveInlineClass";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class LazyClassTypeConstructor
    extends AbstractClassTypeConstructor {
        private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;

        public LazyClassTypeConstructor() {
            super(LazyClassDescriptor.this.c.getStorageManager());
            this.parameters = LazyClassDescriptor.this.c.getStorageManager().createLazyValue(() -> TypeParameterUtilsKt.computeConstructorTypeParameters(LazyClassDescriptor.this));
        }

        @Override
        @NotNull
        protected Collection<KotlinType> computeSupertypes() {
            Collection<KotlinType> collection = LazyClassDescriptor.this.computeSupertypes();
            if (collection == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(0);
            }
            return collection;
        }

        @Override
        protected void reportSupertypeLoopError(@NotNull KotlinType type2) {
            ClassifierDescriptor supertypeDescriptor;
            if (type2 == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(1);
            }
            if ((supertypeDescriptor = type2.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
                ClassDescriptor superclass = (ClassDescriptor)supertypeDescriptor;
                this.reportCyclicInheritanceHierarchyError(LazyClassDescriptor.this.c.getTrace(), LazyClassDescriptor.this, superclass);
            }
        }

        @Override
        protected boolean getShouldReportCyclicScopeWithCompanionWarning() {
            return !LazyClassDescriptor.this.c.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitVisibilityOfNestedClassifiersFromSupertypesOfCompanion);
        }

        @Override
        protected void reportScopesLoopError(@NotNull KotlinType type2) {
            PsiElement reportOn;
            if (type2 == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(2);
            }
            if ((reportOn = DescriptorToSourceUtils.getSourceFromDescriptor(type2.getConstructor().getDeclarationDescriptor())) instanceof KtClass) {
                reportOn = ((KtClass)reportOn).getNameIdentifier();
            }
            if (reportOn != null) {
                LazyClassDescriptor.this.c.getTrace().report(Errors.CYCLIC_SCOPES_WITH_COMPANION.on(reportOn));
            }
        }

        private void reportCyclicInheritanceHierarchyError(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor2, @NotNull ClassDescriptor superclass) {
            PsiNameIdentifierOwner namedElement;
            PsiElement nameIdentifier;
            if (trace == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(3);
            }
            if (classDescriptor2 == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(4);
            }
            if (superclass == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(5);
            }
            PsiElement psiElement = DescriptorToSourceUtils.getSourceFromDescriptor(classDescriptor2);
            PsiElement elementToMark = null;
            if (psiElement instanceof KtClassOrObject) {
                KtClassOrObject classOrObject = (KtClassOrObject)psiElement;
                for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
                    KotlinType supertype2;
                    KtTypeReference typeReference = delegationSpecifier.getTypeReference();
                    if (typeReference == null || (supertype2 = trace.get(BindingContext.TYPE, typeReference)) == null || supertype2.getConstructor() != superclass.getTypeConstructor()) continue;
                    elementToMark = typeReference;
                }
            }
            if (elementToMark == null && psiElement instanceof PsiNameIdentifierOwner && (nameIdentifier = (namedElement = (PsiNameIdentifierOwner)psiElement).getNameIdentifier()) != null) {
                elementToMark = nameIdentifier;
            }
            if (elementToMark != null) {
                trace.report(Errors.CYCLIC_INHERITANCE_HIERARCHY.on(elementToMark));
            }
        }

        @Override
        @NotNull
        protected SupertypeLoopChecker getSupertypeLoopChecker() {
            SupertypeLoopChecker supertypeLoopChecker = LazyClassDescriptor.this.c.getSupertypeLoopChecker();
            if (supertypeLoopChecker == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(6);
            }
            return supertypeLoopChecker;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List list2 = (List)this.parameters.invoke();
            if (list2 == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(7);
            }
            return list2;
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        @NotNull
        public ClassDescriptor getDeclarationDescriptor() {
            LazyClassDescriptor lazyClassDescriptor = LazyClassDescriptor.this;
            if (lazyClassDescriptor == null) {
                LazyClassTypeConstructor.$$$reportNull$$$0(8);
            }
            return lazyClassDescriptor;
        }

        public String toString() {
            return LazyClassDescriptor.this.getName().toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classDescriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superclass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeSupertypes";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupertypeLoopChecker";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameters";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeclarationDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reportSupertypeLoopError";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "reportScopesLoopError";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "reportCyclicInheritanceHierarchyError";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

