/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.component.internal;

import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConsumableConfiguration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.jvm.internal.DefaultJvmFeature;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.component.DefaultAdhocSoftwareComponent;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.component.internal.JvmSoftwareComponentInternal;

public class DefaultJvmSoftwareComponent
extends DefaultAdhocSoftwareComponent
implements JvmSoftwareComponentInternal {
    private static final String SOURCE_ELEMENTS_VARIANT_NAME_SUFFIX = "SourceElements";
    private final JvmFeatureInternal mainFeature;

    @Inject
    public DefaultJvmSoftwareComponent(String componentName, String sourceSetName, Project project, ObjectFactory objectFactory, ProviderFactory providerFactory, JvmPluginServices jvmPluginServices, Instantiator instantiator) {
        super(componentName, instantiator);
        RoleBasedConfigurationContainerInternal configurations = ((ProjectInternal)project).getConfigurations();
        PluginContainer plugins = project.getPlugins();
        ExtensionContainer extensions = project.getExtensions();
        JavaPluginExtension javaExtension = DefaultJvmSoftwareComponent.getJavaPluginExtension(extensions);
        SourceSet sourceSet = DefaultJvmSoftwareComponent.createSourceSet(sourceSetName, javaExtension.getSourceSets());
        this.mainFeature = new DefaultJvmFeature(sourceSetName, sourceSet, Collections.emptyList(), (ProjectInternal)project, false, false);
        this.createSourceElements(configurations, providerFactory, objectFactory, this.mainFeature, jvmPluginServices);
        ((DefaultArtifactPublicationSet)extensions.getByType(DefaultArtifactPublicationSet.class)).addCandidate((PublishArtifact)this.mainFeature.getRuntimeElementsConfiguration().getArtifacts().iterator().next());
        DefaultJvmSoftwareComponent.configurePublishing(plugins, extensions, sourceSet);
        this.addVariantsFromConfiguration(this.mainFeature.getApiElementsConfiguration(), (Action)new JavaConfigurationVariantMapping("compile", false));
        this.addVariantsFromConfiguration(this.mainFeature.getRuntimeElementsConfiguration(), (Action)new JavaConfigurationVariantMapping("runtime", false));
    }

    private static JavaPluginExtension getJavaPluginExtension(ExtensionContainer extensions) {
        JavaPluginExtension javaExtension = (JavaPluginExtension)extensions.findByType(JavaPluginExtension.class);
        if (javaExtension == null) {
            throw new GradleException("The java-base plugin must be applied in order to create instances of " + DefaultJvmSoftwareComponent.class.getSimpleName() + ".");
        }
        return javaExtension;
    }

    private static SourceSet createSourceSet(String name, SourceSetContainer sourceSets) {
        if (sourceSets.findByName(name) != null) {
            throw new GradleException("Cannot create multiple instances of " + DefaultJvmSoftwareComponent.class.getSimpleName() + " with source set name '" + name + "'.");
        }
        return (SourceSet)sourceSets.create(name);
    }

    private ConsumableConfiguration createSourceElements(RoleBasedConfigurationContainerInternal configurations, ProviderFactory providerFactory, ObjectFactory objectFactory, JvmFeatureInternal feature, JvmPluginServices jvmPluginServices) {
        String variantName = feature.getSourceSet().getName() + SOURCE_ELEMENTS_VARIANT_NAME_SUFFIX;
        ConsumableConfiguration variant = (ConsumableConfiguration)configurations.consumable(variantName).get();
        variant.setDescription("List of source directories contained in the Main SourceSet.");
        variant.setVisible(false);
        variant.extendsFrom(new Configuration[]{this.mainFeature.getImplementationConfiguration()});
        jvmPluginServices.configureAsSources((HasConfigurableAttributes)variant);
        variant.getOutgoing().artifacts(feature.getSourceSet().getAllSource().getSourceDirectories().getElements().flatMap(e -> providerFactory.provider(() -> e)), artifact -> artifact.setType("directory"));
        return variant;
    }

    private static void configurePublishing(PluginContainer plugins, ExtensionContainer extensions, SourceSet sourceSet) {
        plugins.withType(PublishingPlugin.class, plugin -> {
            PublishingExtension publishing = (PublishingExtension)extensions.getByType(PublishingExtension.class);
            publishing.getPublications().withType(IvyPublication.class, publication -> {
                VersionMappingStrategyInternal strategy = ((PublicationInternal)publication).getVersionMappingStrategy();
                strategy.defaultResolutionConfiguration("java-api", sourceSet.getCompileClasspathConfigurationName());
                strategy.defaultResolutionConfiguration("java-runtime", sourceSet.getRuntimeClasspathConfigurationName());
            });
            publishing.getPublications().withType(MavenPublication.class, publication -> {
                VersionMappingStrategyInternal strategy = ((PublicationInternal)publication).getVersionMappingStrategy();
                strategy.defaultResolutionConfiguration("java-api", sourceSet.getCompileClasspathConfigurationName());
                strategy.defaultResolutionConfiguration("java-runtime", sourceSet.getRuntimeClasspathConfigurationName());
            });
        });
    }

    @Override
    public void withJavadocJar() {
        this.mainFeature.withJavadocJar();
        Configuration javadocElements = this.mainFeature.getJavadocElementsConfiguration();
        if (!this.isRegisteredAsLegacyVariant(javadocElements)) {
            this.addVariantsFromConfiguration(javadocElements, (Action)new JavaConfigurationVariantMapping("runtime", true));
        }
    }

    @Override
    public void withSourcesJar() {
        this.mainFeature.withSourcesJar();
        Configuration sourcesElements = this.mainFeature.getSourcesElementsConfiguration();
        if (!this.isRegisteredAsLegacyVariant(sourcesElements)) {
            this.addVariantsFromConfiguration(sourcesElements, (Action)new JavaConfigurationVariantMapping("runtime", true));
        }
    }

    @Override
    public JvmFeatureInternal getMainFeature() {
        return this.mainFeature;
    }
}

