/* preferences-dialog.c generated by valac 0.56.17, the Vala compiler
 * generated from preferences-dialog.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "xfmpc.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <src/libc/mpdclient.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libxfce4ui/libxfce4ui.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	XFMPC_PREFERENCES_DIALOG_0_PROPERTY,
	XFMPC_PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* xfmpc_preferences_dialog_properties[XFMPC_PREFERENCES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

struct _XfmpcPreferencesDialogPrivate {
	XfmpcPreferences* preferences;
	GtkCheckButton* entry_use_defaults;
	GtkEntry* entry_host;
	GtkEntry* entry_passwd;
	GtkSpinButton* entry_port;
	GtkCheckButton* show_status_icon;
	GtkCheckButton* show_statusbar;
	GtkComboBoxText* combo_format;
	GtkEntry* entry_custom;
	guint format_timeout;
	GtkBox* mpd_vbox;
};

static gint XfmpcPreferencesDialog_private_offset;
static gpointer xfmpc_preferences_dialog_parent_class = NULL;

static void xfmpc_preferences_dialog_cb_response (XfmpcPreferencesDialog* self,
                                           gint response);
static void xfmpc_preferences_dialog_cb_use_defaults_toggled (XfmpcPreferencesDialog* self);
static void xfmpc_preferences_dialog_cb_update_mpd (XfmpcPreferencesDialog* self,
                                             GtkButton* source);
static void xfmpc_preferences_dialog_cb_show_status_icon_toggled (XfmpcPreferencesDialog* self);
static void xfmpc_preferences_dialog_cb_show_statusbar_toggled (XfmpcPreferencesDialog* self);
static void xfmpc_preferences_dialog_cb_combo_format_changed (XfmpcPreferencesDialog* self,
                                                       GtkComboBox* source);
static void xfmpc_preferences_dialog_cb_entry_custom_changed (XfmpcPreferencesDialog* self);
static gboolean xfmpc_preferences_dialog_timeout_format (XfmpcPreferencesDialog* self);
static gboolean _xfmpc_preferences_dialog_timeout_format_gsource_func (gpointer self);
static GObject * xfmpc_preferences_dialog_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _xfmpc_preferences_dialog_cb_use_defaults_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                  gpointer self);
static void _xfmpc_preferences_dialog_cb_update_mpd_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void _xfmpc_preferences_dialog_cb_show_status_icon_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                      gpointer self);
static void _xfmpc_preferences_dialog_cb_show_statusbar_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                    gpointer self);
static void _xfmpc_preferences_dialog_cb_combo_format_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                              gpointer self);
static void _xfmpc_preferences_dialog_cb_entry_custom_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                             gpointer self);
static void _xfmpc_preferences_dialog_cb_response_gtk_dialog_response (GtkDialog* _sender,
                                                                gint response_id,
                                                                gpointer self);
static void xfmpc_preferences_dialog_finalize (GObject * obj);
static GType xfmpc_preferences_dialog_get_type_once (void);

static inline gpointer
xfmpc_preferences_dialog_get_instance_private (XfmpcPreferencesDialog* self)
{
	return G_STRUCT_MEMBER_P (self, XfmpcPreferencesDialog_private_offset);
}

static void
xfmpc_preferences_dialog_cb_response (XfmpcPreferencesDialog* self,
                                      gint response)
{
	g_return_if_fail (self != NULL);
	switch (response) {
		case GTK_RESPONSE_CLOSE:
		{
			gtk_widget_destroy ((GtkWidget*) self);
			break;
		}
		default:
		break;
	}
}

static void
xfmpc_preferences_dialog_cb_use_defaults_toggled (XfmpcPreferencesDialog* self)
{
	GtkBox* _tmp0_;
	GtkCheckButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpd_vbox;
	_tmp1_ = self->priv->entry_use_defaults;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, !gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_));
}

static void
xfmpc_preferences_dialog_cb_update_mpd (XfmpcPreferencesDialog* self,
                                        GtkButton* source)
{
	XfmpcMpdclient* mpdclient = NULL;
	XfmpcMpdclient* _tmp0_;
	XfmpcPreferences* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	XfmpcPreferences* _tmp4_;
	GtkSpinButton* _tmp5_;
	XfmpcPreferences* _tmp6_;
	GtkEntry* _tmp7_;
	const gchar* _tmp8_;
	XfmpcPreferences* _tmp9_;
	GtkCheckButton* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = xfmpc_mpdclient_get_default ();
	mpdclient = _tmp0_;
	_tmp1_ = self->priv->preferences;
	_tmp2_ = self->priv->entry_host;
	_tmp3_ = gtk_entry_get_text (_tmp2_);
	xfmpc_preferences_set_mpd_hostname (_tmp1_, _tmp3_);
	_tmp4_ = self->priv->preferences;
	_tmp5_ = self->priv->entry_port;
	xfmpc_preferences_set_mpd_port (_tmp4_, gtk_spin_button_get_value_as_int (_tmp5_));
	_tmp6_ = self->priv->preferences;
	_tmp7_ = self->priv->entry_passwd;
	_tmp8_ = gtk_entry_get_text (_tmp7_);
	xfmpc_preferences_set_mpd_password (_tmp6_, _tmp8_);
	_tmp9_ = self->priv->preferences;
	_tmp10_ = self->priv->entry_use_defaults;
	xfmpc_preferences_set_mpd_use_defaults (_tmp9_, gtk_toggle_button_get_active ((GtkToggleButton*) _tmp10_));
	xfmpc_mpdclient_disconnect (mpdclient);
	xfmpc_mpdclient_connect (mpdclient);
}

static void
xfmpc_preferences_dialog_cb_show_status_icon_toggled (XfmpcPreferencesDialog* self)
{
	XfmpcPreferences* _tmp0_;
	GtkCheckButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences;
	_tmp1_ = self->priv->show_status_icon;
	xfmpc_preferences_set_show_status_icon (_tmp0_, gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_));
}

static void
xfmpc_preferences_dialog_cb_show_statusbar_toggled (XfmpcPreferencesDialog* self)
{
	XfmpcPreferences* _tmp0_;
	GtkCheckButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences;
	_tmp1_ = self->priv->show_statusbar;
	xfmpc_preferences_set_show_statusbar (_tmp0_, gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_));
}

static void
xfmpc_preferences_dialog_cb_combo_format_changed (XfmpcPreferencesDialog* self,
                                                  GtkComboBox* source)
{
	GtkComboBoxText* _tmp0_;
	GtkEntry* _tmp9_;
	GtkComboBoxText* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->combo_format;
	switch (gtk_combo_box_get_active ((GtkComboBox*) _tmp0_)) {
		case 0:
		{
			XfmpcPreferences* _tmp1_;
			_tmp1_ = self->priv->preferences;
			xfmpc_preferences_set_song_format (_tmp1_, XFMPC_PREFERENCES_SONG_FORMAT_TITLE);
			break;
		}
		case 1:
		{
			XfmpcPreferences* _tmp2_;
			_tmp2_ = self->priv->preferences;
			xfmpc_preferences_set_song_format (_tmp2_, XFMPC_PREFERENCES_SONG_FORMAT_ALBUM_TITLE);
			break;
		}
		case 2:
		{
			XfmpcPreferences* _tmp3_;
			_tmp3_ = self->priv->preferences;
			xfmpc_preferences_set_song_format (_tmp3_, XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_TITLE);
			break;
		}
		case 3:
		{
			XfmpcPreferences* _tmp4_;
			_tmp4_ = self->priv->preferences;
			xfmpc_preferences_set_song_format (_tmp4_, XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_TITLE_DATE);
			break;
		}
		case 4:
		{
			XfmpcPreferences* _tmp5_;
			_tmp5_ = self->priv->preferences;
			xfmpc_preferences_set_song_format (_tmp5_, XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_ALBUM_TITLE);
			break;
		}
		case 5:
		{
			XfmpcPreferences* _tmp6_;
			_tmp6_ = self->priv->preferences;
			xfmpc_preferences_set_song_format (_tmp6_, XFMPC_PREFERENCES_SONG_FORMAT_ARTIST_ALBUM_TRACK_TITLE);
			break;
		}
		case 6:
		{
			XfmpcPreferences* _tmp7_;
			_tmp7_ = self->priv->preferences;
			xfmpc_preferences_set_song_format (_tmp7_, XFMPC_PREFERENCES_SONG_FORMAT_CUSTOM_FORMAT);
			break;
		}
		default:
		{
			XfmpcPreferences* _tmp8_;
			_tmp8_ = self->priv->preferences;
			xfmpc_preferences_set_song_format (_tmp8_, XFMPC_PREFERENCES_SONG_FORMAT_TITLE);
			break;
		}
	}
	_tmp9_ = self->priv->entry_custom;
	_tmp10_ = self->priv->combo_format;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, gtk_combo_box_get_active ((GtkComboBox*) _tmp10_) == 6);
}

static gboolean
_xfmpc_preferences_dialog_timeout_format_gsource_func (gpointer self)
{
	gboolean result;
	result = xfmpc_preferences_dialog_timeout_format ((XfmpcPreferencesDialog*) self);
	return result;
}

static void
xfmpc_preferences_dialog_cb_entry_custom_changed (XfmpcPreferencesDialog* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->format_timeout > ((guint) 0)) {
		g_source_remove (self->priv->format_timeout);
	}
	self->priv->format_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _xfmpc_preferences_dialog_timeout_format_gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
xfmpc_preferences_dialog_timeout_format (XfmpcPreferencesDialog* self)
{
	gchar* custom_format = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	XfmpcPreferences* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->entry_custom;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	custom_format = _tmp2_;
	_tmp3_ = self->priv->preferences;
	xfmpc_preferences_set_song_format_custom (_tmp3_, custom_format);
	result = FALSE;
	_g_free0 (custom_format);
	return result;
}

XfmpcPreferencesDialog*
xfmpc_preferences_dialog_construct (GType object_type)
{
	XfmpcPreferencesDialog * self = NULL;
	self = (XfmpcPreferencesDialog*) g_object_new (object_type, NULL);
	return self;
}

XfmpcPreferencesDialog*
xfmpc_preferences_dialog_new (void)
{
	return xfmpc_preferences_dialog_construct (XFMPC_TYPE_PREFERENCES_DIALOG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_xfmpc_preferences_dialog_cb_use_defaults_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                             gpointer self)
{
	xfmpc_preferences_dialog_cb_use_defaults_toggled ((XfmpcPreferencesDialog*) self);
}

static void
_xfmpc_preferences_dialog_cb_update_mpd_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	xfmpc_preferences_dialog_cb_update_mpd ((XfmpcPreferencesDialog*) self, _sender);
}

static void
_xfmpc_preferences_dialog_cb_show_status_icon_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                 gpointer self)
{
	xfmpc_preferences_dialog_cb_show_status_icon_toggled ((XfmpcPreferencesDialog*) self);
}

static void
_xfmpc_preferences_dialog_cb_show_statusbar_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                               gpointer self)
{
	xfmpc_preferences_dialog_cb_show_statusbar_toggled ((XfmpcPreferencesDialog*) self);
}

static void
_xfmpc_preferences_dialog_cb_combo_format_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                         gpointer self)
{
	xfmpc_preferences_dialog_cb_combo_format_changed ((XfmpcPreferencesDialog*) self, _sender);
}

static void
_xfmpc_preferences_dialog_cb_entry_custom_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                        gpointer self)
{
	xfmpc_preferences_dialog_cb_entry_custom_changed ((XfmpcPreferencesDialog*) self);
}

static void
_xfmpc_preferences_dialog_cb_response_gtk_dialog_response (GtkDialog* _sender,
                                                           gint response_id,
                                                           gpointer self)
{
	xfmpc_preferences_dialog_cb_response ((XfmpcPreferencesDialog*) self, response_id);
}

static GObject *
xfmpc_preferences_dialog_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcPreferencesDialog * self;
	XfmpcPreferences* _tmp0_;
	GtkNotebook* notebook = NULL;
	GtkNotebook* _tmp1_;
	GtkNotebook* _tmp2_;
	GtkBox* _tmp3_;
	GtkNotebook* _tmp4_;
	GtkBox* vbox = NULL;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp7_;
	GtkNotebook* _tmp8_;
	GtkBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkBox* vbox2 = NULL;
	GtkBox* _tmp11_;
	GtkWidget* frame = NULL;
	GtkBox* _tmp12_;
	GtkWidget* _tmp13_;
	GtkWidget* _tmp14_;
	GtkWidget* _tmp15_;
	GtkBox* _tmp16_;
	GtkWidget* _tmp17_;
	GtkCheckButton* _tmp18_;
	GtkCheckButton* _tmp19_;
	GtkCheckButton* _tmp20_;
	XfmpcPreferences* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	GtkBox* _tmp24_;
	GtkCheckButton* _tmp25_;
	GtkBox* _tmp26_;
	GtkBox* _tmp27_;
	GtkBox* _tmp28_;
	GtkCheckButton* _tmp29_;
	GtkBox* _tmp30_;
	GtkCheckButton* _tmp31_;
	GtkBox* hbox = NULL;
	GtkBox* _tmp32_;
	GtkBox* _tmp33_;
	GtkBox* _tmp34_;
	GtkLabel* _tmp35_;
	GtkBox* _tmp36_;
	GtkLabel* _tmp37_;
	GtkEntry* _tmp38_;
	GtkEntry* _tmp39_;
	GtkEntry* _tmp40_;
	XfmpcPreferences* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	GtkBox* _tmp44_;
	GtkEntry* _tmp45_;
	GtkLabel* _tmp46_;
	GtkBox* _tmp47_;
	GtkLabel* _tmp48_;
	GtkSpinButton* _tmp49_;
	GtkSpinButton* _tmp50_;
	GtkSpinButton* _tmp51_;
	XfmpcPreferences* _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	GtkBox* _tmp55_;
	GtkSpinButton* _tmp56_;
	GtkBox* _tmp57_;
	GtkBox* _tmp58_;
	GtkBox* _tmp59_;
	GtkLabel* _tmp60_;
	GtkBox* _tmp61_;
	GtkLabel* _tmp62_;
	GtkEntry* _tmp63_;
	GtkEntry* _tmp64_;
	XfmpcPreferences* _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	GtkBox* _tmp72_;
	GtkEntry* _tmp73_;
	GtkButton* button = NULL;
	GtkButton* _tmp74_;
	GtkButton* _tmp75_;
	GtkBox* _tmp76_;
	GtkButton* _tmp77_;
	GtkBox* _tmp78_;
	GtkBox* _tmp79_;
	GtkLabel* _tmp80_;
	GtkNotebook* _tmp81_;
	GtkBox* _tmp82_;
	GtkLabel* _tmp83_;
	GtkBox* _tmp84_;
	GtkBox* _tmp85_;
	GtkWidget* _tmp86_;
	GtkWidget* _tmp87_;
	GtkWidget* _tmp88_;
	GtkBox* _tmp89_;
	GtkWidget* _tmp90_;
	GtkCheckButton* _tmp91_;
	GtkCheckButton* _tmp92_;
	XfmpcPreferences* _tmp93_;
	gboolean _tmp94_;
	gboolean _tmp95_;
	GtkCheckButton* _tmp96_;
	GtkBox* _tmp97_;
	GtkCheckButton* _tmp98_;
	GtkCheckButton* _tmp99_;
	GtkCheckButton* _tmp100_;
	XfmpcPreferences* _tmp101_;
	gboolean _tmp102_;
	gboolean _tmp103_;
	GtkCheckButton* _tmp104_;
	GtkBox* _tmp105_;
	GtkCheckButton* _tmp106_;
	GtkBox* _tmp107_;
	GtkBox* _tmp108_;
	GtkWidget* _tmp109_;
	GtkWidget* _tmp110_;
	GtkWidget* _tmp111_;
	GtkBox* _tmp112_;
	GtkWidget* _tmp113_;
	GtkBox* _tmp114_;
	GtkLabel* _tmp115_;
	GtkBox* _tmp116_;
	GtkLabel* _tmp117_;
	GtkComboBoxText* _tmp118_;
	GtkBox* _tmp119_;
	GtkComboBoxText* _tmp120_;
	GtkComboBoxText* _tmp121_;
	GtkComboBoxText* _tmp122_;
	GtkComboBoxText* _tmp123_;
	GtkComboBoxText* _tmp124_;
	GtkComboBoxText* _tmp125_;
	GtkComboBoxText* _tmp126_;
	GtkComboBoxText* _tmp127_;
	GtkComboBoxText* _tmp128_;
	XfmpcPreferences* _tmp129_;
	XfmpcPreferencesSongFormat _tmp130_;
	XfmpcPreferencesSongFormat _tmp131_;
	GtkBox* _tmp132_;
	GtkBox* _tmp133_;
	GtkBox* _tmp134_;
	GtkLabel* _tmp135_;
	GtkBox* _tmp136_;
	GtkLabel* _tmp137_;
	GtkEntry* _tmp138_;
	GtkEntry* _tmp139_;
	GtkEntry* _tmp140_;
	GtkEntry* _tmp141_;
	XfmpcPreferences* _tmp142_;
	const gchar* _tmp143_;
	const gchar* _tmp144_;
	GtkEntry* _tmp145_;
	GtkComboBoxText* _tmp146_;
	GtkBox* _tmp147_;
	GtkEntry* _tmp148_;
	GtkComboBoxText* _tmp149_;
	GtkEntry* _tmp150_;
	GtkBox* _tmp151_;
	GtkBox* _tmp152_;
	GtkLabel* _tmp153_;
	GtkBox* _tmp154_;
	GtkLabel* _tmp155_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp156_;
	GtkGrid* _tmp157_;
	GtkGrid* _tmp158_;
	GtkGrid* _tmp159_;
	PangoAttrList* attrs = NULL;
	PangoAttrList* _tmp160_;
	PangoAttrList* _tmp161_;
	PangoAttribute* _tmp162_;
	GtkLabel* _tmp163_;
	GtkLabel* _tmp164_;
	PangoAttrList* _tmp165_;
	GtkLabel* _tmp166_;
	GtkLabel* _tmp167_;
	GtkGrid* _tmp168_;
	GtkLabel* _tmp169_;
	GtkLabel* _tmp170_;
	GtkLabel* _tmp171_;
	PangoAttrList* _tmp172_;
	GtkLabel* _tmp173_;
	GtkLabel* _tmp174_;
	GtkGrid* _tmp175_;
	GtkLabel* _tmp176_;
	GtkLabel* _tmp177_;
	GtkLabel* _tmp178_;
	PangoAttrList* _tmp179_;
	GtkLabel* _tmp180_;
	GtkLabel* _tmp181_;
	GtkGrid* _tmp182_;
	GtkLabel* _tmp183_;
	GtkLabel* _tmp184_;
	GtkLabel* _tmp185_;
	PangoAttrList* _tmp186_;
	GtkLabel* _tmp187_;
	GtkLabel* _tmp188_;
	GtkGrid* _tmp189_;
	GtkLabel* _tmp190_;
	GtkLabel* _tmp191_;
	GtkLabel* _tmp192_;
	PangoAttrList* _tmp193_;
	GtkLabel* _tmp194_;
	GtkLabel* _tmp195_;
	GtkGrid* _tmp196_;
	GtkLabel* _tmp197_;
	GtkLabel* _tmp198_;
	GtkLabel* _tmp199_;
	PangoAttrList* _tmp200_;
	GtkLabel* _tmp201_;
	GtkLabel* _tmp202_;
	GtkGrid* _tmp203_;
	GtkLabel* _tmp204_;
	GtkLabel* _tmp205_;
	GtkLabel* _tmp206_;
	PangoAttrList* _tmp207_;
	GtkLabel* _tmp208_;
	GtkLabel* _tmp209_;
	GtkGrid* _tmp210_;
	GtkLabel* _tmp211_;
	GtkLabel* _tmp212_;
	GtkLabel* _tmp213_;
	PangoAttrList* _tmp214_;
	GtkLabel* _tmp215_;
	GtkLabel* _tmp216_;
	GtkGrid* _tmp217_;
	GtkLabel* _tmp218_;
	GtkBox* _tmp219_;
	GtkGrid* _tmp220_;
	GtkDialog* dialog = NULL;
	GtkDialog* _tmp221_;
	GtkDialog* _tmp222_;
	parent_class = G_OBJECT_CLASS (xfmpc_preferences_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_PREFERENCES_DIALOG, XfmpcPreferencesDialog);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_icon_name ((GtkWindow*) self, "multimedia-player");
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_window_set_title ((GtkWindow*) self, _ ("Xfmpc Preferences"));
	xfce_titled_dialog_set_subtitle ((XfceTitledDialog*) self, _ ("Customize your MPD client"));
	_tmp0_ = xfmpc_preferences_get_default ();
	self->priv->preferences = _tmp0_;
	_tmp1_ = (GtkNotebook*) gtk_notebook_new ();
	g_object_ref_sink (_tmp1_);
	notebook = _tmp1_;
	_tmp2_ = notebook;
	gtk_container_set_border_width ((GtkContainer*) _tmp2_, (guint) 6);
	_tmp3_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp4_ = notebook;
	gtk_box_pack_start (_tmp3_, (GtkWidget*) _tmp4_, TRUE, TRUE, (guint) 0);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp5_);
	vbox = _tmp5_;
	_tmp6_ = vbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp6_, (guint) 6);
	_tmp7_ = (GtkLabel*) gtk_label_new (_ ("MPD"));
	g_object_ref_sink (_tmp7_);
	label = _tmp7_;
	_tmp8_ = notebook;
	_tmp9_ = vbox;
	_tmp10_ = label;
	gtk_notebook_append_page (_tmp8_, (GtkWidget*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp11_);
	vbox2 = _tmp11_;
	_tmp12_ = vbox2;
	_tmp13_ = xfce_gtk_frame_box_new_with_content (_ ("Connection"), (GtkWidget*) _tmp12_);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	frame = _tmp14_;
	_tmp15_ = frame;
	g_object_ref_sink ((GObject*) _tmp15_);
	_tmp16_ = vbox;
	_tmp17_ = frame;
	gtk_box_pack_start (_tmp16_, _tmp17_, FALSE, FALSE, (guint) 0);
	_tmp18_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("Use _default system settings"));
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->entry_use_defaults);
	self->priv->entry_use_defaults = _tmp18_;
	_tmp19_ = self->priv->entry_use_defaults;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp19_, _ ("If checked, Xfmpc will try to read the environment variables MPD_HOST " \
"and MPD_PORT otherwise it will use localhost"));
	_tmp20_ = self->priv->entry_use_defaults;
	_tmp21_ = self->priv->preferences;
	_tmp22_ = xfmpc_preferences_get_mpd_use_defaults (_tmp21_);
	_tmp23_ = _tmp22_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp20_, _tmp23_);
	_tmp24_ = vbox2;
	_tmp25_ = self->priv->entry_use_defaults;
	gtk_box_pack_start (_tmp24_, (GtkWidget*) _tmp25_, FALSE, FALSE, (guint) 0);
	_tmp26_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->mpd_vbox);
	self->priv->mpd_vbox = _tmp26_;
	_tmp27_ = vbox2;
	_tmp28_ = self->priv->mpd_vbox;
	gtk_box_pack_start (_tmp27_, (GtkWidget*) _tmp28_, FALSE, FALSE, (guint) 0);
	_tmp29_ = self->priv->entry_use_defaults;
	g_signal_connect_object ((GtkToggleButton*) _tmp29_, "toggled", (GCallback) _xfmpc_preferences_dialog_cb_use_defaults_toggled_gtk_toggle_button_toggled, self, 0);
	_tmp30_ = self->priv->mpd_vbox;
	_tmp31_ = self->priv->entry_use_defaults;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp30_, !gtk_toggle_button_get_active ((GtkToggleButton*) _tmp31_));
	_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp32_);
	hbox = _tmp32_;
	_tmp33_ = self->priv->mpd_vbox;
	_tmp34_ = hbox;
	gtk_box_pack_start (_tmp33_, (GtkWidget*) _tmp34_, FALSE, FALSE, (guint) 0);
	_tmp35_ = (GtkLabel*) gtk_label_new (_ ("Hostname:"));
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (label);
	label = _tmp35_;
	_tmp36_ = hbox;
	_tmp37_ = label;
	gtk_box_pack_start (_tmp36_, (GtkWidget*) _tmp37_, FALSE, FALSE, (guint) 0);
	_tmp38_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->entry_host);
	self->priv->entry_host = _tmp38_;
	_tmp39_ = self->priv->entry_host;
	gtk_entry_set_width_chars (_tmp39_, 15);
	_tmp40_ = self->priv->entry_host;
	_tmp41_ = self->priv->preferences;
	_tmp42_ = xfmpc_preferences_get_mpd_hostname (_tmp41_);
	_tmp43_ = _tmp42_;
	gtk_entry_set_text (_tmp40_, _tmp43_);
	_tmp44_ = hbox;
	_tmp45_ = self->priv->entry_host;
	gtk_box_pack_start (_tmp44_, (GtkWidget*) _tmp45_, TRUE, TRUE, (guint) 0);
	_tmp46_ = (GtkLabel*) gtk_label_new (_ ("Port:"));
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (label);
	label = _tmp46_;
	_tmp47_ = hbox;
	_tmp48_ = label;
	gtk_box_pack_start (_tmp47_, (GtkWidget*) _tmp48_, FALSE, FALSE, (guint) 0);
	_tmp49_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) 65536, (gdouble) 1);
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->entry_port);
	self->priv->entry_port = _tmp49_;
	_tmp50_ = self->priv->entry_port;
	gtk_spin_button_set_digits (_tmp50_, (guint) 0);
	_tmp51_ = self->priv->entry_port;
	_tmp52_ = self->priv->preferences;
	_tmp53_ = xfmpc_preferences_get_mpd_port (_tmp52_);
	_tmp54_ = _tmp53_;
	gtk_spin_button_set_value (_tmp51_, (gdouble) _tmp54_);
	_tmp55_ = hbox;
	_tmp56_ = self->priv->entry_port;
	gtk_box_pack_start (_tmp55_, (GtkWidget*) _tmp56_, TRUE, TRUE, (guint) 0);
	_tmp57_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (hbox);
	hbox = _tmp57_;
	_tmp58_ = self->priv->mpd_vbox;
	_tmp59_ = hbox;
	gtk_box_pack_start (_tmp58_, (GtkWidget*) _tmp59_, FALSE, FALSE, (guint) 0);
	_tmp60_ = (GtkLabel*) gtk_label_new (_ ("Password:"));
	g_object_ref_sink (_tmp60_);
	_g_object_unref0 (label);
	label = _tmp60_;
	_tmp61_ = hbox;
	_tmp62_ = label;
	gtk_box_pack_start (_tmp61_, (GtkWidget*) _tmp62_, FALSE, FALSE, (guint) 0);
	_tmp63_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp63_);
	_g_object_unref0 (self->priv->entry_passwd);
	self->priv->entry_passwd = _tmp63_;
	_tmp64_ = self->priv->entry_passwd;
	gtk_entry_set_visibility (_tmp64_, FALSE);
	_tmp65_ = self->priv->preferences;
	_tmp66_ = xfmpc_preferences_get_mpd_password (_tmp65_);
	_tmp67_ = _tmp66_;
	if (_tmp67_ != NULL) {
		GtkEntry* _tmp68_;
		XfmpcPreferences* _tmp69_;
		const gchar* _tmp70_;
		const gchar* _tmp71_;
		_tmp68_ = self->priv->entry_passwd;
		_tmp69_ = self->priv->preferences;
		_tmp70_ = xfmpc_preferences_get_mpd_password (_tmp69_);
		_tmp71_ = _tmp70_;
		gtk_entry_set_text (_tmp68_, _tmp71_);
	}
	_tmp72_ = hbox;
	_tmp73_ = self->priv->entry_passwd;
	gtk_box_pack_start (_tmp72_, (GtkWidget*) _tmp73_, TRUE, TRUE, (guint) 0);
	_tmp74_ = (GtkButton*) gtk_button_new_with_label (_ ("Apply"));
	g_object_ref_sink (_tmp74_);
	button = _tmp74_;
	_tmp75_ = button;
	g_signal_connect_object (_tmp75_, "clicked", (GCallback) _xfmpc_preferences_dialog_cb_update_mpd_gtk_button_clicked, self, 0);
	_tmp76_ = vbox2;
	_tmp77_ = button;
	gtk_box_pack_start (_tmp76_, (GtkWidget*) _tmp77_, TRUE, TRUE, (guint) 0);
	_tmp78_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp78_);
	_g_object_unref0 (vbox);
	vbox = _tmp78_;
	_tmp79_ = vbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp79_, (guint) 6);
	_tmp80_ = (GtkLabel*) gtk_label_new (_ ("Appearance"));
	g_object_ref_sink (_tmp80_);
	_g_object_unref0 (label);
	label = _tmp80_;
	_tmp81_ = notebook;
	_tmp82_ = vbox;
	_tmp83_ = label;
	gtk_notebook_append_page (_tmp81_, (GtkWidget*) _tmp82_, (GtkWidget*) _tmp83_);
	_tmp84_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp84_);
	_g_object_unref0 (vbox2);
	vbox2 = _tmp84_;
	_tmp85_ = vbox2;
	_tmp86_ = xfce_gtk_frame_box_new_with_content (_ ("General"), (GtkWidget*) _tmp85_);
	_tmp87_ = _g_object_ref0 (_tmp86_);
	_g_object_unref0 (frame);
	frame = _tmp87_;
	_tmp88_ = frame;
	g_object_ref_sink ((GObject*) _tmp88_);
	_tmp89_ = vbox;
	_tmp90_ = frame;
	gtk_box_pack_start (_tmp89_, _tmp90_, FALSE, FALSE, (guint) 0);
	_tmp91_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("Close window into notification area"));
	g_object_ref_sink (_tmp91_);
	_g_object_unref0 (self->priv->show_status_icon);
	self->priv->show_status_icon = _tmp91_;
	_tmp92_ = self->priv->show_status_icon;
	_tmp93_ = self->priv->preferences;
	_tmp94_ = xfmpc_preferences_get_show_status_icon (_tmp93_);
	_tmp95_ = _tmp94_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp92_, _tmp95_);
	_tmp96_ = self->priv->show_status_icon;
	g_signal_connect_object ((GtkToggleButton*) _tmp96_, "toggled", (GCallback) _xfmpc_preferences_dialog_cb_show_status_icon_toggled_gtk_toggle_button_toggled, self, 0);
	_tmp97_ = vbox2;
	_tmp98_ = self->priv->show_status_icon;
	gtk_box_pack_start (_tmp97_, (GtkWidget*) _tmp98_, FALSE, FALSE, (guint) 0);
	_tmp99_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("Show _stastusbar"));
	g_object_ref_sink (_tmp99_);
	_g_object_unref0 (self->priv->show_statusbar);
	self->priv->show_statusbar = _tmp99_;
	_tmp100_ = self->priv->show_statusbar;
	_tmp101_ = self->priv->preferences;
	_tmp102_ = xfmpc_preferences_get_show_statusbar (_tmp101_);
	_tmp103_ = _tmp102_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp100_, _tmp103_);
	_tmp104_ = self->priv->show_statusbar;
	g_signal_connect_object ((GtkToggleButton*) _tmp104_, "toggled", (GCallback) _xfmpc_preferences_dialog_cb_show_statusbar_toggled_gtk_toggle_button_toggled, self, 0);
	_tmp105_ = vbox2;
	_tmp106_ = self->priv->show_statusbar;
	gtk_box_pack_start (_tmp105_, (GtkWidget*) _tmp106_, FALSE, FALSE, (guint) 0);
	_tmp107_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp107_);
	_g_object_unref0 (vbox2);
	vbox2 = _tmp107_;
	_tmp108_ = vbox2;
	_tmp109_ = xfce_gtk_frame_box_new_with_content (_ ("Song Format"), (GtkWidget*) _tmp108_);
	_tmp110_ = _g_object_ref0 (_tmp109_);
	_g_object_unref0 (frame);
	frame = _tmp110_;
	_tmp111_ = frame;
	g_object_ref_sink ((GObject*) _tmp111_);
	_tmp112_ = vbox;
	_tmp113_ = frame;
	gtk_box_pack_start (_tmp112_, _tmp113_, FALSE, FALSE, (guint) 0);
	_tmp114_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp114_);
	_g_object_unref0 (hbox);
	hbox = _tmp114_;
	_tmp115_ = (GtkLabel*) gtk_label_new (_ ("Song Format:"));
	g_object_ref_sink (_tmp115_);
	_g_object_unref0 (label);
	label = _tmp115_;
	_tmp116_ = hbox;
	_tmp117_ = label;
	gtk_box_pack_start (_tmp116_, (GtkWidget*) _tmp117_, FALSE, FALSE, (guint) 0);
	_tmp118_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp118_);
	_g_object_unref0 (self->priv->combo_format);
	self->priv->combo_format = _tmp118_;
	_tmp119_ = hbox;
	_tmp120_ = self->priv->combo_format;
	gtk_box_pack_start (_tmp119_, (GtkWidget*) _tmp120_, TRUE, TRUE, (guint) 0);
	_tmp121_ = self->priv->combo_format;
	gtk_combo_box_text_append (_tmp121_, NULL, _ ("Title"));
	_tmp122_ = self->priv->combo_format;
	gtk_combo_box_text_append (_tmp122_, NULL, _ ("Album - Title"));
	_tmp123_ = self->priv->combo_format;
	gtk_combo_box_text_append (_tmp123_, NULL, _ ("Artist - Title"));
	_tmp124_ = self->priv->combo_format;
	gtk_combo_box_text_append (_tmp124_, NULL, _ ("Artist - Title (Date)"));
	_tmp125_ = self->priv->combo_format;
	gtk_combo_box_text_append (_tmp125_, NULL, _ ("Artist - Album - Title"));
	_tmp126_ = self->priv->combo_format;
	gtk_combo_box_text_append (_tmp126_, NULL, _ ("Artist - Album - Track. Title"));
	_tmp127_ = self->priv->combo_format;
	gtk_combo_box_text_append (_tmp127_, NULL, _ ("Custom..."));
	_tmp128_ = self->priv->combo_format;
	_tmp129_ = self->priv->preferences;
	_tmp130_ = xfmpc_preferences_get_song_format (_tmp129_);
	_tmp131_ = _tmp130_;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp128_, (gint) _tmp131_);
	_tmp132_ = vbox2;
	_tmp133_ = hbox;
	gtk_box_pack_start (_tmp132_, (GtkWidget*) _tmp133_, TRUE, TRUE, (guint) 0);
	_tmp134_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp134_);
	_g_object_unref0 (hbox);
	hbox = _tmp134_;
	_tmp135_ = (GtkLabel*) gtk_label_new (_ ("Custom format:"));
	g_object_ref_sink (_tmp135_);
	_g_object_unref0 (label);
	label = _tmp135_;
	_tmp136_ = hbox;
	_tmp137_ = label;
	gtk_box_pack_start (_tmp136_, (GtkWidget*) _tmp137_, FALSE, FALSE, (guint) 0);
	_tmp138_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp138_);
	_g_object_unref0 (self->priv->entry_custom);
	self->priv->entry_custom = _tmp138_;
	_tmp139_ = self->priv->entry_custom;
	gtk_entry_set_width_chars (_tmp139_, 15);
	_tmp140_ = self->priv->entry_custom;
	gtk_entry_set_max_length (_tmp140_, 30);
	_tmp141_ = self->priv->entry_custom;
	_tmp142_ = self->priv->preferences;
	_tmp143_ = xfmpc_preferences_get_song_format_custom (_tmp142_);
	_tmp144_ = _tmp143_;
	gtk_entry_set_text (_tmp141_, _tmp144_);
	_tmp145_ = self->priv->entry_custom;
	_tmp146_ = self->priv->combo_format;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp145_, gtk_combo_box_get_active ((GtkComboBox*) _tmp146_) == 6);
	_tmp147_ = hbox;
	_tmp148_ = self->priv->entry_custom;
	gtk_box_pack_start (_tmp147_, (GtkWidget*) _tmp148_, TRUE, TRUE, (guint) 0);
	_tmp149_ = self->priv->combo_format;
	g_signal_connect_object ((GtkComboBox*) _tmp149_, "changed", (GCallback) _xfmpc_preferences_dialog_cb_combo_format_changed_gtk_combo_box_changed, self, 0);
	_tmp150_ = self->priv->entry_custom;
	g_signal_connect_object ((GtkEditable*) _tmp150_, "changed", (GCallback) _xfmpc_preferences_dialog_cb_entry_custom_changed_gtk_editable_changed, self, 0);
	_tmp151_ = vbox2;
	_tmp152_ = hbox;
	gtk_box_pack_start (_tmp151_, (GtkWidget*) _tmp152_, TRUE, TRUE, (guint) 0);
	_tmp153_ = (GtkLabel*) gtk_label_new (_ ("Available parameters:"));
	g_object_ref_sink (_tmp153_);
	_g_object_unref0 (label);
	label = _tmp153_;
	_tmp154_ = vbox2;
	_tmp155_ = label;
	gtk_box_pack_start (_tmp154_, (GtkWidget*) _tmp155_, TRUE, TRUE, (guint) 0);
	_tmp156_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp156_);
	grid = _tmp156_;
	_tmp157_ = grid;
	gtk_grid_set_column_spacing (_tmp157_, (guint) 6);
	_tmp158_ = grid;
	gtk_grid_set_row_spacing (_tmp158_, (guint) 6);
	_tmp159_ = grid;
	gtk_grid_set_column_homogeneous (_tmp159_, TRUE);
	_tmp160_ = pango_attr_list_new ();
	attrs = _tmp160_;
	_tmp161_ = attrs;
	_tmp162_ = pango_attr_scale_new ((gdouble) PANGO_SCALE_SMALL);
	pango_attr_list_insert (_tmp161_, _tmp162_);
	_tmp163_ = (GtkLabel*) gtk_label_new (_ ("%a: Artist"));
	g_object_ref_sink (_tmp163_);
	_g_object_unref0 (label);
	label = _tmp163_;
	_tmp164_ = label;
	_tmp165_ = attrs;
	gtk_label_set_attributes (_tmp164_, _tmp165_);
	_tmp166_ = label;
	gtk_label_set_xalign (_tmp166_, 0.0f);
	_tmp167_ = label;
	gtk_label_set_yalign (_tmp167_, 0.5f);
	_tmp168_ = grid;
	_tmp169_ = label;
	gtk_grid_attach (_tmp168_, (GtkWidget*) _tmp169_, 1, 0, 1, 1);
	_tmp170_ = (GtkLabel*) gtk_label_new (_ ("%A: Album"));
	g_object_ref_sink (_tmp170_);
	_g_object_unref0 (label);
	label = _tmp170_;
	_tmp171_ = label;
	_tmp172_ = attrs;
	gtk_label_set_attributes (_tmp171_, _tmp172_);
	_tmp173_ = label;
	gtk_label_set_xalign (_tmp173_, 0.0f);
	_tmp174_ = label;
	gtk_label_set_yalign (_tmp174_, 0.5f);
	_tmp175_ = grid;
	_tmp176_ = label;
	gtk_grid_attach (_tmp175_, (GtkWidget*) _tmp176_, 1, 1, 1, 1);
	_tmp177_ = (GtkLabel*) gtk_label_new (_ ("%t: Title"));
	g_object_ref_sink (_tmp177_);
	_g_object_unref0 (label);
	label = _tmp177_;
	_tmp178_ = label;
	_tmp179_ = attrs;
	gtk_label_set_attributes (_tmp178_, _tmp179_);
	_tmp180_ = label;
	gtk_label_set_xalign (_tmp180_, 0.0f);
	_tmp181_ = label;
	gtk_label_set_yalign (_tmp181_, 0.5f);
	_tmp182_ = grid;
	_tmp183_ = label;
	gtk_grid_attach (_tmp182_, (GtkWidget*) _tmp183_, 2, 0, 1, 1);
	_tmp184_ = (GtkLabel*) gtk_label_new (_ ("%D: Disc"));
	g_object_ref_sink (_tmp184_);
	_g_object_unref0 (label);
	label = _tmp184_;
	_tmp185_ = label;
	_tmp186_ = attrs;
	gtk_label_set_attributes (_tmp185_, _tmp186_);
	_tmp187_ = label;
	gtk_label_set_xalign (_tmp187_, 0.0f);
	_tmp188_ = label;
	gtk_label_set_yalign (_tmp188_, 0.5f);
	_tmp189_ = grid;
	_tmp190_ = label;
	gtk_grid_attach (_tmp189_, (GtkWidget*) _tmp190_, 2, 1, 1, 1);
	_tmp191_ = (GtkLabel*) gtk_label_new (_ ("%f: File"));
	g_object_ref_sink (_tmp191_);
	_g_object_unref0 (label);
	label = _tmp191_;
	_tmp192_ = label;
	_tmp193_ = attrs;
	gtk_label_set_attributes (_tmp192_, _tmp193_);
	_tmp194_ = label;
	gtk_label_set_xalign (_tmp194_, 0.0f);
	_tmp195_ = label;
	gtk_label_set_yalign (_tmp195_, 0.5f);
	_tmp196_ = grid;
	_tmp197_ = label;
	gtk_grid_attach (_tmp196_, (GtkWidget*) _tmp197_, 3, 0, 1, 1);
	_tmp198_ = (GtkLabel*) gtk_label_new (_ ("%g: Genre"));
	g_object_ref_sink (_tmp198_);
	_g_object_unref0 (label);
	label = _tmp198_;
	_tmp199_ = label;
	_tmp200_ = attrs;
	gtk_label_set_attributes (_tmp199_, _tmp200_);
	_tmp201_ = label;
	gtk_label_set_xalign (_tmp201_, 0.0f);
	_tmp202_ = label;
	gtk_label_set_yalign (_tmp202_, 0.5f);
	_tmp203_ = grid;
	_tmp204_ = label;
	gtk_grid_attach (_tmp203_, (GtkWidget*) _tmp204_, 3, 1, 1, 1);
	_tmp205_ = (GtkLabel*) gtk_label_new (_ ("%d: Date"));
	g_object_ref_sink (_tmp205_);
	_g_object_unref0 (label);
	label = _tmp205_;
	_tmp206_ = label;
	_tmp207_ = attrs;
	gtk_label_set_attributes (_tmp206_, _tmp207_);
	_tmp208_ = label;
	gtk_label_set_xalign (_tmp208_, 0.0f);
	_tmp209_ = label;
	gtk_label_set_yalign (_tmp209_, 0.5f);
	_tmp210_ = grid;
	_tmp211_ = label;
	gtk_grid_attach (_tmp210_, (GtkWidget*) _tmp211_, 4, 0, 1, 1);
	_tmp212_ = (GtkLabel*) gtk_label_new (_ ("%T: Track"));
	g_object_ref_sink (_tmp212_);
	_g_object_unref0 (label);
	label = _tmp212_;
	_tmp213_ = label;
	_tmp214_ = attrs;
	gtk_label_set_attributes (_tmp213_, _tmp214_);
	_tmp215_ = label;
	gtk_label_set_xalign (_tmp215_, 0.0f);
	_tmp216_ = label;
	gtk_label_set_yalign (_tmp216_, 0.5f);
	_tmp217_ = grid;
	_tmp218_ = label;
	gtk_grid_attach (_tmp217_, (GtkWidget*) _tmp218_, 4, 1, 1, 1);
	_tmp219_ = vbox2;
	_tmp220_ = grid;
	gtk_box_pack_start (_tmp219_, (GtkWidget*) _tmp220_, TRUE, TRUE, (guint) 0);
	_tmp221_ = _g_object_ref0 ((GtkDialog*) self);
	dialog = _tmp221_;
	_tmp222_ = dialog;
	gtk_dialog_add_button (_tmp222_, _ ("Close"), (gint) GTK_RESPONSE_CLOSE);
	gtk_widget_show_all ((GtkWidget*) self);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _xfmpc_preferences_dialog_cb_response_gtk_dialog_response, self, 0);
	_g_object_unref0 (dialog);
	_pango_attr_list_unref0 (attrs);
	_g_object_unref0 (grid);
	_g_object_unref0 (button);
	_g_object_unref0 (hbox);
	_g_object_unref0 (frame);
	_g_object_unref0 (vbox2);
	_g_object_unref0 (label);
	_g_object_unref0 (vbox);
	_g_object_unref0 (notebook);
	return obj;
}

static void
xfmpc_preferences_dialog_class_init (XfmpcPreferencesDialogClass * klass,
                                     gpointer klass_data)
{
	xfmpc_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XfmpcPreferencesDialog_private_offset);
	G_OBJECT_CLASS (klass)->constructor = xfmpc_preferences_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_preferences_dialog_finalize;
}

static void
xfmpc_preferences_dialog_instance_init (XfmpcPreferencesDialog * self,
                                        gpointer klass)
{
	self->priv = xfmpc_preferences_dialog_get_instance_private (self);
}

static void
xfmpc_preferences_dialog_finalize (GObject * obj)
{
	XfmpcPreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_PREFERENCES_DIALOG, XfmpcPreferencesDialog);
	_g_object_unref0 (self->priv->entry_use_defaults);
	_g_object_unref0 (self->priv->entry_host);
	_g_object_unref0 (self->priv->entry_passwd);
	_g_object_unref0 (self->priv->entry_port);
	_g_object_unref0 (self->priv->show_status_icon);
	_g_object_unref0 (self->priv->show_statusbar);
	_g_object_unref0 (self->priv->combo_format);
	_g_object_unref0 (self->priv->entry_custom);
	_g_object_unref0 (self->priv->mpd_vbox);
	G_OBJECT_CLASS (xfmpc_preferences_dialog_parent_class)->finalize (obj);
}

static GType
xfmpc_preferences_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XfmpcPreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcPreferencesDialog), 0, (GInstanceInitFunc) xfmpc_preferences_dialog_instance_init, NULL };
	GType xfmpc_preferences_dialog_type_id;
	xfmpc_preferences_dialog_type_id = g_type_register_static (xfce_titled_dialog_get_type (), "XfmpcPreferencesDialog", &g_define_type_info, 0);
	XfmpcPreferencesDialog_private_offset = g_type_add_instance_private (xfmpc_preferences_dialog_type_id, sizeof (XfmpcPreferencesDialogPrivate));
	return xfmpc_preferences_dialog_type_id;
}

GType
xfmpc_preferences_dialog_get_type (void)
{
	static volatile gsize xfmpc_preferences_dialog_type_id__once = 0;
	if (g_once_init_enter (&xfmpc_preferences_dialog_type_id__once)) {
		GType xfmpc_preferences_dialog_type_id;
		xfmpc_preferences_dialog_type_id = xfmpc_preferences_dialog_get_type_once ();
		g_once_init_leave (&xfmpc_preferences_dialog_type_id__once, xfmpc_preferences_dialog_type_id);
	}
	return xfmpc_preferences_dialog_type_id__once;
}

