/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "GenWindow_Base.h"
#include "GenWindow.h"
#include "Globals.h"
#include "Enums.h"

GenWindow_Base::GenWindow_Base(int ix, int iy, int iParentID, int flags):
activate(true), closed(false), parentID(iParentID), borderColor(gold),
transparent(0), bStatic(flags & WFLAG_STATIC), cantClose(flags & WFLAG_CANTCLOSE), 
visible(!(flags & WFLAG_INVISIBLE)) {
	myID = ++windowIDs;
	
	if (flags & WFLAG_TILED) {
		rect.x = globalSettings.screenWidth;
		rect.y = globalSettings.screenHeight;
	} else {
		rect.x = ix;
		rect.y = iy;
	}

	for (list<GenWindow>::iterator iter = myWindows.begin(); iter != myWindows.end(); ++iter)
		iter->WinMessage(WC_ImActive, 0, 0, all_constant, myID);
}

GenWindow_Base::~GenWindow_Base() {
	MessageWindows(WC_ImClosing, 0, 0, all_constant, myID);
}

void GenWindow_Base::InitBorder() {
	borderRect.x = rect.x - smallBorderSize;
	borderRect.y = rect.y - smallBorderSize;
	borderRect.w = rect.w + (smallBorderSize << 1);
	borderRect.h = rect.h + (smallBorderSize << 1);
}

bool GenWindow_Base::MouseD(Uint8 button, Uint16 x, Uint16 y) {
	//cursor inside window?

	if (x >= rect.x
	        && x < rect.x + rect.w
	        && y >= rect.y
	        && y < rect.y + rect.h) {
		if (button) {
			activate = true;
			MessageWindows(WC_ImActive, 0, 0, all_constant, myID);
		}

		return true;
	}

	return false;
}

void GenWindow_Base::Move(int distx, int disty) {
	rect.x+= distx;
	rect.y+= disty;

	borderRect.x+= distx;
	borderRect.y+= disty;

	MessageWindows(WC_ImMoving, distx, disty, all_constant, myID);
}

void GenWindow_Base::DrawSelf() {
	if (!transparent) {
		JSDL.BltFill(borderRect, borderColor);
		JSDL.BltFill(rect, veryDarkGreen);
	}
}

void GenWindow_Base::WinMessage(WindowChoice theMessage, int paremOne, int paremTwo, int targetID, int sourceID) {
	if (targetID == all_constant || targetID == myID) {
		switch (theMessage) {
		case WC_ImActive:
			if (sourceID == parentID) {
				activate = 1;
				MessageWindows(WC_ImActive, 0, 0, all_constant, myID);
			}
			break;

		case WC_ImClosing:
			if (sourceID == parentID) {
				closed = true;
				MessageWindows(WC_ImClosing, 0, 0, all_constant, myID);
			}
			break;

		case WC_ImMoving:
			if (sourceID == parentID) {
				Move(paremOne, paremTwo);
				MessageWindows(WC_ImMoving, 0, 0, all_constant, myID);
			}
			break;

		case WC_ExpensiveUpdate:
			ExpensiveUpdate();
			break;

		case WC_YouClose:
			closed = true;
			MessageWindows(WC_ImClosing, 0, 0, all_constant, myID);
			break;
		}
	}
}

void GenWindow_Base::GroupNumChange(int nGroup, int howMany, int& myGroup) {
	if (nGroup == myGroup && howMany < 0)
		closed = true;

	//add or minus
	else if (myGroup >= nGroup)
		myGroup+= howMany;
}

void GenWindow_Base::CentreWindow() {
	rect.x = (globalSettings.screenWidth - rect.w) / 2;
	rect.y = (globalSettings.screenHeight - rect.h) / 2;

	InitBorder();
}

