/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.stream.IntStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jrm.locale.Messages;
import jrm.misc.BreakException;
import jrm.misc.Log;
import jrm.misc.Settings;
import jrm.profile.data.Device;
import jrm.profile.data.Disk;
import jrm.profile.data.Entity;
import jrm.profile.data.Machine;
import jrm.profile.data.MachineList;
import jrm.profile.data.MachineListList;
import jrm.profile.data.Rom;
import jrm.profile.data.Sample;
import jrm.profile.data.Samples;
import jrm.profile.data.Slot;
import jrm.profile.data.SlotOption;
import jrm.profile.data.Software;
import jrm.profile.data.SoftwareList;
import jrm.profile.data.SystmDevice;
import jrm.profile.data.SystmMechanical;
import jrm.profile.data.SystmStandard;
import jrm.profile.data.Systms;
import jrm.profile.filter.CatVer;
import jrm.profile.filter.NPlayers;
import jrm.profile.manager.ProfileNFO;
import jrm.ui.progress.ProgressHandler;
import org.apache.commons.lang3.BooleanUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Profile
implements Serializable {
    public long machines_cnt = 0L;
    public long softwares_list_cnt = 0L;
    public long softwares_cnt = 0L;
    public long roms_cnt = 0L;
    public long swroms_cnt = 0L;
    public long disks_cnt = 0L;
    public long swdisks_cnt = 0L;
    public long samples_cnt = 0L;
    public boolean md5_roms = false;
    public boolean md5_disks = false;
    public boolean sha1_roms = false;
    public boolean sha1_disks = false;
    public String build = null;
    public final HashMap<String, StringBuffer> header = new HashMap();
    public final MachineListList machinelist_list = new MachineListList();
    public final HashSet<String> suspicious_crc = new HashSet();
    public transient Properties settings = null;
    public transient Systms systems = null;
    public transient Collection<String> years = null;
    public transient ProfileNFO nfo = null;
    public transient CatVer catver = null;
    public transient NPlayers nplayers = null;
    public static transient Profile curr_profile;
    private int props_hashcode = 0;

    private Profile() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _load(File file, final ProgressHandler handler) {
        handler.setProgress(String.format(Messages.getString("Profile.Parsing"), file), -1);
        try (InputStream in = handler.getInputStream(new FileInputStream(file), (int)file.length());){
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(in, new DefaultHandler(){
                private final HashMap<String, Rom> roms_bycrc = new HashMap();
                private boolean in_description = false;
                private boolean in_year = false;
                private boolean in_manufacturer = false;
                private boolean in_publisher = false;
                private boolean in_header = false;
                private boolean in_cabinet_dipsw = false;
                private final EnumSet<Machine.CabinetType> cabtype_set = EnumSet.noneOf(Machine.CabinetType.class);
                private SoftwareList curr_software_list = null;
                private Software curr_software = null;
                private Software.Part curr_part = null;
                private Software.Part.DataArea curr_dataarea = null;
                private Software.Part.DiskArea curr_diskarea = null;
                private Machine curr_machine = null;
                private Device curr_device = null;
                private Samples curr_sampleset = null;
                private Rom curr_rom = null;
                private Disk curr_disk = null;
                private Slot curr_slot = null;
                private final HashSet<String> roms = new HashSet();
                private final HashSet<String> disks = new HashSet();
                private String curr_tag;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    block269: {
                        block295: {
                            block294: {
                                block293: {
                                    block292: {
                                        block291: {
                                            block290: {
                                                block289: {
                                                    block288: {
                                                        block287: {
                                                            block286: {
                                                                block285: {
                                                                    block284: {
                                                                        block283: {
                                                                            block282: {
                                                                                block281: {
                                                                                    block280: {
                                                                                        block279: {
                                                                                            block278: {
                                                                                                block277: {
                                                                                                    block276: {
                                                                                                        block275: {
                                                                                                            block274: {
                                                                                                                block273: {
                                                                                                                    block272: {
                                                                                                                        block271: {
                                                                                                                            block270: {
                                                                                                                                block268: {
                                                                                                                                    this.curr_tag = qName;
                                                                                                                                    if (!qName.equals("mame") && !qName.equals("datafile")) break block268;
                                                                                                                                    for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                                                                        switch (attributes.getQName(i)) {
                                                                                                                                            case "build": {
                                                                                                                                                Profile.this.build = attributes.getValue(i);
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    break block269;
                                                                                                                                }
                                                                                                                                if (!qName.equals("header")) break block270;
                                                                                                                                this.in_header = true;
                                                                                                                                break block269;
                                                                                                                            }
                                                                                                                            if (!qName.equals("softwarelist") || this.curr_machine != null) break block271;
                                                                                                                            this.curr_software_list = new SoftwareList();
                                                                                                                            block237: for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                                                                switch (attributes.getQName(i)) {
                                                                                                                                    case "name": {
                                                                                                                                        this.curr_software_list.setName(attributes.getValue(i).trim());
                                                                                                                                        Profile.this.machinelist_list.softwarelist_list.putByName(this.curr_software_list);
                                                                                                                                        continue block237;
                                                                                                                                    }
                                                                                                                                    case "description": {
                                                                                                                                        this.curr_software_list.description.append(attributes.getValue(i).trim());
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                            break block269;
                                                                                                                        }
                                                                                                                        if (!qName.equals("softwarelist")) break block272;
                                                                                                                        Machine.SWList swlist = this.curr_machine.new Machine.SWList();
                                                                                                                        block238: for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                                                            switch (attributes.getQName(i)) {
                                                                                                                                case "name": {
                                                                                                                                    swlist.name = attributes.getValue(i);
                                                                                                                                    continue block238;
                                                                                                                                }
                                                                                                                                case "status": {
                                                                                                                                    swlist.status = Machine.SWStatus.valueOf(attributes.getValue(i));
                                                                                                                                    continue block238;
                                                                                                                                }
                                                                                                                                case "filter": {
                                                                                                                                    swlist.filter = attributes.getValue(i);
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                        this.curr_machine.swlists.put(swlist.name, swlist);
                                                                                                                        if (!Profile.this.machinelist_list.softwarelist_defs.containsKey(swlist.name)) {
                                                                                                                            Profile.this.machinelist_list.softwarelist_defs.put(swlist.name, new ArrayList());
                                                                                                                        }
                                                                                                                        Profile.this.machinelist_list.softwarelist_defs.get(swlist.name).add(this.curr_machine);
                                                                                                                        break block269;
                                                                                                                    }
                                                                                                                    if (!qName.equals("software")) break block273;
                                                                                                                    this.curr_software = new Software();
                                                                                                                    block239: for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                                                        switch (attributes.getQName(i)) {
                                                                                                                            case "name": {
                                                                                                                                this.curr_software.setName(attributes.getValue(i).trim());
                                                                                                                                continue block239;
                                                                                                                            }
                                                                                                                            case "cloneof": {
                                                                                                                                this.curr_software.cloneof = attributes.getValue(i);
                                                                                                                                continue block239;
                                                                                                                            }
                                                                                                                            case "supported": {
                                                                                                                                this.curr_software.supported = Software.Supported.valueOf(attributes.getValue(i));
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                    break block269;
                                                                                                                }
                                                                                                                if (!qName.equals("feature") || this.curr_software == null) break block274;
                                                                                                                if (!attributes.getValue("name").equalsIgnoreCase("compatibility")) break block269;
                                                                                                                this.curr_software.compatibility = attributes.getValue("value");
                                                                                                                break block269;
                                                                                                            }
                                                                                                            if (!qName.equals("part") || this.curr_software == null) break block275;
                                                                                                            this.curr_part = new Software.Part();
                                                                                                            this.curr_software.parts.add(this.curr_part);
                                                                                                            block240: for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                                                switch (attributes.getQName(i)) {
                                                                                                                    case "name": {
                                                                                                                        this.curr_part.name = attributes.getValue(i).trim();
                                                                                                                        continue block240;
                                                                                                                    }
                                                                                                                    case "interface": {
                                                                                                                        this.curr_part.intrface = attributes.getValue(i).trim();
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                            break block269;
                                                                                                        }
                                                                                                        if (!qName.equals("dataarea") || this.curr_software == null || this.curr_part == null) break block276;
                                                                                                        this.curr_dataarea = new Software.Part.DataArea();
                                                                                                        this.curr_part.dataareas.add(this.curr_dataarea);
                                                                                                        block241: for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                                            switch (attributes.getQName(i)) {
                                                                                                                case "name": {
                                                                                                                    this.curr_dataarea.name = attributes.getValue(i).trim();
                                                                                                                    continue block241;
                                                                                                                }
                                                                                                                case "size": {
                                                                                                                    this.curr_dataarea.size = Integer.valueOf(attributes.getValue(i));
                                                                                                                    continue block241;
                                                                                                                }
                                                                                                                case "width": 
                                                                                                                case "databits": {
                                                                                                                    this.curr_dataarea.databits = Integer.valueOf(attributes.getValue(i));
                                                                                                                    continue block241;
                                                                                                                }
                                                                                                                case "endianness": 
                                                                                                                case "endian": {
                                                                                                                    this.curr_dataarea.endianness = Software.Part.DataArea.Endianness.valueOf(attributes.getValue(i));
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                        break block269;
                                                                                                    }
                                                                                                    if (!qName.equals("diskarea") || this.curr_software == null || this.curr_part == null) break block277;
                                                                                                    this.curr_diskarea = new Software.Part.DiskArea();
                                                                                                    this.curr_part.diskareas.add(this.curr_diskarea);
                                                                                                    for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                                        switch (attributes.getQName(i)) {
                                                                                                            case "name": {
                                                                                                                this.curr_diskarea.name = attributes.getValue(i).trim();
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                    break block269;
                                                                                                }
                                                                                                if (!qName.equals("machine") && !qName.equals("game")) break block278;
                                                                                                this.curr_machine = new Machine();
                                                                                                block243: for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                                    switch (attributes.getQName(i)) {
                                                                                                        case "name": {
                                                                                                            this.curr_machine.setName(attributes.getValue(i).trim());
                                                                                                            ((MachineList)Profile.this.machinelist_list.get(0)).putByName(this.curr_machine);
                                                                                                            continue block243;
                                                                                                        }
                                                                                                        case "romof": {
                                                                                                            this.curr_machine.romof = attributes.getValue(i).trim();
                                                                                                            continue block243;
                                                                                                        }
                                                                                                        case "cloneof": {
                                                                                                            this.curr_machine.cloneof = attributes.getValue(i).trim();
                                                                                                            continue block243;
                                                                                                        }
                                                                                                        case "sampleof": {
                                                                                                            this.curr_machine.sampleof = attributes.getValue(i).trim();
                                                                                                            if (!((MachineList)Profile.this.machinelist_list.get((int)0)).samplesets.containsName(this.curr_machine.sampleof)) {
                                                                                                                this.curr_sampleset = new Samples(this.curr_machine.sampleof);
                                                                                                                ((MachineList)Profile.this.machinelist_list.get((int)0)).samplesets.putByName(this.curr_sampleset);
                                                                                                                continue block243;
                                                                                                            }
                                                                                                            this.curr_sampleset = ((MachineList)Profile.this.machinelist_list.get((int)0)).samplesets.getByName(this.curr_machine.sampleof);
                                                                                                            continue block243;
                                                                                                        }
                                                                                                        case "isbios": {
                                                                                                            this.curr_machine.isbios = BooleanUtils.toBoolean((String)attributes.getValue(i));
                                                                                                            continue block243;
                                                                                                        }
                                                                                                        case "ismechanical": {
                                                                                                            this.curr_machine.ismechanical = BooleanUtils.toBoolean((String)attributes.getValue(i));
                                                                                                            continue block243;
                                                                                                        }
                                                                                                        case "isdevice": {
                                                                                                            this.curr_machine.isdevice = BooleanUtils.toBoolean((String)attributes.getValue(i));
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                                break block269;
                                                                                            }
                                                                                            if (!qName.equals("description") || this.curr_machine == null && this.curr_software == null && this.curr_software_list == null) break block279;
                                                                                            this.in_description = true;
                                                                                            break block269;
                                                                                        }
                                                                                        if (!qName.equals("year") || this.curr_machine == null && this.curr_software == null) break block280;
                                                                                        this.in_year = true;
                                                                                        break block269;
                                                                                    }
                                                                                    if (!qName.equals("manufacturer") || this.curr_machine == null) break block281;
                                                                                    this.in_manufacturer = true;
                                                                                    break block269;
                                                                                }
                                                                                if (!qName.equals("publisher") || this.curr_software == null) break block282;
                                                                                this.in_publisher = true;
                                                                                break block269;
                                                                            }
                                                                            if (!qName.equals("driver")) break block283;
                                                                            if (this.curr_machine == null) break block269;
                                                                            block244: for (int i = 0; i < attributes.getLength(); ++i) {
                                                                                switch (attributes.getQName(i)) {
                                                                                    case "status": {
                                                                                        this.curr_machine.driver.setStatus(attributes.getValue(i));
                                                                                        continue block244;
                                                                                    }
                                                                                    case "emulation": {
                                                                                        this.curr_machine.driver.setEmulation(attributes.getValue(i));
                                                                                        continue block244;
                                                                                    }
                                                                                    case "cocktail": {
                                                                                        this.curr_machine.driver.setCocktail(attributes.getValue(i));
                                                                                        continue block244;
                                                                                    }
                                                                                    case "savestate": {
                                                                                        this.curr_machine.driver.setSaveState(attributes.getValue(i));
                                                                                    }
                                                                                }
                                                                            }
                                                                            break block269;
                                                                        }
                                                                        if (!qName.equals("display")) break block284;
                                                                        if (this.curr_machine == null) break block269;
                                                                        block245: for (int i = 0; i < attributes.getLength(); ++i) {
                                                                            switch (attributes.getQName(i)) {
                                                                                case "rotate": {
                                                                                    try {
                                                                                        Integer orientation = Integer.parseInt(attributes.getValue(i));
                                                                                        if (orientation == 0 || orientation == 180) {
                                                                                            this.curr_machine.orientation = Machine.DisplayOrientation.horizontal;
                                                                                        }
                                                                                        if (orientation != 90 && orientation != 270) continue block245;
                                                                                        this.curr_machine.orientation = Machine.DisplayOrientation.vertical;
                                                                                        continue block245;
                                                                                    }
                                                                                    catch (NumberFormatException orientation) {
                                                                                        // empty catch block
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                        break block269;
                                                                    }
                                                                    if (!qName.equals("input")) break block285;
                                                                    if (this.curr_machine == null) break block269;
                                                                    block246: for (int i = 0; i < attributes.getLength(); ++i) {
                                                                        switch (attributes.getQName(i)) {
                                                                            case "players": {
                                                                                this.curr_machine.input.setPlayers(attributes.getValue(i));
                                                                                continue block246;
                                                                            }
                                                                            case "coins": {
                                                                                this.curr_machine.input.setCoins(attributes.getValue(i));
                                                                                continue block246;
                                                                            }
                                                                            case "service": {
                                                                                this.curr_machine.input.setService(attributes.getValue(i));
                                                                                continue block246;
                                                                            }
                                                                            case "tilt": {
                                                                                this.curr_machine.input.setTilt(attributes.getValue(i));
                                                                            }
                                                                        }
                                                                    }
                                                                    break block269;
                                                                }
                                                                if (!qName.equals("device")) break block286;
                                                                if (this.curr_machine == null) break block269;
                                                                this.curr_device = new Device();
                                                                this.curr_machine.devices.add(this.curr_device);
                                                                block247: for (int i = 0; i < attributes.getLength(); ++i) {
                                                                    switch (attributes.getQName(i)) {
                                                                        case "type": {
                                                                            this.curr_device.type = attributes.getValue(i).trim();
                                                                            continue block247;
                                                                        }
                                                                        case "tag": {
                                                                            this.curr_device.tag = attributes.getValue(i).trim();
                                                                            continue block247;
                                                                        }
                                                                        case "interface": {
                                                                            this.curr_device.intrface = attributes.getValue(i).trim();
                                                                            continue block247;
                                                                        }
                                                                        case "fixed_image": {
                                                                            this.curr_device.fixed_image = attributes.getValue(i).trim();
                                                                            continue block247;
                                                                        }
                                                                        case "mandatory": {
                                                                            this.curr_device.mandatory = attributes.getValue(i).trim();
                                                                        }
                                                                    }
                                                                }
                                                                break block269;
                                                            }
                                                            if (!qName.equals("instance")) break block287;
                                                            if (this.curr_machine == null || this.curr_device == null) break block269;
                                                            this.curr_device.instance = this.curr_device.new Device.Instance();
                                                            block248: for (int i = 0; i < attributes.getLength(); ++i) {
                                                                switch (attributes.getQName(i)) {
                                                                    case "name": {
                                                                        this.curr_device.instance.name = attributes.getValue(i).trim();
                                                                        continue block248;
                                                                    }
                                                                    case "briefname": {
                                                                        this.curr_device.instance.briefname = attributes.getValue(i).trim();
                                                                    }
                                                                }
                                                            }
                                                            break block269;
                                                        }
                                                        if (!qName.equals("extension")) break block288;
                                                        if (this.curr_machine == null || this.curr_device == null) break block269;
                                                        Device.Extension ext = this.curr_device.new Device.Extension();
                                                        this.curr_device.extensions.add(ext);
                                                        for (int i = 0; i < attributes.getLength(); ++i) {
                                                            switch (attributes.getQName(i)) {
                                                                case "name": {
                                                                    ext.name = attributes.getValue(i).trim();
                                                                }
                                                            }
                                                        }
                                                        break block269;
                                                    }
                                                    if (!qName.equals("dipswitch")) break block289;
                                                    if (this.curr_machine == null) break block269;
                                                    block250: for (int i = 0; i < attributes.getLength(); ++i) {
                                                        switch (attributes.getQName(i)) {
                                                            case "name": {
                                                                if (!"cabinet".equalsIgnoreCase(attributes.getValue(i))) continue block250;
                                                                this.in_cabinet_dipsw = true;
                                                            }
                                                        }
                                                    }
                                                    break block269;
                                                }
                                                if (!qName.equals("dipvalue")) break block290;
                                                if (this.curr_machine == null || !this.in_cabinet_dipsw) break block269;
                                                block251: for (int i = 0; i < attributes.getLength(); ++i) {
                                                    switch (attributes.getQName(i)) {
                                                        case "name": {
                                                            if ("cocktail".equalsIgnoreCase(attributes.getValue(i))) {
                                                                this.cabtype_set.add(Machine.CabinetType.cocktail);
                                                                continue block251;
                                                            }
                                                            if (!"upright".equalsIgnoreCase(attributes.getValue(i))) continue block251;
                                                            this.cabtype_set.add(Machine.CabinetType.upright);
                                                        }
                                                    }
                                                }
                                                break block269;
                                            }
                                            if (!qName.equals("sample")) break block291;
                                            if (this.curr_machine == null) break block269;
                                            for (int i = 0; i < attributes.getLength(); ++i) {
                                                switch (attributes.getQName(i)) {
                                                    case "name": {
                                                        if (this.curr_sampleset == null) {
                                                            this.curr_machine.sampleof = this.curr_machine.getBaseName();
                                                            if (!((MachineList)Profile.this.machinelist_list.get((int)0)).samplesets.containsName(this.curr_machine.sampleof)) {
                                                                this.curr_sampleset = new Samples(this.curr_machine.sampleof);
                                                                ((MachineList)Profile.this.machinelist_list.get((int)0)).samplesets.putByName(this.curr_sampleset);
                                                            } else {
                                                                this.curr_sampleset = ((MachineList)Profile.this.machinelist_list.get((int)0)).samplesets.getByName(this.curr_machine.sampleof);
                                                            }
                                                        }
                                                        this.curr_machine.samples.add(this.curr_sampleset.add(new Sample(this.curr_sampleset, attributes.getValue(i))));
                                                        ++Profile.this.samples_cnt;
                                                    }
                                                }
                                            }
                                            break block269;
                                        }
                                        if (!qName.equals("device_ref")) break block292;
                                        if (this.curr_machine == null) break block269;
                                        for (int i = 0; i < attributes.getLength(); ++i) {
                                            switch (attributes.getQName(i)) {
                                                case "name": {
                                                    this.curr_machine.device_ref.add(attributes.getValue(i));
                                                }
                                            }
                                        }
                                        break block269;
                                    }
                                    if (!qName.equals("slot")) break block293;
                                    if (this.curr_machine == null) break block269;
                                    for (int i = 0; i < attributes.getLength(); ++i) {
                                        switch (attributes.getQName(i)) {
                                            case "name": {
                                                this.curr_slot = new Slot();
                                                this.curr_slot.name = attributes.getValue(i);
                                                this.curr_machine.slots.put(this.curr_slot.name, this.curr_slot);
                                            }
                                        }
                                    }
                                    break block269;
                                }
                                if (!qName.equals("slotoption")) break block294;
                                if (this.curr_machine == null || this.curr_slot == null) break block269;
                                SlotOption slotoption = new SlotOption();
                                block255: for (int i = 0; i < attributes.getLength(); ++i) {
                                    switch (attributes.getQName(i)) {
                                        case "name": {
                                            slotoption.setName(attributes.getValue(i));
                                            this.curr_slot.add(slotoption);
                                            continue block255;
                                        }
                                        case "devname": {
                                            slotoption.devname = attributes.getValue(i);
                                            continue block255;
                                        }
                                        case "default": {
                                            slotoption.def = BooleanUtils.toBoolean((String)attributes.getValue(i));
                                        }
                                    }
                                }
                                break block269;
                            }
                            if (!qName.equals("rom")) break block295;
                            if (this.curr_machine == null && this.curr_software == null) break block269;
                            this.curr_rom = new Rom(this.curr_machine != null ? this.curr_machine : this.curr_software);
                            if (this.curr_software != null && this.curr_dataarea != null) {
                                this.curr_dataarea.roms.add(this.curr_rom);
                            }
                            block256: for (int i = 0; i < attributes.getLength(); ++i) {
                                switch (attributes.getQName(i)) {
                                    case "name": {
                                        this.curr_rom.setName(attributes.getValue(i).trim());
                                        continue block256;
                                    }
                                    case "size": {
                                        this.curr_rom.size = Long.decode(attributes.getValue(i));
                                        continue block256;
                                    }
                                    case "offset": {
                                        try {
                                            this.curr_rom.offset = Integer.decode(attributes.getValue(i));
                                        }
                                        catch (NumberFormatException e) {
                                            this.curr_rom.offset = Integer.decode("0x" + attributes.getValue(i));
                                        }
                                        continue block256;
                                    }
                                    case "value": {
                                        this.curr_rom.value = attributes.getValue(i);
                                        continue block256;
                                    }
                                    case "crc": {
                                        this.curr_rom.crc = attributes.getValue(i).toLowerCase();
                                        continue block256;
                                    }
                                    case "sha1": {
                                        this.curr_rom.sha1 = attributes.getValue(i).toLowerCase();
                                        Profile.this.sha1_roms = true;
                                        continue block256;
                                    }
                                    case "md5": {
                                        this.curr_rom.md5 = attributes.getValue(i).toLowerCase();
                                        Profile.this.md5_roms = true;
                                        continue block256;
                                    }
                                    case "merge": {
                                        this.curr_rom.merge = attributes.getValue(i).trim();
                                        continue block256;
                                    }
                                    case "bios": {
                                        this.curr_rom.bios = attributes.getValue(i);
                                        continue block256;
                                    }
                                    case "region": {
                                        this.curr_rom.region = attributes.getValue(i);
                                        continue block256;
                                    }
                                    case "date": {
                                        this.curr_rom.date = attributes.getValue(i);
                                        continue block256;
                                    }
                                    case "optional": {
                                        this.curr_rom.optional = BooleanUtils.toBoolean((String)attributes.getValue(i));
                                        continue block256;
                                    }
                                    case "status": {
                                        this.curr_rom.status = Entity.Status.valueOf(attributes.getValue(i));
                                        continue block256;
                                    }
                                    case "loadflag": {
                                        this.curr_rom.loadflag = Rom.LoadFlag.getEnum(attributes.getValue(i));
                                    }
                                }
                            }
                            break block269;
                        }
                        if (qName.equals("disk") && (this.curr_machine != null || this.curr_software != null)) {
                            this.curr_disk = new Disk(this.curr_machine != null ? this.curr_machine : this.curr_software);
                            if (this.curr_software != null && this.curr_diskarea != null) {
                                this.curr_diskarea.disks.add(this.curr_disk);
                            }
                            block257: for (int i = 0; i < attributes.getLength(); ++i) {
                                switch (attributes.getQName(i)) {
                                    case "name": {
                                        this.curr_disk.setName(attributes.getValue(i).trim());
                                        continue block257;
                                    }
                                    case "sha1": {
                                        this.curr_disk.sha1 = attributes.getValue(i).toLowerCase();
                                        Profile.this.sha1_disks = true;
                                        continue block257;
                                    }
                                    case "md5": {
                                        this.curr_disk.md5 = attributes.getValue(i).toLowerCase();
                                        Profile.this.md5_disks = true;
                                        continue block257;
                                    }
                                    case "merge": {
                                        this.curr_disk.merge = attributes.getValue(i).trim();
                                        continue block257;
                                    }
                                    case "index": {
                                        this.curr_disk.index = Integer.decode(attributes.getValue(i));
                                        continue block257;
                                    }
                                    case "optional": {
                                        this.curr_disk.optional = BooleanUtils.toBoolean((String)attributes.getValue(i));
                                        continue block257;
                                    }
                                    case "writeable": {
                                        this.curr_disk.writeable = BooleanUtils.toBoolean((String)attributes.getValue(i));
                                        continue block257;
                                    }
                                    case "region": {
                                        this.curr_disk.region = attributes.getValue(i);
                                        continue block257;
                                    }
                                    case "status": {
                                        this.curr_disk.status = Entity.Status.valueOf(attributes.getValue(i));
                                    }
                                }
                            }
                        }
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equals("header")) {
                        this.in_header = false;
                    } else if (qName.equals("softwarelist") && this.curr_software_list != null) {
                        Profile.this.machinelist_list.softwarelist_list.add(this.curr_software_list);
                        ++Profile.this.softwares_list_cnt;
                        this.curr_software_list = null;
                    } else if (qName.equals("software")) {
                        this.roms.clear();
                        this.disks.clear();
                        this.curr_software_list.add(this.curr_software);
                        ++Profile.this.softwares_cnt;
                        this.curr_software = null;
                        handler.setProgress(String.format(Messages.getString("Profile.SWLoaded"), Profile.this.softwares_cnt, Profile.this.swroms_cnt, Profile.this.swdisks_cnt));
                        if (handler.isCancel()) {
                            throw new BreakException();
                        }
                    } else if (qName.equals("machine") || qName.equals("game")) {
                        this.roms.clear();
                        this.disks.clear();
                        ((MachineList)Profile.this.machinelist_list.get(0)).add(this.curr_machine);
                        ++Profile.this.machines_cnt;
                        this.curr_machine = null;
                        this.curr_sampleset = null;
                        handler.setProgress(String.format(Messages.getString("Profile.Loaded"), Profile.this.machines_cnt, Profile.this.roms_cnt, Profile.this.disks_cnt, Profile.this.samples_cnt));
                        if (handler.isCancel()) {
                            throw new BreakException();
                        }
                    } else if (qName.equals("rom")) {
                        if (this.curr_rom.getName() != null) {
                            Rom old_rom;
                            if (!this.roms.contains(this.curr_rom.getBaseName())) {
                                this.roms.add(this.curr_rom.getBaseName());
                                if (this.curr_machine != null) {
                                    this.curr_machine.roms.add(this.curr_rom);
                                    ++Profile.this.roms_cnt;
                                } else {
                                    this.curr_software.roms.add(this.curr_rom);
                                    ++Profile.this.swroms_cnt;
                                }
                            }
                            if (this.curr_rom.crc != null && (old_rom = this.roms_bycrc.put(this.curr_rom.crc, this.curr_rom)) != null) {
                                if (old_rom.sha1 != null && this.curr_rom.sha1 != null && !old_rom.equals(this.curr_rom)) {
                                    Profile.this.suspicious_crc.add(this.curr_rom.crc);
                                }
                                if (old_rom.md5 != null && this.curr_rom.md5 != null && !old_rom.equals(this.curr_rom)) {
                                    Profile.this.suspicious_crc.add(this.curr_rom.crc);
                                }
                            }
                        }
                    } else if (qName.equals("disk")) {
                        if (this.curr_disk.getName() != null && !this.disks.contains(this.curr_disk.getBaseName())) {
                            this.disks.add(this.curr_disk.getBaseName());
                            if (this.curr_machine != null) {
                                this.curr_machine.disks.add(this.curr_disk);
                                ++Profile.this.disks_cnt;
                            } else {
                                this.curr_software.disks.add(this.curr_disk);
                                ++Profile.this.swdisks_cnt;
                            }
                        }
                    } else if (qName.equals("description") && (this.curr_machine != null || this.curr_software != null || this.curr_software_list != null)) {
                        this.in_description = false;
                    } else if (qName.equals("year") && (this.curr_machine != null || this.curr_software != null)) {
                        this.in_year = false;
                    } else if (qName.equals("manufacturer") && this.curr_machine != null) {
                        this.in_manufacturer = false;
                    } else if (qName.equals("publisher") && this.curr_software != null) {
                        this.in_publisher = false;
                    } else if (qName.equals("dipswitch") && this.in_cabinet_dipsw) {
                        this.curr_machine.cabinetType = this.cabtype_set.contains((Object)Machine.CabinetType.cocktail) ? (this.cabtype_set.contains((Object)Machine.CabinetType.upright) ? Machine.CabinetType.any : Machine.CabinetType.cocktail) : Machine.CabinetType.upright;
                        this.cabtype_set.clear();
                        this.in_cabinet_dipsw = false;
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.in_description) {
                        if (this.curr_machine != null) {
                            this.curr_machine.description.append(ch, start, length);
                        } else if (this.curr_software != null) {
                            this.curr_software.description.append(ch, start, length);
                        } else if (this.curr_software_list != null) {
                            this.curr_software_list.description.append(ch, start, length);
                        }
                    } else if (this.in_year) {
                        if (this.curr_machine != null) {
                            this.curr_machine.year.append(ch, start, length);
                        } else if (this.curr_software != null) {
                            this.curr_software.year.append(ch, start, length);
                        }
                    } else if (this.in_manufacturer && this.curr_machine != null) {
                        this.curr_machine.manufacturer.append(ch, start, length);
                    } else if (this.in_publisher && this.curr_software != null) {
                        this.curr_software.publisher.append(ch, start, length);
                    } else if (this.in_header) {
                        if (!Profile.this.header.containsKey(this.curr_tag)) {
                            Profile.this.header.put(this.curr_tag, new StringBuffer());
                        }
                        Profile.this.header.get(this.curr_tag).append(ch, start, length);
                    }
                }
            });
            boolean bl = true;
            return bl;
        }
        catch (ParserConfigurationException | SAXException e) {
            Log.err("Parser Exception", e);
            return false;
        }
        catch (IOException e) {
            Log.err("IO Exception", e);
            return false;
        }
        catch (BreakException e) {
            return false;
        }
        catch (Throwable e) {
            Log.err("Other Exception", e);
        }
        return false;
    }

    private static File getCacheFile(File file) {
        return Settings.getWorkFile(file.getParentFile(), file.getName(), ".cache");
    }

    public void save() {
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(Profile.getCacheFile(this.nfo.file))));){
            oos.writeObject(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Profile load(File file, ProgressHandler handler) {
        return Profile.load(ProfileNFO.load(file), handler);
    }

    public static Profile load(ProfileNFO nfo, ProgressHandler handler) {
        Profile profile = null;
        File cachefile = Profile.getCacheFile(nfo.file);
        if (!(cachefile.lastModified() < nfo.file.lastModified() || nfo.isJRM() && cachefile.lastModified() < nfo.mame.fileroms.lastModified() || Settings.getProperty("debug_nocache", false))) {
            handler.setProgress(Messages.getString("Profile.LoadingCache"), -1);
            try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(handler.getInputStream(new FileInputStream(cachefile), (int)cachefile.length())));){
                profile = (Profile)ois.readObject();
                profile.nfo = nfo;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (profile == null) {
            profile = new Profile();
            profile.nfo = nfo;
            if (nfo.isJRM()) {
                if (nfo.mame.fileroms != null) {
                    if (!profile._load(nfo.mame.fileroms, handler)) {
                        return null;
                    }
                    if (nfo.mame.filesl != null && !profile._load(nfo.mame.filesl, handler)) {
                        return null;
                    }
                }
            } else if (!profile._load(nfo.file, handler)) {
                return null;
            }
            handler.setProgress(Messages.getString("Profile.BuildingParentClonesRelations"), -1);
            profile.buildParentClonesRelations();
            handler.setProgress(Messages.getString("Profile.SavingCache"), -1);
            profile.save();
        }
        profile.nfo.stats.version = profile.build != null ? profile.build : (profile.header.containsKey("version") ? profile.header.get("version").toString() : null);
        profile.nfo.stats.totalSets = profile.softwares_cnt + profile.machines_cnt;
        profile.nfo.stats.totalRoms = profile.roms_cnt + profile.swroms_cnt;
        profile.nfo.stats.totalDisks = profile.disks_cnt + profile.swdisks_cnt;
        handler.setProgress("Loading settings...", -1);
        profile.loadSettings();
        handler.setProgress("Creating Systems filters...", -1);
        profile.loadSystems();
        handler.setProgress("Creating Years filters...", -1);
        profile.loadYears();
        profile.loadCatVer(handler);
        profile.loadNPlayers(handler);
        return profile;
    }

    private void buildParentClonesRelations() {
        this.machinelist_list.forEach(machine_list -> machine_list.forEach(machine -> {
            if (machine.romof != null) {
                machine.setParent(machine_list.getByName(machine.romof));
                if (machine.parent != null && !machine.getParent().isbios) {
                    machine.getParent().clones.put(machine.getName(), machine);
                }
            }
            machine.device_ref.forEach(device_ref -> machine.device_machines.putIfAbsent((String)device_ref, machine_list.getByName((String)device_ref)));
            machine.slots.values().forEach(slot -> slot.forEach(slotoption -> machine.device_machines.putIfAbsent(slotoption.devname, machine_list.getByName(slotoption.devname))));
        }));
        this.machinelist_list.softwarelist_list.forEach(software_list -> software_list.forEach(software -> {
            if (software.cloneof != null) {
                software.setParent(software_list.getByName(software.cloneof));
                if (software.parent != null) {
                    software.getParent().clones.put(software.getName(), software);
                }
            }
        }));
    }

    public static File getSettingsFile(File file) {
        return Settings.getWorkFile(file.getParentFile(), file.getName(), ".properties");
    }

    public void saveSettings() {
        try {
            this.settings = Profile.saveSettings(this.nfo.file, this.settings);
            this.nfo.save();
        }
        catch (IOException e) {
            Log.err("IO", e);
        }
    }

    public static Properties saveSettings(File file, Properties settings) throws IOException {
        if (settings == null) {
            settings = new Properties();
        }
        try (FileOutputStream os = new FileOutputStream(Profile.getSettingsFile(file));){
            settings.storeToXML(os, null);
        }
        return settings;
    }

    public void loadSettings() {
        try {
            this.settings = Profile.loadSettings(this.nfo.file, this.settings);
        }
        catch (IOException e) {
            Log.err("IO", e);
        }
    }

    public static Properties loadSettings(File file, Properties settings) throws IOException {
        if (settings == null) {
            settings = new Properties();
        }
        if (Profile.getSettingsFile(file).exists()) {
            try (FileInputStream is = new FileInputStream(Profile.getSettingsFile(file));){
                settings.loadFromXML(is);
            }
        }
        return settings;
    }

    public void setProperty(String property, boolean value) {
        this.settings.setProperty(property, Boolean.toString(value));
    }

    public void setProperty(String property, String value) {
        this.settings.setProperty(property, value);
    }

    public boolean getProperty(String property, boolean def) {
        return Boolean.parseBoolean(this.settings.getProperty(property, Boolean.toString(def)));
    }

    public String getProperty(String property, String def) {
        return this.settings.getProperty(property, def);
    }

    public void setPropsCheckPoint() {
        this.props_hashcode = this.settings.hashCode();
    }

    public boolean hasPropsChanged() {
        return this.props_hashcode != this.settings.hashCode();
    }

    public String getName() {
        String name = "<html><body>[<span color='blue'>" + Settings.getWorkPath().resolve("xmlfiles").toAbsolutePath().normalize().relativize(this.nfo.file.toPath()) + "</span>] ";
        if (this.build != null) {
            name = name + "<b>" + this.build + "</b>";
        } else if (this.header.size() > 0) {
            if (this.header.containsKey("description")) {
                name = name + "<b>" + this.header.get("description") + "</b>";
            } else if (this.header.containsKey("name")) {
                name = name + "<b>" + this.header.get("name") + "</b>";
                if (this.header.containsKey("version")) {
                    name = name + " (" + this.header.get("version") + ")";
                }
            }
        }
        String strcnt = "";
        if (((MachineList)this.machinelist_list.get(0)).size() > 0) {
            strcnt = strcnt + this.machines_cnt + " Machines";
        }
        if (this.machinelist_list.softwarelist_list.size() > 0) {
            strcnt = strcnt + (strcnt.isEmpty() ? "" : ", ") + this.softwares_list_cnt + " Software Lists, " + this.softwares_cnt + " Softwares";
        }
        name = name + "(" + strcnt + ")</body></html>";
        return name;
    }

    public void loadSystems() {
        this.systems = new Systms();
        this.systems.add(SystmStandard.STANDARD);
        this.systems.add(SystmMechanical.MECHANICAL);
        this.systems.add(SystmDevice.DEVICE);
        ArrayList<Machine> machines = new ArrayList<Machine>();
        ((MachineList)this.machinelist_list.get(0)).forEach(m -> {
            if (m.isbios) {
                machines.add((Machine)m);
            }
        });
        machines.sort((a, b) -> a.getName().compareTo(b.getName()));
        machines.forEach(this.systems::add);
        ArrayList<SoftwareList> softwarelists = new ArrayList<SoftwareList>();
        this.machinelist_list.softwarelist_list.forEach(softwarelists::add);
        softwarelists.sort((a, b) -> a.getName().compareTo(b.getName()));
        softwarelists.forEach(this.systems::add);
    }

    public void loadYears() {
        HashSet<String> years = new HashSet<String>();
        years.add("");
        ((MachineList)this.machinelist_list.get(0)).forEach(m -> years.add(m.year.toString()));
        this.machinelist_list.softwarelist_list.forEach(sl -> sl.forEach(s -> years.add(s.year.toString())));
        years.add("????");
        this.years = years;
    }

    public void loadCatVer(ProgressHandler handler) {
        try {
            File file = new File(this.getProperty("filter.catver.ini", null));
            if (file.exists()) {
                if (handler != null) {
                    handler.setProgress("Loading catver.ini ...", -1);
                }
                this.catver = CatVer.read(file);
                for (CatVer.Category cat : this.catver) {
                    for (CatVer.SubCategory subcat : cat) {
                        for (String game : subcat) {
                            Machine m = ((MachineList)this.machinelist_list.get(0)).getByName(game);
                            if (m == null) continue;
                            m.subcat = subcat;
                        }
                    }
                }
            } else {
                this.catver = null;
            }
        }
        catch (Throwable e) {
            this.catver = null;
        }
    }

    public void loadNPlayers(ProgressHandler handler) {
        try {
            File file = new File(this.getProperty("filter.nplayers.ini", null));
            if (file.exists()) {
                if (handler != null) {
                    handler.setProgress("Loading nplayers.ini ...", -1);
                }
                this.nplayers = NPlayers.read(file);
                for (NPlayers.NPlayer nplayer : this.nplayers) {
                    for (String game : nplayer) {
                        Machine m = ((MachineList)this.machinelist_list.get(0)).getByName(game);
                        if (m == null) continue;
                        m.nplayer = nplayer;
                    }
                }
            } else {
                this.nplayers = null;
            }
        }
        catch (Throwable e) {
            this.nplayers = null;
        }
    }

    public int size() {
        return this.machinelist_list.size() + this.machinelist_list.softwarelist_list.size();
    }

    public int subsize() {
        return ((MachineList)this.machinelist_list.get(0)).size() + ((MachineList)this.machinelist_list.get((int)0)).samplesets.size() + this.machinelist_list.softwarelist_list.stream().flatMapToInt(sl -> IntStream.of(sl.size())).sum();
    }
}

