/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.properties.DefaultTaskProperties;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.ResolveMutationsNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.properties.bean.PropertyWalker;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.service.ServiceRegistry;

public class LocalTaskNode
extends TaskNode {
    private final TaskInternal task;
    private final WorkValidationContext validationContext;
    private final ResolveMutationsNode resolveMutationsNode;
    private boolean hasVisitedMutationsNode;
    private Set<Node> lifecycleSuccessors;
    private boolean isolated;
    private List<? extends ResourceLock> resourceLocks;
    private TaskProperties taskProperties;
    private ProjectInternal taskProject;

    public LocalTaskNode(TaskInternal task, WorkValidationContext workValidationContext, Function<LocalTaskNode, ResolveMutationsNode> resolveNodeFactory) {
        this.task = task;
        this.validationContext = workValidationContext;
        this.resolveMutationsNode = resolveNodeFactory.apply(this);
        this.taskProject = (ProjectInternal)task.getProject();
    }

    public void isolated() {
        this.isolated = true;
    }

    public WorkValidationContext getValidationContext() {
        return this.validationContext;
    }

    @Override
    @Nullable
    public ResourceLock getProjectToLock() {
        if (this.isolated) {
            return null;
        }
        return this.taskProject.getOwner().getTaskExecutionLock();
    }

    @Override
    @Nullable
    public ProjectInternal getOwningProject() {
        return this.taskProject;
    }

    @Override
    public List<? extends ResourceLock> getResourcesToLock() {
        if (this.resourceLocks == null) {
            this.resourceLocks = this.task.getSharedResources();
        }
        return this.resourceLocks;
    }

    @Override
    public TaskInternal getTask() {
        return this.task;
    }

    @Override
    public boolean isPublicNode() {
        return true;
    }

    public TaskProperties getTaskProperties() {
        if (this.taskProperties == null) {
            ServiceRegistry serviceRegistry = this.taskProject.getServices();
            FileCollectionFactory fileCollectionFactory = (FileCollectionFactory)serviceRegistry.get(FileCollectionFactory.class);
            PropertyWalker propertyWalker = (PropertyWalker)serviceRegistry.get(PropertyWalker.class);
            this.taskProperties = DefaultTaskProperties.resolve(propertyWalker, fileCollectionFactory, this.task);
        }
        return this.taskProperties;
    }

    @Override
    public Throwable getNodeFailure() {
        return this.task.getState().getFailure();
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver) {
        this.taskProject.getTasks().prepareForExecution(this.task);
        for (Node targetNode : this.getDependencies(dependencyResolver)) {
            this.addDependencySuccessor(targetNode);
        }
        this.lifecycleSuccessors = dependencyResolver.resolveDependenciesFor(this.task, this.task.getLifecycleDependencies());
        for (Node targetNode : this.getFinalizedBy(dependencyResolver)) {
            if (!(targetNode instanceof TaskNode)) {
                throw new IllegalStateException("Only tasks can be finalizers: " + targetNode);
            }
            this.addFinalizerNode((TaskNode)targetNode);
        }
        for (Node targetNode : this.getMustRunAfter(dependencyResolver)) {
            this.addMustSuccessor(targetNode);
        }
        for (Node targetNode : this.getShouldRunAfter(dependencyResolver)) {
            this.addShouldSuccessor(targetNode);
        }
    }

    private void addFinalizerNode(TaskNode finalizerNode) {
        this.deprecateLifecycleHookReferencingNonLocalTask("finalizedBy", finalizerNode);
        finalizerNode.addFinalizingSuccessor(this);
    }

    private Set<Node> getDependencies(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getTaskDependencies());
    }

    private Set<Node> getFinalizedBy(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getFinalizedBy());
    }

    private Set<Node> getMustRunAfter(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getMustRunAfter());
    }

    private Set<Node> getShouldRunAfter(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getShouldRunAfter());
    }

    @Override
    public String toString() {
        return this.task.getIdentityPath().toString();
    }

    @Override
    public boolean hasPendingPreExecutionNodes() {
        return !this.hasVisitedMutationsNode;
    }

    @Override
    public void visitPreExecutionNodes(Consumer<? super Node> visitor) {
        if (!this.hasVisitedMutationsNode) {
            visitor.accept(this.resolveMutationsNode);
            this.hasVisitedMutationsNode = true;
        }
    }

    public Node getPrepareNode() {
        return this.resolveMutationsNode;
    }

    @Override
    public void markFailedDueToDependencies(Consumer<Node> completionAction) {
        super.markFailedDueToDependencies(completionAction);
        if (!this.resolveMutationsNode.isComplete()) {
            this.resolveMutationsNode.markFailedDueToDependencies(completionAction);
        }
    }

    @Override
    public void cancelExecution(Consumer<Node> completionAction) {
        super.cancelExecution(completionAction);
        if (this.resolveMutationsNode.isRequired()) {
            this.resolveMutationsNode.cancelExecution(completionAction);
        }
    }

    @Override
    public Set<Node> getLifecycleSuccessors() {
        return this.lifecycleSuccessors;
    }

    @Override
    public void setLifecycleSuccessors(Set<Node> lifecycleSuccessors) {
        this.lifecycleSuccessors = lifecycleSuccessors;
    }

    @Override
    protected boolean dependsOnOutcome(Node dependency) {
        return this.lifecycleSuccessors.contains(dependency);
    }
}

