/*!
 * \file
 * \brief Include file for the IT++ protocols module
 * \author Tony Ottosson
 *
 * -------------------------------------------------------------------------
 *
 * Copyright (C) 1995-2010  (see AUTHORS file for a list of contributors)
 *
 * This file is part of IT++ - a C++ library of mathematical, signal
 * processing, speech processing, and communications classes and functions.
 *
 * IT++ is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * IT++ is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with IT++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * -------------------------------------------------------------------------
 */

#ifndef ITPROTOCOL_H
#define ITPROTOCOL_H

/*!
 * \defgroup protocol Protocols Module
 * @{
 */

/*!
 * @}
 */

#include <itpp/itbase.h>
#include <itpp/protocol/events.h>
#include <itpp/protocol/front_drop_queue.h>
#include <itpp/protocol/packet.h>
#include <itpp/protocol/packet_channel.h>
#include <itpp/protocol/packet_generator.h>
#include <itpp/protocol/selective_repeat.h>
#include <itpp/protocol/signals_slots.h>
#include <itpp/protocol/tcp.h>
#include <itpp/protocol/tcp_client_server.h>

#endif // #ifndef ITPROTOCOL_H
