#! /bin/sh
# Do not edit this file!
# this file is generated by 'generate_test.pl'.

#
# idnconv2 command test.
# Test '-flush' option.
# (This test only inspects whether idnconv2 accepts '-flush' option.)
#
#             api: command
#  local_encoding: U-escape
#         command: ../../tools/idnconv/idnconv2 -c /dev/null -flush
#           input: === \u{e0}a ===
#           input: === \u{e0}b ===
#          output: === xn--a-rfa ===
#          output: === xn--b-rfa ===
#        exitcode: 0

################## setup ##################

unset LC_ALL
unset LC_CTYPE
unset LC_MESSAGES
unset LANG
unset IDN_LOCAL_CODESET
unset IDN_LOG_LEVEL

SRCDIR=`dirname $0`
SYSCONFDIR=${SYSCONFDIR-"/etc"}
IGNORE=false
export IDN_LOCAL_CODESET; IDN_LOCAL_CODESET=U-escape

rm -f idn2.conf
touch idn2.conf
rm -f localmap1
rm -f localmap2
rm -f localmap3
rm -f localmap4
rm -f localset
rm -f expect.txt
rm -f output.txt

################## test ##################

echo '=== xn--a-rfa ===' >> expect.txt
echo '=== xn--b-rfa ===' >> expect.txt
echo 'exitcode=0' >> expect.txt
rm -f input.txt
touch input.txt
echo '=== \u{e0}a ===' >> input.txt
echo '=== \u{e0}b ===' >> input.txt
cat input.txt | ../../tools/idnconv/idnconv2 -c /dev/null -flush > output.txt 2>&1
echo 'exitcode='$? >> output.txt
rm -f input.txt

################## teardown ##################

cmp expect.txt output.txt > /dev/null 2>&1
RESULT=$?
[ X$IGNORE = Xtrue ] && RESULT=77
if [ X$QUIET != Xtrue ]; then
    if [ $RESULT -eq 0 ]; then
        echo "PASS: $0"
    elif [ $RESULT -eq 77 ]; then
        echo "SKIP: $0"
    else
        echo "FAIL: $0"
    fi
fi
[ $RESULT -eq 0 -o $RESULT -eq 77 ] || exit $RESULT
rm -f idn2.conf
rm -f localmap1
rm -f localmap2
rm -f localmap3
rm -f localmap4
rm -f localset
rm -f expect.txt
rm -f output.txt
exit $RESULT
