/*------------------------->  ANSI C - sourcefile  <-------------------------*/
/* Copyright (C) 2000 by University of Waikato                               */
/* This file is part of the GNU Sather package. It is free software; you may */
/* redistribute  and/or modify it under the terms of the  GNU General Public */
/* License (GPL)  as  published  by the  Free  Software  Foundation;  either */
/* version 2 of the license, or (at your option) any later version.          */
/* This  program  is distributed  in the  hope that it will  be  useful, but */
/* WITHOUT ANY WARRANTY without even the implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE. See Doc/GPL for more details.        */
/* The license text is also available from:  Free Software Foundation, Inc., */
/* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA                     */
/*------------>  Please email comments to <bug-sather@gnu.org>  <------------*/

#include <stdio.h>
#include <tcl.h>
#include <tk.h>

#include <gc/gc.h>

Tcl_Channel Tcl_Exec(Tcl_Interp *interp, char *process)
{
  Tcl_Channel chan ;
  char *argv[1] = {process} ;
  chan = Tcl_OpenCommandChannel(interp, 1, argv, TCL_STDOUT|TCL_STDIN) ;
  if (chan == NULL) {
    fprintf(stderr,
	    "Unable to open Tcl Command Channel\ninterp->result = %s\n",
	    interp->result) ;
    fflush(stderr) ;
    exit(1) ;
  }
  Tcl_RegisterChannel(interp, chan) ;
  return chan ;
}
