/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.FilterConsumer;
import gnu.lists.UnescapedData;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.xml.XMLPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class HttpPrinter
extends FilterConsumer {
    Vector headers = new Vector();
    StringBuilder sbuf = new StringBuilder(100);
    Object currentHeader;
    private int seenStartDocument;
    protected String sawContentType;
    private int elementNesting;
    protected OutputStream ostream;
    OutPort writer;
    boolean seenXmlHeader;

    public HttpPrinter(OutputStream outputStream) {
        super(null);
        this.ostream = outputStream;
    }

    public HttpPrinter(OutPort outPort) {
        super(null);
        this.writer = outPort;
    }

    public static HttpPrinter make(OutPort outPort) {
        return new HttpPrinter(outPort);
    }

    private void writeRaw(String string) throws IOException {
        if (this.writer != null) {
            this.writer.write(string);
        } else {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                this.ostream.write((byte)string.charAt(i));
            }
        }
    }

    public void printHeader(String string, String string2) throws IOException {
        this.writeRaw(string);
        this.writeRaw(": ");
        this.writeRaw(string2);
        this.writeRaw("\n");
    }

    public void printHeaders() throws IOException {
        int n = this.headers.size();
        for (int i = 0; i < n; i += 2) {
            this.printHeader(this.headers.elementAt(i).toString(), this.headers.elementAt(i + 1).toString());
        }
        this.writeRaw("\n");
    }

    public void addHeader(String string, String string2) {
        if (string.equalsIgnoreCase("Content-type")) {
            this.sawContentType = string2;
        }
        this.headers.addElement(string);
        this.headers.addElement(string2);
    }

    public void startAttribute(Object object2) {
        if (this.base == null) {
            this.currentHeader = object2;
        } else {
            this.base.startAttribute(object2);
        }
    }

    public void endAttribute() {
        if (this.currentHeader != null) {
            this.addHeader(this.currentHeader.toString(), this.sbuf.toString());
            this.sbuf.setLength(0);
            this.currentHeader = null;
        } else {
            this.base.endAttribute();
        }
    }

    public void beginData() {
        if (this.base == null) {
            if (this.sawContentType == null) {
                this.addHeader("Content-type", "text/html");
            }
            if (this.writer == null) {
                this.writer = new OutPort(this.ostream);
            }
            String string = null;
            if ("text/html".equalsIgnoreCase(this.sawContentType)) {
                string = "html";
            } else if ("text/xhtml".equalsIgnoreCase(this.sawContentType)) {
                string = "xhtml";
            } else if ("text/plain".equalsIgnoreCase(this.sawContentType)) {
                string = "plain";
            }
            this.base = XMLPrinter.make(this.writer, string);
            if (this.seenStartDocument == 0) {
                this.base.startDocument();
                this.seenStartDocument = 1;
            }
            try {
                this.printHeaders();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.toString());
            }
        }
        this.append(this.sbuf);
        this.sbuf.setLength(0);
    }

    public void startElement(Object object2) {
        if (this.sawContentType == null) {
            String string = !this.seenXmlHeader ? "text/html" : (object2 instanceof Symbol && "html".equals(((Symbol)object2).getLocalPart()) ? "text/xhtml" : "text/xml");
            this.addHeader("Content-type", string);
        }
        this.beginData();
        this.base.startElement(object2);
        ++this.elementNesting;
    }

    public void endElement() {
        super.endElement();
        --this.elementNesting;
        if (this.elementNesting == 0 && this.seenStartDocument == 1) {
            this.endDocument();
        }
    }

    public void writeObject(Object object2) {
        if (object2 instanceof Consumable && !(object2 instanceof UnescapedData)) {
            ((Consumable)object2).consume(this);
        } else {
            this.beginData();
            super.writeObject(object2);
        }
    }

    public Consumer append(CharSequence charSequence, int n, int n2) {
        if (this.base == null) {
            this.sbuf.append(charSequence, n, n2);
        } else {
            this.base.write(charSequence, n, n2);
        }
        return this;
    }

    public Consumer append(CharSequence charSequence) {
        if (this.base == null) {
            this.sbuf.append(charSequence);
        } else if (charSequence == null) {
            this.base.write("null");
        } else {
            this.base.write(charSequence, 0, charSequence.length());
        }
        return this;
    }

    public void write(char[] cArray, int n, int n2) {
        if (this.base == null) {
            this.sbuf.append(cArray, n, n2);
        } else {
            this.base.write(cArray, n, n2);
        }
    }

    public void startDocument() {
        if (this.base != null) {
            this.base.startDocument();
        }
        this.seenStartDocument = 2;
    }

    public void endDocument() {
        if (this.base != null) {
            this.base.endDocument();
        }
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.ostream != null) {
                this.ostream.flush();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

