/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.ScopeExp;
import gnu.lists.Pair;
import gnu.mapping.Named;
import gnu.mapping.Printable;
import gnu.mapping.Symbol;
import java.io.PrintWriter;
import java.util.Vector;
import kawa.lang.Translator;

public abstract class Syntax
implements Printable,
Named {
    Object name;

    public final String getName() {
        return this.name == null ? null : (this.name instanceof Symbol ? ((Symbol)this.name).getName() : this.name.toString());
    }

    public Object getSymbol() {
        return this.name;
    }

    public void setName(Object object2) {
        this.name = object2;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Syntax() {
    }

    public Syntax(Object object2) {
        this.setName(object2);
    }

    public Expression rewrite(Object object2, Translator translator) {
        throw new InternalError("rewrite method not defined");
    }

    public Expression rewriteForm(Object object2, Translator translator) {
        if (object2 instanceof Pair) {
            return this.rewriteForm((Pair)object2, translator);
        }
        return translator.syntaxError("non-list form for " + this);
    }

    public Expression rewriteForm(Pair pair, Translator translator) {
        return this.rewrite(pair.cdr, translator);
    }

    public void scanForm(Pair pair, ScopeExp scopeExp, Translator translator) {
        boolean bl = this.scanForDefinitions(pair, translator.formStack, scopeExp, translator);
        if (!bl) {
            translator.formStack.add(new ErrorExp("syntax error"));
        }
    }

    public boolean scanForDefinitions(Pair pair, Vector vector, ScopeExp scopeExp, Translator translator) {
        vector.addElement(pair);
        return true;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<syntax ");
        String string = this.getName();
        if (string == null) {
            printWriter.print("<unnamed>");
        } else {
            printWriter.print(string);
        }
        printWriter.print('>');
    }
}

