/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Literal;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleInfo;
import gnu.expr.QuoteExp;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.mapping.WrappedException;
import gnu.text.SourceMessages;
import java.io.Externalizable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ModuleExp
extends LambdaExp
implements Externalizable {
    public static boolean debugPrintExpr = false;
    public static final int EXPORT_SPECIFIED = 2048;
    public static final int STATIC_SPECIFIED = 4096;
    public static final int NONSTATIC_SPECIFIED = 8192;
    public static final int SUPERTYPE_SPECIFIED = 16384;
    public static final int STATIC_RUN_SPECIFIED = 32768;
    public static final int LAZY_DECLARATIONS = 65536;
    public static String dumpZipPrefix;
    public static int interactiveCounter;
    public static boolean alwaysCompile;
    ClassType superType;
    ClassType[] interfaces;
    ModuleInfo info;

    public String getJavaName() {
        String string = this.getName();
        return string == null ? "lambda" : Compilation.mangleName(string);
    }

    public static Class evalToClass(Compilation compilation) {
        ModuleExp moduleExp = compilation.getModule();
        SourceMessages sourceMessages = compilation.getMessages();
        try {
            Object object2;
            Object object3;
            ArrayClassLoader arrayClassLoader;
            String string = moduleExp.getJavaName();
            compilation.loader = arrayClassLoader = new ArrayClassLoader();
            compilation.compile(moduleExp, string, null);
            if (sourceMessages.seenErrors()) {
                return null;
            }
            byte[][] byArrayArray = new byte[compilation.numClasses][];
            ZipOutputStream zipOutputStream = null;
            if (dumpZipPrefix != null) {
                StringBuffer stringBuffer = new StringBuffer(dumpZipPrefix);
                if (interactiveCounter >= 0) {
                    stringBuffer.append(interactiveCounter);
                }
                stringBuffer.append(".zip");
                object3 = new FileOutputStream(stringBuffer.toString());
                zipOutputStream = new ZipOutputStream((OutputStream)object3);
            }
            for (int i = 0; i < compilation.numClasses; ++i) {
                object3 = compilation.classes[i];
                object2 = ((Type)object3).getName();
                byte[] byArray = ((ClassType)object3).writeToArray();
                arrayClassLoader.addClass((String)object2, byArray);
                if (zipOutputStream == null) continue;
                String string2 = ((String)object2).replace('.', '/') + ".class";
                ZipEntry zipEntry = new ZipEntry(string2);
                zipEntry.setSize(byArray.length);
                CRC32 cRC32 = new CRC32();
                cRC32.update(byArray);
                zipEntry.setCrc(cRC32.getValue());
                zipEntry.setMethod(0);
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(byArray);
            }
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            CallContext callContext = CallContext.getInstance();
            callContext.value1 = compilation;
            for (int i = 0; i < compilation.numClasses; ++i) {
                object2 = compilation.classes[i];
                ((Type)object2).setReflectClass(arrayClassLoader.loadClass(((Type)object2).getName(), false));
                ((ObjectType)object2).setExisting(true);
            }
            return arrayClassLoader.loadClass(string, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(OutPort.errDefault());
            throw new RuntimeException("I/O error in lambda eval: " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("class not found in lambda eval");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void evalModule(Environment environment, CallContext callContext, Compilation compilation) throws Throwable {
        ModuleExp moduleExp = compilation.getModule();
        Environment environment2 = Environment.getCurrent();
        try {
            if (environment != environment2) {
                Environment.setCurrent(environment);
            }
            if (!alwaysCompile && !compilation.mustCompile) {
                if (debugPrintExpr) {
                    OutPort outPort = OutPort.outDefault();
                    outPort.println("[Evaluating module \"" + moduleExp.getName() + "\":");
                    moduleExp.print(outPort);
                    outPort.println(']');
                    outPort.flush();
                }
                moduleExp.body.apply(callContext);
            } else {
                Class clazz;
                block18: {
                    clazz = ModuleExp.evalToClass(compilation);
                    if (clazz != null) break block18;
                    return;
                }
                try {
                    Object object2;
                    try {
                        object2 = clazz.getDeclaredField("$instance").get(null);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        object2 = clazz.newInstance();
                    }
                    for (Declaration declaration = moduleExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
                        Object object3;
                        String string = declaration.getName();
                        if (declaration.isPrivate() || string == null) continue;
                        Field field = declaration.field;
                        Symbol symbol = string instanceof Symbol ? (Symbol)((Object)string) : Symbol.make("", string.toString().intern());
                        Object object4 = compilation.getLanguage().getEnvPropertyFor(declaration);
                        if (declaration.getFlag(16513)) {
                            object3 = declaration.getValue();
                            Object object5 = object3 instanceof QuoteExp && object3 != QuoteExp.undefined_exp ? ((QuoteExp)object3).getValue() : declaration.field.getReflectField().get(null);
                            if (declaration.isIndirectBinding()) {
                                environment.addLocation(symbol, object4, (Location)object5);
                                continue;
                            }
                            environment.define(symbol, object4, object5);
                            continue;
                        }
                        object3 = new StaticFieldLocation(field.getDeclaringClass(), field.getName());
                        environment.addLocation(symbol, object4, (Location)object3);
                    }
                    if (object2 instanceof ModuleBody) {
                        ((ModuleBody)object2).run(callContext);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("class illegal access: in lambda eval");
                }
            }
            callContext.runUntilDone();
        }
        finally {
            if (environment != environment2) {
                Environment.setCurrent(environment2);
            }
        }
    }

    public static void setupLiterals() {
        CallContext callContext = CallContext.getInstance();
        Compilation compilation = (Compilation)callContext.value1;
        try {
            Class clazz = compilation.loader.loadClass(compilation.mainClass.getName(), true);
            Literal literal = compilation.litTable.literalsChain;
            while (literal != null) {
                clazz.getDeclaredField(literal.field.getName()).set(null, literal.value);
                literal = literal.next;
            }
        }
        catch (Throwable throwable) {
            throw new WrappedException("internal error", throwable);
        }
    }

    public final ClassType getSuperType() {
        return this.superType;
    }

    public final void setSuperType(ClassType classType) {
        this.superType = classType;
    }

    public final ClassType[] getInterfaces() {
        return this.interfaces;
    }

    public final void setInterfaces(ClassType[] classTypeArray) {
        this.interfaces = classTypeArray;
    }

    public final boolean isStatic() {
        return this.getFlag(4096) || Compilation.moduleStatic > 0 && !this.getFlag(16384) && !this.getFlag(8192);
    }

    public boolean staticInitRun() {
        return this.isStatic() && (this.getFlag(32768) || Compilation.moduleStatic == 2);
    }

    void allocFields(Compilation compilation) {
        Declaration declaration;
        for (declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (declaration.isSimple() && !declaration.isPublic() || declaration.field != null || !declaration.getFlag(65536)) continue;
            declaration.makeField(compilation, null);
        }
        for (declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (declaration.field != null) continue;
            Expression expression = declaration.getValue();
            if ((declaration.isSimple() && !declaration.isPublic() || declaration.ignorable()) && !declaration.isNamespaceDecl() && !(expression instanceof ClassExp) || declaration.getFlag(65536)) continue;
            if (expression instanceof LambdaExp && !(expression instanceof ClassExp)) {
                ((LambdaExp)expression).allocFieldFor(compilation);
                continue;
            }
            if (!declaration.getFlag(16384) && !declaration.isAlias() || expression == QuoteExp.undefined_exp) {
                expression = null;
            }
            declaration.makeField(compilation, expression);
        }
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkModuleExp(this);
    }

    public void print(OutPort outPort) {
        Declaration declaration;
        outPort.startLogicalBlock("(Module/", ")", 2);
        Object object2 = this.getSymbol();
        if (object2 != null) {
            outPort.print(object2);
            outPort.print('/');
        }
        outPort.print(this.id);
        outPort.print('/');
        outPort.writeSpaceFill();
        outPort.startLogicalBlock("(", false, ")");
        if (declaration != null) {
            outPort.print("Declarations:");
            for (declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
                outPort.writeSpaceFill();
                declaration.printInfo(outPort);
            }
        }
        outPort.endLogicalBlock(")");
        outPort.writeSpaceLinear();
        if (this.body == null) {
            outPort.print("<null body>");
        } else {
            this.body.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Declaration firstDecl() {
        ModuleExp moduleExp = this;
        synchronized (moduleExp) {
            if (this.getFlag(65536)) {
                this.info.setupModuleExp();
            }
        }
        return this.decls;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        String string = null;
        if (this.type != null && this.type != Compilation.typeProcedure && !this.type.isExisting()) {
            objectOutput.writeObject(this.type);
        } else {
            if (string == null) {
                string = this.getName();
            }
            if (string == null) {
                string = this.getFile();
            }
            objectOutput.writeObject(string);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object2 = objectInput.readObject();
        if (object2 instanceof ClassType) {
            this.type = (ClassType)object2;
            this.setName(this.type.getName());
        } else {
            this.setName((String)object2);
        }
        this.flags |= 0x10000;
    }

    static {
        alwaysCompile = false;
    }
}

