/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;

public abstract class ScopeExp
extends Expression {
    Declaration decls;
    Declaration last;
    Scope scope = new Scope();
    public ScopeExp outer;

    public final Declaration firstDecl() {
        return this.decls;
    }

    public void add(Declaration declaration) {
        if (this.last == null) {
            this.decls = declaration;
        } else {
            this.last.next = declaration;
        }
        this.last = declaration;
        declaration.context = this;
    }

    public void add(Declaration declaration, Declaration declaration2) {
        if (declaration == null) {
            declaration2.next = this.decls;
            this.decls = declaration2;
        } else {
            declaration2.next = declaration.next;
            declaration.next = declaration2;
        }
        if (this.last == declaration) {
            this.last = declaration2;
        }
        declaration2.context = this;
    }

    public void remove(Declaration declaration) {
        Declaration declaration2 = null;
        Declaration declaration3 = this.firstDecl();
        while (declaration3 != null) {
            if (declaration3 == declaration) {
                this.remove(declaration2, declaration);
                return;
            }
            declaration2 = declaration;
            declaration3 = declaration3.nextDecl();
        }
    }

    public void remove(Declaration declaration, Declaration declaration2) {
        if (declaration == null) {
            this.decls = declaration2.next;
        } else {
            declaration.next = declaration2.next;
        }
        if (this.last == declaration2) {
            this.last = declaration;
        }
    }

    public LambdaExp currentLambda() {
        ScopeExp scopeExp = this;
        while (scopeExp != null) {
            if (scopeExp instanceof LambdaExp) {
                return (LambdaExp)scopeExp;
            }
            scopeExp = scopeExp.outer;
        }
        return null;
    }

    public ModuleExp currentModule() {
        ScopeExp scopeExp = this;
        while (scopeExp != null) {
            if (scopeExp instanceof ModuleExp) {
                return (ModuleExp)scopeExp;
            }
            scopeExp = scopeExp.outer;
        }
        return null;
    }

    public Declaration lookup(Object object2) {
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            if (declaration.symbol == object2) {
                return declaration;
            }
            declaration = declaration.nextDecl();
        }
        return null;
    }

    public Declaration lookup(Object object2, Interpreter interpreter, int n) {
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            if (declaration.symbol == object2 && (interpreter.getNamespaceOf(declaration) & n) != 0) {
                return declaration;
            }
            declaration = declaration.nextDecl();
        }
        return null;
    }

    public Declaration getNoDefine(Object object2) {
        Declaration declaration = this.lookup(object2);
        if (declaration == null) {
            declaration = this.addDeclaration(object2);
            declaration.flags |= 0x10200;
        }
        return declaration;
    }

    public Declaration getDefine(Object object2, char c, Compilation compilation) {
        Declaration declaration = this.lookup(object2);
        if (declaration == null) {
            declaration = this.addDeclaration(object2);
        } else if ((declaration.flags & 0x10200) != 0) {
            declaration.flags &= 0xFFFEFDFF;
        } else {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("duplicate definition for '");
            stringBuffer.append(object2);
            int n = declaration.getLine();
            if (n <= 0) {
                stringBuffer.append('\'');
            } else {
                stringBuffer.append("' (overrides ");
                String string = declaration.getFile();
                if (string == null || string.equals(compilation.getFile())) {
                    stringBuffer.append("line ");
                } else {
                    stringBuffer.append(string);
                    stringBuffer.append(':');
                }
                stringBuffer.append(n);
                int n2 = declaration.getColumn();
                if (n2 > 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(n2);
                }
                stringBuffer.append(')');
            }
            compilation.error(c, stringBuffer.toString());
            declaration = this.addDeclaration(object2);
        }
        return declaration;
    }

    public final Declaration addDeclaration(Object object2) {
        Declaration declaration = new Declaration(object2);
        this.addDeclaration(declaration);
        return declaration;
    }

    public final Declaration addDeclaration(Object object2, Type type) {
        Declaration declaration = new Declaration(object2);
        this.addDeclaration(declaration);
        declaration.setType(type);
        return declaration;
    }

    public final void addDeclaration(Declaration declaration) {
        this.add(declaration);
    }

    public int countDecls() {
        int n = 0;
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            ++n;
            declaration = declaration.nextDecl();
        }
        return n;
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkScopeExp(this);
    }
}

