/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.SeriesTarget;
import gnu.expr.Target;

public class ConsumerTarget
extends Target {
    Variable consumer;

    public ConsumerTarget(Variable variable) {
        this.consumer = variable;
    }

    public Variable getConsumerVariable() {
        return this.consumer;
    }

    public static void compileUsingConsumer(Expression expression, Compilation compilation, Target target) {
        if (target instanceof ConsumerTarget || target instanceof IgnoreTarget) {
            expression.compile(compilation, target);
        } else {
            CodeAttr codeAttr = compilation.getCode();
            Scope scope = codeAttr.pushScope();
            Variable variable = scope.addVariable(codeAttr, Compilation.typeValues, null);
            ConsumerTarget consumerTarget = new ConsumerTarget(variable);
            codeAttr.emitInvokeStatic(Compilation.typeValues.getDeclaredMethod("make", 0));
            codeAttr.emitStore(variable);
            expression.compile(compilation, consumerTarget);
            codeAttr.emitLoad(variable);
            codeAttr.emitInvokeVirtual(Compilation.typeValues.getDeclaredMethod("canonicalize", 0));
            codeAttr.popScope();
            target.compileFromStack(compilation, Compilation.typeValues);
        }
    }

    public void compileFromStack(Compilation compilation, Type type) {
        CodeAttr codeAttr = compilation.getCode();
        String string = null;
        Method method = null;
        boolean bl = false;
        if (type instanceof PrimType) {
            char c = type.getSignature().charAt(0);
            switch (c) {
                case 'B': 
                case 'I': 
                case 'S': {
                    string = "writeInt";
                    break;
                }
                case 'J': {
                    string = "writeLong";
                    bl = true;
                    break;
                }
                case 'F': {
                    string = "writeFloat";
                    break;
                }
                case 'D': {
                    string = "writeDouble";
                    bl = true;
                    break;
                }
                case 'C': {
                    string = "writeChar";
                    break;
                }
                case 'Z': {
                    string = "writeBoolean";
                    break;
                }
                case 'V': {
                    return;
                }
            }
        } else if (SeriesTarget.isSingletonType(type)) {
            string = "writeObject";
        } else {
            method = Compilation.typeValues.getDeclaredMethod("writeValues", 2);
            codeAttr.emitLoad(this.consumer);
            codeAttr.emitInvokeStatic(method);
            return;
        }
        if (bl) {
            codeAttr.pushScope();
            Variable variable = codeAttr.addLocal(type);
            codeAttr.emitStore(variable);
            codeAttr.emitLoad(this.consumer);
            codeAttr.emitLoad(variable);
            codeAttr.popScope();
        } else {
            codeAttr.emitLoad(this.consumer);
            codeAttr.emitSwap();
        }
        if (method == null && string != null) {
            method = Compilation.typeConsumer.getDeclaredMethod(string, 1);
        }
        if (method != null) {
            codeAttr.emitInvokeInterface(method);
        }
    }

    public Type getType() {
        return Compilation.scmSequenceType;
    }
}

