/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.ConsumerWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class PrintConsumer
extends PrintWriter
implements Appendable,
Consumer {
    public PrintConsumer(Consumer out, boolean autoFlush) {
        super(out instanceof Writer ? (Writer)((Object)out) : new ConsumerWriter(out), autoFlush);
    }

    public PrintConsumer(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public PrintConsumer(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public PrintConsumer(Writer out) {
        super(out);
    }

    protected void startNumber() {
    }

    protected void endNumber() {
    }

    @Override
    public PrintConsumer append(char c) {
        this.print(c);
        return this;
    }

    @Override
    public PrintConsumer append(CharSequence csq) {
        if (csq == null) {
            csq = "null";
        }
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public PrintConsumer append(CharSequence csq, int start, int end) {
        if (csq == null) {
            csq = "null";
        }
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public void write(CharSequence csq, int start, int end) {
        if (csq instanceof String) {
            this.write((String)csq, start, end);
        } else {
            for (int i = start; i < end; ++i) {
                this.write(csq.charAt(i));
            }
        }
    }

    @Override
    public void writeBoolean(boolean v) {
        this.print(v);
    }

    @Override
    public void writeFloat(float v) {
        this.startNumber();
        this.print(v);
        this.endNumber();
    }

    @Override
    public void writeDouble(double v) {
        this.startNumber();
        this.print(v);
        this.endNumber();
    }

    @Override
    public void writeInt(int v) {
        this.startNumber();
        this.print(v);
        this.endNumber();
    }

    @Override
    public void writeLong(long v) {
        this.startNumber();
        this.print(v);
        this.endNumber();
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(Object type) {
    }

    @Override
    public void endElement() {
    }

    @Override
    public void startAttribute(Object attrType) {
    }

    @Override
    public void endAttribute() {
    }

    @Override
    public void writeObject(Object v) {
        this.print(v);
    }

    @Override
    public boolean ignoring() {
        return false;
    }
}

