// |reftest| skip -- BigInt is not supported
// Copyright (C) 2017 Robin Templeton. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-multiplicative-operators-runtime-semantics-evaluation
description: BigInt division arithmetic
features: [BigInt]
---*/

function testDiv(x, y, z) {
    assert.sameValue(x / y, z, x + " / " + y + " = " + z);
}

testDiv(0xFEDCBA9876543210n, 0xFEDCBA9876543210n, 0x1n);
testDiv(0xFEDCBA9876543210n, 0xFEDCBA987654320Fn, 0x1n);
testDiv(0xFEDCBA9876543210n, 0xFEDCBA98n, 0x100000000n);
testDiv(0xFEDCBA9876543210n, 0xFEDCBA97n, 0x100000001n);
testDiv(0xFEDCBA9876543210n, 0x1234n, 0xE0042813BE5DCn);
testDiv(0xFEDCBA9876543210n, 0x3n, 0x54F43E32D21C10B0n);
testDiv(0xFEDCBA9876543210n, 0x2n, 0x7F6E5D4C3B2A1908n);
testDiv(0xFEDCBA9876543210n, 0x1n, 0xFEDCBA9876543210n);
testDiv(0xFEDCBA9876543210n, -0x1n, -0xFEDCBA9876543210n);
testDiv(0xFEDCBA9876543210n, -0x2n, -0x7F6E5D4C3B2A1908n);
testDiv(0xFEDCBA9876543210n, -0x3n, -0x54F43E32D21C10B0n);
testDiv(0xFEDCBA9876543210n, -0x1234n, -0xE0042813BE5DCn);
testDiv(0xFEDCBA9876543210n, -0xFEDCBA97n, -0x100000001n);
testDiv(0xFEDCBA9876543210n, -0xFEDCBA98n, -0x100000000n);
testDiv(0xFEDCBA9876543210n, -0xFEDCBA987654320Fn, -0x1n);
testDiv(0xFEDCBA9876543210n, -0xFEDCBA9876543210n, -0x1n);
testDiv(0xFEDCBA987654320Fn, 0xFEDCBA9876543210n, 0x0n);
testDiv(0xFEDCBA987654320Fn, 0xFEDCBA987654320Fn, 0x1n);
testDiv(0xFEDCBA987654320Fn, 0xFEDCBA98n, 0x100000000n);
testDiv(0xFEDCBA987654320Fn, 0xFEDCBA97n, 0x100000001n);
testDiv(0xFEDCBA987654320Fn, 0x1234n, 0xE0042813BE5DCn);
testDiv(0xFEDCBA987654320Fn, 0x3n, 0x54F43E32D21C10AFn);
testDiv(0xFEDCBA987654320Fn, 0x2n, 0x7F6E5D4C3B2A1907n);
testDiv(0xFEDCBA987654320Fn, 0x1n, 0xFEDCBA987654320Fn);
testDiv(0xFEDCBA987654320Fn, -0x1n, -0xFEDCBA987654320Fn);
testDiv(0xFEDCBA987654320Fn, -0x2n, -0x7F6E5D4C3B2A1907n);
testDiv(0xFEDCBA987654320Fn, -0x3n, -0x54F43E32D21C10AFn);
testDiv(0xFEDCBA987654320Fn, -0x1234n, -0xE0042813BE5DCn);
testDiv(0xFEDCBA987654320Fn, -0xFEDCBA97n, -0x100000001n);
testDiv(0xFEDCBA987654320Fn, -0xFEDCBA98n, -0x100000000n);
testDiv(0xFEDCBA987654320Fn, -0xFEDCBA987654320Fn, -0x1n);
testDiv(0xFEDCBA987654320Fn, -0xFEDCBA9876543210n, 0x0n);
testDiv(0xFEDCBA98n, 0xFEDCBA9876543210n, 0x0n);
testDiv(0xFEDCBA98n, 0xFEDCBA987654320Fn, 0x0n);
testDiv(0xFEDCBA98n, 0xFEDCBA98n, 0x1n);
testDiv(0xFEDCBA98n, 0xFEDCBA97n, 0x1n);
testDiv(0xFEDCBA98n, 0x1234n, 0xE0042n);
testDiv(0xFEDCBA98n, 0x3n, 0x54F43E32n);
testDiv(0xFEDCBA98n, 0x2n, 0x7F6E5D4Cn);
testDiv(0xFEDCBA98n, 0x1n, 0xFEDCBA98n);
testDiv(0xFEDCBA98n, -0x1n, -0xFEDCBA98n);
testDiv(0xFEDCBA98n, -0x2n, -0x7F6E5D4Cn);
testDiv(0xFEDCBA98n, -0x3n, -0x54F43E32n);
testDiv(0xFEDCBA98n, -0x1234n, -0xE0042n);
testDiv(0xFEDCBA98n, -0xFEDCBA97n, -0x1n);
testDiv(0xFEDCBA98n, -0xFEDCBA98n, -0x1n);
testDiv(0xFEDCBA98n, -0xFEDCBA987654320Fn, 0x0n);
testDiv(0xFEDCBA98n, -0xFEDCBA9876543210n, 0x0n);
testDiv(0xFEDCBA97n, 0xFEDCBA9876543210n, 0x0n);
testDiv(0xFEDCBA97n, 0xFEDCBA987654320Fn, 0x0n);
testDiv(0xFEDCBA97n, 0xFEDCBA98n, 0x0n);
testDiv(0xFEDCBA97n, 0xFEDCBA97n, 0x1n);
testDiv(0xFEDCBA97n, 0x1234n, 0xE0042n);
testDiv(0xFEDCBA97n, 0x3n, 0x54F43E32n);
testDiv(0xFEDCBA97n, 0x2n, 0x7F6E5D4Bn);
testDiv(0xFEDCBA97n, 0x1n, 0xFEDCBA97n);
testDiv(0xFEDCBA97n, -0x1n, -0xFEDCBA97n);
testDiv(0xFEDCBA97n, -0x2n, -0x7F6E5D4Bn);
testDiv(0xFEDCBA97n, -0x3n, -0x54F43E32n);
testDiv(0xFEDCBA97n, -0x1234n, -0xE0042n);
testDiv(0xFEDCBA97n, -0xFEDCBA97n, -0x1n);
testDiv(0xFEDCBA97n, -0xFEDCBA98n, 0x0n);
testDiv(0xFEDCBA97n, -0xFEDCBA987654320Fn, 0x0n);
testDiv(0xFEDCBA97n, -0xFEDCBA9876543210n, 0x0n);
testDiv(0x1234n, 0xFEDCBA9876543210n, 0x0n);
testDiv(0x1234n, 0xFEDCBA987654320Fn, 0x0n);
testDiv(0x1234n, 0xFEDCBA98n, 0x0n);
testDiv(0x1234n, 0xFEDCBA97n, 0x0n);
testDiv(0x1234n, 0x1234n, 0x1n);
testDiv(0x1234n, 0x3n, 0x611n);
testDiv(0x1234n, 0x2n, 0x91An);
testDiv(0x1234n, 0x1n, 0x1234n);
testDiv(0x1234n, -0x1n, -0x1234n);
testDiv(0x1234n, -0x2n, -0x91An);
testDiv(0x1234n, -0x3n, -0x611n);
testDiv(0x1234n, -0x1234n, -0x1n);
testDiv(0x1234n, -0xFEDCBA97n, 0x0n);
testDiv(0x1234n, -0xFEDCBA98n, 0x0n);
testDiv(0x1234n, -0xFEDCBA987654320Fn, 0x0n);
testDiv(0x1234n, -0xFEDCBA9876543210n, 0x0n);
testDiv(0x3n, 0xFEDCBA9876543210n, 0x0n);
testDiv(0x3n, 0xFEDCBA987654320Fn, 0x0n);
testDiv(0x3n, 0xFEDCBA98n, 0x0n);
testDiv(0x3n, 0xFEDCBA97n, 0x0n);
testDiv(0x3n, 0x1234n, 0x0n);
testDiv(0x3n, 0x3n, 0x1n);
testDiv(0x3n, 0x2n, 0x1n);
testDiv(0x3n, 0x1n, 0x3n);
testDiv(0x3n, -0x1n, -0x3n);
testDiv(0x3n, -0x2n, -0x1n);
testDiv(0x3n, -0x3n, -0x1n);
testDiv(0x3n, -0x1234n, 0x0n);
testDiv(0x3n, -0xFEDCBA97n, 0x0n);
testDiv(0x3n, -0xFEDCBA98n, 0x0n);
testDiv(0x3n, -0xFEDCBA987654320Fn, 0x0n);
testDiv(0x3n, -0xFEDCBA9876543210n, 0x0n);
testDiv(0x2n, 0xFEDCBA9876543210n, 0x0n);
testDiv(0x2n, 0xFEDCBA987654320Fn, 0x0n);
testDiv(0x2n, 0xFEDCBA98n, 0x0n);
testDiv(0x2n, 0xFEDCBA97n, 0x0n);
testDiv(0x2n, 0x1234n, 0x0n);
testDiv(0x2n, 0x3n, 0x0n);
testDiv(0x2n, 0x2n, 0x1n);
testDiv(0x2n, 0x1n, 0x2n);
testDiv(0x2n, -0x1n, -0x2n);
testDiv(0x2n, -0x2n, -0x1n);
testDiv(0x2n, -0x3n, 0x0n);
testDiv(0x2n, -0x1234n, 0x0n);
testDiv(0x2n, -0xFEDCBA97n, 0x0n);
testDiv(0x2n, -0xFEDCBA98n, 0x0n);
testDiv(0x2n, -0xFEDCBA987654320Fn, 0x0n);
testDiv(0x2n, -0xFEDCBA9876543210n, 0x0n);
testDiv(0x1n, 0xFEDCBA9876543210n, 0x0n);
testDiv(0x1n, 0xFEDCBA987654320Fn, 0x0n);
testDiv(0x1n, 0xFEDCBA98n, 0x0n);
testDiv(0x1n, 0xFEDCBA97n, 0x0n);
testDiv(0x1n, 0x1234n, 0x0n);
testDiv(0x1n, 0x3n, 0x0n);
testDiv(0x1n, 0x2n, 0x0n);
testDiv(0x1n, 0x1n, 0x1n);
testDiv(0x1n, -0x1n, -0x1n);
testDiv(0x1n, -0x2n, 0x0n);
testDiv(0x1n, -0x3n, 0x0n);
testDiv(0x1n, -0x1234n, 0x0n);
testDiv(0x1n, -0xFEDCBA97n, 0x0n);
testDiv(0x1n, -0xFEDCBA98n, 0x0n);
testDiv(0x1n, -0xFEDCBA987654320Fn, 0x0n);
testDiv(0x1n, -0xFEDCBA9876543210n, 0x0n);
testDiv(-0x1n, 0xFEDCBA9876543210n, 0x0n);
testDiv(-0x1n, 0xFEDCBA987654320Fn, 0x0n);
testDiv(-0x1n, 0xFEDCBA98n, 0x0n);
testDiv(-0x1n, 0xFEDCBA97n, 0x0n);
testDiv(-0x1n, 0x1234n, 0x0n);
testDiv(-0x1n, 0x3n, 0x0n);
testDiv(-0x1n, 0x2n, 0x0n);
testDiv(-0x1n, 0x1n, -0x1n);
testDiv(-0x1n, -0x1n, 0x1n);
testDiv(-0x1n, -0x2n, 0x0n);
testDiv(-0x1n, -0x3n, 0x0n);
testDiv(-0x1n, -0x1234n, 0x0n);
testDiv(-0x1n, -0xFEDCBA97n, 0x0n);
testDiv(-0x1n, -0xFEDCBA98n, 0x0n);
testDiv(-0x1n, -0xFEDCBA987654320Fn, 0x0n);
testDiv(-0x1n, -0xFEDCBA9876543210n, 0x0n);
testDiv(-0x2n, 0xFEDCBA9876543210n, 0x0n);
testDiv(-0x2n, 0xFEDCBA987654320Fn, 0x0n);
testDiv(-0x2n, 0xFEDCBA98n, 0x0n);
testDiv(-0x2n, 0xFEDCBA97n, 0x0n);
testDiv(-0x2n, 0x1234n, 0x0n);
testDiv(-0x2n, 0x3n, 0x0n);
testDiv(-0x2n, 0x2n, -0x1n);
testDiv(-0x2n, 0x1n, -0x2n);
testDiv(-0x2n, -0x1n, 0x2n);
testDiv(-0x2n, -0x2n, 0x1n);
testDiv(-0x2n, -0x3n, 0x0n);
testDiv(-0x2n, -0x1234n, 0x0n);
testDiv(-0x2n, -0xFEDCBA97n, 0x0n);
testDiv(-0x2n, -0xFEDCBA98n, 0x0n);
testDiv(-0x2n, -0xFEDCBA987654320Fn, 0x0n);
testDiv(-0x2n, -0xFEDCBA9876543210n, 0x0n);
testDiv(-0x3n, 0xFEDCBA9876543210n, 0x0n);
testDiv(-0x3n, 0xFEDCBA987654320Fn, 0x0n);
testDiv(-0x3n, 0xFEDCBA98n, 0x0n);
testDiv(-0x3n, 0xFEDCBA97n, 0x0n);
testDiv(-0x3n, 0x1234n, 0x0n);
testDiv(-0x3n, 0x3n, -0x1n);
testDiv(-0x3n, 0x2n, -0x1n);
testDiv(-0x3n, 0x1n, -0x3n);
testDiv(-0x3n, -0x1n, 0x3n);
testDiv(-0x3n, -0x2n, 0x1n);
testDiv(-0x3n, -0x3n, 0x1n);
testDiv(-0x3n, -0x1234n, 0x0n);
testDiv(-0x3n, -0xFEDCBA97n, 0x0n);
testDiv(-0x3n, -0xFEDCBA98n, 0x0n);
testDiv(-0x3n, -0xFEDCBA987654320Fn, 0x0n);
testDiv(-0x3n, -0xFEDCBA9876543210n, 0x0n);
testDiv(-0x1234n, 0xFEDCBA9876543210n, 0x0n);
testDiv(-0x1234n, 0xFEDCBA987654320Fn, 0x0n);
testDiv(-0x1234n, 0xFEDCBA98n, 0x0n);
testDiv(-0x1234n, 0xFEDCBA97n, 0x0n);
testDiv(-0x1234n, 0x1234n, -0x1n);
testDiv(-0x1234n, 0x3n, -0x611n);
testDiv(-0x1234n, 0x2n, -0x91An);
testDiv(-0x1234n, 0x1n, -0x1234n);
testDiv(-0x1234n, -0x1n, 0x1234n);
testDiv(-0x1234n, -0x2n, 0x91An);
testDiv(-0x1234n, -0x3n, 0x611n);
testDiv(-0x1234n, -0x1234n, 0x1n);
testDiv(-0x1234n, -0xFEDCBA97n, 0x0n);
testDiv(-0x1234n, -0xFEDCBA98n, 0x0n);
testDiv(-0x1234n, -0xFEDCBA987654320Fn, 0x0n);
testDiv(-0x1234n, -0xFEDCBA9876543210n, 0x0n);
testDiv(-0xFEDCBA97n, 0xFEDCBA9876543210n, 0x0n);
testDiv(-0xFEDCBA97n, 0xFEDCBA987654320Fn, 0x0n);
testDiv(-0xFEDCBA97n, 0xFEDCBA98n, 0x0n);
testDiv(-0xFEDCBA97n, 0xFEDCBA97n, -0x1n);
testDiv(-0xFEDCBA97n, 0x1234n, -0xE0042n);
testDiv(-0xFEDCBA97n, 0x3n, -0x54F43E32n);
testDiv(-0xFEDCBA97n, 0x2n, -0x7F6E5D4Bn);
testDiv(-0xFEDCBA97n, 0x1n, -0xFEDCBA97n);
testDiv(-0xFEDCBA97n, -0x1n, 0xFEDCBA97n);
testDiv(-0xFEDCBA97n, -0x2n, 0x7F6E5D4Bn);
testDiv(-0xFEDCBA97n, -0x3n, 0x54F43E32n);
testDiv(-0xFEDCBA97n, -0x1234n, 0xE0042n);
testDiv(-0xFEDCBA97n, -0xFEDCBA97n, 0x1n);
testDiv(-0xFEDCBA97n, -0xFEDCBA98n, 0x0n);
testDiv(-0xFEDCBA97n, -0xFEDCBA987654320Fn, 0x0n);
testDiv(-0xFEDCBA97n, -0xFEDCBA9876543210n, 0x0n);
testDiv(-0xFEDCBA98n, 0xFEDCBA9876543210n, 0x0n);
testDiv(-0xFEDCBA98n, 0xFEDCBA987654320Fn, 0x0n);
testDiv(-0xFEDCBA98n, 0xFEDCBA98n, -0x1n);
testDiv(-0xFEDCBA98n, 0xFEDCBA97n, -0x1n);
testDiv(-0xFEDCBA98n, 0x1234n, -0xE0042n);
testDiv(-0xFEDCBA98n, 0x3n, -0x54F43E32n);
testDiv(-0xFEDCBA98n, 0x2n, -0x7F6E5D4Cn);
testDiv(-0xFEDCBA98n, 0x1n, -0xFEDCBA98n);
testDiv(-0xFEDCBA98n, -0x1n, 0xFEDCBA98n);
testDiv(-0xFEDCBA98n, -0x2n, 0x7F6E5D4Cn);
testDiv(-0xFEDCBA98n, -0x3n, 0x54F43E32n);
testDiv(-0xFEDCBA98n, -0x1234n, 0xE0042n);
testDiv(-0xFEDCBA98n, -0xFEDCBA97n, 0x1n);
testDiv(-0xFEDCBA98n, -0xFEDCBA98n, 0x1n);
testDiv(-0xFEDCBA98n, -0xFEDCBA987654320Fn, 0x0n);
testDiv(-0xFEDCBA98n, -0xFEDCBA9876543210n, 0x0n);
testDiv(-0xFEDCBA987654320Fn, 0xFEDCBA9876543210n, 0x0n);
testDiv(-0xFEDCBA987654320Fn, 0xFEDCBA987654320Fn, -0x1n);
testDiv(-0xFEDCBA987654320Fn, 0xFEDCBA98n, -0x100000000n);
testDiv(-0xFEDCBA987654320Fn, 0xFEDCBA97n, -0x100000001n);
testDiv(-0xFEDCBA987654320Fn, 0x1234n, -0xE0042813BE5DCn);
testDiv(-0xFEDCBA987654320Fn, 0x3n, -0x54F43E32D21C10AFn);
testDiv(-0xFEDCBA987654320Fn, 0x2n, -0x7F6E5D4C3B2A1907n);
testDiv(-0xFEDCBA987654320Fn, 0x1n, -0xFEDCBA987654320Fn);
testDiv(-0xFEDCBA987654320Fn, -0x1n, 0xFEDCBA987654320Fn);
testDiv(-0xFEDCBA987654320Fn, -0x2n, 0x7F6E5D4C3B2A1907n);
testDiv(-0xFEDCBA987654320Fn, -0x3n, 0x54F43E32D21C10AFn);
testDiv(-0xFEDCBA987654320Fn, -0x1234n, 0xE0042813BE5DCn);
testDiv(-0xFEDCBA987654320Fn, -0xFEDCBA97n, 0x100000001n);
testDiv(-0xFEDCBA987654320Fn, -0xFEDCBA98n, 0x100000000n);
testDiv(-0xFEDCBA987654320Fn, -0xFEDCBA987654320Fn, 0x1n);
testDiv(-0xFEDCBA987654320Fn, -0xFEDCBA9876543210n, 0x0n);
testDiv(-0xFEDCBA9876543210n, 0xFEDCBA9876543210n, -0x1n);
testDiv(-0xFEDCBA9876543210n, 0xFEDCBA987654320Fn, -0x1n);
testDiv(-0xFEDCBA9876543210n, 0xFEDCBA98n, -0x100000000n);
testDiv(-0xFEDCBA9876543210n, 0xFEDCBA97n, -0x100000001n);
testDiv(-0xFEDCBA9876543210n, 0x1234n, -0xE0042813BE5DCn);
testDiv(-0xFEDCBA9876543210n, 0x3n, -0x54F43E32D21C10B0n);
testDiv(-0xFEDCBA9876543210n, 0x2n, -0x7F6E5D4C3B2A1908n);
testDiv(-0xFEDCBA9876543210n, 0x1n, -0xFEDCBA9876543210n);
testDiv(-0xFEDCBA9876543210n, -0x1n, 0xFEDCBA9876543210n);
testDiv(-0xFEDCBA9876543210n, -0x2n, 0x7F6E5D4C3B2A1908n);
testDiv(-0xFEDCBA9876543210n, -0x3n, 0x54F43E32D21C10B0n);
testDiv(-0xFEDCBA9876543210n, -0x1234n, 0xE0042813BE5DCn);
testDiv(-0xFEDCBA9876543210n, -0xFEDCBA97n, 0x100000001n);
testDiv(-0xFEDCBA9876543210n, -0xFEDCBA98n, 0x100000000n);
testDiv(-0xFEDCBA9876543210n, -0xFEDCBA987654320Fn, 0x1n);
testDiv(-0xFEDCBA9876543210n, -0xFEDCBA9876543210n, 0x1n);

reportCompare(0, 0);
