/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.der;

import gnu.crypto.der.DER;
import gnu.crypto.der.DERWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERValue
implements DER {
    private final int tagClass;
    private final boolean constructed;
    private final int tag;
    private int length;
    private final Object value;
    private byte[] encoded;

    public int getExternalTag() {
        return this.tagClass | this.tag | (this.constructed ? 32 : 0);
    }

    public int getTag() {
        return this.tag;
    }

    public int getTagClass() {
        return this.tagClass;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public int getLength() {
        if (this.encoded == null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.length = DERWriter.write(out, this);
                this.encoded = out.toByteArray();
            }
            catch (IOException ioe) {
                this.encoded = new byte[0];
            }
        }
        return this.length;
    }

    public Object getValue() {
        return this.value;
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.length = DERWriter.write(out, this);
                this.encoded = out.toByteArray();
            }
            catch (IOException ioe) {
                this.encoded = new byte[0];
            }
        }
        return (byte[])this.encoded.clone();
    }

    public int getEncodedLength() {
        if (this.encoded == null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.length = DERWriter.write(out, this);
                this.encoded = out.toByteArray();
            }
            catch (IOException ioe) {
                this.encoded = new byte[0];
            }
        }
        return this.encoded.length;
    }

    public String toString() {
        return "DERValue [ tag=" + this.tag + ", class=" + this.tagClass + ", constructed=" + this.constructed + ", value=" + this.value + " ]";
    }

    public DERValue(int tag, int length, Object value, byte[] encoded) {
        this.tagClass = tag & 0xC0;
        this.tag = tag & 0x1F;
        boolean bl = false;
        if ((tag & 0x20) == 32) {
            bl = true;
        }
        this.constructed = bl;
        this.length = length;
        this.value = value;
        if (encoded != null) {
            this.encoded = (byte[])encoded.clone();
        }
    }

    public DERValue(int tag, Object value) {
        this(tag, 0, value, null);
    }
}

