/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing1.metrics;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.simulatedAnnealing1.SimulatedAnnealing;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AreaOverlapMetric {
    private List<PlacementFrame.PlacementNode> allNodes;
    private SimulatedAnnealing.IncrementalState incState;
    private double currentScore;
    private Map<PlacementFrame.PlacementNode, Double> oevrlapScores;

    public AreaOverlapMetric(List<PlacementFrame.PlacementNode> allNodes, SimulatedAnnealing.IncrementalState incrementalState) {
        this.oevrlapScores = new HashMap<PlacementFrame.PlacementNode, Double>(allNodes.size());
        this.allNodes = allNodes;
        this.incState = incrementalState;
    }

    public double init(List<PlacementFrame.PlacementNode> allNodes) {
        this.currentScore = 0.0;
        for (PlacementFrame.PlacementNode node : allNodes) {
            this.oevrlapScores.put(node, new Double(0.0));
            this.computeOverlapForNode(node);
        }
        return this.currentScore;
    }

    public double getCurrentScore() {
        return this.currentScore;
    }

    public double computeOverlapForNode(PlacementFrame.PlacementNode theOne) {
        double areaOverlap = 0.0;
        for (PlacementFrame.PlacementNode notTheOne : this.allNodes) {
            if (theOne == notTheOne) continue;
            double x1 = theOne.getPlacementX();
            double y1 = theOne.getPlacementY();
            double w1 = theOne.getWidth();
            double h1 = theOne.getHeight();
            int angle1 = theOne.getPlacementOrientation().getAngle();
            double x2 = notTheOne.getPlacementX();
            double y2 = notTheOne.getPlacementY();
            double w2 = theOne.getWidth();
            double h2 = theOne.getHeight();
            int angle2 = notTheOne.getPlacementOrientation().getAngle();
            int originalPlacementNodeIndex = this.allNodes.indexOf(theOne);
            if (this.incState.isNodeChanged(originalPlacementNodeIndex)) {
                SimulatedAnnealing.PlacementNodePosition changedNode = this.incState.getNodeFromState(originalPlacementNodeIndex);
                x1 = changedNode.getPlacementX();
                y1 = changedNode.getPlacementY();
                angle1 = changedNode.getPlacementOrientation().getAngle();
            }
            Rectangle2D.Double r1 = this.getRectangleForNode(x1, y1, w1, h1, angle1);
            Rectangle2D.Double r2 = this.getRectangleForNode(x2, y2, w2, h2, angle2);
            areaOverlap += this.getIntersectionArea(r1, r2);
        }
        double oldScore = this.oevrlapScores.get(theOne);
        if (!(oldScore > 0.0) || Math.abs(oldScore - areaOverlap) > 0.001) {
            // empty if block
        }
        this.oevrlapScores.put(theOne, new Double(areaOverlap));
        this.currentScore = this.currentScore - oldScore + areaOverlap;
        return areaOverlap;
    }

    private Rectangle2D.Double getRectangleForNode(double x, double y, double w, double h, int angle) {
        switch (angle) {
            case 0: {
                return new Rectangle2D.Double(x - w / 2.0, y - h / 2.0, w, h);
            }
            case 90: {
                return new Rectangle2D.Double(x - h / 2.0, y - w / 2.0, h, w);
            }
            case 180: {
                return new Rectangle2D.Double(x - w / 2.0, y - h / 2.0, w, h);
            }
            case 270: {
                return new Rectangle2D.Double(x - h / 2.0, y - w / 2.0, h, w);
            }
        }
        return new Rectangle2D.Double(x - w / 2.0, y - h / 2.0, w, h);
    }

    private double getIntersectionArea(Rectangle2D.Double r1, Rectangle2D.Double r2) {
        double area = 0.0;
        Rectangle2D overlap = r1.createIntersection(r2);
        if (!overlap.isEmpty()) {
            area = overlap.getWidth() * overlap.getHeight();
        }
        return area;
    }

    public double update(int index) {
        double BeforeIncUpdate = this.currentScore;
        this.computeOverlapForNode(this.allNodes.get(index));
        double incScore = this.currentScore;
        double newScore = this.currentScore;
        if (Math.abs(incScore - newScore) > 1.0E-4) {
            System.out.println("BeforeIncUpdate=" + BeforeIncUpdate + ", after update: incScore=" + incScore + ", correctScore=" + newScore);
        }
        return this.currentScore;
    }
}

